/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.block.tile;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.cad.AssembleCADEvent;
import vazkii.psi.api.cad.EnumCADComponent;
import vazkii.psi.api.cad.ICADComponent;
import vazkii.psi.api.cad.ISocketable;
import vazkii.psi.api.cad.ITileCADAssembler;
import vazkii.psi.api.cad.PostCADCraftEvent;
import vazkii.psi.common.block.BlockCADAssembler;
import vazkii.psi.common.block.base.ModBlocks;
import vazkii.psi.common.block.tile.container.ContainerCADAssembler;
import vazkii.psi.common.core.handler.PsiSoundHandler;
import vazkii.psi.common.item.ItemCAD;

public class TileCADAssembler
extends BlockEntity
implements ITileCADAssembler,
MenuProvider {
    private final CADStackHandler inventory = new CADStackHandler();
    private ItemStack cachedCAD = null;

    public TileCADAssembler(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlocks.cadAssemblerType.get(), pos, state);
    }

    public IItemHandlerModifiable getInventory() {
        return this.inventory;
    }

    @Override
    public void clearCachedCAD() {
        this.cachedCAD = null;
    }

    @Override
    public ItemStack getCachedCAD(Player player) {
        ItemStack cad = this.cachedCAD;
        if (cad == null) {
            ItemStack assembly = this.getStackForComponent(EnumCADComponent.ASSEMBLY);
            if (!assembly.isEmpty()) {
                List<ItemStack> components = IntStream.range(1, 6).mapToObj(arg_0 -> ((CADStackHandler)this.inventory).getStackInSlot(arg_0)).collect(Collectors.toList());
                cad = ItemCAD.makeCADWithAssembly(assembly, components);
            } else {
                cad = ItemStack.EMPTY;
            }
            AssembleCADEvent assembling = new AssembleCADEvent(cad, this, player);
            NeoForge.EVENT_BUS.post((Event)assembling);
            cad = assembling.isCanceled() ? ItemStack.EMPTY : assembling.getCad();
            this.cachedCAD = cad;
        }
        return cad;
    }

    @Override
    public ItemStack getStackForComponent(EnumCADComponent componentType) {
        return this.inventory.getStackInSlot(componentType.ordinal() + 1);
    }

    @Override
    public boolean setStackForComponent(EnumCADComponent componentType, ItemStack component) {
        ICADComponent componentItem;
        int slot = componentType.ordinal() + 1;
        if (component.isEmpty()) {
            this.inventory.setStackInSlot(slot, component);
            return true;
        }
        Item item = component.getItem();
        if (item instanceof ICADComponent && (componentItem = (ICADComponent)item).getComponentType(component) == componentType) {
            this.inventory.setStackInSlot(slot, component);
            return true;
        }
        return false;
    }

    @Override
    public ItemStack getSocketableStack() {
        return this.inventory.getStackInSlot(0);
    }

    @Override
    public ISocketable getSocketable() {
        return ISocketable.socketable(this.getSocketableStack());
    }

    @Override
    public boolean setSocketableStack(ItemStack stack) {
        if (stack.isEmpty() || ISocketable.isSocketable(stack)) {
            this.inventory.setStackInSlot(0, stack);
            return true;
        }
        return false;
    }

    @Override
    public void onCraftCAD(ItemStack cad) {
        NeoForge.EVENT_BUS.post((Event)new PostCADCraftEvent(cad, this));
        for (int i = 1; i < 6; ++i) {
            this.inventory.setStackInSlot(i, ItemStack.EMPTY);
        }
        if (this.level == null) {
            return;
        }
        if (!this.level.isClientSide) {
            this.level.playSound(null, (double)this.getBlockPos().getX() + 0.5, (double)this.getBlockPos().getY() + 0.5, (double)this.getBlockPos().getZ() + 0.5, PsiSoundHandler.cadCreate, SoundSource.BLOCKS, 0.5f, 1.0f);
        }
    }

    @Override
    public boolean isBulletSlotEnabled(int slot) {
        if (this.getSocketableStack().isEmpty()) {
            return false;
        }
        ISocketable socketable = this.getSocketable();
        return socketable != null && socketable.isSocketSlotAvailable(slot);
    }

    protected void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.inventory.getItems(), (HolderLookup.Provider)provider);
    }

    public void loadAdditional(@NotNull CompoundTag cmp, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(cmp, provider);
        this.readPacketNBT(cmp, provider);
    }

    public void readPacketNBT(@NotNull CompoundTag tag, HolderLookup.Provider provider) {
        ListTag items = tag.getList("Items", 10);
        if (items.size() == 19) {
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                this.inventory.setStackInSlot(i, ItemStack.EMPTY);
            }
            ISocketable socketable = null;
            for (int i = 0; i < items.size(); ++i) {
                if (i == 0) continue;
                ItemStack stack = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)items.getCompound(i));
                if (i == 6) {
                    this.setSocketableStack(stack);
                    if (stack.isEmpty()) continue;
                    socketable = (ISocketable)stack.getCapability(PsiAPI.SOCKETABLE_CAPABILITY);
                    continue;
                }
                if (i == 1) {
                    this.setStackForComponent(EnumCADComponent.CORE, stack);
                    continue;
                }
                if (i == 2) {
                    this.setStackForComponent(EnumCADComponent.ASSEMBLY, stack);
                    continue;
                }
                if (i == 3) {
                    this.setStackForComponent(EnumCADComponent.SOCKET, stack);
                    continue;
                }
                if (i == 4) {
                    this.setStackForComponent(EnumCADComponent.BATTERY, stack);
                    continue;
                }
                if (i == 5) {
                    this.setStackForComponent(EnumCADComponent.DYE, stack);
                    continue;
                }
                int idx = i - 7;
                if (socketable == null) continue;
                socketable.setBulletInSocket(idx, stack);
            }
        } else {
            for (int i = 0; i < items.size(); ++i) {
                CompoundTag compoundtag = items.getCompound(i);
                int j = compoundtag.getByte("Slot") & 0xFF;
                if (j >= this.inventory.getItems().size()) continue;
                this.inventory.getItems().set(j, (Object)ItemStack.parse((HolderLookup.Provider)provider, (Tag)compoundtag).orElse(ItemStack.EMPTY));
            }
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this, (e, provider) -> this.getUpdateTag((HolderLookup.Provider)provider));
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag cmp = new CompoundTag();
        this.saveAdditional(cmp, provider);
        return cmp;
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)((BlockCADAssembler)((Object)ModBlocks.cadAssembler.get())).getDescriptionId());
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, @NotNull Inventory playerInventory, @NotNull Player playerEntity) {
        return new ContainerCADAssembler(i, playerInventory, this);
    }

    private class CADStackHandler
    extends ItemStackHandler {
        private CADStackHandler() {
            super(6);
        }

        private NonNullList<ItemStack> getItems() {
            return this.stacks;
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (0 < slot && slot < 6) {
                TileCADAssembler.this.clearCachedCAD();
            }
            TileCADAssembler.this.setChanged();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (stack.isEmpty()) {
                return true;
            }
            if (slot == 0) {
                return ISocketable.isSocketable(stack);
            }
            if (slot < 6) {
                return stack.getItem() instanceof ICADComponent && ((ICADComponent)stack.getItem()).getComponentType(stack).ordinal() == slot - 1;
            }
            return false;
        }
    }
}

