/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.item.tool;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.Nullable;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.cad.ISocketable;
import vazkii.psi.common.core.handler.PlayerDataHandler;
import vazkii.psi.common.item.ItemCAD;
import vazkii.psi.common.item.base.ModDataComponents;
import vazkii.psi.common.item.tool.ToolSocketable;
import vazkii.psi.common.spell.trick.block.PieceTrickBreakBlock;

public interface IPsimetalTool {
    public static BlockHitResult raytraceFromEntity(Level worldIn, Player player, ClipContext.Fluid fluidMode, double range) {
        float f = player.getXRot();
        float f1 = player.getYRot();
        Vec3 vec3d = player.getEyePosition(1.0f);
        float f2 = Mth.cos((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = Mth.sin((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -Mth.cos((float)(-f * ((float)Math.PI / 180)));
        float f5 = Mth.sin((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        Vec3 vec3d1 = vec3d.add((double)f6 * range, (double)f5 * range, (double)f7 * range);
        return worldIn.clip(new ClipContext(vec3d, vec3d1, ClipContext.Block.OUTLINE, fluidMode, (Entity)player));
    }

    public static void regen(ItemStack stack, Entity entityIn) {
        if (IPsimetalTool.isItemValidForRegen(stack, entityIn)) {
            Player player = (Player)entityIn;
            PlayerDataHandler.PlayerData data = PlayerDataHandler.get(player);
            int regenTime = (Integer)stack.getOrDefault(ModDataComponents.REGEN_TIME, (Object)0);
            if (!data.overflowed && regenTime % 16 == 0 && (float)data.getAvailablePsi() / (float)data.getTotalPsi() > 0.5f) {
                data.deductPsi(150, 0, true);
                stack.setDamageValue(stack.getDamageValue() - 1);
            }
            stack.set(ModDataComponents.REGEN_TIME, (Object)(regenTime + 1));
        }
    }

    public static boolean isItemValidForRegen(ItemStack stack, Entity entityIn) {
        if (!(entityIn instanceof Player)) {
            return false;
        }
        Player player = (Player)entityIn;
        return player.getOffhandItem() != stack && player.getMainHandItem() != stack && stack.getDamageValue() > 0;
    }

    public static boolean isEnabled(ItemStack stack) {
        return stack.getDamageValue() < stack.getMaxDamage();
    }

    default public void castOnBlockBreak(ItemStack itemstack, Player player) {
        if (!IPsimetalTool.isEnabled(itemstack) || PieceTrickBreakBlock.doingHarvestCheck.get().booleanValue()) {
            return;
        }
        PlayerDataHandler.PlayerData data = PlayerDataHandler.get(player);
        ItemStack playerCad = PsiAPI.getPlayerCAD(player);
        if (!playerCad.isEmpty()) {
            ISocketable sockets = ISocketable.socketable(itemstack);
            ItemStack bullet = sockets.getSelectedBullet();
            ItemCAD.cast(player.getCommandSenderWorld(), player, data, bullet, playerCad, 5, 10, 0.05f, context -> {
                context.tool = itemstack;
                context.positionBroken = IPsimetalTool.raytraceFromEntity(player.getCommandSenderWorld(), player, ClipContext.Fluid.NONE, player.getAttributes().getValue(Attributes.BLOCK_INTERACTION_RANGE));
            });
        }
    }

    default public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new ToolSocketable(stack, 3);
    }
}

