/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.network.message;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;
import vazkii.psi.common.Psi;

public record MessageVisualEffect(int color, double x, double y, double z, double width, double height, double offset, int effectType) implements CustomPacketPayload
{
    public static final int TYPE_CRAFT = 0;
    public static final ResourceLocation ID = Psi.location("message_visual_effect");
    public static final CustomPacketPayload.Type<MessageVisualEffect> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, MessageVisualEffect> CODEC = new StreamCodec<RegistryFriendlyByteBuf, MessageVisualEffect>(){

        @NotNull
        public MessageVisualEffect decode(RegistryFriendlyByteBuf pBuffer) {
            return new MessageVisualEffect(pBuffer.readInt(), pBuffer.readDouble(), pBuffer.readDouble(), pBuffer.readDouble(), pBuffer.readDouble(), pBuffer.readDouble(), pBuffer.readDouble(), pBuffer.readInt());
        }

        public void encode(RegistryFriendlyByteBuf pBuffer, MessageVisualEffect message) {
            pBuffer.writeInt(message.color());
            pBuffer.writeDouble(message.x());
            pBuffer.writeDouble(message.y());
            pBuffer.writeDouble(message.z());
            pBuffer.writeDouble(message.width());
            pBuffer.writeDouble(message.height());
            pBuffer.writeDouble(message.offset());
            pBuffer.writeInt(message.effectType());
        }
    };

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext ctx) {
        float r = (float)(this.color >> 16 & 0xFF) / 255.0f;
        float g = (float)(this.color >> 8 & 0xFF) / 255.0f;
        float b = (float)(this.color & 0xFF) / 255.0f;
        ctx.enqueueWork(() -> {
            Level world = Psi.proxy.getClientWorld();
            if (this.effectType == 0) {
                for (int i = 0; i < 5; ++i) {
                    double particleX = this.x + (Math.random() - 0.5) * 2.1 * this.width;
                    double particleY = this.y - this.offset;
                    double particleZ = this.z + (Math.random() - 0.5) * 2.1 * this.width;
                    float grav = -0.05f - (float)Math.random() * 0.01f;
                    Psi.proxy.sparkleFX(particleX, particleY, particleZ, r, g, b, grav, 3.5f, 15);
                    double m = 0.01;
                    double d3 = 10.0;
                    for (int j = 0; j < 3; ++j) {
                        double d0 = world.random.nextGaussian() * m;
                        double d1 = world.random.nextGaussian() * m;
                        double d2 = world.random.nextGaussian() * m;
                        world.addParticle((ParticleOptions)ParticleTypes.EXPLOSION, this.x + (double)world.random.nextFloat() * this.width * 2.0 - this.width - d0 * d3, this.y + (double)world.random.nextFloat() * this.height - d1 * d3, this.z + (double)world.random.nextFloat() * this.width * 2.0 - this.width - d2 * d3, d0, d1, d2);
                    }
                }
            }
        });
    }
}

