/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.util.math;

import com.mojang.serialization.Codec;
import java.util.Locale;
import net.mehvahdjukaar.moonlight.api.util.math.Vec2i;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.phys.Vec2;

public enum Direction2D implements StringRepresentable
{
    UP(0, 1),
    DOWN(0, -1),
    RIGHT(1, 0),
    LEFT(-1, 0);

    public static final Codec<Direction2D> CODEC;
    final Vec2i step;

    private Direction2D(int dx, int dy) {
        this.step = new Vec2i(dx, dy);
    }

    public Vec2i getStep() {
        return this.step;
    }

    public Direction2D getOpposite() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> DOWN;
            case 1 -> UP;
            case 3 -> RIGHT;
            case 2 -> LEFT;
        };
    }

    public Direction2D clockwise() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> RIGHT;
            case 2 -> DOWN;
            case 1 -> LEFT;
            case 3 -> UP;
        };
    }

    public Direction2D counterClockwise() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> LEFT;
            case 3 -> DOWN;
            case 1 -> RIGHT;
            case 2 -> UP;
        };
    }

    public static Direction2D closest(Vec2 vec) {
        double absY;
        double absX = Math.abs(vec.x);
        if (absX > (absY = (double)Math.abs(vec.y))) {
            return vec.x > 0.0f ? RIGHT : LEFT;
        }
        return vec.y > 0.0f ? UP : DOWN;
    }

    public static Direction2D closest(Vec2i vec) {
        double absY;
        double absX = Math.abs(vec.x());
        if (absX > (absY = (double)Math.abs(vec.y()))) {
            return vec.x() > 0 ? RIGHT : LEFT;
        }
        return vec.y() > 0 ? UP : DOWN;
    }

    public String getSerializedName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public static Direction2D from3D(Direction dir, Rotation facingRot) {
        dir = facingRot.rotate(dir);
        return switch (dir) {
            case Direction.UP -> UP;
            case Direction.DOWN -> DOWN;
            case Direction.WEST -> LEFT;
            case Direction.EAST -> RIGHT;
            default -> throw new IllegalArgumentException("Invalid horizontal direction: " + String.valueOf(dir));
        };
    }

    static {
        CODEC = StringRepresentable.fromEnum(Direction2D::values);
    }
}

