/*
 * Decompiled with CFR 0.152.
 */
package giselle.jei_mekanism_multiblocks.client.jei.category.better_fusion;

import giselle.jei_mekanism_multiblocks.client.gui.CheckBoxWidget;
import giselle.jei_mekanism_multiblocks.client.gui.IntSliderWidget;
import giselle.jei_mekanism_multiblocks.client.gui.IntSliderWithButtons;
import giselle.jei_mekanism_multiblocks.client.gui.Mod2IntSliderWidget;
import giselle.jei_mekanism_multiblocks.client.jei.MultiblockCategory;
import giselle.jei_mekanism_multiblocks.client.jei.MultiblockWidget;
import giselle.jei_mekanism_multiblocks.client.jei.ResultWidget;
import giselle.jei_mekanism_multiblocks.client.jei.category.ICostConsumer;
import giselle.jei_mekanism_multiblocks.common.util.VolumeTextHelper;
import igentuman.bfr.common.BetterFusionReactor;
import igentuman.bfr.common.registries.BfrBlocks;
import java.util.List;
import java.util.function.Consumer;
import mekanism.api.MekanismAPI;
import mekanism.api.math.MathUtils;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.HeatUtils;
import mekanism.common.util.text.EnergyDisplay;
import mekanism.generators.common.GeneratorTags;
import mekanism.generators.common.config.MekanismGeneratorsConfig;
import mekanism.generators.common.registries.GeneratorsBlocks;
import mekanism.generators.common.registries.GeneratorsItems;
import mezz.jei.api.helpers.IGuiHelper;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class BetterFusionReactorCategory
extends MultiblockCategory<FusionReactorCategoryWidget> {
    public BetterFusionReactorCategory(IGuiHelper helper) {
        super(helper, BetterFusionReactor.rl((String)"fusion_reactor"), FusionReactorCategoryWidget.class, (Component)Component.translatable((String)"text.jei_mekanism_multiblocks.building.better_fusion_reactor"), new ItemStack((ItemLike)BfrBlocks.FUSION_REACTOR_CONTROLLER));
    }

    @Override
    protected void getRecipeCatalystItemStacks(Consumer<ItemStack> consumer) {
        super.getRecipeCatalystItemStacks(consumer);
        consumer.accept(new ItemStack((ItemLike)BfrBlocks.FUSION_REACTOR_CONTROLLER));
        consumer.accept(new ItemStack((ItemLike)BfrBlocks.FUSION_REACTOR_FRAME));
        consumer.accept(new ItemStack((ItemLike)BfrBlocks.FUSION_REACTOR_PORT));
        consumer.accept(new ItemStack((ItemLike)BfrBlocks.FUSION_REACTOR_LOGIC_ADAPTER));
        consumer.accept(new ItemStack((ItemLike)BfrBlocks.LASER_FOCUS_MATRIX));
        consumer.accept(new ItemStack((ItemLike)GeneratorsBlocks.REACTOR_GLASS));
        List fusionFuelChemicals = MekanismAPI.CHEMICAL_REGISTRY.getTag(GeneratorTags.Chemicals.FUSION_FUEL).stream().flatMap(HolderSet.ListBacked::stream).toList();
        for (Holder chemical : fusionFuelChemicals) {
            consumer.accept(ChemicalUtil.getFilledVariant((ItemStack)new ItemStack((ItemLike)GeneratorsItems.HOHLRAUM.get()), (Holder)chemical));
        }
    }

    public static class FusionReactorCategoryWidget
    extends MultiblockWidget {
        protected CheckBoxWidget waterCooledCheckBox;
        protected IntSliderWithButtons portsWidget;
        protected IntSliderWithButtons logicAdaptersWidget;
        protected IntSliderWithButtons injectionRateWidget;

        @Override
        protected void collectOtherConfigs(Consumer<AbstractWidget> consumer) {
            super.collectOtherConfigs(consumer);
            this.waterCooledCheckBox = new CheckBoxWidget(0, 0, 0, 0, (Component)Component.translatable((String)"text.jei_mekanism_multiblocks.specs.water_cooled"), false);
            consumer.accept((AbstractWidget)this.waterCooledCheckBox);
            this.waterCooledCheckBox.addSelectedChangedHandler(this::onWaterCooledChanged);
            this.portsWidget = new IntSliderWithButtons(0, 0, 0, 0, "text.jei_mekanism_multiblocks.specs.ports", 0, 0, 0);
            consumer.accept(this.portsWidget);
            ((IntSliderWidget)((Object)this.portsWidget.getSlider())).addValueChangeHanlder(this::onPortsChanged);
            this.logicAdaptersWidget = new IntSliderWithButtons(0, 0, 0, 0, "text.jei_mekanism_multiblocks.specs.logic_adapters", 0, 0, 0);
            consumer.accept(this.logicAdaptersWidget);
            ((IntSliderWidget)((Object)this.logicAdaptersWidget.getSlider())).addValueChangeHanlder(this::onLogicAdaptersChanged);
            this.injectionRateWidget = new IntSliderWithButtons(0, 0, 0, 0, "text.jei_mekanism_multiblocks.specs.injection_rate", new Mod2IntSliderWidget(0, 0, 0, 0, (Component)Component.empty(), 2, 2, 1000, 1));
            consumer.accept(this.injectionRateWidget);
            ((IntSliderWidget)((Object)this.injectionRateWidget.getSlider())).addValueChangeHanlder(this::onInjectionRateChanged);
            this.updatePortsSliderLimit();
            this.updateInjectionRateInfoMessage();
        }

        @Override
        public void load(CompoundTag tag) {
            super.load(tag);
            this.setWaterCooled(tag.getBoolean("WaterCooled"));
            this.setPortCount(tag.getInt("PortCount"));
            this.setLogicAdapterCount(tag.getInt("LogicAdapterCount"));
            this.setInjectionRate(tag.getInt("InjectionRate"));
        }

        @Override
        public void save(CompoundTag tag) {
            super.save(tag);
            tag.putBoolean("WaterCooled", this.isWaterCooled());
            tag.putInt("PortCount", this.getPortCount());
            tag.putInt("LogicAdapterCount", this.getLogicAdapterCount());
            tag.putInt("InjectionRate", this.getInjectionRate());
        }

        @Override
        protected void onDimensionChanged() {
            super.onDimensionChanged();
            this.updatePortsSliderLimit();
        }

        @Override
        public int getCornerBlocks() {
            return 36;
        }

        @Override
        public int getSideBlocks() {
            return 28;
        }

        public void updatePortsSliderLimit() {
            IntSliderWidget portsSlider = (IntSliderWidget)((Object)this.portsWidget.getSlider());
            int minPorts = portsSlider.getMinValue();
            int ports = portsSlider.getValue();
            portsSlider.setMinValue(this.isWaterCooled() ? 4 : 2);
            portsSlider.setMaxValue(this.getSideBlocks());
            portsSlider.setValue(ports + (portsSlider.getMinValue() - minPorts));
            this.updateLogicAdaptersSliderLimit();
        }

        public void updateLogicAdaptersSliderLimit() {
            IntSliderWidget adaptersSlider = (IntSliderWidget)((Object)this.logicAdaptersWidget.getSlider());
            int adapters = adaptersSlider.getValue();
            adaptersSlider.setMaxValue(this.getSideBlocks() - this.getPortCount());
            adaptersSlider.setValue(adapters);
        }

        protected void onPortsChanged(int ports) {
            this.updateLogicAdaptersSliderLimit();
            this.markNeedUpdate();
        }

        protected void onLogicAdaptersChanged(int logicAdapters) {
            this.markNeedUpdate();
        }

        protected void onInjectionRateChanged(int injectionRate) {
            this.markNeedUpdate();
            this.updateInjectionRateInfoMessage();
        }

        protected void onWaterCooledChanged(boolean waterCooled) {
            this.updatePortsSliderLimit();
            this.markNeedUpdate();
            this.updateInjectionRateInfoMessage();
        }

        public void updateInjectionRateInfoMessage() {
            if (this.isWaterCooled()) {
                int limitedInjectionRate = Math.min(this.getInjectionRate(), 98);
                Tooltip tooltip = Tooltip.create((Component)Component.translatable((String)"text.jei_mekanism_multiblocks.tooltip.need_set_injection_rate", (Object[])new Object[]{limitedInjectionRate}));
                this.waterCooledCheckBox.setTooltip(tooltip);
                this.injectionRateWidget.setTooltip(tooltip);
            } else {
                this.waterCooledCheckBox.setTooltip(null);
                this.injectionRateWidget.setTooltip(null);
            }
        }

        @Override
        protected void collectCost(ICostConsumer consumer) {
            super.collectCost(consumer);
            int corners = this.getCornerBlocks();
            int sides = this.getSideBlocks();
            int ports = this.getPortCount();
            sides -= ports;
            int logicAdapter = this.getLogicAdapterCount();
            sides -= logicAdapter;
            int frames = 0;
            int glasses = 0;
            if (this.isUseGlass()) {
                frames = corners;
                glasses = sides;
            } else {
                frames = corners + sides;
                glasses = 0;
            }
            consumer.accept(new ItemStack((ItemLike)BfrBlocks.FUSION_REACTOR_CONTROLLER));
            consumer.accept(new ItemStack((ItemLike)BfrBlocks.FUSION_REACTOR_FRAME, frames));
            consumer.accept(new ItemStack((ItemLike)BfrBlocks.FUSION_REACTOR_PORT, ports));
            consumer.accept(new ItemStack((ItemLike)BfrBlocks.FUSION_REACTOR_LOGIC_ADAPTER, logicAdapter));
            consumer.accept(new ItemStack((ItemLike)BfrBlocks.LASER_FOCUS_MATRIX));
            consumer.accept(new ItemStack((ItemLike)this.getGlassBlock(), glasses));
        }

        @Override
        protected void collectResult(Consumer<AbstractWidget> consumer) {
            super.collectResult(consumer);
            int injectionRate = this.getInjectionRate();
            int limitedInjectionRate = Math.min(injectionRate, 98);
            long waterTank = MekanismGeneratorsConfig.generators.fusionWaterPerInjection.get() * limitedInjectionRate;
            long steamTank = MekanismGeneratorsConfig.generators.fusionSteamPerInjection.get() * (long)limitedInjectionRate;
            long fuelTank = MekanismGeneratorsConfig.generators.fusionFuelCapacity.get();
            long energyFusionFuel = MathUtils.clampToLong((double)((double)MekanismGeneratorsConfig.generators.energyPerFusionFuel.get() * 0.6666666666666666));
            double casingThermalConductivity = MekanismGeneratorsConfig.generators.fusionCasingThermalConductivity.get();
            double casingTemp = (double)MathUtils.multiplyClamped((long)energyFusionFuel, (long)injectionRate) / casingThermalConductivity;
            long steamProduction = 0L;
            if (this.isWaterCooled()) {
                double waterHeatingRatio = MekanismGeneratorsConfig.generators.fusionWaterHeatingRatio.get();
                double wateredCasingTemp = (double)MathUtils.multiplyClamped((long)energyFusionFuel, (long)injectionRate) / (casingThermalConductivity + waterHeatingRatio);
                double waterHeat = waterHeatingRatio * wateredCasingTemp;
                steamProduction = (long)(HeatUtils.getSteamEnergyEfficiency() * waterHeat / HeatUtils.getWaterThermalEnthalpy());
                steamProduction = Math.min(steamProduction, waterTank);
                double coolingHeat = (double)steamProduction / HeatUtils.getSteamEnergyEfficiency() * HeatUtils.getWaterThermalEnthalpy();
                double coolingCasingTemp = coolingHeat / casingThermalConductivity;
                casingTemp -= coolingCasingTemp;
            }
            double fusionThermocoupleEfficiency = MekanismGeneratorsConfig.generators.fusionThermocoupleEfficiency.get();
            double passiveGeneration = fusionThermocoupleEfficiency * casingThermalConductivity * casingTemp;
            consumer.accept(new ResultWidget((Component)Component.translatable((String)"text.jei_mekanism_multiblocks.result.passive_generation"), EnergyDisplay.of((long)MathUtils.clampToLong((double)passiveGeneration)).getTextComponent()));
            if (steamProduction > 0L) {
                consumer.accept(new ResultWidget((Component)Component.translatable((String)"text.jei_mekanism_multiblocks.result.steam_production"), VolumeTextHelper.formatMBt(steamProduction)));
            }
            consumer.accept(new ResultWidget((Component)Component.translatable((String)"text.jei_mekanism_multiblocks.result.fuel_tank"), VolumeTextHelper.formatMB(fuelTank)));
            if (this.isWaterCooled()) {
                MutableComponent injectionRateTooltip = Component.translatable((String)"text.jei_mekanism_multiblocks.tooltip.need_set_injection_rate", (Object[])new Object[]{limitedInjectionRate});
                ResultWidget watTankWidget = new ResultWidget((Component)Component.translatable((String)"text.jei_mekanism_multiblocks.result.water_tank"), VolumeTextHelper.formatMB(waterTank));
                watTankWidget.setJeiTooltip(new Component[]{injectionRateTooltip});
                consumer.accept(watTankWidget);
                ResultWidget steamTankWidget = new ResultWidget((Component)Component.translatable((String)"text.jei_mekanism_multiblocks.result.steam_tank"), VolumeTextHelper.formatMB(steamTank));
                steamTankWidget.setJeiTooltip(new Component[]{injectionRateTooltip});
                consumer.accept(steamTankWidget);
            }
            consumer.accept(new ResultWidget((Component)Component.translatable((String)"text.jei_mekanism_multiblocks.result.energy_capacity"), EnergyDisplay.of((long)MekanismGeneratorsConfig.generators.fusionEnergyCapacity.get()).getTextComponent()));
        }

        public int getPortCount() {
            return ((IntSliderWidget)((Object)this.portsWidget.getSlider())).getValue();
        }

        public void setPortCount(int portCount) {
            ((IntSliderWidget)((Object)this.portsWidget.getSlider())).setValue(portCount);
        }

        public int getLogicAdapterCount() {
            return ((IntSliderWidget)((Object)this.logicAdaptersWidget.getSlider())).getValue();
        }

        public void setLogicAdapterCount(int logicAdapterCount) {
            ((IntSliderWidget)((Object)this.logicAdaptersWidget.getSlider())).setValue(logicAdapterCount);
        }

        public int getInjectionRate() {
            return ((IntSliderWidget)((Object)this.injectionRateWidget.getSlider())).getValue();
        }

        public void setInjectionRate(int injectionRate) {
            ((IntSliderWidget)((Object)this.injectionRateWidget.getSlider())).setValue(injectionRate);
        }

        public boolean isWaterCooled() {
            return this.waterCooledCheckBox.isSelected();
        }

        public void setWaterCooled(boolean waterCooled) {
            this.waterCooledCheckBox.setSelected(waterCooled);
        }

        @Override
        public int getDimensionWidthMin() {
            return 5;
        }

        @Override
        public int getDimensionWidthMax() {
            return 5;
        }

        @Override
        public int getDimensionLengthMin() {
            return 5;
        }

        @Override
        public int getDimensionLengthMax() {
            return 5;
        }

        @Override
        public int getDimensionHeightMin() {
            return 5;
        }

        @Override
        public int getDimensionHeightMax() {
            return 5;
        }

        @Override
        public Block getGlassBlock() {
            return (Block)GeneratorsBlocks.REACTOR_GLASS.get();
        }
    }
}

