/*
 * Decompiled with CFR 0.152.
 */
package dev.uncandango.kubejstweaks.kubejs.kjs71.mixin.core.main;

import com.google.gson.JsonObject;
import com.llamalad7.mixinextras.injector.ModifyReceiver;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import dev.latvian.mods.kubejs.recipe.schema.JsonRecipeSchemaLoader;
import dev.uncandango.kubejstweaks.KubeJSTweaks;
import dev.uncandango.kubejstweaks.mixin.annotation.ConditionalMixin;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.ModList;
import net.neoforged.neoforgespi.language.IModFileInfo;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Coerce;
import org.spongepowered.asm.mixin.injection.ModifyArg;

@ConditionalMixin(modId="kubejs", versionRange="[2101.7.1-build.181]")
@Mixin(value={JsonRecipeSchemaLoader.class})
public class JsonRecipeSchemaLoaderMixin {
    @ModifyReceiver(method={"load"}, at={@At(value="FIELD", target="Ldev/latvian/mods/kubejs/recipe/schema/JsonRecipeSchemaLoader$RecipeSchemaBuilder;keys:Ljava/util/List;", ordinal=1)})
    @Coerce
    private static Object grabHolder(@Coerce Object instance, @Share(value="holder") LocalRef<RecipeSchemaBuilderAccessor> holderRef) {
        holderRef.set((Object)((RecipeSchemaBuilderAccessor)instance));
        return instance;
    }

    @ModifyArg(method={"load"}, at=@At(value="INVOKE", target="Ljava/util/HashMap;put(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;"), index=1)
    private static Object clearJsonIfModNotLoaded(Object value) {
        ResourceLocation id = ((RecipeSchemaBuilderAccessor)value).kjstweaks$getId();
        JsonObject json = ((RecipeSchemaBuilderAccessor)value).kjstweaks$getJson();
        if (!ModList.get().isLoaded(id.getNamespace())) {
            json.asMap().clear();
            KubeJSTweaks.LOGGER.info("Skipping schema {} for mod NOT loaded: {}", (Object)id, (Object)id.getNamespace());
        }
        return value;
    }

    @WrapWithCondition(method={"load"}, at={@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z", ordinal=1)})
    private static boolean checkVersion(List<Object> instance, Object e, @Local JsonObject keyJson, @Share(value="holder") LocalRef<RecipeSchemaBuilderAccessor> holderRef) {
        ResourceLocation type = ((RecipeSchemaBuilderAccessor)holderRef.get()).kjstweaks$getId();
        String modId = type.getNamespace();
        if (keyJson.has("kubejstweaks:version_range")) {
            String range = keyJson.getAsJsonPrimitive("kubejstweaks:version_range").getAsString();
            KubeJSTweaks.LOGGER.debug("Mod id {} with conditional version {}", (Object)modId, (Object)range);
            try {
                VersionRange rangeSpec = VersionRange.createFromVersionSpec((String)range);
                IModFileInfo modFile = ModList.get().getModFileById(modId);
                if (modFile != null) {
                    DefaultArtifactVersion modVersion = new DefaultArtifactVersion(modFile.versionString());
                    if (rangeSpec.containsVersion((ArtifactVersion)modVersion)) {
                        KubeJSTweaks.LOGGER.debug("Key component for type {} with version range {} matches with mod version {}.", new Object[]{type, range, modVersion});
                        return true;
                    }
                    KubeJSTweaks.LOGGER.debug("Key component for type {} with version range {} DOES NOT match with mod version {}.", new Object[]{type, range, modVersion});
                } else {
                    KubeJSTweaks.LOGGER.warn("Mod {} was not found for key component type {}.", (Object)modId, (Object)type);
                }
            }
            catch (InvalidVersionSpecificationException ex) {
                KubeJSTweaks.LOGGER.error("Error evaluating version for a key component for mod: " + modId, (Throwable)ex);
            }
            return false;
        }
        return true;
    }

    @ConditionalMixin(modId="kubejs", versionRange="[2101.7.1-build.181]")
    @Mixin(targets={"dev.latvian.mods.kubejs.recipe.schema.JsonRecipeSchemaLoader$RecipeSchemaBuilder"})
    public static interface RecipeSchemaBuilderAccessor {
        @Accessor(value="id")
        public ResourceLocation kjstweaks$getId();

        @Accessor(value="json")
        public JsonObject kjstweaks$getJson();
    }
}

