/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.item.component;

import com.buuz135.functionalstorage.block.tile.ControllableDrawerTile;
import com.buuz135.functionalstorage.item.component.FunctionalUpgradeBehavior;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public record GenerateFluidBehavior(FluidStack fluid) implements FunctionalUpgradeBehavior
{
    public static final MapCodec<GenerateFluidBehavior> CODEC = RecordCodecBuilder.mapCodec(in -> in.group((App)FluidStack.CODEC.fieldOf("fluid").forGetter(GenerateFluidBehavior::fluid)).apply((Applicative)in, GenerateFluidBehavior::new));

    @Override
    public void work(Level level, BlockPos pos, ControllableDrawerTile<?> drawer, ItemStack upgradeStack, int upgradeSlot) {
        IFluidHandler capability = (IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, pos, (Object)Direction.UP);
        if (capability != null) {
            capability.fill(this.fluid.copy(), IFluidHandler.FluidAction.EXECUTE);
        }
    }

    @Override
    public MapCodec<? extends FunctionalUpgradeBehavior> codec() {
        return CODEC;
    }

    @Override
    public List<Component> getTooltip() {
        List<Component> list = FunctionalUpgradeBehavior.super.getTooltip();
        list.add((Component)Component.translatable((String)"functionalupgrade.desc.generate_fluid", (Object[])new Object[]{this.fluid.getAmount(), this.fluid.getHoverName().getString()}));
        return list;
    }
}

