/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.model.armor;

import com.google.common.collect.ImmutableList;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.joml.Vector3f;
import twilightforest.components.entity.TravellersWingsAnimAttachment;
import twilightforest.init.TFDataAttachments;
import twilightforest.util.TFMathUtil;

public class TravellersWingsModel
extends HumanoidModel<LivingEntity> {
    private static final double TAU = 4.0;
    private static final float ANGLE_10_DEG = 0.17453294f;
    private static final Vector3f SMALL_SWING = new Vector3f(8.0f, 8.0f, 8.0f);
    private static final Vector3f BIG_SWING = new Vector3f(15.0f, 15.0f, 15.0f);
    private static final float BASE_OFFSET = -0.5f;
    private static final float PART_OFFSET = 0.002f;
    private final ModelPart wingBaseRight;
    private final ModelPart wingBaseLeft;
    private final List<ModelPart> wingPartsRight;
    private final List<ModelPart> wingPartsLeft;
    private final Camera mainCamera;

    public TravellersWingsModel(ModelPart root) {
        super(root);
        root = root.getChild("body");
        this.wingBaseLeft = root.getChild("wingBaseLeft");
        this.wingPartsLeft = List.of(this.wingBaseLeft.getChild("wingEdgeLeft"), this.wingBaseLeft.getChild("wingInsetLeft"), this.wingBaseLeft.getChild("wingCenterLeft"), this.wingBaseLeft.getChild("wingFlangeLeft"), this.wingBaseLeft.getChild("wingAuxLeft"));
        this.wingBaseRight = root.getChild("wingBaseRight");
        this.wingPartsRight = List.of(this.wingBaseRight.getChild("wingEdgeRight"), this.wingBaseRight.getChild("wingInsetRight"), this.wingBaseRight.getChild("wingCenterRight"), this.wingBaseRight.getChild("wingFlangeRight"), this.wingBaseRight.getChild("wingAuxRight"));
        this.body.skipDraw = true;
        this.mainCamera = Minecraft.getInstance().gameRenderer.getMainCamera();
    }

    public static LayerDefinition createLayer(float deformation) {
        MeshDefinition mesh = HumanoidModel.createMesh((CubeDeformation)new CubeDeformation(deformation), (float)0.0f);
        PartDefinition root = mesh.getRoot().getChild("body");
        TravellersWingsModel.createWings(root);
        TravellersWingsModel.createBelt(root, 0.0f);
        return LayerDefinition.create((MeshDefinition)mesh, (int)128, (int)32);
    }

    protected static void createWings(PartDefinition root) {
        PartDefinition wbl = root.addOrReplaceChild("wingBaseLeft", CubeListBuilder.create().texOffs(64, 9).mirror().addBox(-0.5f, -1.0f, 0.0f, 1.0f, 2.0f, 10.0f), PartPose.offsetAndRotation((float)1.0f, (float)1.0f, (float)0.0f, (float)0.5235988f, (float)0.5235988f, (float)0.0f));
        wbl.addOrReplaceChild("wingEdgeLeft", CubeListBuilder.create().texOffs(64, 21).mirror().addBox(0.0f, 0.0f, -2.0f, 1.0f, 9.0f, 2.0f), PartPose.offsetAndRotation((float)-0.498f, (float)-1.0f, (float)10.0f, (float)0.5235988f, (float)0.0f, (float)0.0f));
        wbl.addOrReplaceChild("wingInsetLeft", CubeListBuilder.create().texOffs(70, 21).mirror().addBox(0.0f, 0.0f, -1.0f, 1.0f, 9.0f, 2.0f), PartPose.offsetAndRotation((float)-0.496f, (float)0.0f, (float)7.8f, (float)0.34906587f, (float)0.0f, (float)0.0f));
        wbl.addOrReplaceChild("wingCenterLeft", CubeListBuilder.create().texOffs(76, 21).mirror().addBox(0.0f, 0.0f, -1.0f, 1.0f, 9.0f, 2.0f), PartPose.offsetAndRotation((float)-0.494f, (float)0.3f, (float)6.3f, (float)0.17453294f, (float)0.0f, (float)0.0f));
        wbl.addOrReplaceChild("wingFlangeLeft", CubeListBuilder.create().texOffs(82, 21).mirror().addBox(0.0f, 0.0f, -1.0f, 1.0f, 8.0f, 2.0f), PartPose.offsetAndRotation((float)-0.492f, (float)0.3f, (float)5.1f, (float)0.0f, (float)0.0f, (float)0.0f));
        wbl.addOrReplaceChild("wingAuxLeft", CubeListBuilder.create().texOffs(88, 21).mirror().addBox(0.0f, 0.0f, -1.0f, 1.0f, 7.0f, 2.0f), PartPose.offsetAndRotation((float)-0.49f, (float)0.1f, (float)4.0f, (float)-0.17453294f, (float)0.0f, (float)0.0f));
        PartDefinition wbr = root.addOrReplaceChild("wingBaseRight", CubeListBuilder.create().texOffs(98, 9).addBox(-0.5f, -1.0f, 0.0f, 1.0f, 2.0f, 10.0f), PartPose.offsetAndRotation((float)-1.0f, (float)1.0f, (float)0.0f, (float)0.5235988f, (float)-0.5235988f, (float)0.0f));
        wbr.addOrReplaceChild("wingEdgeRight", CubeListBuilder.create().texOffs(98, 21).addBox(0.0f, 0.0f, -2.0f, 1.0f, 9.0f, 2.0f), PartPose.offsetAndRotation((float)-0.502f, (float)-1.0f, (float)10.0f, (float)0.5235988f, (float)0.0f, (float)0.0f));
        wbr.addOrReplaceChild("wingInsetRight", CubeListBuilder.create().texOffs(104, 21).addBox(0.0f, 0.0f, -1.0f, 1.0f, 9.0f, 2.0f), PartPose.offsetAndRotation((float)-0.504f, (float)0.0f, (float)7.8f, (float)0.34906587f, (float)0.0f, (float)0.0f));
        wbr.addOrReplaceChild("wingCenterRight", CubeListBuilder.create().texOffs(110, 21).addBox(0.0f, 0.0f, -1.0f, 1.0f, 9.0f, 2.0f), PartPose.offsetAndRotation((float)-0.506f, (float)0.3f, (float)6.3f, (float)0.17453294f, (float)0.0f, (float)0.0f));
        wbr.addOrReplaceChild("wingFlangeRight", CubeListBuilder.create().texOffs(116, 21).addBox(0.0f, 0.0f, -1.0f, 1.0f, 8.0f, 2.0f), PartPose.offsetAndRotation((float)-0.508f, (float)0.3f, (float)5.1f, (float)0.0f, (float)0.0f, (float)0.0f));
        wbr.addOrReplaceChild("wingAuxRight", CubeListBuilder.create().texOffs(122, 21).addBox(0.0f, 0.0f, -1.0f, 1.0f, 7.0f, 2.0f), PartPose.offsetAndRotation((float)-0.51f, (float)0.1f, (float)4.0f, (float)-0.17453294f, (float)0.0f, (float)0.0f));
    }

    protected static void createBelt(PartDefinition root, float deformation) {
        CubeDeformation cubeDeformation = new CubeDeformation(deformation);
        root.addOrReplaceChild("buckle", CubeListBuilder.create().texOffs(8, 9).addBox(-2.0f, -2.0f, 0.0f, 4.0f, 4.0f, 1.0f, cubeDeformation), PartPose.offset((float)0.0f, (float)10.0f, (float)-2.75f));
        root.addOrReplaceChild("frontRight", CubeListBuilder.create().texOffs(0, 9).addBox(-3.0f, -1.0f, 0.0f, 3.0f, 2.0f, 1.0f, cubeDeformation), PartPose.offset((float)-1.75f, (float)10.0f, (float)-2.5f));
        root.addOrReplaceChild("frontLeft", CubeListBuilder.create().texOffs(18, 9).addBox(0.0f, -1.0f, 0.0f, 3.0f, 2.0f, 1.0f, cubeDeformation), PartPose.offset((float)1.75f, (float)10.0f, (float)-2.5f));
        root.addOrReplaceChild("sideRight", CubeListBuilder.create().texOffs(0, 3).addBox(-1.0f, -1.0f, 0.0f, 1.0f, 2.0f, 4.0f, cubeDeformation.extend(-0.01f)), PartPose.offset((float)-3.75f, (float)10.0f, (float)-2.0f));
        root.addOrReplaceChild("sideLeft", CubeListBuilder.create().texOffs(16, 3).addBox(0.0f, -1.0f, 0.0f, 1.0f, 2.0f, 4.0f, cubeDeformation.extend(-0.01f)), PartPose.offset((float)3.75f, (float)10.0f, (float)-2.0f));
        root.addOrReplaceChild("back", CubeListBuilder.create().texOffs(2, 0).addBox(-4.5f, -1.0f, 0.0f, 9.0f, 2.0f, 1.0f, cubeDeformation), PartPose.offset((float)0.0f, (float)10.0f, (float)1.5f));
    }

    /*
     * Unable to fully structure code
     */
    public void setupModelAnimations(LivingEntity entity, float f, float f1, double ageInTicks, float netHeadYaw, float headPitch) {
        block9: {
            block11: {
                block12: {
                    block10: {
                        block8: {
                            this.bodyParts().forEach((Consumer<ModelPart>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$setupModelAnimations$0(net.minecraft.client.model.geom.ModelPart ), (Lnet/minecraft/client/model/geom/ModelPart;)V)());
                            super.setupAnim(entity, f, f1, (float)ageInTicks, netHeadYaw, headPitch);
                            attachment = (TravellersWingsAnimAttachment)entity.getData(TFDataAttachments.TRAVELLERS_WINGS_ANIM);
                            dtInTicks = ageInTicks - attachment.oldAgeInTicks;
                            if (entity.isCrouching()) {
                                this.wingBaseRight.y += 2.0f;
                                this.wingBaseLeft.y += 2.0f;
                            }
                            if (!attachment.doubleJump || !(attachment.doubleJumpTime < 13.33)) break block8;
                            this.wingBaseRight.xRot = (float)TFMathUtil.interpolateToTarget(attachment.xRotOld, -0.4000000059604645, dtInTicks, 3.0);
                            this.wingBaseRight.yRot = (float)TFMathUtil.interpolateToTarget(attachment.yRotOld, -0.800000011920929, dtInTicks, 3.0);
                            this.wingBaseRight.zRot = (float)TFMathUtil.interpolateToTarget(attachment.zRotOld, -0.10000000149011612, dtInTicks, 3.0);
                            attachment.doubleJumpTime += dtInTicks;
                            break block9;
                        }
                        if (!this.riding) break block10;
                        rotations = this.calculateRotations(attachment, dtInTicks, 10.0f, 0.5235988f, -0.6f, -0.3f, TravellersWingsModel.BIG_SWING);
                        break block11;
                    }
                    if (!entity.isSwimming()) break block12;
                    rotations = this.calculateRotations(attachment, dtInTicks, 17.0f, 0.69813174f, -1.0f, -0.5f, TravellersWingsModel.BIG_SWING);
                    break block11;
                }
                if (entity.onGround() || entity.isInLiquid() || !(entity.fallDistance < 2.3f)) ** GOTO lbl-1000
                if (!(entity instanceof Player)) ** GOTO lbl-1000
                player = (Player)entity;
                if (!player.getAbilities().flying) lbl-1000:
                // 2 sources

                {
                    rotations = this.calculateRotations(attachment, dtInTicks, 17.0f, 0.8726647f, -1.1f, -0.1f, TravellersWingsModel.BIG_SWING);
                } else if (entity.getDeltaMovement().y < 0.0 && entity.fallDistance > 2.3f) {
                    rotations = this.calculateRotations(attachment, dtInTicks, 2.0f, 0.69813174f, -1.1f, -0.3f, TravellersWingsModel.SMALL_SWING);
                } else if (entity.isSprinting() || this.attackTime > 0.0f) {
                    rotations = this.calculateRotations(attachment, dtInTicks, 2.0f, 0.5235988f, -0.3f, 0.0f, TravellersWingsModel.BIG_SWING);
                } else {
                    phaseDivisor = (double)entity.walkAnimation.speed() > 0.1 ? 4.0f : 20.0f;
                    rotations = this.calculateRotations(attachment, dtInTicks, phaseDivisor, 0.5235988f, -0.6f, -0.3f, TravellersWingsModel.BIG_SWING);
                }
            }
            this.wingBaseRight.xRot = (float)TFMathUtil.interpolateToTarget(attachment.xRotOld, rotations.x, dtInTicks, 4.0);
            this.wingBaseRight.yRot = (float)TFMathUtil.interpolateToTarget(attachment.yRotOld, rotations.y, dtInTicks, 4.0);
            this.wingBaseRight.zRot = (float)TFMathUtil.interpolateToTarget(attachment.zRotOld, rotations.z, dtInTicks, 4.0);
        }
        this.wingBaseLeft.xRot = this.wingBaseRight.xRot;
        this.wingBaseLeft.yRot = -this.wingBaseRight.yRot;
        this.wingBaseLeft.zRot = -this.wingBaseRight.zRot;
        attachment.accumulatedPhase %= 6.2831854820251465;
        attachment.oldAgeInTicks = ageInTicks;
        attachment.xRotOld = this.wingBaseRight.xRot;
        attachment.yRotOld = this.wingBaseRight.yRot;
        attachment.zRotOld = this.wingBaseRight.zRot;
        distance = (float)(Math.sqrt(entity.distanceToSqr(this.mainCamera.getPosition())) * 0.0020000000949949026);
        partCount = Math.min(this.wingPartsLeft.size(), this.wingPartsRight.size());
        for (partIndex = 0; partIndex < partCount; ++partIndex) {
            offset = (float)(partIndex + 1) * distance;
            this.wingPartsLeft.get((int)partIndex).x = -0.5f + offset;
            this.wingPartsRight.get((int)partIndex).x = -0.5f - offset;
        }
    }

    private Vector3f calculateRotations(TravellersWingsAnimAttachment attachment, double dtInTicks, float phaseDivisor, float xOffset, float yOffset, float zOffset, Vector3f sinDivisors) {
        attachment.accumulatedPhase += dtInTicks / (double)phaseDivisor;
        float sinT = (float)Math.sin(attachment.accumulatedPhase);
        return new Vector3f(sinT / sinDivisors.x + xOffset, sinT / sinDivisors.y + yOffset, sinT / sinDivisors.z + zOffset);
    }

    protected Iterable<ModelPart> headParts() {
        return Collections.emptyList();
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body, (Object)this.leftLeg, (Object)this.rightLeg);
    }

    public static void skipWings(ModelPart leggingsLayer, boolean skip) {
        ModelPart body = leggingsLayer.getChild("body");
        ModelPart wbl = body.getChild("wingBaseLeft");
        wbl.skipDraw = skip;
        wbl.getChild((String)"wingEdgeLeft").skipDraw = skip;
        wbl.getChild((String)"wingInsetLeft").skipDraw = skip;
        wbl.getChild((String)"wingCenterLeft").skipDraw = skip;
        wbl.getChild((String)"wingFlangeLeft").skipDraw = skip;
        wbl.getChild((String)"wingAuxLeft").skipDraw = skip;
        ModelPart wbr = body.getChild("wingBaseRight");
        wbr.skipDraw = skip;
        wbr.getChild((String)"wingEdgeRight").skipDraw = skip;
        wbr.getChild((String)"wingInsetRight").skipDraw = skip;
        wbr.getChild((String)"wingCenterRight").skipDraw = skip;
        wbr.getChild((String)"wingFlangeRight").skipDraw = skip;
        wbr.getChild((String)"wingAuxRight").skipDraw = skip;
    }

    public static void skipBelt(ModelPart leggingsLayer, boolean skip) {
        ModelPart body = leggingsLayer.getChild("body");
        body.getChild((String)"buckle").skipDraw = skip;
        body.getChild((String)"frontRight").skipDraw = skip;
        body.getChild((String)"frontLeft").skipDraw = skip;
        body.getChild((String)"sideRight").skipDraw = skip;
        body.getChild((String)"sideLeft").skipDraw = skip;
        body.getChild((String)"back").skipDraw = skip;
    }

    private static /* synthetic */ void lambda$setupModelAnimations$0(ModelPart modelPart) {
        modelPart.getAllParts().forEach(ModelPart::resetPose);
    }
}

