/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.model.item;

import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.math.Transformation;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.RenderTypeGroup;
import net.neoforged.neoforge.client.model.CompositeModel;
import net.neoforged.neoforge.client.model.DynamicFluidContainerModel;
import net.neoforged.neoforge.client.model.SimpleModelState;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import net.neoforged.neoforge.client.model.geometry.IUnbakedGeometry;
import net.neoforged.neoforge.client.model.geometry.StandaloneGeometryBakingContext;
import net.neoforged.neoforge.client.model.geometry.UnbakedGeometryHelper;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import twilightforest.TwilightForestMod;
import twilightforest.init.TFDataComponents;
import twilightforest.init.custom.TravellersModifiersManager;
import twilightforest.item.travellers_gear.TravellersArmorItem;
import twilightforest.item.travellers_gear.modifiers.TravellersModifier;

public class TravellersGearItemModel
implements IUnbakedGeometry<TravellersGearItemModel> {
    private static final Function<Float, Transformation> TRANSFORM = f -> new Transformation(null, null, new Vector3f(1.0f + f.floatValue()), null);
    private final List<Holder.Reference<TravellersModifier>> modifiers;
    private final String directory;
    private final boolean broken;
    private final String brokenDirectory;
    private final boolean showGloves;

    TravellersGearItemModel(List<Holder.Reference<TravellersModifier>> modifiers, String directory, boolean broken, String brokenDirectory, boolean showGloves) {
        this.modifiers = modifiers;
        this.directory = directory;
        this.broken = broken;
        this.brokenDirectory = brokenDirectory;
        this.showGloves = showGloves;
    }

    public TravellersGearItemModel withModifiers(List<Holder.Reference<TravellersModifier>> modifiers, boolean broken, boolean showGloves) {
        return new TravellersGearItemModel(modifiers, this.directory, broken, this.brokenDirectory, showGloves);
    }

    public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides) {
        TextureAtlasSprite modSprite;
        TextureAtlasSprite sprite = this.getSprite(context, spriteGetter);
        StandaloneGeometryBakingContext itemContext = StandaloneGeometryBakingContext.builder((IGeometryBakingContext)context).withGui3d(false).withUseBlockLight(false).build(TwilightForestMod.prefix("travellers_gear"));
        CompositeModel.Baked.Builder modelBuilder = CompositeModel.Baked.builder((IGeometryBakingContext)itemContext, null, (ItemOverrides)new Overrides(overrides, this, baker, (IGeometryBakingContext)itemContext), (ItemTransforms)context.getTransforms());
        RenderTypeGroup normalRenderTypes = DynamicFluidContainerModel.getLayerRenderTypes((boolean)false);
        if (sprite != null) {
            List unbaked = UnbakedGeometryHelper.createUnbakedItemElements((int)0, (TextureAtlasSprite)sprite);
            List quads = UnbakedGeometryHelper.bakeElements((List)unbaked, $ -> sprite, (ModelState)modelState);
            modelBuilder.addQuads(normalRenderTypes, (Collection)quads);
        }
        int layers = 1;
        for (Holder.Reference reference : this.modifiers) {
            TextureAtlasSprite modSprite2 = this.getModifierSprite((ResourceKey<TravellersModifier>)reference.key(), spriteGetter);
            if (modSprite2.contents().name().equals((Object)MissingTextureAtlasSprite.getLocation())) continue;
            List unbaked = UnbakedGeometryHelper.createUnbakedItemElements((int)0, (TextureAtlasSprite)modSprite2);
            List quads = UnbakedGeometryHelper.bakeElements((List)unbaked, $ -> modSprite2, (ModelState)new SimpleModelState(modelState.getRotation().compose(TRANSFORM.apply(Float.valueOf((float)layers * 0.001f))), modelState.isUvLocked()));
            modelBuilder.addQuads(normalRenderTypes, (Collection)quads);
            ++layers;
        }
        if (this.showGloves && !(modSprite = spriteGetter.apply(ClientHooks.getBlockMaterial((ResourceLocation)TwilightForestMod.prefix("item/" + (this.broken ? this.brokenDirectory : this.directory) + "gloves")))).contents().name().equals((Object)MissingTextureAtlasSprite.getLocation())) {
            List list = UnbakedGeometryHelper.createUnbakedItemElements((int)0, (TextureAtlasSprite)modSprite);
            List quads = UnbakedGeometryHelper.bakeElements((List)list, $ -> modSprite, (ModelState)new SimpleModelState(modelState.getRotation().compose(TRANSFORM.apply(Float.valueOf((float)layers * 0.001f))), modelState.isUvLocked()));
            modelBuilder.addQuads(normalRenderTypes, (Collection)quads);
        }
        modelBuilder.setParticle(sprite);
        return modelBuilder.build();
    }

    @Nullable
    private TextureAtlasSprite getSprite(IGeometryBakingContext context, Function<Material, TextureAtlasSprite> spriteGetter) {
        Material baseLocation;
        Material material = baseLocation = context.hasMaterial("base") ? context.getMaterial("base") : null;
        if (this.broken) {
            Material brokenLocation;
            Material material2 = brokenLocation = context.hasMaterial("broken") ? context.getMaterial("broken") : null;
            return brokenLocation != null ? spriteGetter.apply(brokenLocation) : (baseLocation != null ? spriteGetter.apply(baseLocation) : null);
        }
        return baseLocation != null ? spriteGetter.apply(baseLocation) : null;
    }

    private TextureAtlasSprite getModifierSprite(ResourceKey<TravellersModifier> modifier, Function<Material, TextureAtlasSprite> spriteGetter) {
        return spriteGetter.apply(ClientHooks.getBlockMaterial((ResourceLocation)modifier.location().withPrefix("item/" + (this.broken ? this.brokenDirectory : this.directory))));
    }

    private static final class Overrides
    extends ItemOverrides {
        private final Map<String, BakedModel> possibleCombos = Maps.newHashMap();
        private final ItemOverrides nested;
        private final TravellersGearItemModel parent;
        private final ModelBaker baker;
        private final IGeometryBakingContext owner;

        private Overrides(ItemOverrides nested, TravellersGearItemModel parent, ModelBaker baker, IGeometryBakingContext owner) {
            this.nested = nested;
            this.parent = parent;
            this.baker = baker;
            this.owner = owner;
        }

        @Nullable
        public BakedModel resolve(BakedModel originalModel, ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int seed) {
            BakedModel overridden = this.nested.resolve(originalModel, stack, level, entity, seed);
            if (overridden != originalModel) {
                return overridden;
            }
            if (level == null) {
                level = Minecraft.getInstance().level;
            }
            if (level == null) {
                return originalModel;
            }
            List<Holder.Reference<TravellersModifier>> modifiers = TravellersModifiersManager.findAllInsertableModifiers((Level)level, stack);
            boolean broken = TravellersArmorItem.isTravellersArmorAndBroken(stack);
            boolean gloves = stack.has(TFDataComponents.TRAVELLERS_HAS_GLOVES);
            String key = BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).getPath() + this.getModifiersSuffix(modifiers, broken, gloves);
            if (!this.possibleCombos.containsKey(key)) {
                TravellersGearItemModel unbaked = this.parent.withModifiers(modifiers, broken, gloves);
                BakedModel bakedModel = unbaked.bake(this.owner, this.baker, Material::sprite, (ModelState)BlockModelRotation.X0_Y0, this);
                this.possibleCombos.put(key, bakedModel);
                return bakedModel;
            }
            return this.possibleCombos.get(key);
        }

        private String getModifiersSuffix(List<Holder.Reference<TravellersModifier>> modifiers, boolean broken, boolean gloves) {
            StringBuilder ret = new StringBuilder();
            if (gloves) {
                ret.append("_gloves");
            }
            if (broken) {
                ret.append("_broken");
            }
            for (Holder.Reference<TravellersModifier> mod : modifiers) {
                ret.append("_").append(mod.key().location().toLanguageKey());
            }
            return ret.toString();
        }
    }

    public static final class Loader
    implements IGeometryLoader<TravellersGearItemModel> {
        public static final Loader INSTANCE = new Loader();

        private Loader() {
        }

        public TravellersGearItemModel read(JsonObject object, JsonDeserializationContext context) {
            return new TravellersGearItemModel(List.of(), GsonHelper.getAsString((JsonObject)object, (String)"modifier_directory"), false, GsonHelper.getAsString((JsonObject)object, (String)"broken_modifier_directory"), false);
        }
    }
}

