/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.command;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.function.Function;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceKeyArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.common.util.FakePlayer;
import twilightforest.TFRegistries;
import twilightforest.beanification.Component;
import twilightforest.init.custom.TravellersModifiersManager;
import twilightforest.item.travellers_gear.TravellersArmorItem;
import twilightforest.item.travellers_gear.modifiers.InsertableTravellersModifier;
import twilightforest.item.travellers_gear.modifiers.TravellersModifiable;
import twilightforest.item.travellers_gear.modifiers.TravellersModifier;

@Component
public class TravellersGearCommand {
    private static final DynamicCommandExceptionType ERROR_INVALID_MODIFIER = new DynamicCommandExceptionType(p_304101_ -> net.minecraft.network.chat.Component.translatableEscape((String)"commands.tffeature.invalid_modifier", (Object[])new Object[]{p_304101_}));
    private final SimpleCommandExceptionType ERROR_NOT_RUN_BY_PLAYER = new SimpleCommandExceptionType((Message)net.minecraft.network.chat.Component.translatable((String)"commands.tffeature.not_player"));
    private final SimpleCommandExceptionType ERROR_NOT_HOLDING_GEAR = new SimpleCommandExceptionType((Message)net.minecraft.network.chat.Component.translatable((String)"commands.tffeature.not_travellers_gear"));
    private final SimpleCommandExceptionType ERROR_TOO_MANY_MODIFIERS = new SimpleCommandExceptionType((Message)net.minecraft.network.chat.Component.translatable((String)"commands.tffeature.too_many_modifiers"));
    private final Function<net.minecraft.network.chat.Component, SimpleCommandExceptionType> ERROR_NO_MODIFIER = component -> new SimpleCommandExceptionType((Message)net.minecraft.network.chat.Component.translatable((String)"commands.tffeature.no_modifier", (Object[])new Object[]{component}));
    private final Function<net.minecraft.network.chat.Component, SimpleCommandExceptionType> ERROR_HAS_MODIFIER = component -> new SimpleCommandExceptionType((Message)net.minecraft.network.chat.Component.translatable((String)"commands.tffeature.has_modifier", (Object[])new Object[]{component}));
    private final Function<net.minecraft.network.chat.Component, SimpleCommandExceptionType> ERROR_WRONG_SLOT = component -> new SimpleCommandExceptionType((Message)net.minecraft.network.chat.Component.translatable((String)"commands.tffeature.wrong_modifier_slot", (Object[])new Object[]{component}));
    private final SimpleCommandExceptionType ERROR_ABILITY = new SimpleCommandExceptionType((Message)net.minecraft.network.chat.Component.translatable((String)"commands.tffeature.ability_modifier"));

    public LiteralArgumentBuilder<CommandSourceStack> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"travellers_gear").requires(cs -> cs.hasPermission(2))).then(Commands.literal((String)"add_modifier").then(Commands.argument((String)"modifier", (ArgumentType)ResourceKeyArgument.key(TFRegistries.Keys.TRAVELLERS_MODIFIERS)).executes(context -> this.addModifier((CommandSourceStack)context.getSource(), (Holder.Reference<TravellersModifier>)ResourceKeyArgument.resolveKey((CommandContext)context, (String)"modifier", TFRegistries.Keys.TRAVELLERS_MODIFIERS, (DynamicCommandExceptionType)ERROR_INVALID_MODIFIER)))))).then(Commands.literal((String)"remove_modifier").then(Commands.argument((String)"modifier", (ArgumentType)ResourceKeyArgument.key(TFRegistries.Keys.TRAVELLERS_MODIFIERS)).executes(context -> this.removeModifier((CommandSourceStack)context.getSource(), (Holder.Reference<TravellersModifier>)ResourceKeyArgument.resolveKey((CommandContext)context, (String)"modifier", TFRegistries.Keys.TRAVELLERS_MODIFIERS, (DynamicCommandExceptionType)ERROR_INVALID_MODIFIER)))));
    }

    private int addModifier(CommandSourceStack source, Holder.Reference<TravellersModifier> modifier) throws CommandSyntaxException {
        Player player;
        MutableComponent modKey = net.minecraft.network.chat.Component.translatable((String)modifier.key().location().toLanguageKey(((TravellersModifier)modifier.value()).getPrefix()));
        Entity entity = source.getEntity();
        if (!(entity instanceof Player) || (player = (Player)entity) instanceof FakePlayer) {
            throw this.ERROR_NOT_RUN_BY_PLAYER.create();
        }
        Item item = player.getMainHandItem().getItem();
        if (!(item instanceof TravellersModifiable)) {
            throw this.ERROR_NOT_HOLDING_GEAR.create();
        }
        TravellersModifiable armor = (TravellersModifiable)item;
        if (((TravellersModifier)modifier.value()).isAbility()) {
            throw this.ERROR_ABILITY.create();
        }
        if (TravellersModifiersManager.countInsertableModifiers((HolderLookup.Provider)source.registryAccess(), player.getMainHandItem()) >= (long)armor.getModifierSlots()) {
            throw this.ERROR_TOO_MANY_MODIFIERS.create();
        }
        if (TravellersModifiersManager.hasTravellersModifier((HolderLookup.Provider)source.registryAccess(), player.getMainHandItem(), (ResourceKey<TravellersModifier>)modifier.key())) {
            throw this.ERROR_HAS_MODIFIER.apply((net.minecraft.network.chat.Component)modKey).create();
        }
        if (!((TravellersModifier)modifier.value()).group().test(player.getEquipmentSlotForItem(player.getMainHandItem()))) {
            throw this.ERROR_WRONG_SLOT.apply((net.minecraft.network.chat.Component)modKey).create();
        }
        TravellersModifiersManager.addModifier((HolderLookup.Provider)source.registryAccess(), player.getMainHandItem(), (ResourceKey<TravellersModifier>)modifier.key());
        source.sendSuccess(() -> TravellersGearCommand.lambda$addModifier$7((net.minecraft.network.chat.Component)modKey, player), true);
        return 1;
    }

    private int removeModifier(CommandSourceStack source, Holder.Reference<TravellersModifier> modifier) throws CommandSyntaxException {
        Player player;
        MutableComponent modKey = net.minecraft.network.chat.Component.translatable((String)modifier.key().location().toLanguageKey(((TravellersModifier)modifier.value()).getPrefix()));
        Entity entity = source.getEntity();
        if (!(entity instanceof Player) || (player = (Player)entity) instanceof FakePlayer) {
            throw this.ERROR_NOT_RUN_BY_PLAYER.create();
        }
        if (!(player.getMainHandItem().getItem() instanceof TravellersArmorItem)) {
            throw this.ERROR_NOT_HOLDING_GEAR.create();
        }
        if (((TravellersModifier)modifier.value()).isAbility()) {
            throw this.ERROR_ABILITY.create();
        }
        if (!TravellersModifiersManager.hasTravellersModifier((HolderLookup.Provider)source.registryAccess(), player.getMainHandItem(), (ResourceKey<TravellersModifier>)modifier.key())) {
            throw this.ERROR_NO_MODIFIER.apply((net.minecraft.network.chat.Component)modKey).create();
        }
        ((InsertableTravellersModifier)modifier.value()).removeModifier(player.getMainHandItem());
        source.sendSuccess(() -> TravellersGearCommand.lambda$removeModifier$8((net.minecraft.network.chat.Component)modKey, player), true);
        return 1;
    }

    private static /* synthetic */ net.minecraft.network.chat.Component lambda$removeModifier$8(net.minecraft.network.chat.Component modKey, Player player) {
        return net.minecraft.network.chat.Component.translatable((String)"commands.tffeature.removed_modifier", (Object[])new Object[]{modKey, player.getMainHandItem().getHoverName()});
    }

    private static /* synthetic */ net.minecraft.network.chat.Component lambda$addModifier$7(net.minecraft.network.chat.Component modKey, Player player) {
        return net.minecraft.network.chat.Component.translatable((String)"commands.tffeature.added_modifier", (Object[])new Object[]{modKey, player.getMainHandItem().getHoverName()});
    }
}

