/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.monster;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import twilightforest.entity.projectile.SlimeProjectile;
import twilightforest.init.TFEntities;
import twilightforest.init.TFSounds;

public class SlimeBeetle
extends Monster
implements RangedAttackMob {
    public SlimeBeetle(EntityType<? extends SlimeBeetle> type, Level world) {
        super(type, world);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 3.0f, 1.25, 2.0));
        this.goalSelector.addGoal(3, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.0, 30, 10.0f));
        this.goalSelector.addGoal(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 25.0).add(Attributes.MOVEMENT_SPEED, 0.23).add(Attributes.ATTACK_DAMAGE, 4.0);
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return (SoundEvent)TFSounds.SLIME_BEETLE_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)TFSounds.SLIME_BEETLE_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)TFSounds.SLIME_BEETLE_DEATH.get();
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        this.playSound((SoundEvent)TFSounds.SLIME_BEETLE_STEP.get(), 0.15f, 1.0f);
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        SlimeProjectile projectile = new SlimeProjectile((EntityType<? extends SlimeProjectile>)((EntityType)TFEntities.SLIME_BLOB.get()), this.level(), (LivingEntity)this);
        this.playSound((SoundEvent)TFSounds.SLIME_BEETLE_SQUISH.get(), 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
        double tx = target.getX() - this.getX();
        double ty = target.getY() + (double)target.getEyeHeight() - 1.1 - projectile.getY();
        double tz = target.getZ() - this.getZ();
        float heightOffset = Mth.sqrt((float)((float)(tx * tx + tz * tz))) * 0.2f;
        projectile.shoot(tx, ty + (double)heightOffset, tz, 0.6f, 6.0f);
        this.level().addFreshEntity((Entity)projectile);
    }
}

