/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.projectile;

import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.Nullable;
import twilightforest.enchantment.ApplyFrostedEffect;
import twilightforest.entity.projectile.TFArrow;
import twilightforest.init.TFEntities;

public class IceArrow
extends TFArrow {
    public IceArrow(EntityType<? extends IceArrow> type, Level world) {
        super(type, world);
    }

    public IceArrow(Level world, @Nullable LivingEntity shooter, ItemStack stack, ItemStack weapon) {
        super((EntityType<? extends TFArrow>)((EntityType)TFEntities.ICE_ARROW.get()), world, shooter, stack, weapon);
    }

    public IceArrow(AbstractArrow parentArrow, ItemStack stack, ItemStack weapon) {
        super((EntityType<? extends TFArrow>)((EntityType)TFEntities.ICE_ARROW.get()), parentArrow, stack, weapon);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide() && !this.inGround) {
            BlockState stateId = Blocks.SNOW.defaultBlockState();
            for (int i = 0; i < 4; ++i) {
                this.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.FALLING_DUST, stateId), this.getX() + this.getDeltaMovement().x() * (double)i / 4.0, this.getY() + this.getDeltaMovement().y() * (double)i / 4.0, this.getZ() + this.getDeltaMovement().z() * (double)i / 4.0, -this.getDeltaMovement().x(), -this.getDeltaMovement().y() + 0.2, -this.getDeltaMovement().z());
            }
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        Entity entity;
        super.onHitEntity(result);
        if (!this.level().isClientSide() && (entity = result.getEntity()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            ApplyFrostedEffect.doChillAuraEffect(living, 200, 2, true);
        }
    }
}

