/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.events;

import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.EntityMountEvent;
import net.neoforged.neoforge.event.entity.EntityTeleportEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import twilightforest.beanification.Component;
import twilightforest.beanification.PostConstruct;
import twilightforest.components.entity.YetiThrowAttachment;
import twilightforest.entity.IHostileMount;
import twilightforest.init.TFDamageTypes;
import twilightforest.init.TFDataAttachments;

@Component
public class HostileMountEvents {
    public static volatile boolean allowDismount = false;

    @PostConstruct
    private void setup() {
        NeoForge.EVENT_BUS.addListener(this::handleMountDamage);
        NeoForge.EVENT_BUS.addListener(this::preventTeleportingOffHostileMounts);
        NeoForge.EVENT_BUS.addListener(this::preventMountDismount);
        NeoForge.EVENT_BUS.addListener(this::preventHostilMountCrouching);
    }

    @SubscribeEvent
    private void handleMountDamage(LivingIncomingDamageEvent event) {
        LivingEntity living = event.getEntity();
        DamageSource damageSource = event.getSource();
        if (living instanceof Player && HostileMountEvents.isRidingUnfriendly(living) && damageSource.is(DamageTypes.IN_WALL)) {
            event.setCanceled(true);
        }
        if (damageSource.is(DamageTypes.FALL) && ((YetiThrowAttachment)living.getData(TFDataAttachments.YETI_THROWING)).getThrown()) {
            float amount = event.getAmount();
            event.setCanceled(true);
            living.hurt(TFDamageTypes.getEntityDamageSource(living.level(), TFDamageTypes.YEETED, (Entity)((YetiThrowAttachment)living.getData(TFDataAttachments.YETI_THROWING)).getThrower(), new EntityType[0]), amount);
        }
    }

    private void preventTeleportingOffHostileMounts(EntityTeleportEvent event) {
        LivingEntity living;
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity && HostileMountEvents.isRidingUnfriendly(living = (LivingEntity)entity)) {
            event.setCanceled(true);
        }
    }

    public static void hostileDismount(Entity rider) {
        allowDismount = true;
        rider.stopRiding();
        allowDismount = false;
    }

    private void preventMountDismount(EntityMountEvent event) {
        Player player;
        Entity entity;
        if (!event.getLevel().isClientSide() && !event.isMounting() && event.getEntityBeingMounted().isAlive() && (entity = event.getEntityMounting()) instanceof Player && (player = (Player)entity).isAlive() && HostileMountEvents.isRidingUnfriendly((LivingEntity)player) && !allowDismount && !player.getAbilities().invulnerable) {
            event.setCanceled(true);
        }
    }

    private void preventHostilMountCrouching(EntityTickEvent.Post event) {
        if (event.getEntity() instanceof IHostileMount) {
            event.getEntity().getPassengers().forEach(e -> e.setShiftKeyDown(false));
        }
    }

    public static boolean isRidingUnfriendly(LivingEntity entity) {
        return entity.isPassenger() && entity.getVehicle() instanceof IHostileMount;
    }
}

