/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.network;

import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import twilightforest.TwilightForestMod;
import twilightforest.components.item.ItemDisplayContents;
import twilightforest.init.TFDataComponents;
import twilightforest.init.TFSounds;
import twilightforest.init.custom.TravellersModifiersManager;

public record CycleMapSlotPacket() implements CustomPacketPayload
{
    public static final CycleMapSlotPacket INSTANCE = new CycleMapSlotPacket();
    public static final CustomPacketPayload.Type<CycleMapSlotPacket> TYPE = new CustomPacketPayload.Type(TwilightForestMod.prefix("cycle_map_slot_packet"));
    public static final StreamCodec<RegistryFriendlyByteBuf, CycleMapSlotPacket> STREAM_CODEC = StreamCodec.unit((Object)INSTANCE);

    public static void handle(CycleMapSlotPacket message, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            int newIndex;
            Player player = ctx.player();
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ItemStack headStack = player.getItemBySlot(EquipmentSlot.HEAD);
            ItemDisplayContents contents = (ItemDisplayContents)headStack.get(TFDataComponents.ITEM_DISPLAY);
            if (contents == null || contents.isEmpty() || !TravellersModifiersManager.isModifierActive((LivingEntity)player, TravellersModifiersManager.ITEM_DISPLAY_MODIFIER)) {
                return;
            }
            ItemDisplayContents.Mutable mutable = new ItemDisplayContents.Mutable(contents);
            int oldIndex = mutable.chosenMapSlot();
            if (oldIndex != (newIndex = mutable.cycleChosenMapSlot())) {
                ItemDisplayContents updatedContents = mutable.toImmutable();
                headStack.set(TFDataComponents.ITEM_DISPLAY, (Object)updatedContents);
                serverPlayer.getInventory().setChanged();
                player.playNotifySound(newIndex == -1 ? (SoundEvent)TFSounds.CYCLE_MAPS_EMPTY.get() : (SoundEvent)TFSounds.CYCLE_MAPS.get(), player.getSoundSource(), 1.0f, 1.0f);
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

