/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.util.landmarks;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.structure.Structure;
import twilightforest.init.TFBiomes;
import twilightforest.init.TFStructures;
import twilightforest.util.WorldUtil;
import twilightforest.util.iterators.XZQuadrantIterator;

public class LegacyLandmarkPlacements {
    private static final Map<ResourceKey<Biome>, ResourceKey<Structure>> BIOME_2_STRUCTURES = new ImmutableMap.Builder().put(TFBiomes.ENCHANTED_FOREST, TFStructures.QUEST_GROVE).put(TFBiomes.LAKE, TFStructures.QUEST_ISLAND).put(TFBiomes.SWAMP, TFStructures.LABYRINTH).put(TFBiomes.FIRE_SWAMP, TFStructures.HYDRA_LAIR).put(TFBiomes.DARK_FOREST, TFStructures.KNIGHT_STRONGHOLD).put(TFBiomes.DARK_FOREST_CENTER, TFStructures.DARK_TOWER).put(TFBiomes.SNOWY_FOREST, TFStructures.YETI_CAVE).put(TFBiomes.GLACIER, TFStructures.AURORA_PALACE).put(TFBiomes.HIGHLANDS, TFStructures.TROLL_CAVE).put(TFBiomes.FINAL_PLATEAU, TFStructures.FINAL_CASTLE).build();
    public static final SimpleWeightedRandomList<ResourceKey<Structure>> VARIETY_LANDMARKS = (SimpleWeightedRandomList)Util.make(() -> {
        SimpleWeightedRandomList.Builder varietyLandmarks = new SimpleWeightedRandomList.Builder();
        varietyLandmarks.add(TFStructures.HOLLOW_HILL_SMALL, 6);
        varietyLandmarks.add(TFStructures.HOLLOW_HILL_MEDIUM, 3);
        varietyLandmarks.add(TFStructures.HOLLOW_HILL_LARGE, 1);
        varietyLandmarks.add(TFStructures.HEDGE_MAZE, 2);
        varietyLandmarks.add(TFStructures.NAGA_COURTYARD, 2);
        varietyLandmarks.add(TFStructures.LICH_TOWER, 2);
        return varietyLandmarks.build();
    });

    public static boolean blockNearLandmarkCenter(int blockX, int blockZ, int range) {
        for (int x = -range; x <= range; ++x) {
            for (int z = -range; z <= range; ++z) {
                if (!LegacyLandmarkPlacements.chunkHasLandmarkCenter(blockX >> 4 + x, blockZ >> 4 + z)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean blockIsInLandmarkCenter(int blockX, int blockZ) {
        return LegacyLandmarkPlacements.chunkHasLandmarkCenter(blockX >> 4, blockZ >> 4);
    }

    public static boolean chunkHasLandmarkCenter(int chunkX, int chunkZ) {
        BlockPos nearestCenter = LegacyLandmarkPlacements.getNearestCenterXZ(chunkX, chunkZ);
        return chunkX == nearestCenter.getX() >> 4 && chunkZ == nearestCenter.getZ() >> 4;
    }

    public static int manhattanDistanceFromLandmarkCenter(int chunkX, int chunkZ) {
        BlockPos nearestCenter = LegacyLandmarkPlacements.getNearestCenterXZ(chunkX, chunkZ);
        int deltaChunkX = Math.abs(chunkX - (nearestCenter.getX() >> 4));
        int deltaChunkZ = Math.abs(chunkZ - (nearestCenter.getZ() >> 4));
        return deltaChunkX + deltaChunkZ;
    }

    public static ResourceKey<Structure> pickLandmarkAtBlock(int blockX, int blockZ, LevelReader world) {
        return LegacyLandmarkPlacements.pickLandmarkForChunk(blockX >> 4, blockZ >> 4, world);
    }

    public static ResourceKey<Structure> pickLandmarkForChunk(int chunkX, int chunkZ, LevelReader world) {
        ResourceKey<Structure> biomeFeature;
        BlockPos pos = new BlockPos(((chunkX = Math.round((float)chunkX / 16.0f) * 16) << 4) + 8, 0, ((chunkZ = Math.round((float)chunkZ / 16.0f) * 16) << 4) + 8);
        Optional biomeResourceKey = world.getBiome(pos).unwrapKey();
        if (biomeResourceKey.isPresent() && (biomeFeature = BIOME_2_STRUCTURES.get(biomeResourceKey.get())) != null) {
            return biomeFeature;
        }
        return LegacyLandmarkPlacements.pickVarietyLandmark(chunkX, chunkZ);
    }

    public static ResourceKey<Structure> pickVarietyLandmark(int chunkX, int chunkZ) {
        chunkX = Math.round((float)chunkX / 16.0f) * 16;
        chunkZ = Math.round((float)chunkZ / 16.0f) * 16;
        int regionOffsetX = Math.abs((chunkX + 64 >> 4) % 8);
        int regionOffsetZ = Math.abs((chunkZ + 64 >> 4) % 8);
        if (regionOffsetX == 4 && regionOffsetZ == 5 || regionOffsetX == 4 && regionOffsetZ == 3) {
            return TFStructures.LICH_TOWER;
        }
        if (regionOffsetX == 5 && regionOffsetZ == 4 || regionOffsetX == 3 && regionOffsetZ == 4) {
            return TFStructures.NAGA_COURTYARD;
        }
        return VARIETY_LANDMARKS.getRandomValue((RandomSource)new LegacyRandomSource(WorldUtil.getOverworldSeed() + (long)chunkX * 25117L + (long)chunkZ * 151121L)).orElse(TFStructures.HOLLOW_HILL_SMALL);
    }

    public static XZQuadrantIterator<BlockPos> landmarkCenterScanner(BlockPos searchFocus, int gridSearchRadius) {
        return new XZQuadrantIterator<BlockPos>(searchFocus.getX() >> 4 & 0xFFFFFFF0, searchFocus.getZ() >> 4 & 0xFFFFFFF0, false, gridSearchRadius, 16, LegacyLandmarkPlacements::getNearestCenterXZ);
    }

    public static BlockPos getNearestCenterXZ(int chunkX, int chunkZ) {
        return LegacyLandmarkPlacements.getNearestCenterXZ(chunkX, chunkZ, 0);
    }

    public static BlockPos getNearestCenterXZ(int chunkX, int chunkZ, int height) {
        int regionX = chunkX + 8 >> 4;
        int regionZ = chunkZ + 8 >> 4;
        long seed = (long)regionX * 3129871L ^ (long)regionZ * 116129781L;
        seed = seed * seed * 42317861L + seed * 7L;
        int num0 = (int)(seed >> 12 & 3L);
        int num1 = (int)(seed >> 15 & 3L);
        int num2 = (int)(seed >> 18 & 3L);
        int num3 = (int)(seed >> 21 & 3L);
        int centerX = 8 + num0 - num1;
        int centerZ = 8 + num2 - num3;
        int ccz = regionZ >= 0 ? (regionZ * 16 + centerZ - 8) * 16 + 8 : (regionZ * 16 + (16 - centerZ) - 8) * 16 + 9;
        int ccx = regionX >= 0 ? (regionX * 16 + centerX - 8) * 16 + 8 : (regionX * 16 + (16 - centerX) - 8) * 16 + 9;
        return new BlockPos(ccx, height, ccz);
    }
}

