/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.chunkblanketing;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import twilightforest.init.custom.ChunkBlanketProcessors;
import twilightforest.util.WorldUtil;
import twilightforest.util.landmarks.LegacyLandmarkPlacements;
import twilightforest.world.components.chunkblanketing.ChunkBlanketProcessor;
import twilightforest.world.components.chunkblanketing.ChunkBlanketType;

public record CanopyBlanketProcessor(HolderSet<Biome> biomesForApplication, BlockStateProvider blockState, int height, HolderSet<Structure> avoidStructures) implements ChunkBlanketProcessor
{
    public static final MapCodec<CanopyBlanketProcessor> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)RegistryCodecs.homogeneousList((ResourceKey)Registries.BIOME, (boolean)true).fieldOf("biome_mask").forGetter(CanopyBlanketProcessor::biomesForApplication), (App)BlockStateProvider.CODEC.fieldOf("block").forGetter(CanopyBlanketProcessor::blockState), (App)Codec.INT.fieldOf("height").forGetter(CanopyBlanketProcessor::height), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.STRUCTURE, (boolean)true).fieldOf("avoid_structures").forGetter(CanopyBlanketProcessor::avoidStructures)).apply((Applicative)inst, CanopyBlanketProcessor::new));

    @Override
    public void processChunk(RandomSource random, Function<BlockPos, Holder<Biome>> biomeGetter, ChunkAccess chunkAccess) {
        List<Structure> avoidStructures = this.avoidStructures.stream().map(Holder::value).toList();
        CanopyBlanketProcessor.addDarkForestCanopy(biomeGetter, chunkAccess, this.height, this.biomesForApplication, this.blockState, avoidStructures);
    }

    private static boolean addDarkForestCanopy(Function<BlockPos, Holder<Biome>> biomeGetter, ChunkAccess chunk, int height, HolderSet<Biome> biomeFilter, BlockStateProvider canopyBlock, Collection<Structure> avoidStructures) {
        ChunkPos chunkPos = chunk.getPos();
        BlockPos chunkOrigin = chunkPos.getWorldPosition();
        int[] thicks = new int[25];
        boolean biomeFound = false;
        for (int dZ = 0; dZ < 5; ++dZ) {
            for (int dX = 0; dX < 5; ++dX) {
                for (int bx = -1; bx <= 1; ++bx) {
                    for (int bz = -1; bz <= 1; ++bz) {
                        Holder<Biome> biomeAt = biomeGetter.apply(chunkOrigin.offset(dX + bx << 2, 0, dZ + bz << 2));
                        if (!biomeFilter.contains(biomeAt)) continue;
                        int n = dX + dZ * 5;
                        thicks[n] = thicks[n] + 1;
                        biomeFound = true;
                    }
                }
            }
        }
        if (!biomeFound) {
            return false;
        }
        Set structuresThroughChunk = chunk.getAllReferences().keySet();
        boolean clearingForStructureNearby = !structuresThroughChunk.isEmpty() && !Collections.disjoint(structuresThroughChunk, avoidStructures);
        BlockPos nearestCenter = clearingForStructureNearby ? LegacyLandmarkPlacements.getNearestCenterXZ(chunkPos.x, chunkPos.z, height).subtract((Vec3i)chunkOrigin) : BlockPos.ZERO;
        int hx = nearestCenter.getX();
        int hz = nearestCenter.getZ();
        XoroshiroRandomSource random = new XoroshiroRandomSource(WorldUtil.getOverworldSeed(), Mth.getSeed((Vec3i)chunkOrigin));
        for (int dZ = 0; dZ < 16; ++dZ) {
            for (int dX = 0; dX < 16; ++dX) {
                int dY;
                BlockPos pos;
                int rz;
                int rx;
                int dist;
                int qx = dX >> 2;
                int qz = dZ >> 2;
                int topOccupiedBlock = chunk.getHeight(Heightmap.Types.WORLD_SURFACE_WG, dX, dZ);
                BlockPos surfacePos = chunkOrigin.offset(dX, topOccupiedBlock, dZ);
                if (chunk.getFluidState(surfacePos).is(FluidTags.WATER)) continue;
                float xweight = (float)(dX % 4) * 0.25f + 0.125f;
                float zweight = (float)(dZ % 4) * 0.25f + 0.125f;
                float thickness = (float)thicks[qx + qz * 5] * (1.0f - xweight) * (1.0f - zweight) + (float)thicks[qx + 1 + qz * 5] * xweight * (1.0f - zweight) + (float)thicks[qx + (qz + 1) * 5] * (1.0f - xweight) * zweight + (float)thicks[qx + 1 + (qz + 1) * 5] * xweight * zweight - 4.0f;
                if (clearingForStructureNearby && (dist = (int)Mth.sqrt((float)((rx = dX - hx) * rx + (rz = dZ - hz) * rz))) < 24) {
                    thickness -= (float)(24 - dist);
                }
                if (!(thickness > 1.0f) || chunk.getBlockState(pos = surfacePos.atY(dY = chunk.getHeight(Heightmap.Types.WORLD_SURFACE_WG, dX, dZ))).liquid()) continue;
                int treeBottom = pos.getY() + height - (int)(thickness * 0.5f);
                int treeTop = treeBottom + (int)thickness;
                for (int y = treeBottom; y < treeTop; ++y) {
                    chunk.setBlockState(pos.atY(y), canopyBlock.getState((RandomSource)random, pos), false);
                }
            }
        }
        return true;
    }

    @Override
    public ChunkBlanketType getType() {
        return (ChunkBlanketType)ChunkBlanketProcessors.CANOPY.value();
    }
}

