/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import twilightforest.block.SnowLoggable;
import twilightforest.data.tags.BlockTagGenerator;
import twilightforest.util.TFMathUtil;
import twilightforest.util.WorldUtil;
import twilightforest.world.components.feature.config.BerryBushConfig;

public class BerryBushFeature
extends Feature<BerryBushConfig> {
    private static final float DEFAULT_RIPE_PROBABILITY = 0.2f;

    public BerryBushFeature(Codec<BerryBushConfig> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<BerryBushConfig> context) {
        WorldGenLevel level = context.level();
        BlockPos pos = context.origin();
        BlockState stateToPlace = ((BerryBushConfig)context.config()).bushState();
        RandomSource random = context.random();
        TagKey<Block> generatesOn = ((BerryBushConfig)context.config()).placesOn();
        if (!level.getBlockState(pos.below()).is(generatesOn)) {
            return false;
        }
        boolean isInSnowyBiome = ((BerryBushConfig)context.config()).canBeSnowy() && ((Biome)level.getBiome(pos).value()).shouldSnow((LevelReader)level, pos);
        return switch (this.chooseSize(random).ordinal()) {
            case 3 -> this.generateLargeNode(level, pos, stateToPlace, generatesOn, random, isInSnowyBiome);
            case 2 -> this.generateMediumNode(level, pos, stateToPlace, generatesOn, random, isInSnowyBiome);
            case 1 -> this.generateSmallNode(level, pos, stateToPlace, generatesOn, random, isInSnowyBiome);
            default -> this.setBush(level, pos, stateToPlace, generatesOn, random.nextInt(4), isInSnowyBiome);
        };
    }

    protected boolean generateLargeNode(WorldGenLevel level, BlockPos pos, BlockState state, TagKey<Block> generatesOn, RandomSource random, boolean isInSnowyBiome) {
        int dz;
        int dx;
        boolean placed = false;
        for (dx = -1; dx <= 1; ++dx) {
            for (dz = -1; dz <= 1; ++dz) {
                placed |= this.setBush(level, pos.offset(dx, -2, dz), state, generatesOn, random, isInSnowyBiome);
            }
        }
        for (dx = -2; dx <= 2; ++dx) {
            for (int dy = -1; dy <= 0; ++dy) {
                for (int dz2 = -2; dz2 <= 2; ++dz2) {
                    if (TFMathUtil.taxicabGeometryDistance(dx, dz2) >= 4) continue;
                    placed |= this.setBush(level, pos.offset(dx, dy, dz2), state, generatesOn, random, isInSnowyBiome);
                }
            }
        }
        for (dx = -1; dx <= 1; ++dx) {
            for (dz = -1; dz <= 1; ++dz) {
                placed |= this.setBush(level, pos.offset(dx, 1, dz), state, generatesOn, random, isInSnowyBiome);
            }
        }
        return placed;
    }

    protected boolean generateMediumNode(WorldGenLevel level, BlockPos pos, BlockState state, TagKey<Block> generatesOn, RandomSource random, boolean isInSnowyBiome) {
        boolean placed = false;
        for (int dy = 0; dy <= 2; ++dy) {
            int maxTaxicabDistance = 2 - dy;
            for (int dx = -maxTaxicabDistance; dx <= maxTaxicabDistance; ++dx) {
                for (int dz = -maxTaxicabDistance; dz <= maxTaxicabDistance; ++dz) {
                    if (TFMathUtil.taxicabGeometryDistance(dx, dz) >= 2 * maxTaxicabDistance && !random.nextBoolean()) continue;
                    placed |= this.setBush(level, pos.offset(dx, dy, dz), state, generatesOn, random, isInSnowyBiome);
                }
            }
        }
        return placed;
    }

    protected boolean generateSmallNode(WorldGenLevel level, BlockPos pos, BlockState state, TagKey<Block> generatesOn, RandomSource random, boolean isInSnowyBiome) {
        boolean placed = this.setBush(level, pos.offset(0, 0, 0), state, generatesOn, random, isInSnowyBiome);
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                if (TFMathUtil.taxicabGeometryDistance(dx, dz) != 1 || !random.nextBoolean()) continue;
                placed |= this.setBush(level, pos.offset(dx, 0, dz), state, generatesOn, random.nextInt(4), isInSnowyBiome);
            }
        }
        return placed;
    }

    protected boolean setBush(WorldGenLevel level, BlockPos pos, BlockState state, TagKey<Block> generatesOn, RandomSource random, boolean isInSnowyBiome) {
        return this.setBush(level, pos, state, generatesOn, random.nextFloat() < 0.2f ? 3 : 2, isInSnowyBiome);
    }

    protected boolean setBush(WorldGenLevel level, BlockPos pos, BlockState state, TagKey<Block> generatesOn, int age, boolean isInSnowyBiome) {
        BlockState stateToReplace = level.getBlockState(pos);
        if (!stateToReplace.is(BlockTagGenerator.TF_BERRY_BUSHES_REPLACE) || stateToReplace.is(BlockTags.FEATURES_CANNOT_REPLACE) || !stateToReplace.getFluidState().isEmpty()) {
            return false;
        }
        if (!level.getBlockState(pos.below()).is(generatesOn) && age < 2) {
            return false;
        }
        BlockState stateToPlace = (BlockState)state.trySetValue((Property)BlockStateProperties.AGE_3, (Comparable)Integer.valueOf(age));
        if (isInSnowyBiome && !level.getBlockState(pos.below()).is(state.getBlock())) {
            stateToPlace = (BlockState)stateToPlace.trySetValue((Property)SnowLoggable.SNOW_LAYERS, (Comparable)Integer.valueOf(1));
        }
        level.setBlock(pos, stateToPlace, 3);
        this.markAboveForPostProcessing(level, pos);
        if (isInSnowyBiome && age >= 2) {
            level.setBlock(pos.above(), Blocks.SNOW.defaultBlockState(), 3);
        }
        return true;
    }

    protected BushNodeSizes chooseSize(RandomSource random) {
        List weights = List.of(Pair.of((Object)((Object)BushNodeSizes.LARGE), (Object)Float.valueOf(1.0f)), Pair.of((Object)((Object)BushNodeSizes.MEDIUM), (Object)Float.valueOf(2.0f)), Pair.of((Object)((Object)BushNodeSizes.SMALL), (Object)Float.valueOf(4.0f)), Pair.of((Object)((Object)BushNodeSizes.TINY), (Object)Float.valueOf(3.0f)));
        return (BushNodeSizes)((Object)WorldUtil.getRandomElementWithWeights(weights, random));
    }

    protected static enum BushNodeSizes {
        TINY,
        SMALL,
        MEDIUM,
        LARGE;

    }
}

