/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures;

import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.JigsawReplacementProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.neoforged.neoforge.common.world.PieceBeardifierModifier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import twilightforest.beanification.Autowired;
import twilightforest.init.TFStructurePieceTypes;
import twilightforest.util.jigsaw.JigsawPlaceContext;
import twilightforest.util.jigsaw.JigsawRecord;
import twilightforest.world.components.structures.TwilightTemplateStructurePiece;
import twilightforest.world.components.structures.markerhandler.TemplateMarkerHandler;
import twilightforest.world.components.structures.util.ProgressionPiece;
import twilightforest.world.components.structures.util.StructureTemplateDefinitions;
import twilightforest.world.components.structures.util.TemplateMarkerHandlerList;
import twilightforest.world.components.structures.util.TemplatePoolInstance;

public class TwilightJigsawPiece
extends TwilightTemplateStructurePiece
implements ProgressionPiece,
PieceBeardifierModifier {
    private static final Logger LOGGER = LogManager.getLogger((String)"twilightforest/TwilightJigsawPiece");
    @Autowired
    private static StructureTemplateDefinitions structureTemplateDefinitions;
    private static final String NBT_JIGSAW_SOURCE = "source";
    private static final String NBT_JIGSAW_CONNECTIONS = "connections";
    private static final String NBT_TERRAIN_ADAPT = "terrain_adaptation";
    private static final String NBT_TEMPLATE_PROCESSORS = "template_processors";
    private static final String NBT_PLACE_PROJECTION = "place_projection";
    private static final String NBT_GROUND_OFFSET = "ground_offset";
    private static final String NBT_IGNORE_WATERLOG = "ignore_waterlog";
    private static final String NBT_MARKER_HANDLERS = "marker_handlers";
    private static final String NBT_RANDOMIZED_PROCESSORS = "randomized_processors";
    private final JigsawRecord sourceJigsaw;
    private final List<JigsawRecord> spareJigsaws;
    private final TerrainAdjustment terrainAdjustment;
    private final Optional<Holder<StructureProcessorList>> processors;
    private final StructureTemplatePool.Projection projection;
    private final Optional<Holder<TemplateMarkerHandlerList>> markerHandlers;
    private final int beardifierGroundDelta;
    private final StructureProcessorList serializedProcessors;
    private final Map<String, String> poolAliases;

    public static TwilightJigsawPiece defaultDeserialize(StructurePieceSerializationContext ctx, CompoundTag compoundTag) {
        TwilightJigsawPiece twilightJigsawPiece = new TwilightJigsawPiece((StructurePieceType)TFStructurePieceTypes.TFJigsawTemplate.value(), compoundTag, ctx, TwilightJigsawPiece.readSettings(compoundTag));
        twilightJigsawPiece.placeSettings().addProcessor((StructureProcessor)JigsawReplacementProcessor.INSTANCE);
        twilightJigsawPiece.placeSettings().addProcessor((StructureProcessor)BlockIgnoreProcessor.STRUCTURE_BLOCK);
        return twilightJigsawPiece;
    }

    public static TwilightJigsawPiece defaultForTemplate(int genDepth, StructureTemplateManager structureManager, ResourceLocation templateLocation, JigsawPlaceContext jigsawContext, TemplatePoolInstance templatePoolInstance, StructureProcessorList serializedProcessors) {
        TwilightJigsawPiece twilightJigsawPiece = new TwilightJigsawPiece((StructurePieceType)TFStructurePieceTypes.TFJigsawTemplate.value(), genDepth, structureManager, templateLocation, jigsawContext, templatePoolInstance, serializedProcessors, templatePoolInstance.poolAliases());
        twilightJigsawPiece.placeSettings().addProcessor((StructureProcessor)JigsawReplacementProcessor.INSTANCE);
        twilightJigsawPiece.placeSettings().addProcessor((StructureProcessor)BlockIgnoreProcessor.STRUCTURE_BLOCK);
        return twilightJigsawPiece;
    }

    public TwilightJigsawPiece(StructurePieceType structurePieceType, CompoundTag compoundTag, StructurePieceSerializationContext ctx, StructurePlaceSettings placeSettings) {
        super(structurePieceType, compoundTag, ctx, placeSettings);
        this.sourceJigsaw = TwilightJigsawPiece.readSourceFromNBT(compoundTag);
        this.spareJigsaws = TwilightJigsawPiece.readConnectionsFromNBT(compoundTag);
        this.terrainAdjustment = compoundTag.contains(NBT_TERRAIN_ADAPT) ? TerrainAdjustment.valueOf((String)compoundTag.getString(NBT_TERRAIN_ADAPT)) : TerrainAdjustment.NONE;
        RegistryOps dynamicOps = RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)ctx.registryAccess());
        this.processors = compoundTag.contains(NBT_TEMPLATE_PROCESSORS) ? StructureProcessorType.LIST_CODEC.parse((DynamicOps)dynamicOps, (Object)compoundTag.get(NBT_TEMPLATE_PROCESSORS)).resultOrPartial(message -> LOGGER.error("Error deserializing template_processors: {}", message)) : Optional.empty();
        this.projection = compoundTag.contains(NBT_PLACE_PROJECTION) ? StructureTemplatePool.Projection.valueOf((String)compoundTag.getString(NBT_PLACE_PROJECTION)) : StructureTemplatePool.Projection.RIGID;
        this.markerHandlers = compoundTag.contains(NBT_MARKER_HANDLERS) ? TemplateMarkerHandlerList.HOLDER_CODEC.parse((DynamicOps)dynamicOps, (Object)compoundTag.get(NBT_MARKER_HANDLERS)).resultOrPartial(message -> LOGGER.error("Error deserializing marker_handlers: {}", message)) : Optional.empty();
        this.beardifierGroundDelta = compoundTag.getInt(NBT_GROUND_OFFSET);
        if (compoundTag.getBoolean(NBT_IGNORE_WATERLOG)) {
            this.placeSettings.setLiquidSettings(LiquidSettings.IGNORE_WATERLOGGING);
        }
        this.processors.ifPresent(p -> ((StructureProcessorList)p.value()).list().forEach(arg_0 -> ((StructurePlaceSettings)this.placeSettings).addProcessor(arg_0)));
        this.serializedProcessors = compoundTag.contains(NBT_RANDOMIZED_PROCESSORS) ? StructureProcessorType.LIST_OBJECT_CODEC.parse((DynamicOps)dynamicOps, (Object)compoundTag.get(NBT_RANDOMIZED_PROCESSORS)).resultOrPartial(message -> LOGGER.error("Error deserializing randomized_processors: {}", message)).orElseGet(() -> new StructureProcessorList(List.of())) : new StructureProcessorList(List.of());
        this.serializedProcessors.list().forEach(arg_0 -> ((StructurePlaceSettings)this.placeSettings).addProcessor(arg_0));
        this.poolAliases = Map.of();
    }

    public TwilightJigsawPiece(StructurePieceType type, int genDepth, StructureTemplateManager structureManager, ResourceLocation templateLocation, JigsawPlaceContext jigsawContext) {
        super(type, genDepth, structureManager, templateLocation, jigsawContext.placementSettings(), jigsawContext.templatePos());
        this.sourceJigsaw = jigsawContext.seedJigsaw();
        this.spareJigsaws = Collections.unmodifiableList(jigsawContext.spareJigsaws());
        this.terrainAdjustment = TerrainAdjustment.NONE;
        this.processors = Optional.empty();
        this.projection = StructureTemplatePool.Projection.RIGID;
        this.markerHandlers = Optional.empty();
        this.beardifierGroundDelta = 0;
        this.serializedProcessors = new StructureProcessorList(List.of());
        this.poolAliases = Map.of();
    }

    public TwilightJigsawPiece(StructurePieceType type, int genDepth, StructureTemplateManager structureManager, ResourceLocation templateLocation, JigsawPlaceContext jigsawContext, TemplatePoolInstance templatePoolInstance, StructureProcessorList serializedProcessors, Map<String, String> poolAliases) {
        super(type, genDepth, structureManager, templateLocation, jigsawContext.placementSettings(), jigsawContext.templatePos());
        this.sourceJigsaw = jigsawContext.seedJigsaw();
        this.spareJigsaws = Collections.unmodifiableList(jigsawContext.spareJigsaws());
        this.terrainAdjustment = templatePoolInstance.terrainAdjustment();
        this.processors = templatePoolInstance.processors();
        this.projection = templatePoolInstance.projection();
        this.markerHandlers = templatePoolInstance.markerHandlers();
        this.beardifierGroundDelta = templatePoolInstance.beardifierGroundDelta().map(TemplatePoolInstance.HeightAdjustment::beardifierGroundDelta).orElse(0);
        if (templatePoolInstance.ignoreWorldWaterlog()) {
            this.placeSettings.setLiquidSettings(LiquidSettings.IGNORE_WATERLOGGING);
        }
        this.processors.ifPresent(p -> ((StructureProcessorList)p.value()).list().forEach(arg_0 -> ((StructurePlaceSettings)this.placeSettings).addProcessor(arg_0)));
        this.serializedProcessors = serializedProcessors;
        this.serializedProcessors.list().forEach(arg_0 -> ((StructurePlaceSettings)this.placeSettings).addProcessor(arg_0));
        this.poolAliases = poolAliases;
    }

    protected static JigsawRecord readSourceFromNBT(CompoundTag structureTag) {
        return JigsawRecord.fromTag(structureTag.getCompound(NBT_JIGSAW_SOURCE));
    }

    protected static List<JigsawRecord> readConnectionsFromNBT(CompoundTag structureTag) {
        ListTag connections = structureTag.getList(NBT_JIGSAW_CONNECTIONS, 10);
        if (connections.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<JigsawRecord> connectionsList = new ArrayList<JigsawRecord>();
        for (Tag tagEntry : connections) {
            if (!(tagEntry instanceof CompoundTag)) continue;
            CompoundTag tag = (CompoundTag)tagEntry;
            connectionsList.add(JigsawRecord.fromTag(tag));
        }
        return Collections.unmodifiableList(connectionsList);
    }

    @Override
    protected void addAdditionalSaveData(StructurePieceSerializationContext ctx, CompoundTag structureTag) {
        Optional markerHandlersList;
        super.addAdditionalSaveData(ctx, structureTag);
        structureTag.put(NBT_JIGSAW_SOURCE, (Tag)this.sourceJigsaw.toTag());
        ListTag tags = new ListTag();
        for (JigsawRecord record : this.spareJigsaws) {
            tags.add((Object)record.toTag());
        }
        structureTag.put(NBT_JIGSAW_CONNECTIONS, (Tag)tags);
        if (this.terrainAdjustment != TerrainAdjustment.NONE) {
            structureTag.putString(NBT_TERRAIN_ADAPT, this.terrainAdjustment.toString());
        }
        RegistryOps registryOps = RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)ctx.registryAccess());
        if (this.processors.isPresent()) {
            Optional processorsList = StructureProcessorType.LIST_CODEC.encodeStart((DynamicOps)registryOps, this.processors.get()).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0));
            if (processorsList.isPresent()) {
                structureTag.put(NBT_TEMPLATE_PROCESSORS, (Tag)processorsList.get());
            }
        }
        if (this.markerHandlers.isPresent()) {
            markerHandlersList = TemplateMarkerHandlerList.HOLDER_CODEC.encodeStart((DynamicOps)registryOps, this.markerHandlers.get()).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0));
            if (markerHandlersList.isPresent()) {
                structureTag.put(NBT_MARKER_HANDLERS, (Tag)markerHandlersList.get());
            }
        }
        markerHandlersList = StructureProcessorType.LIST_OBJECT_CODEC.encodeStart((DynamicOps)registryOps, (Object)this.serializedProcessors).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0));
        if (markerHandlersList.isPresent()) {
            structureTag.put(NBT_RANDOMIZED_PROCESSORS, (Tag)markerHandlersList.get());
        }
        structureTag.putInt(NBT_GROUND_OFFSET, this.beardifierGroundDelta);
        if (!this.placeSettings.shouldApplyWaterlogging()) {
            structureTag.putBoolean(NBT_IGNORE_WATERLOG, true);
        }
    }

    @Deprecated(forRemoval=true)
    public void addChildren(StructurePiece parent, StructurePieceAccessor pieceAccessor, RandomSource random) {
    }

    public void addJigsaws(TwilightJigsawPiece parent, StructurePieceAccessor pieceAccessor, Structure.GenerationContext context) {
        WorldgenRandom random = context.random();
        random.setSeed(random.nextLong() ^ context.seed() * this.templatePosition.asLong());
        this.addChildren((StructurePiece)parent, pieceAccessor, (RandomSource)random);
        List<JigsawRecord> jigsaws = this.spareJigsaws;
        for (int i = 0; i < jigsaws.size(); ++i) {
            this.processJigsaw(parent, pieceAccessor, context, jigsaws.get(i), i);
        }
    }

    protected void processJigsaw(TwilightJigsawPiece parent, StructurePieceAccessor pieceAccessor, Structure.GenerationContext context, JigsawRecord connection, int jigsawIndex) {
        BlockPos parentJunctionPos;
        ResourceLocation templatePool = ResourceLocation.parse((String)this.poolAliases.getOrDefault(connection.pool(), connection.pool()));
        TwilightJigsawPiece jigsawPiece = structureTemplateDefinitions.initializeTemplateFromPool(templatePool, parentJunctionPos = this.templatePosition.offset((Vec3i)connection.pos()), connection.orientation(), connection.target(), context, this.genDepth + 1, parent.projection == StructureTemplatePool.Projection.TERRAIN_MATCHING);
        if (jigsawPiece == null) {
            return;
        }
        if (pieceAccessor.findCollisionPiece(jigsawPiece.boundingBox) != null) {
            return;
        }
        pieceAccessor.addPiece((StructurePiece)jigsawPiece);
        jigsawPiece.addJigsaws(this, pieceAccessor, context);
    }

    @Override
    public void postProcess(WorldGenLevel level, StructureManager structureManager, ChunkGenerator chunkGen, RandomSource random, BoundingBox chunkBounds, ChunkPos chunkPos, BlockPos structureCenterPos) {
        super.postProcess(level, structureManager, chunkGen, random, chunkBounds, chunkPos, structureCenterPos);
        ChunkAccess chunkAt = level.getChunk(chunkPos.getWorldPosition());
        for (StructureTemplate.StructureBlockInfo blockInfo : this.template.filterBlocks(this.templatePosition, this.placeSettings, Blocks.JIGSAW)) {
            BlockPos infoPos = blockInfo.pos();
            if (!chunkBounds.isInside((Vec3i)infoPos)) continue;
            chunkAt.markPosForPostprocessing(infoPos);
        }
    }

    @Override
    protected void handleDataMarker(String label, BlockPos pos, WorldGenLevel level, RandomSource random, BoundingBox chunkBounds, ChunkGenerator chunkGen, Rotation rotation) {
        super.handleDataMarker(label, pos, level, random, chunkBounds, chunkGen, rotation);
        if (this.markerHandlers.isEmpty()) {
            return;
        }
        for (TemplateMarkerHandler handler : ((TemplateMarkerHandlerList)this.markerHandlers.get().value()).markerHandlers()) {
            if (handler.handleDataMarker(label, pos, level, random, chunkBounds, chunkGen, rotation)) break;
        }
    }

    public JigsawRecord getSourceJigsaw() {
        return this.sourceJigsaw;
    }

    public BlockPos getSourcePosition() {
        return this.templatePosition.offset((Vec3i)this.sourceJigsaw.pos());
    }

    public List<JigsawRecord> getSpareJigsaws() {
        return this.spareJigsaws;
    }

    public List<JigsawRecord> matchSpareJigsaws(Predicate<JigsawRecord> filter) {
        ArrayList<JigsawRecord> jigsaws = new ArrayList<JigsawRecord>();
        for (JigsawRecord record : this.spareJigsaws) {
            if (!filter.test(record)) continue;
            jigsaws.add(record);
        }
        return jigsaws;
    }

    public int firstMatchIndex(Predicate<JigsawRecord> filter) {
        for (int i = 0; i < this.spareJigsaws.size(); ++i) {
            if (!filter.test(this.spareJigsaws.get(i))) continue;
            return i;
        }
        return -1;
    }

    public BoundingBox getBeardifierBox() {
        return this.boundingBox;
    }

    public TerrainAdjustment getTerrainAdjustment() {
        return this.terrainAdjustment;
    }

    public int getGroundLevelDelta() {
        return this.beardifierGroundDelta;
    }
}

