/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.lichtowerrevamp;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.neoforged.neoforge.common.world.PieceBeardifierModifier;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import twilightforest.TwilightForestMod;
import twilightforest.beanification.Autowired;
import twilightforest.init.TFStructurePieceTypes;
import twilightforest.util.BoundingBoxUtils;
import twilightforest.util.jigsaw.JigsawPlaceContext;
import twilightforest.util.jigsaw.JigsawRecord;
import twilightforest.world.components.structures.SpawnIndexProvider;
import twilightforest.world.components.structures.TwilightJigsawPiece;
import twilightforest.world.components.structures.lichtowerrevamp.LichTowerBaseTrim;
import twilightforest.world.components.structures.lichtowerrevamp.LichTowerRoomDecor;
import twilightforest.world.components.structures.lichtowerrevamp.LichTowerSegment;
import twilightforest.world.components.structures.lichtowerrevamp.LichTowerUtil;
import twilightforest.world.components.structures.lichtowerrevamp.LichTowerWingBridge;
import twilightforest.world.components.structures.util.SortablePiece;

public final class LichTowerBase
extends TwilightJigsawPiece
implements PieceBeardifierModifier,
SpawnIndexProvider,
SortablePiece {
    @Autowired
    private static LichTowerUtil lichTowerUtil;
    private final int casketWingIndex;

    public LichTowerBase(StructurePieceSerializationContext ctx, CompoundTag compoundTag) {
        super((StructurePieceType)TFStructurePieceTypes.LICH_TOWER_BASE.get(), compoundTag, ctx, LichTowerBase.readSettings(compoundTag));
        this.casketWingIndex = compoundTag.getInt("CasketWingIdx");
        LichTowerUtil.addDefaultProcessors(this.placeSettings.addProcessor((StructureProcessor)TrimProcessor.INSTANCE));
    }

    public LichTowerBase(StructureTemplateManager structureManager, JigsawPlaceContext jigsawContext) {
        super((StructurePieceType)TFStructurePieceTypes.LICH_TOWER_BASE.get(), 1, structureManager, TwilightForestMod.prefix("lich_tower/tower_base"), jigsawContext);
        this.boundingBox = BoundingBoxUtils.cloneWithAdjustments(this.boundingBox, 0, 0, 0, 0, 30, 0);
        this.casketWingIndex = this.firstMatchIndex(r -> "twilightforest:lich_tower/bridge".equals(r.target()));
        LichTowerUtil.addDefaultProcessors(this.placeSettings.addProcessor((StructureProcessor)TrimProcessor.INSTANCE));
    }

    @Override
    protected void addAdditionalSaveData(StructurePieceSerializationContext ctx, CompoundTag structureTag) {
        super.addAdditionalSaveData(ctx, structureTag);
        structureTag.putInt("CasketWingIdx", this.casketWingIndex);
    }

    @Override
    protected void processJigsaw(TwilightJigsawPiece parent, StructurePieceAccessor pieceAccessor, Structure.GenerationContext context, JigsawRecord connection, int jigsawIndex) {
        switch (connection.target()) {
            case "twilightforest:lich_tower/tower_below": {
                LichTowerSegment.buildTowerBySegments(pieceAccessor, context, connection.pos(), connection.orientation(), this, this.structureManager, context.random().nextIntBetweenInclusive(12, 15));
                break;
            }
            case "twilightforest:lich_tower/bridge": {
                ResourceLocation room = jigsawIndex == this.casketWingIndex ? lichTowerUtil.getKeepsakeCasketRoom((RandomSource)context.random()) : null;
                if (room == null && connection.pos().getY() >= 6) break;
                LichTowerWingBridge.tryRoomAndBridge(this, pieceAccessor, context, connection, this.structureManager, true, 4, true, this.genDepth + 1, room);
                break;
            }
            case "twilightforest:lich_tower/decor": {
                ResourceLocation decorId = lichTowerUtil.rollRandomDecor((RandomSource)context.random(), true);
                JigsawPlaceContext placeableJunction = JigsawPlaceContext.pickPlaceableJunction(this.templatePosition(), connection.pos(), connection.orientation(), this.structureManager, decorId, "twilightforest:lich_tower/decor", (RandomSource)context.random());
                if (placeableJunction == null) break;
                LichTowerRoomDecor decor = new LichTowerRoomDecor(this.genDepth + 1, this.structureManager, decorId, placeableJunction);
                pieceAccessor.addPiece((StructurePiece)decor);
                decor.addJigsaws(this, pieceAccessor, context);
                break;
            }
            case "twilightforest:lich_tower/tower_trim": {
                ResourceLocation decorId = TwilightForestMod.prefix("lich_tower/central_trim");
                JigsawPlaceContext placeableJunction = JigsawPlaceContext.pickPlaceableJunction(this.templatePosition(), connection.pos(), connection.orientation(), this.structureManager, decorId, "twilightforest:lich_tower/tower_trim", (RandomSource)context.random());
                if (placeableJunction == null) break;
                LichTowerBaseTrim decor = new LichTowerBaseTrim(this.structureManager, placeableJunction);
                pieceAccessor.addPiece((StructurePiece)decor);
                decor.addJigsaws(this, pieceAccessor, context);
            }
        }
    }

    @Override
    protected void handleDataMarker(String label, BlockPos pos, WorldGenLevel level, RandomSource random, BoundingBox chunkBounds, ChunkGenerator chunkGen, Rotation rotation) {
        String[] splitLabel = label.split(":");
        if (splitLabel.length == 2 && "candle".equals(splitLabel[0]) && StringUtils.isNumeric((CharSequence)splitLabel[1])) {
            boolean majorCandle;
            level.removeBlock(pos, false);
            boolean bl = majorCandle = Integer.parseInt(splitLabel[1]) == 2;
            if (!majorCandle && random.nextInt(3) != 0) {
                return;
            }
            int candleCount = majorCandle ? 3 : 1 + random.nextInt(2);
            BlockState candleBlock = (BlockState)((BlockState)Blocks.CANDLE.defaultBlockState().setValue((Property)CandleBlock.LIT, (Comparable)Boolean.valueOf(true))).setValue((Property)CandleBlock.CANDLES, (Comparable)Integer.valueOf(candleCount));
            level.setBlock(pos, candleBlock, 3);
        }
    }

    @Override
    public BoundingBox getBeardifierBox() {
        return this.boundingBox;
    }

    @Override
    public TerrainAdjustment getTerrainAdjustment() {
        return TerrainAdjustment.BEARD_BOX;
    }

    @Override
    public int getGroundLevelDelta() {
        return 1;
    }

    @Override
    public int getSpawnIndex() {
        return 1;
    }

    @Override
    public int getSortKey() {
        return 1;
    }

    private static class TrimProcessor
    extends StructureProcessor {
        private static final TrimProcessor INSTANCE = new TrimProcessor();

        private TrimProcessor() {
        }

        @Nullable
        public StructureTemplate.StructureBlockInfo process(LevelReader level, BlockPos origin, BlockPos centerBottom, StructureTemplate.StructureBlockInfo originalBlockInfo, StructureTemplate.StructureBlockInfo modifiedBlockInfo, StructurePlaceSettings settings, @Nullable StructureTemplate template) {
            if (modifiedBlockInfo.state().is(Blocks.POLISHED_ANDESITE_STAIRS) && level.getBlockState(modifiedBlockInfo.pos()).is(BlockTags.STONE_BRICKS)) {
                return null;
            }
            return super.process(level, origin, centerBottom, originalBlockInfo, modifiedBlockInfo, settings, template);
        }

        protected StructureProcessorType<?> getType() {
            return null;
        }
    }
}

