/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.lichtowerrevamp;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.neoforged.neoforge.common.world.PieceBeardifierModifier;
import org.jetbrains.annotations.Nullable;
import twilightforest.TFRegistries;
import twilightforest.beanification.Autowired;
import twilightforest.data.tags.BlockTagGenerator;
import twilightforest.data.tags.CustomTagGenerator;
import twilightforest.entity.MagicPainting;
import twilightforest.entity.MagicPaintingVariant;
import twilightforest.init.TFEntities;
import twilightforest.init.TFStructurePieceTypes;
import twilightforest.init.custom.MagicPaintingVariants;
import twilightforest.util.BoundingBoxUtils;
import twilightforest.util.jigsaw.JigsawPlaceContext;
import twilightforest.util.jigsaw.JigsawRecord;
import twilightforest.world.components.structures.SpawnIndexProvider;
import twilightforest.world.components.structures.TwilightJigsawPiece;
import twilightforest.world.components.structures.lichtowerrevamp.LichBossRoom;
import twilightforest.world.components.structures.lichtowerrevamp.LichTowerUtil;
import twilightforest.world.components.structures.lichtowerrevamp.LichTowerWingRoom;

public class LichTowerMagicGallery
extends TwilightJigsawPiece
implements PieceBeardifierModifier,
SpawnIndexProvider {
    @Autowired
    private static LichTowerUtil lichTowerUtil;

    public LichTowerMagicGallery(StructurePieceSerializationContext ctx, CompoundTag compoundTag) {
        super((StructurePieceType)TFStructurePieceTypes.LICH_MAGIC_GALLERY.value(), compoundTag, ctx, LichTowerMagicGallery.readSettings(compoundTag));
        LichTowerUtil.addDefaultProcessors(this.placeSettings.addProcessor(lichTowerUtil.getRoomSpawnerProcessor()));
    }

    public LichTowerMagicGallery(int genDepth, StructureTemplateManager structureManager, ResourceLocation templateLocation, JigsawPlaceContext jigsawContext) {
        super((StructurePieceType)TFStructurePieceTypes.LICH_MAGIC_GALLERY.value(), genDepth, structureManager, templateLocation, jigsawContext);
        LichTowerUtil.addDefaultProcessors(this.placeSettings.addProcessor(lichTowerUtil.getRoomSpawnerProcessor()));
    }

    @Override
    public BoundingBox getBeardifierBox() {
        return this.boundingBox;
    }

    @Override
    public TerrainAdjustment getTerrainAdjustment() {
        return TerrainAdjustment.NONE;
    }

    @Override
    public int getGroundLevelDelta() {
        return 0;
    }

    @Override
    public void postProcess(WorldGenLevel level, StructureManager structureManager, ChunkGenerator chunkGen, RandomSource random, BoundingBox chunkBounds, ChunkPos chunkPos, BlockPos structureCenterPos) {
        this.removeBanisters(level, chunkBounds);
        super.postProcess(level, structureManager, chunkGen, random, chunkBounds, chunkPos, structureCenterPos);
    }

    private void removeBanisters(WorldGenLevel level, BoundingBox chunkBounds) {
        JigsawRecord sourceJigsaw = this.getSourceJigsaw();
        BlockPos sourcePos = this.templatePosition.offset((Vec3i)sourceJigsaw.pos());
        Direction front = sourceJigsaw.orientation().front();
        BlockPos leftPos = sourcePos.relative(front.getClockWise(Direction.Axis.Y));
        Direction counterClockWise = front.getCounterClockWise(Direction.Axis.Y);
        int span = BoundingBoxUtils.getSpan(this.boundingBox, counterClockWise.getAxis());
        int evenShift = (span + 1) % 2;
        BlockPos rightPos = sourcePos.relative(counterClockWise, 1 + evenShift);
        LichTowerMagicGallery.removeIfBanister(level, leftPos, chunkBounds);
        LichTowerMagicGallery.removeIfBanister(level, leftPos.above(), chunkBounds);
        LichTowerMagicGallery.removeIfBanister(level, rightPos, chunkBounds);
        LichTowerMagicGallery.removeIfBanister(level, rightPos.below(), chunkBounds);
        if (evenShift == 1) {
            LichTowerMagicGallery.removeIfBanister(level, sourcePos.relative(counterClockWise, 1).below(), chunkBounds);
        }
    }

    private static void removeIfBanister(WorldGenLevel level, BlockPos pos, BoundingBox chunkBounds) {
        if (chunkBounds.isInside((Vec3i)pos) && level.getBlockState(pos).is(BlockTagGenerator.BANISTERS)) {
            level.removeBlock(pos, false);
        }
    }

    @Override
    protected void processJigsaw(TwilightJigsawPiece parent, StructurePieceAccessor pieceAccessor, Structure.GenerationContext context, JigsawRecord connection, int jigsawIndex) {
        if ("twilightforest:lich_tower/roof".equals(connection.target())) {
            ResourceLocation fallbackRoof = lichTowerUtil.rollGalleryRoof((RandomSource)context.random(), this.boundingBox);
            FrontAndTop orientationToMatch = LichTowerWingRoom.getVerticalOrientation(connection, Direction.UP, this);
            LichTowerWingRoom.tryRoof(pieceAccessor, context, connection, fallbackRoof, orientationToMatch, true, this, this.genDepth + 1, this.structureManager);
        }
    }

    @Override
    protected void handleDataMarker(String label, BlockPos pos, WorldGenLevel level, RandomSource random, BoundingBox chunkBounds, ChunkGenerator chunkGen, Rotation rotation) {
        level.removeBlock(pos, false);
        if ("painting".equals(label)) {
            Direction direction = this.placeSettings.getRotation().rotate(Direction.SOUTH);
            Optional<Holder.Reference<MagicPaintingVariant>> variantHolderOpt = LichTowerMagicGallery.variantForGallery((ServerLevelAccessor)level, this.templateName);
            MagicPainting galleryPainting = (MagicPainting)((EntityType)TFEntities.MAGIC_PAINTING.value()).create((Level)level.getLevel());
            if (variantHolderOpt.isPresent() && galleryPainting != null) {
                galleryPainting.setDirection(direction);
                galleryPainting.setVariant((Holder<MagicPaintingVariant>)((Holder)variantHolderOpt.get()));
                variantHolderOpt.get().value();
                this.placeSettings.getRotation();
                galleryPainting.moveTo(pos.getBottomCenter(), 0.0f, 0.0f);
                level.addFreshEntityWithPassengers((Entity)galleryPainting);
            }
        } else {
            LichBossRoom.placePainting(label, pos, (ServerLevelAccessor)level, random, chunkBounds, this.placeSettings.getRotation(), 2, 1, CustomTagGenerator.PaintingVariantTagGenerator.LICH_TOWER_PAINTINGS);
        }
    }

    private static Optional<Holder.Reference<MagicPaintingVariant>> variantForGallery(ServerLevelAccessor level, String roomId) {
        ResourceKey<MagicPaintingVariant> variantId;
        switch (roomId) {
            case "twilightforest:lich_tower/gallery/castaway_paradise": {
                ResourceKey<MagicPaintingVariant> resourceKey = MagicPaintingVariants.CASTAWAY_PARADISE;
                break;
            }
            case "twilightforest:lich_tower/gallery/darkness": {
                ResourceKey<MagicPaintingVariant> resourceKey = MagicPaintingVariants.DARKNESS;
                break;
            }
            case "twilightforest:lich_tower/gallery/lucid_lands": {
                ResourceKey<MagicPaintingVariant> resourceKey = MagicPaintingVariants.LUCID_LANDS;
                break;
            }
            case "twilightforest:lich_tower/gallery/music_in_the_mire": {
                ResourceKey<MagicPaintingVariant> resourceKey = MagicPaintingVariants.MUSIC_IN_THE_MIRE;
                break;
            }
            case "twilightforest:lich_tower/gallery/the_hostile_paradise": {
                ResourceKey<MagicPaintingVariant> resourceKey = MagicPaintingVariants.THE_HOSTILE_PARADISE;
                break;
            }
            default: {
                ResourceKey<MagicPaintingVariant> resourceKey = variantId = null;
            }
        }
        if (variantId == null) {
            return Optional.empty();
        }
        return level.registryAccess().registryOrThrow(TFRegistries.Keys.MAGIC_PAINTINGS).getHolder(variantId);
    }

    public static void tryPlaceGallery(Structure.GenerationContext context, StructurePieceAccessor pieceAccessor, @Nullable ResourceLocation roomId, JigsawRecord connection, TwilightJigsawPiece parent, int newDepth, StructureTemplateManager structureManager, String jigsawLabel) {
        JigsawPlaceContext placeableJunction = JigsawPlaceContext.pickPlaceableJunction(parent.templatePosition(), connection.pos(), connection.orientation(), structureManager, roomId, jigsawLabel, (RandomSource)context.random());
        if (placeableJunction != null) {
            LichTowerMagicGallery room = new LichTowerMagicGallery(newDepth, structureManager, roomId, placeableJunction);
            pieceAccessor.addPiece((StructurePiece)room);
            room.addJigsaws(parent, pieceAccessor, context);
        }
    }

    @Override
    public int getSpawnIndex() {
        return 1;
    }
}

