/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.markerhandler;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.RandomizableContainer;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.storage.loot.LootTable;
import twilightforest.init.custom.TemplateMarkerHandlers;
import twilightforest.world.components.structures.markerhandler.TemplateMarkerHandler;
import twilightforest.world.components.structures.markerhandler.TemplateMarkerHandlerType;

public record LootMarkerHandler(BlockStateProvider provider, ResourceKey<LootTable> lootTable) implements TemplateMarkerHandler
{
    public static final MapCodec<LootMarkerHandler> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockStateProvider.CODEC.fieldOf("loot_block").forGetter(LootMarkerHandler::provider), (App)ResourceKey.codec((ResourceKey)Registries.LOOT_TABLE).fieldOf("loot_table").forGetter(LootMarkerHandler::lootTable)).apply((Applicative)instance, LootMarkerHandler::new));

    @Override
    public boolean handleDataMarker(String label, BlockPos pos, WorldGenLevel level, RandomSource random, BoundingBox chunkBounds, ChunkGenerator chunkGen, Rotation rotation) {
        BlockState state = this.provider.getState(random, pos).rotate(rotation);
        if (level.setBlock(pos, state, 3) && level.getBlockEntity(pos) instanceof RandomizableContainer) {
            RandomizableContainer.setBlockEntityLootTable((BlockGetter)level, (RandomSource)random, (BlockPos)pos, this.lootTable);
            return true;
        }
        return false;
    }

    @Override
    public TemplateMarkerHandlerType getType() {
        return (TemplateMarkerHandlerType)TemplateMarkerHandlers.LOOT.value();
    }
}

