/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.placements;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacementType;
import twilightforest.init.TFStructurePlacementTypes;
import twilightforest.util.landmarks.LegacyLandmarkPlacements;

public class AvoidLandmarkGridPlacement
extends RandomSpreadStructurePlacement {
    public static final MapCodec<AvoidLandmarkGridPlacement> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Vec3i.offsetCodec((int)16).optionalFieldOf("locate_offset", (Object)Vec3i.ZERO).forGetter(rec$ -> ((AvoidLandmarkGridPlacement)((Object)((Object)((Object)rec$)))).locateOffset()), (App)StructurePlacement.FrequencyReductionMethod.CODEC.optionalFieldOf("frequency_reduction_method", (Object)StructurePlacement.FrequencyReductionMethod.DEFAULT).forGetter(rec$ -> ((AvoidLandmarkGridPlacement)((Object)((Object)((Object)rec$)))).frequencyReductionMethod()), (App)Codec.floatRange((float)0.0f, (float)1.0f).optionalFieldOf("frequency", (Object)Float.valueOf(1.0f)).forGetter(rec$ -> Float.valueOf(((AvoidLandmarkGridPlacement)((Object)((Object)((Object)rec$)))).frequency())), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("salt").forGetter(rec$ -> ((AvoidLandmarkGridPlacement)((Object)((Object)((Object)rec$)))).salt()), (App)StructurePlacement.ExclusionZone.CODEC.optionalFieldOf("exclusion_zone").forGetter(rec$ -> ((AvoidLandmarkGridPlacement)((Object)((Object)((Object)rec$)))).exclusionZone()), (App)Codec.intRange((int)0, (int)4096).fieldOf("spacing").forGetter(RandomSpreadStructurePlacement::spacing), (App)Codec.intRange((int)0, (int)4096).fieldOf("separation").forGetter(RandomSpreadStructurePlacement::separation), (App)RandomSpreadType.CODEC.optionalFieldOf("spread_type", (Object)RandomSpreadType.LINEAR).forGetter(RandomSpreadStructurePlacement::spreadType), (App)AvoidAdditionalStructures.CODEC.optionalFieldOf("avoid_additional_structures").forGetter(AvoidLandmarkGridPlacement::otherStructuresToAvoid)).apply((Applicative)instance, AvoidLandmarkGridPlacement::new)).validate(AvoidLandmarkGridPlacement::validate);
    private final Optional<AvoidAdditionalStructures> avoidOtherStructures;

    private static DataResult<AvoidLandmarkGridPlacement> validate(AvoidLandmarkGridPlacement placement) {
        return placement.spacing() <= placement.separation() ? DataResult.error(() -> "Spacing has to be larger than separation") : DataResult.success((Object)((Object)placement));
    }

    public AvoidLandmarkGridPlacement(int spacing, int separation, RandomSpreadType spreadType, int salt, Optional<AvoidAdditionalStructures> avoidOtherStructures) {
        super(spacing, separation, spreadType, salt);
        this.avoidOtherStructures = avoidOtherStructures;
    }

    public AvoidLandmarkGridPlacement(Vec3i locateOffset, StructurePlacement.FrequencyReductionMethod reduction, float frequencyModifier, int salt, Optional<StructurePlacement.ExclusionZone> exclusionZone, int spacing, int separation, RandomSpreadType spreadType, Optional<AvoidAdditionalStructures> avoidOtherStructures) {
        super(locateOffset, reduction, frequencyModifier, salt, exclusionZone, spacing, separation, spreadType);
        this.avoidOtherStructures = avoidOtherStructures;
    }

    protected boolean isPlacementChunk(ChunkGeneratorStructureState state, int chunkX, int chunkZ) {
        ChunkPos chunkpos = this.getPotentialStructureChunk(state.getLevelSeed(), chunkX, chunkZ);
        if (chunkpos.x != chunkX || chunkpos.z != chunkZ) {
            return false;
        }
        BlockPos.MutableBlockPos featurePos = LegacyLandmarkPlacements.getNearestCenterXZ(chunkX, chunkZ).mutable();
        featurePos.set(Math.abs(featurePos.getX() - chunkpos.getWorldPosition().getX()), 0, Math.abs(featurePos.getZ() - chunkpos.getWorldPosition().getZ()));
        int size = 80;
        return featurePos.getX() >= size || featurePos.getZ() >= size;
    }

    public boolean applyInteractionsWithOtherStructures(ChunkGeneratorStructureState structureState, int x, int z) {
        return super.applyInteractionsWithOtherStructures(structureState, x, z) && (this.avoidOtherStructures.isEmpty() || !this.avoidOtherStructures.get().isPlacementForbidden(structureState, x, z));
    }

    private Optional<AvoidAdditionalStructures> otherStructuresToAvoid() {
        return this.avoidOtherStructures;
    }

    public StructurePlacementType<?> type() {
        return (StructurePlacementType)TFStructurePlacementTypes.AVOID_GRID_LANDMARK_PLACEMENT_TYPE.get();
    }

    public record AvoidAdditionalStructures(Object2IntArrayMap<Holder<StructureSet>> avoidStructures) {
        public static final Codec<AvoidAdditionalStructures> CODEC = Codec.unboundedMap((Codec)StructureSet.CODEC, (Codec)Codec.intRange((int)0, (int)16)).xmap(map -> new AvoidAdditionalStructures((Object2IntArrayMap<Holder<StructureSet>>)new Object2IntArrayMap(map)), AvoidAdditionalStructures::avoidStructures);

        private boolean isPlacementForbidden(ChunkGeneratorStructureState structureState, int x, int z) {
            for (Object2IntMap.Entry structureSetEntry : this.avoidStructures.object2IntEntrySet()) {
                if (!structureState.hasStructureChunkInRange((Holder)structureSetEntry.getKey(), x, z, structureSetEntry.getIntValue())) continue;
                return true;
            }
            return false;
        }
    }
}

