/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.util;

import com.google.common.collect.Streams;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.MobSpawnSettings;

public interface ControlledSpawns {
    public static final String CODEC_NAME = "controlled_spawns";

    public List<MobSpawnSettings.SpawnerData> getCombinedMonsterSpawnableList();

    public List<MobSpawnSettings.SpawnerData> getCombinedCreatureSpawnableList();

    public List<MobSpawnSettings.SpawnerData> getSpawnableList(MobCategory var1);

    public List<MobSpawnSettings.SpawnerData> getSpawnableMonsterList(int var1);

    public record ControlledSpawningConfig(Map<String, List<MobSpawnSettings.SpawnerData>> spawnableMonsterLists, List<MobSpawnSettings.SpawnerData> ambientCreatureList, List<MobSpawnSettings.SpawnerData> waterCreatureList, List<MobSpawnSettings.SpawnerData> combinedMonsterSpawnableCache, List<MobSpawnSettings.SpawnerData> combinedCreatureSpawnableCache) {
        public static final Codec<ControlledSpawningConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)MobSpawnSettings.SpawnerData.CODEC.listOf()).fieldOf("labelled_monster_spawns").forGetter(ControlledSpawningConfig::spawnableMonsterLists), (App)MobSpawnSettings.SpawnerData.CODEC.listOf().fieldOf("ambient_spawns").forGetter(ControlledSpawningConfig::ambientCreatureList), (App)MobSpawnSettings.SpawnerData.CODEC.listOf().fieldOf("water_spawns").forGetter(ControlledSpawningConfig::waterCreatureList)).apply((Applicative)instance, ControlledSpawningConfig::create));
        public static final ControlledSpawningConfig EMPTY = ControlledSpawningConfig.create(Map.of(), List.of(), List.of());

        public static ControlledSpawningConfig firstIndexMonsters(MobSpawnSettings.SpawnerData ... spawnableMonsterList) {
            return ControlledSpawningConfig.justMonsters(Arrays.asList(spawnableMonsterList));
        }

        public static ControlledSpawningConfig justMonsters(List<MobSpawnSettings.SpawnerData> ... spawnableMonsterLists) {
            return ControlledSpawningConfig.create(ControlledSpawningConfig.convertMonsterList(Arrays.asList(spawnableMonsterLists)), List.of(), List.of());
        }

        public static ControlledSpawningConfig create(List<List<MobSpawnSettings.SpawnerData>> spawnableMonsterLists, List<MobSpawnSettings.SpawnerData> ambientCreatureList, List<MobSpawnSettings.SpawnerData> waterCreatureList) {
            return ControlledSpawningConfig.create(ControlledSpawningConfig.convertMonsterList(spawnableMonsterLists), ambientCreatureList, waterCreatureList);
        }

        public static ControlledSpawningConfig create(Map<String, List<MobSpawnSettings.SpawnerData>> spawnableMonsterLists, List<MobSpawnSettings.SpawnerData> ambientCreatureList, List<MobSpawnSettings.SpawnerData> waterCreatureList) {
            return new ControlledSpawningConfig(spawnableMonsterLists, ambientCreatureList, waterCreatureList, spawnableMonsterLists.values().stream().flatMap(Collection::stream).toList(), Streams.concat((Stream[])new Stream[]{ambientCreatureList.stream(), waterCreatureList.stream()}).toList());
        }

        private static Map<String, List<MobSpawnSettings.SpawnerData>> convertMonsterList(List<List<MobSpawnSettings.SpawnerData>> lists) {
            int i = 0;
            HashMap<String, List<MobSpawnSettings.SpawnerData>> map = new HashMap<String, List<MobSpawnSettings.SpawnerData>>();
            for (List<MobSpawnSettings.SpawnerData> list : lists) {
                map.put("" + i, list);
                ++i;
            }
            return map;
        }

        public List<MobSpawnSettings.SpawnerData> getForLabel(String index) {
            return this.spawnableMonsterLists().getOrDefault(index, List.of());
        }
    }
}

