/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftboceanmobs;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.ftb.mods.ftboceanmobs.Config;
import dev.ftb.mods.ftboceanmobs.entity.riftweaver.RiftWeaverBoss;
import dev.ftb.mods.ftboceanmobs.entity.riftweaver.RiftWeaverModes;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;

public class ModCommands {
    public static final SimpleCommandExceptionType NO_WEAVER = new SimpleCommandExceptionType((Message)Component.literal((String)"No Rift Weaver within 100 blocks"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext ignoredBuildContext) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"ftboceanmobs").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"weavertest").requires(cs -> cs.hasPermission(2))).then(Commands.literal((String)"mode").then(Commands.argument((String)"modename", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> SharedSuggestionProvider.suggest(RiftWeaverModes.sortedNames(), (SuggestionsBuilder)builder)).executes(ctx -> ModCommands.setWeaverMode((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"modename")))))).then(Commands.literal((String)"toggle_armor").executes(ModCommands::toggleWeaverArmor))).then(Commands.literal((String)"toggle_frenzy").executes(ModCommands::toggleWeaverFrenzy))).then(Commands.literal((String)"mark_arena").executes(ModCommands::markArena))));
    }

    private static int setWeaverMode(CommandContext<CommandSourceStack> ctx, String modename) throws CommandSyntaxException {
        try {
            ModCommands.findWeaver(ctx).forceQueueMode(RiftWeaverModes.byName(modename).orElseThrow(IllegalArgumentException::new));
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("Set mode for Rift Weaver to '" + modename + "'")), false);
            return 1;
        }
        catch (IllegalArgumentException e) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)("Invalid mode '" + modename + "'")).withStyle(ChatFormatting.RED));
            return 0;
        }
    }

    private static int toggleWeaverArmor(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        RiftWeaverBoss weaver;
        weaver.setArmorActive(!(weaver = ModCommands.findWeaver(ctx)).isArmorActive());
        return 1;
    }

    private static int toggleWeaverFrenzy(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        RiftWeaverBoss weaver;
        weaver.setFrenzied(!(weaver = ModCommands.findWeaver(ctx)).isFrenzied());
        return 1;
    }

    private static int markArena(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        RiftWeaverBoss weaver = ModCommands.findWeaver(ctx);
        for (int i = -Config.arenaRadius; i <= Config.arenaRadius; ++i) {
            for (int j = -Config.arenaRadius; j <= Config.arenaRadius; ++j) {
                int x = weaver.getSpawnPos().getX() + i;
                int z = weaver.getSpawnPos().getZ() + j;
                int y = weaver.level().getHeight(Heightmap.Types.OCEAN_FLOOR, x, z);
                long d = Math.round(weaver.getSpawnPos().distToCenterSqr((double)x, (double)weaver.getSpawnPos().getY(), (double)z));
                if (Math.abs(d - (long)Config.arenaRadiusSq) < 48L) {
                    for (int k = 0; k < 5; ++k) {
                        weaver.level().setBlock(new BlockPos(x, y + k, z), Blocks.GOLD_BLOCK.defaultBlockState(), 3);
                    }
                    continue;
                }
                if (d >= (long)(Config.arenaRadiusSq - 48)) continue;
                if (weaver.level().random.nextInt(100) == 0) {
                    weaver.level().setBlock(new BlockPos(x, y, z), Blocks.SPONGE.defaultBlockState(), 3);
                    continue;
                }
                weaver.level().setBlock(new BlockPos(x, y, z), Blocks.WATER.defaultBlockState(), 3);
            }
        }
        weaver.level().setBlock(weaver.getSpawnPos().above(), Blocks.COPPER_BLOCK.defaultBlockState(), 3);
        return 1;
    }

    private static RiftWeaverBoss findWeaver(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
        RiftWeaverBoss boss = (RiftWeaverBoss)player.level().getNearestEntity(RiftWeaverBoss.class, TargetingConditions.DEFAULT, (LivingEntity)player, player.getX(), player.getY(), player.getZ(), new AABB(player.blockPosition()).inflate(100.0));
        if (boss == null) {
            throw NO_WEAVER.create();
        }
        return boss;
    }
}

