/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftboceanmobs.entity;

import dev.ftb.mods.ftboceanmobs.entity.BaseRiftMob;
import dev.ftb.mods.ftboceanmobs.mobai.DelayedMeleeAttackGoal;
import dev.ftb.mods.ftboceanmobs.registry.ModSounds;
import java.util.EnumSet;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.util.GeckoLibUtil;

public class RiftDemon
extends BaseRiftMob {
    private static final RawAnimation ANIM_ATTACK_GLARE = RawAnimation.begin().thenPlay("attack.glare");
    protected static final EntityDataAccessor<Byte> DATA_STATE = SynchedEntityData.defineId(RiftDemon.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final byte STATE_NONE = 0;
    private static final byte STATE_SHIELD_UP = 1;
    private static final byte STATE_GLARING = 2;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public RiftDemon(EntityType<? extends RiftDemon> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MOVEMENT_SPEED, (double)0.23f).add(Attributes.MAX_HEALTH, 140.0).add(Attributes.ARMOR, 12.0).add(Attributes.ARMOR_TOUGHNESS, 8.0).add(Attributes.FOLLOW_RANGE, 48.0).add(Attributes.WATER_MOVEMENT_EFFICIENCY, 0.3333333432674408).add(Attributes.ATTACK_DAMAGE, 20.0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new ShieldsUpGoal(this));
        this.goalSelector.addGoal(1, (Goal)new GlareGoal(this));
        this.goalSelector.addGoal(2, (Goal)new DelayedMeleeAttackGoal((PathfinderMob)this, 1.3, false, 18));
        this.goalSelector.addGoal(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Warden.class, true));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(DefaultAnimations.genericWalkIdleController((GeoAnimatable)this));
        controllers.add(new AnimationController((GeoAnimatable)this, "Attacking", 10, this::attackState));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_STATE, (Object)0);
    }

    public boolean isBlocking() {
        return this.isShieldUp();
    }

    protected void blockUsingShield(LivingEntity attacker) {
        attacker.hurt(this.level().damageSources().hotFloor(), 8.0f);
        attacker.igniteForTicks(30);
        this.playSound(SoundEvents.SHIELD_BLOCK, 1.0f, 1.0f);
    }

    private PlayState attackState(AnimationState<RiftDemon> state) {
        state.setControllerSpeed(1.0f);
        if (this.isShieldUp()) {
            return state.setAndContinue(DefaultAnimations.ATTACK_BLOCK);
        }
        if (this.isGlaring()) {
            return state.setAndContinue(ANIM_ATTACK_GLARE);
        }
        if (this.swinging) {
            return state.setAndContinue(DefaultAnimations.ATTACK_STRIKE);
        }
        return PlayState.STOP;
    }

    public boolean isShieldUp() {
        return (Byte)this.entityData.get(DATA_STATE) == 1;
    }

    public boolean isGlaring() {
        return (Byte)this.entityData.get(DATA_STATE) == 2;
    }

    public void setShieldUp() {
        this.entityData.set(DATA_STATE, (Object)1);
    }

    public void setGlaring() {
        this.entityData.set(DATA_STATE, (Object)2);
    }

    private void clearState() {
        this.entityData.set(DATA_STATE, (Object)0);
    }

    public int getCurrentSwingDuration() {
        return 30;
    }

    protected AABB getAttackBoundingBox() {
        return super.getAttackBoundingBox().inflate(2.0);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public boolean doHurtTarget(Entity entity) {
        if (super.doHurtTarget(entity)) {
            entity.igniteForSeconds(4.0f);
            return true;
        }
        return false;
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        this.playSound(SoundEvents.PIGLIN_BRUTE_STEP, 1.0f, 0.75f);
    }

    @Override
    public void playDelayedAttackSound() {
        this.playSound((SoundEvent)ModSounds.RIFT_DEMON_ATTACK.get());
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)ModSounds.RIFT_DEMON_DEATH.get();
    }

    protected float nextStep() {
        return this.moveDist + 1.2f;
    }

    private boolean couldBlock() {
        LivingEntity target = this.getTarget();
        if (target == null || !target.isAlive() || target.distanceToSqr(this.position()) >= 25.0) {
            return false;
        }
        Vec3 targetPos = target.position();
        Vec3 viewVec = this.calculateViewVector(0.0f, this.getYHeadRot());
        Vec3 offset = targetPos.vectorTo(this.position());
        offset = new Vec3(offset.x, 0.0, offset.z).normalize();
        return offset.dot(viewVec) < 0.0;
    }

    private boolean checkGlareDist() {
        if (this.getTarget() == null) {
            return false;
        }
        double d2 = this.distanceToSqr((Entity)this.getTarget());
        return d2 >= 36.0 && d2 <= 256.0;
    }

    public static class ShieldsUpGoal
    extends AnimatedActionGoal {
        public ShieldsUpGoal(RiftDemon riftDemon) {
            super(riftDemon, 48, 30, d -> ((RiftDemon)d).random.nextInt(20) == 0 && d.couldBlock(), riftDemon::setShieldUp);
        }

        @Override
        public void start() {
            super.start();
            this.riftDemon.playSound((SoundEvent)ModSounds.RIFT_DEMON_SHIELD.get(), 1.2f, 1.0f);
        }
    }

    public static class GlareGoal
    extends AnimatedActionGoal {
        public GlareGoal(RiftDemon riftDemon) {
            super(riftDemon, 94, 200, d -> ((RiftDemon)d).random.nextInt(80) == 0 && d.checkGlareDist(), riftDemon::setGlaring);
        }

        @Override
        public void start() {
            super.start();
            this.riftDemon.playSound((SoundEvent)ModSounds.RIFT_DEMON_LIGHTNING.get());
        }

        @Override
        public void tick() {
            super.tick();
            switch (this.tickCounter % 20) {
                case 4: {
                    this.addLightning((LivingEntity)this.riftDemon, true, Vec3.ZERO);
                    break;
                }
                case 0: {
                    Vec3 v = this.target.getViewVector(1.0f);
                    Vec3 v2 = new Vec3(v.x, 0.0, v.y);
                    this.addLightning(this.target, false, new Vec3(this.target.getRandom().nextDouble() * 6.0 - 3.0, 0.0, this.target.getRandom().nextDouble() * 6.0 - 3.0).add(v2));
                }
            }
        }

        private void addLightning(LivingEntity entity, boolean visual, Vec3 offset) {
            LightningBolt lightningbolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create(entity.level());
            if (lightningbolt != null) {
                lightningbolt.moveTo(Vec3.atBottomCenterOf((Vec3i)entity.blockPosition()).add(offset));
                lightningbolt.setVisualOnly(visual);
                entity.level().addFreshEntity((Entity)lightningbolt);
            }
        }
    }

    private static abstract class AnimatedActionGoal
    extends Goal {
        protected final RiftDemon riftDemon;
        private final int ticks;
        private final int minInterval;
        private final Function<RiftDemon, Boolean> useCheck;
        private final Runnable onStart;
        protected int tickCounter;
        protected LivingEntity target;
        private int nextUseTick;

        public AnimatedActionGoal(RiftDemon riftDemon, int ticks, int minInterval, Function<RiftDemon, Boolean> useCheck, Runnable onStart) {
            this.riftDemon = riftDemon;
            this.ticks = ticks;
            this.minInterval = minInterval;
            this.useCheck = useCheck;
            this.onStart = onStart;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            this.target = this.riftDemon.getTarget();
            return this.riftDemon.tickCount >= this.nextUseTick && this.useCheck.apply(this.riftDemon) != false;
        }

        public boolean canContinueToUse() {
            return this.riftDemon.getTarget() != null && this.target.isAlive() && this.tickCounter > 0;
        }

        public void start() {
            this.onStart.run();
            this.tickCounter = AnimatedActionGoal.reducedTickDelay((int)this.ticks);
        }

        public void stop() {
            this.riftDemon.clearState();
            this.nextUseTick = this.riftDemon.tickCount + this.minInterval;
        }

        public void tick() {
            this.riftDemon.getLookControl().setLookAt((Entity)this.target);
            if (this.tickCounter > 0) {
                --this.tickCounter;
            }
        }
    }
}

