/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.controller;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.wrapper.EmptyItemHandler;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.controller.IControllableStorage;
import net.p3pp3rf1y.sophisticatedcore.controller.IControllerBoundable;
import net.p3pp3rf1y.sophisticatedcore.controller.ILinkable;
import net.p3pp3rf1y.sophisticatedcore.inventory.IInsertBlockOverride;
import net.p3pp3rf1y.sophisticatedcore.inventory.IItemHandlerSimpleInserter;
import net.p3pp3rf1y.sophisticatedcore.inventory.ITrackedContentsItemHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import org.apache.logging.log4j.util.Supplier;

public abstract class ControllerBlockEntityBase
extends BlockEntity
implements IItemHandlerSimpleInserter,
IInsertBlockOverride {
    private List<BlockPos> storagePositions = new ArrayList<BlockPos>();
    private final Map<BlockPos, Integer> storagePositionIndexes = new HashMap<BlockPos, Integer>();
    private List<Integer> baseIndexes = new ArrayList<Integer>();
    private int totalSlots = 0;
    protected final Map<ItemStackKey, Set<BlockPos>> stackStorages = new HashMap<ItemStackKey, Set<BlockPos>>();
    private final Map<BlockPos, Set<ItemStackKey>> storageStacks = new HashMap<BlockPos, Set<ItemStackKey>>();
    protected final Map<Item, Set<ItemStackKey>> itemStackKeys = new HashMap<Item, Set<ItemStackKey>>();
    private final Comparator<BlockPos> distanceComparator = Comparator.comparingDouble(p -> p.distSqr((Vec3i)this.getBlockPos())).thenComparing(Comparator.naturalOrder());
    protected final Set<BlockPos> emptySlotsStorages = new TreeSet<BlockPos>(this.distanceComparator);
    protected final Map<Item, Set<BlockPos>> memorizedItemStorages = new HashMap<Item, Set<BlockPos>>();
    private final Map<BlockPos, Set<Item>> storageMemorizedItems = new HashMap<BlockPos, Set<Item>>();
    protected final Map<Integer, Set<BlockPos>> memorizedStackStorages = new HashMap<Integer, Set<BlockPos>>();
    private final Map<BlockPos, Set<Integer>> storageMemorizedStacks = new HashMap<BlockPos, Set<Integer>>();
    protected final Map<Item, Set<BlockPos>> filterItemStorages = new HashMap<Item, Set<BlockPos>>();
    private final Map<BlockPos, Set<Item>> storageFilterItems = new HashMap<BlockPos, Set<Item>>();
    private Set<BlockPos> linkedBlocks = new TreeSet<BlockPos>(this.distanceComparator);
    private Set<BlockPos> connectingBlocks = new TreeSet<BlockPos>(this.distanceComparator);
    private Set<BlockPos> nonConnectingBlocks = new TreeSet<BlockPos>(this.distanceComparator);
    private WeakReference<IItemHandlerModifiable>[] cachedHandlers = new WeakReference[0];

    public boolean addLinkedBlock(BlockPos linkedPos) {
        if (this.level != null && !this.level.isClientSide() && this.isWithinRange(linkedPos) && !this.linkedBlocks.contains(linkedPos) && !this.storagePositions.contains(linkedPos)) {
            this.linkedBlocks.add(linkedPos);
            this.setChanged();
            WorldHelper.getBlockEntity((BlockGetter)this.level, linkedPos, ILinkable.class).ifPresent(l -> {
                if (l.connectLinkedSelf()) {
                    LinkedHashSet<BlockPos> positionsToCheck = new LinkedHashSet<BlockPos>();
                    positionsToCheck.add(linkedPos);
                    this.searchAndAddBoundables(positionsToCheck, true);
                }
                this.searchAndAddBoundables(new LinkedHashSet<BlockPos>(l.getConnectablePositions()), false);
            });
            WorldHelper.notifyBlockUpdate(this);
            return true;
        }
        return false;
    }

    public void removeLinkedBlock(BlockPos storageBlockPos) {
        this.linkedBlocks.remove(storageBlockPos);
        this.setChanged();
        this.verifyStoragesConnected();
        WorldHelper.notifyBlockUpdate(this);
    }

    public void onLoad() {
        super.onLoad();
        if (this.level != null && !this.level.isClientSide()) {
            this.stackStorages.clear();
            this.storageStacks.clear();
            this.itemStackKeys.clear();
            this.emptySlotsStorages.clear();
            this.storagePositions.forEach(this::addStorageStacksAndRegisterListeners);
        }
    }

    public boolean isStorageConnected(BlockPos storagePos) {
        return this.storagePositions.contains(storagePos);
    }

    public void searchAndAddBoundables() {
        HashSet<BlockPos> positionsToCheck = new HashSet<BlockPos>();
        for (Direction dir : Direction.values()) {
            positionsToCheck.add(this.getBlockPos().offset(dir.getNormal()));
        }
        this.searchAndAddBoundables(positionsToCheck, false);
    }

    public void changeSlots(BlockPos storagePos, int newSlots, boolean hasEmptySlots) {
        this.updateBaseIndexesAndTotalSlots(storagePos, newSlots);
        this.updateEmptySlots(storagePos, hasEmptySlots);
    }

    public void updateEmptySlots(BlockPos storagePos, boolean hasEmptySlots) {
        if (this.emptySlotsStorages.contains(storagePos) && !hasEmptySlots) {
            this.emptySlotsStorages.remove(storagePos);
        } else if (!this.emptySlotsStorages.contains(storagePos) && hasEmptySlots) {
            this.emptySlotsStorages.add(storagePos);
        }
    }

    private void updateBaseIndexesAndTotalSlots(BlockPos storagePos, int newSlots) {
        int index = this.storagePositions.indexOf(storagePos);
        int originalSlots = this.getStorageSlots(index);
        int diff = newSlots - originalSlots;
        for (int i = index; i < this.baseIndexes.size(); ++i) {
            this.baseIndexes.set(i, this.baseIndexes.get(i) + diff);
        }
        this.totalSlots += diff;
        WorldHelper.notifyBlockUpdate(this);
    }

    private int getStorageSlots(int index) {
        int previousBaseIndex = index == 0 ? 0 : this.baseIndexes.get(index - 1);
        return this.baseIndexes.get(index) - previousBaseIndex;
    }

    public int getSlots(int storageIndex) {
        if (storageIndex < 0 || storageIndex >= this.baseIndexes.size()) {
            return 0;
        }
        return this.getStorageSlots(storageIndex);
    }

    private void searchAndAddBoundables(Set<BlockPos> positionsToCheck, boolean addingLinkedSelf) {
        HashSet positionsChecked = new HashSet();
        boolean first = true;
        while (!positionsToCheck.isEmpty()) {
            Iterator<BlockPos> it = positionsToCheck.iterator();
            BlockPos posToCheck = it.next();
            it.remove();
            boolean finalFirst = first;
            WorldHelper.getLoadedBlockEntity(this.level, posToCheck, IControllerBoundable.class).ifPresentOrElse(boundable -> this.tryToConnectStorageAndAddPositionsToCheckAround(positionsToCheck, addingLinkedSelf, positionsChecked, posToCheck, finalFirst, (IControllerBoundable)boundable), () -> positionsChecked.add(posToCheck));
            first = false;
        }
    }

    private void tryToConnectStorageAndAddPositionsToCheckAround(Set<BlockPos> positionsToCheck, boolean addingLinkedSelf, Set<BlockPos> positionsChecked, BlockPos posToCheck, boolean finalFirst, IControllerBoundable boundable) {
        if (boundable.canBeConnected() || addingLinkedSelf && finalFirst) {
            IControllableStorage storage;
            ILinkable linkable;
            if (boundable instanceof ILinkable && (linkable = (ILinkable)boundable).isLinked() && (!addingLinkedSelf || !finalFirst)) {
                this.linkedBlocks.remove(posToCheck);
                linkable.setNotLinked();
                this.clearCachedHandlers();
            } else if (boundable instanceof IControllableStorage && (storage = (IControllableStorage)boundable).hasStorageData()) {
                this.addStorageData(posToCheck);
            } else {
                if (boundable.canConnectStorages()) {
                    this.connectingBlocks.add(posToCheck);
                } else {
                    this.nonConnectingBlocks.add(posToCheck);
                }
                boundable.registerController(this);
            }
            if (boundable.canConnectStorages()) {
                this.addUncheckedPositionsAround(positionsToCheck, positionsChecked, posToCheck);
            }
        }
    }

    private void clearCachedHandlers() {
        this.cachedHandlers = new WeakReference[this.storagePositions.size()];
    }

    public void clearCachedHandler(BlockPos storagePos) {
        Integer index = this.storagePositionIndexes.get(storagePos);
        if (index != null && index < this.cachedHandlers.length) {
            this.cachedHandlers[index.intValue()] = null;
        }
    }

    private void addUncheckedPositionsAround(Set<BlockPos> positionsToCheck, Set<BlockPos> positionsChecked, BlockPos currentPos) {
        for (Direction dir : Direction.values()) {
            BlockPos pos = currentPos.offset(dir.getNormal());
            if (positionsChecked.contains(pos) || (this.storagePositions.contains(pos) || this.connectingBlocks.contains(pos) || this.nonConnectingBlocks.contains(pos)) && !this.linkedBlocks.contains(pos) || !this.isWithinRange(pos)) continue;
            positionsToCheck.add(pos);
        }
    }

    private boolean isWithinRange(BlockPos pos) {
        return Math.abs(pos.getX() - this.getBlockPos().getX()) <= this.getSearchRange() && Math.abs(pos.getY() - this.getBlockPos().getY()) <= this.getSearchRange() && Math.abs(pos.getZ() - this.getBlockPos().getZ()) <= this.getSearchRange();
    }

    protected abstract int getSearchRange();

    public void addStorage(BlockPos storagePos) {
        if (this.storagePositions.contains(storagePos)) {
            this.removeStorageInventoryData(storagePos);
            this.clearCachedHandlers();
        }
        if (this.isWithinRange(storagePos)) {
            LinkedHashSet<BlockPos> positionsToCheck = new LinkedHashSet<BlockPos>();
            positionsToCheck.add(storagePos);
            this.searchAndAddBoundables(positionsToCheck, false);
        }
        WorldHelper.notifyBlockUpdate(this);
    }

    private void addStorageData(BlockPos storagePos) {
        this.storagePositions.add(storagePos);
        int index = this.storagePositions.size() - 1;
        this.storagePositionIndexes.put(storagePos, index);
        this.totalSlots += this.getHandlerFromIndex(index).getSlots();
        this.baseIndexes.add(this.totalSlots);
        this.addStorageStacksAndRegisterListeners(storagePos);
        this.setChanged();
        WorldHelper.notifyBlockUpdate(this);
    }

    public void addStorageStacksAndRegisterListeners(BlockPos storagePos) {
        WorldHelper.getLoadedBlockEntity(this.level, storagePos, IControllableStorage.class).ifPresent(storage -> {
            ITrackedContentsItemHandler handler = storage.getStorageWrapper().getInventoryForInputOutput();
            handler.getTrackedStacks().forEach(k -> this.addStorageStack(storagePos, (ItemStackKey)k));
            if (handler.hasEmptySlots()) {
                this.emptySlotsStorages.add(storagePos);
            }
            MemorySettingsCategory memorySettings = storage.getStorageWrapper().getSettingsHandler().getTypeCategory(MemorySettingsCategory.class);
            memorySettings.getFilterItemSlots().keySet().forEach(i -> this.addStorageMemorizedItem(storagePos, (Item)i));
            memorySettings.getFilterStackSlots().keySet().forEach(stackHash -> this.addStorageMemorizedStack(storagePos, (int)stackHash));
            this.setStorageFilterItems(storagePos, storage.getStorageWrapper().getInventoryHandler().getFilterItems());
            storage.registerController(this);
        });
    }

    public void addStorageMemorizedItem(BlockPos storagePos, Item item) {
        this.memorizedItemStorages.computeIfAbsent(item, stackKey -> new LinkedHashSet()).add(storagePos);
        this.storageMemorizedItems.computeIfAbsent(storagePos, pos -> new HashSet()).add(item);
    }

    public void addStorageMemorizedStack(BlockPos storagePos, int stackHash) {
        this.memorizedStackStorages.computeIfAbsent(stackHash, stackKey -> new LinkedHashSet()).add(storagePos);
        this.storageMemorizedStacks.computeIfAbsent(storagePos, pos -> new HashSet()).add(stackHash);
    }

    public void removeStorageMemorizedItem(BlockPos storagePos, Item item) {
        this.memorizedItemStorages.computeIfPresent(item, (i, positions) -> {
            positions.remove(storagePos);
            return positions;
        });
        if (this.memorizedItemStorages.containsKey(item) && this.memorizedItemStorages.get(item).isEmpty()) {
            this.memorizedItemStorages.remove(item);
        }
        this.storageMemorizedItems.remove(storagePos);
    }

    public void removeStorageMemorizedStack(BlockPos storagePos, int stackHash) {
        this.memorizedStackStorages.computeIfPresent(stackHash, (i, positions) -> {
            positions.remove(storagePos);
            return positions;
        });
        if (this.memorizedStackStorages.containsKey(stackHash) && this.memorizedStackStorages.get(stackHash).isEmpty()) {
            this.memorizedStackStorages.remove(stackHash);
        }
        this.storageMemorizedStacks.remove(storagePos);
    }

    private <T> Optional<T> getWrapperValueFromHolder(BlockPos storagePos, Function<IStorageWrapper, T> valueGetter) {
        return WorldHelper.getLoadedBlockEntity(this.level, storagePos, IControllableStorage.class).map(holder -> valueGetter.apply(holder.getStorageWrapper()));
    }

    public void addStorageStack(BlockPos storagePos, ItemStackKey itemStackKey) {
        this.stackStorages.computeIfAbsent(itemStackKey, stackKey -> new LinkedHashSet()).add(storagePos);
        this.storageStacks.computeIfAbsent(storagePos, pos -> new HashSet()).add(itemStackKey);
        this.itemStackKeys.computeIfAbsent(itemStackKey.getStack().getItem(), item -> new LinkedHashSet()).add(itemStackKey);
    }

    public void removeStorageStack(BlockPos storagePos, ItemStackKey stackKey) {
        this.stackStorages.computeIfPresent(stackKey, (sk, positions) -> {
            positions.remove(storagePos);
            return positions;
        });
        if (this.stackStorages.containsKey(stackKey) && this.stackStorages.get(stackKey).isEmpty()) {
            this.stackStorages.remove(stackKey);
            this.itemStackKeys.computeIfPresent(stackKey.getStack().getItem(), (i, stackKeys) -> {
                stackKeys.remove(stackKey);
                return stackKeys;
            });
            if (this.itemStackKeys.containsKey(stackKey.getStack().getItem()) && this.itemStackKeys.get(stackKey.getStack().getItem()).isEmpty()) {
                this.itemStackKeys.remove(stackKey.getStack().getItem());
            }
        }
        this.storageStacks.computeIfPresent(storagePos, (pos, stackKeys) -> {
            stackKeys.remove(stackKey);
            return stackKeys;
        });
        if (this.storageStacks.containsKey(storagePos) && this.storageStacks.get(storagePos).isEmpty()) {
            this.storageStacks.remove(storagePos);
        }
    }

    public void removeStorageStacks(BlockPos storagePos) {
        this.storageStacks.computeIfPresent(storagePos, (pos, stackKeys) -> {
            stackKeys.forEach(stackKey -> {
                Set<BlockPos> storages = this.stackStorages.get(stackKey);
                if (storages != null) {
                    storages.remove(storagePos);
                    if (storages.isEmpty()) {
                        this.stackStorages.remove(stackKey);
                        this.itemStackKeys.computeIfPresent(stackKey.getStack().getItem(), (i, positions) -> {
                            positions.remove(stackKey);
                            return positions;
                        });
                        if (this.itemStackKeys.containsKey(stackKey.getStack().getItem()) && this.itemStackKeys.get(stackKey.getStack().getItem()).isEmpty()) {
                            this.itemStackKeys.remove(stackKey.getStack().getItem());
                        }
                    }
                }
            });
            return stackKeys;
        });
        this.storageStacks.remove(storagePos);
    }

    protected boolean hasItem(Item item) {
        return this.itemStackKeys.containsKey(item);
    }

    protected boolean isMemorizedItem(ItemStack stack) {
        return this.memorizedItemStorages.containsKey(stack.getItem()) || this.memorizedStackStorages.containsKey(ItemStack.hashItemAndComponents((ItemStack)stack));
    }

    protected boolean isFilterItem(Item item) {
        return this.filterItemStorages.containsKey(item);
    }

    public void removeBoundable(BlockPos boundablePos) {
        this.removeConnectingBlock(boundablePos);
        this.verifyStoragesConnected();
    }

    public void removeStorage(BlockPos storagePos) {
        this.removeConnectingBlock(storagePos);
        this.removeStorageInventoryDataAndUnregisterController(storagePos);
        this.verifyStoragesConnected();
    }

    private void removeConnectingBlock(BlockPos storagePos) {
        if (this.connectingBlocks.remove(storagePos)) {
            WorldHelper.getLoadedBlockEntity(this.level, storagePos, IControllerBoundable.class).ifPresent(IControllerBoundable::unregisterController);
        }
    }

    public void removeNonConnectingBlock(BlockPos storagePos) {
        if (this.nonConnectingBlocks.remove(storagePos)) {
            WorldHelper.getLoadedBlockEntity(this.level, storagePos, IControllerBoundable.class).ifPresent(IControllerBoundable::unregisterController);
        }
    }

    private void removeStorageInventoryDataAndUnregisterController(BlockPos storagePos) {
        if (!this.storagePositions.contains(storagePos)) {
            return;
        }
        this.removeStorageInventoryData(storagePos);
        this.linkedBlocks.remove(storagePos);
        WorldHelper.getLoadedBlockEntity(this.level, storagePos, IControllableStorage.class).ifPresent(IControllableStorage::unregisterController);
        this.clearCachedHandlers();
        this.setChanged();
        WorldHelper.notifyBlockUpdate(this);
    }

    private void removeStorageInventoryData(BlockPos storagePos) {
        int idx = this.storagePositions.indexOf(storagePos);
        this.totalSlots -= this.getStorageSlots(idx);
        this.removeStorageStacks(storagePos);
        this.removeStorageMemorizedItems(storagePos);
        this.removeStorageMemorizedStacks(storagePos);
        this.removeStorageWithEmptySlots(storagePos);
        this.removeStorageFilterItems(storagePos);
        this.storagePositions.remove(idx);
        this.removeStoragePositionIndex(storagePos);
        this.removeBaseIndexAt(idx);
    }

    private void removeStoragePositionIndex(BlockPos storagePos) {
        Integer removedIndex = this.storagePositionIndexes.remove(storagePos);
        if (removedIndex == null) {
            return;
        }
        for (Map.Entry<BlockPos, Integer> entry : this.storagePositionIndexes.entrySet()) {
            int index = entry.getValue();
            if (index <= removedIndex) continue;
            entry.setValue(index - 1);
        }
    }

    private void removeStorageFilterItems(BlockPos storagePos) {
        this.storageFilterItems.computeIfPresent(storagePos, (pos, items) -> {
            items.forEach(item -> {
                Set<BlockPos> storages = this.filterItemStorages.get(item);
                if (storages != null) {
                    storages.remove(storagePos);
                    if (storages.isEmpty()) {
                        this.filterItemStorages.remove(item);
                    }
                }
            });
            return items;
        });
        this.storageFilterItems.remove(storagePos);
    }

    private void removeStorageMemorizedItems(BlockPos storagePos) {
        this.storageMemorizedItems.computeIfPresent(storagePos, (pos, items) -> {
            items.forEach(item -> {
                Set<BlockPos> storages = this.memorizedItemStorages.get(item);
                if (storages != null) {
                    storages.remove(storagePos);
                    if (storages.isEmpty()) {
                        this.memorizedItemStorages.remove(item);
                    }
                }
            });
            return items;
        });
        this.storageMemorizedItems.remove(storagePos);
    }

    private void removeStorageMemorizedStacks(BlockPos storagePos) {
        this.storageMemorizedStacks.computeIfPresent(storagePos, (pos, items) -> {
            items.forEach(stackHash -> {
                Set<BlockPos> storages = this.memorizedStackStorages.get(stackHash);
                if (storages != null) {
                    storages.remove(storagePos);
                    if (storages.isEmpty()) {
                        this.memorizedStackStorages.remove(stackHash);
                    }
                }
            });
            return items;
        });
        this.storageMemorizedStacks.remove(storagePos);
    }

    private void verifyStoragesConnected() {
        HashSet<BlockPos> toVerify = new HashSet<BlockPos>(this.storagePositions);
        toVerify.addAll(this.connectingBlocks);
        toVerify.addAll(this.nonConnectingBlocks);
        HashSet<BlockPos> positionsToCheck = new HashSet<BlockPos>();
        for (Direction dir : Direction.values()) {
            BlockPos offsetPos = this.getBlockPos().offset(dir.getNormal());
            if (!toVerify.contains(offsetPos)) continue;
            positionsToCheck.add(offsetPos);
        }
        HashSet<BlockPos> positionsChecked = new HashSet<BlockPos>();
        this.verifyConnected(toVerify, positionsToCheck, positionsChecked);
        this.linkedBlocks.forEach(linkedPosition -> WorldHelper.getBlockEntity((BlockGetter)this.getLevel(), linkedPosition, ILinkable.class).ifPresent(l -> {
            if (l.connectLinkedSelf() && toVerify.contains(linkedPosition)) {
                positionsToCheck.add((BlockPos)linkedPosition);
            }
            l.getConnectablePositions().forEach(p -> {
                if (toVerify.contains(p)) {
                    positionsToCheck.add((BlockPos)p);
                }
            });
        }));
        this.verifyConnected(toVerify, positionsToCheck, positionsChecked);
        toVerify.forEach(storagePos -> {
            this.removeConnectingBlock((BlockPos)storagePos);
            this.removeNonConnectingBlock((BlockPos)storagePos);
            this.removeStorageInventoryDataAndUnregisterController((BlockPos)storagePos);
        });
        this.clearCachedHandlers();
    }

    private void verifyConnected(HashSet<BlockPos> toVerify, Set<BlockPos> positionsToCheck, Set<BlockPos> positionsChecked) {
        while (!positionsToCheck.isEmpty()) {
            Iterator<BlockPos> it = positionsToCheck.iterator();
            BlockPos posToCheck = it.next();
            it.remove();
            positionsChecked.add(posToCheck);
            WorldHelper.getLoadedBlockEntity(this.level, posToCheck, IControllerBoundable.class).ifPresent(h -> {
                toVerify.remove(posToCheck);
                if (h.canConnectStorages()) {
                    for (Direction dir : Direction.values()) {
                        BlockPos pos = posToCheck.offset(dir.getNormal());
                        if (positionsChecked.contains(pos) || !toVerify.contains(pos)) continue;
                        positionsToCheck.add(pos);
                    }
                }
            });
        }
    }

    private void removeBaseIndexAt(int idx) {
        if (idx >= this.baseIndexes.size()) {
            return;
        }
        int slotsRemoved = this.getStorageSlots(idx);
        this.baseIndexes.remove(idx);
        for (int i = idx; i < this.baseIndexes.size(); ++i) {
            this.baseIndexes.set(i, this.baseIndexes.get(i) - slotsRemoved);
        }
    }

    protected ControllerBlockEntityBase(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
    }

    public int getSlots() {
        return this.totalSlots;
    }

    private int getIndexForSlot(int slot) {
        if (slot < 0) {
            return -1;
        }
        for (int i = 0; i < this.baseIndexes.size(); ++i) {
            if (slot - this.baseIndexes.get(i) >= 0) continue;
            return i;
        }
        return -1;
    }

    protected IItemHandlerModifiable getHandlerFromIndex(int index) {
        IItemHandlerModifiable handler;
        if (index < 0 || index >= this.storagePositions.size()) {
            return (IItemHandlerModifiable)EmptyItemHandler.INSTANCE;
        }
        if (index >= this.cachedHandlers.length) {
            this.cachedHandlers = Arrays.copyOf(this.cachedHandlers, index + 1);
        }
        if (this.cachedHandlers[index] != null && (handler = (IItemHandlerModifiable)this.cachedHandlers[index].get()) != null) {
            return handler;
        }
        handler = this.getWrapperValueFromHolder(this.storagePositions.get(index), wrapper -> wrapper.getInventoryForInputOutput()).orElse((IItemHandlerModifiable)EmptyItemHandler.INSTANCE);
        this.cachedHandlers[index] = new WeakReference<IItemHandlerModifiable>(handler);
        return handler;
    }

    protected int getSlotFromIndex(int slot, int index) {
        if (index <= 0 || index >= this.baseIndexes.size()) {
            return slot;
        }
        return slot - this.baseIndexes.get(index - 1);
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        if (this.isSlotIndexInvalid(slot)) {
            return ItemStack.EMPTY;
        }
        int handlerIndex = this.getIndexForSlot(slot);
        IItemHandlerModifiable handler = this.getHandlerFromIndex(handlerIndex);
        if (this.validateHandlerSlotIndex((IItemHandler)handler, handlerIndex, slot = this.getSlotFromIndex(slot, handlerIndex), "getStackInSlot")) {
            return handler.getStackInSlot(slot);
        }
        return ItemStack.EMPTY;
    }

    private boolean isSlotIndexInvalid(int slot) {
        return slot < 0 || slot >= this.totalSlots;
    }

    private boolean validateHandlerSlotIndex(IItemHandler handler, int handlerIndex, int slot, String methodName) {
        if (slot >= 0 && slot < handler.getSlots()) {
            return true;
        }
        if (handlerIndex < 0 || handlerIndex >= this.storagePositions.size()) {
            SophisticatedCore.LOGGER.debug("Invalid handler index calculated {} in controller's {} method. If you see many of these messages try replacing controller at {}", new Supplier[]{() -> handlerIndex, () -> methodName, () -> this.getBlockPos().toShortString()});
        } else {
            SophisticatedCore.LOGGER.debug("Invalid slot {} passed into controller's {} method for storage at {}. If you see many of these messages try replacing controller at {}", new Supplier[]{() -> slot, () -> methodName, () -> this.storagePositions.get(handlerIndex).toShortString(), () -> this.getBlockPos().toShortString()});
        }
        return false;
    }

    @Nonnull
    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        int handlerIndex;
        IItemHandlerModifiable handler;
        if (this.isSlotIndexInvalid(slot)) {
            return stack;
        }
        if (simulate && this.validateHandlerSlotIndex((IItemHandler)(handler = this.getHandlerFromIndex(handlerIndex = this.getIndexForSlot(slot))), handlerIndex, slot = this.getSlotFromIndex(slot, handlerIndex), "insertItem")) {
            return handler.insertItem(slot, stack, true);
        }
        return this.insertItem(stack, simulate, true);
    }

    @Override
    public ItemStack insertItem(ItemStack stack, boolean simulate) {
        return this.insertItem(stack, simulate, true);
    }

    protected ItemStack insertItem(ItemStack stack, boolean simulate, boolean insertIntoAnyEmpty) {
        ItemStackKey stackKey = ItemStackKey.of(stack);
        ItemStack remaining = stack;
        if ((remaining = this.insertIntoStoragesThatMatchStack(remaining, stackKey, simulate)).isEmpty()) {
            return remaining;
        }
        int stackHash = stackKey.hashCode();
        if (this.memorizedStackStorages.containsKey(stackHash) && (remaining = this.insertIntoStorages(this.memorizedStackStorages.get(stackHash), remaining, simulate, false)).isEmpty()) {
            return remaining;
        }
        if ((remaining = this.insertIntoStoragesThatMatchItem(remaining, simulate)).isEmpty()) {
            return remaining;
        }
        if (this.memorizedItemStorages.containsKey(stack.getItem()) && (remaining = this.insertIntoStorages(this.memorizedItemStorages.get(stack.getItem()), remaining, simulate, false)).isEmpty()) {
            return remaining;
        }
        if (this.filterItemStorages.containsKey(stack.getItem()) && (remaining = this.insertIntoStorages(this.filterItemStorages.get(stack.getItem()), remaining, simulate, false)).isEmpty()) {
            return remaining;
        }
        return insertIntoAnyEmpty ? this.insertIntoStorages(this.emptySlotsStorages, remaining, simulate, false) : remaining;
    }

    private ItemStack insertIntoStoragesThatMatchStack(ItemStack remaining, ItemStackKey stackKey, boolean simulate) {
        if (this.stackStorages.containsKey(stackKey)) {
            Set<BlockPos> positions = this.stackStorages.get(stackKey);
            remaining = this.insertIntoStorages(positions, remaining, simulate, false);
        }
        return remaining;
    }

    private ItemStack insertIntoStoragesThatMatchItem(ItemStack remaining, boolean simulate) {
        if (!this.emptySlotsStorages.isEmpty() && this.itemStackKeys.containsKey(remaining.getItem())) {
            Set<ItemStackKey> matchingStackKeys = this.itemStackKeys.get(remaining.getItem());
            if (remaining.getCount() > remaining.getMaxStackSize()) {
                matchingStackKeys = new LinkedHashSet<ItemStackKey>(matchingStackKeys);
            }
            for (ItemStackKey key : matchingStackKeys) {
                Set<BlockPos> positions;
                if (!this.stackStorages.containsKey(key) || !(remaining = this.insertIntoStorages(positions = this.stackStorages.get(key), remaining, simulate, true)).isEmpty()) continue;
                return ItemStack.EMPTY;
            }
        }
        return remaining;
    }

    private ItemStack insertIntoStorages(Set<BlockPos> positions, ItemStack stack, boolean simulate, boolean checkHasEmptySlotFirst) {
        ItemStack remaining = stack;
        LinkedHashSet<BlockPos> positionsCopy = new LinkedHashSet<BlockPos>(positions);
        for (BlockPos storagePos : positionsCopy) {
            if (checkHasEmptySlotFirst && !this.emptySlotsStorages.contains(storagePos) || !(remaining = this.insertIntoStorage(storagePos, remaining, simulate)).isEmpty()) continue;
            return ItemStack.EMPTY;
        }
        return remaining;
    }

    protected ItemStack insertIntoStorage(BlockPos storagePos, ItemStack remaining, boolean simulate) {
        Integer idx = this.storagePositionIndexes.get(storagePos);
        if (idx == null) {
            return remaining;
        }
        IItemHandlerModifiable handler = this.getHandlerFromIndex(idx);
        if (handler instanceof IItemHandlerSimpleInserter) {
            IItemHandlerSimpleInserter simpleInserter = (IItemHandlerSimpleInserter)handler;
            return simpleInserter.insertItem(remaining, simulate);
        }
        return remaining;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.isSlotIndexInvalid(slot)) {
            return ItemStack.EMPTY;
        }
        int handlerIndex = this.getIndexForSlot(slot);
        IItemHandlerModifiable handler = this.getHandlerFromIndex(handlerIndex);
        if (this.validateHandlerSlotIndex((IItemHandler)handler, handlerIndex, slot = this.getSlotFromIndex(slot, handlerIndex), "extractItem(int slot, int amount, boolean simulate)")) {
            return handler.extractItem(slot, amount, simulate);
        }
        return ItemStack.EMPTY;
    }

    public int getSlotLimit(int slot) {
        int localSlot;
        if (this.isSlotIndexInvalid(slot)) {
            return 0;
        }
        int handlerIndex = this.getIndexForSlot(slot);
        IItemHandlerModifiable handler = this.getHandlerFromIndex(handlerIndex);
        if (this.validateHandlerSlotIndex((IItemHandler)handler, handlerIndex, localSlot = this.getSlotFromIndex(slot, handlerIndex), "getSlotLimit(int slot)")) {
            return handler.getSlotLimit(localSlot);
        }
        return 0;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        int localSlot;
        if (this.isSlotIndexInvalid(slot)) {
            return false;
        }
        int handlerIndex = this.getIndexForSlot(slot);
        IItemHandlerModifiable handler = this.getHandlerFromIndex(handlerIndex);
        if (this.validateHandlerSlotIndex((IItemHandler)handler, handlerIndex, localSlot = this.getSlotFromIndex(slot, handlerIndex), "isItemValid(int slot, ItemStack stack)")) {
            return handler.isItemValid(localSlot, stack);
        }
        return false;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        if (this.isSlotIndexInvalid(slot)) {
            return;
        }
        int handlerIndex = this.getIndexForSlot(slot);
        IItemHandlerModifiable handler = this.getHandlerFromIndex(handlerIndex);
        if (this.validateHandlerSlotIndex((IItemHandler)handler, handlerIndex, slot = this.getSlotFromIndex(slot, handlerIndex), "setStackInSlot(int slot, ItemStack stack)")) {
            handler.setStackInSlot(slot, stack);
        }
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.detachFromStoragesAndUnlinkBlocks();
    }

    public void detachFromStoragesAndUnlinkBlocks() {
        this.storagePositions.forEach(pos -> WorldHelper.getLoadedBlockEntity(this.level, pos, IControllableStorage.class).ifPresent(IControllableStorage::unregisterController));
        this.connectingBlocks.forEach(pos -> WorldHelper.getLoadedBlockEntity(this.level, pos, IControllerBoundable.class).ifPresent(IControllerBoundable::unregisterController));
        this.nonConnectingBlocks.forEach(pos -> WorldHelper.getLoadedBlockEntity(this.level, pos, IControllerBoundable.class).ifPresent(IControllerBoundable::unregisterController));
        new HashSet<BlockPos>(this.linkedBlocks).forEach(linkedPos -> WorldHelper.getLoadedBlockEntity(this.level, linkedPos, ILinkable.class).ifPresent(ILinkable::unlinkFromController));
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        this.saveData(tag);
    }

    private CompoundTag saveData(CompoundTag tag) {
        NBTHelper.putList(tag, "storagePositions", this.storagePositions, p -> LongTag.valueOf((long)p.asLong()));
        NBTHelper.putList(tag, "connectingBlocks", this.connectingBlocks, p -> LongTag.valueOf((long)p.asLong()));
        NBTHelper.putList(tag, "nonConnectingBlocks", this.nonConnectingBlocks, p -> LongTag.valueOf((long)p.asLong()));
        NBTHelper.putList(tag, "linkedBlocks", this.linkedBlocks, p -> LongTag.valueOf((long)p.asLong()));
        NBTHelper.putList(tag, "baseIndexes", this.baseIndexes, IntTag::valueOf);
        tag.putInt("totalSlots", this.totalSlots);
        return tag;
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.storagePositions = NBTHelper.getCollection(tag, "storagePositions", (byte)4, t -> Optional.of(BlockPos.of((long)((LongTag)t).getAsLong())), ArrayList::new).orElseGet(ArrayList::new);
        this.setupStoragePositionIndexes();
        this.connectingBlocks = NBTHelper.getCollection(tag, "connectingBlocks", (byte)4, t -> Optional.of(BlockPos.of((long)((LongTag)t).getAsLong())), LinkedHashSet::new).orElseGet(LinkedHashSet::new);
        this.nonConnectingBlocks = NBTHelper.getCollection(tag, "nonConnectingBlocks", (byte)4, t -> Optional.of(BlockPos.of((long)((LongTag)t).getAsLong())), LinkedHashSet::new).orElseGet(LinkedHashSet::new);
        this.baseIndexes = NBTHelper.getCollection(tag, "baseIndexes", (byte)3, t -> Optional.of(((IntTag)t).getAsInt()), ArrayList::new).orElseGet(ArrayList::new);
        this.totalSlots = tag.getInt("totalSlots");
        this.linkedBlocks = NBTHelper.getCollection(tag, "linkedBlocks", (byte)4, t -> Optional.of(BlockPos.of((long)((LongTag)t).getAsLong())), LinkedHashSet::new).orElseGet(LinkedHashSet::new);
    }

    private void setupStoragePositionIndexes() {
        this.storagePositionIndexes.clear();
        for (int i = 0; i < this.storagePositions.size(); ++i) {
            this.storagePositionIndexes.put(this.storagePositions.get(i), i);
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveData(super.getUpdateTag(registries));
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void addStorageWithEmptySlots(BlockPos storageBlockPos) {
        this.emptySlotsStorages.add(storageBlockPos);
    }

    public void removeStorageWithEmptySlots(BlockPos storageBlockPos) {
        this.emptySlotsStorages.remove(storageBlockPos);
    }

    public Set<BlockPos> getLinkedBlocks() {
        return this.linkedBlocks;
    }

    public List<BlockPos> getStoragePositions() {
        return this.storagePositions;
    }

    public void setStorageFilterItems(BlockPos storagePos, Set<Item> filterItems) {
        this.removeStorageFilterItems(storagePos);
        if (filterItems.isEmpty()) {
            return;
        }
        for (Item item : filterItems) {
            this.filterItemStorages.computeIfAbsent(item, stackKey -> new LinkedHashSet()).add(storagePos);
        }
        this.storageFilterItems.put(storagePos, new LinkedHashSet<Item>(filterItems));
    }

    public boolean hasMatchingStackOrItem(ItemStackKey stackKey) {
        Item item = stackKey.getStack().getItem();
        return this.stackStorages.containsKey(stackKey) || this.itemStackKeys.containsKey(item) || this.memorizedStackStorages.containsKey(stackKey.hashCode()) || this.memorizedItemStorages.containsKey(item) || this.filterItemStorages.containsKey(item);
    }

    @Override
    public boolean isInsertBlocked() {
        return this.storagePositions.stream().allMatch(pos -> this.getWrapperValueFromHolder((BlockPos)pos, storageWrapper -> storageWrapper.getInventoryHandler().isInsertBlocked()).orElse(true));
    }
}

