/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.inventory;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.ITrackedContentsItemHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.upgrades.FilterLogic;

public class FilteredItemHandler<T extends IItemHandler>
implements IItemHandler {
    protected final T inventoryHandler;
    protected final List<FilterLogic> inputFilters;
    private final List<FilterLogic> outputFilters;

    public FilteredItemHandler(T inventoryHandler, List<FilterLogic> inputFilters, List<FilterLogic> outputFilters) {
        this.inventoryHandler = inventoryHandler;
        this.inputFilters = inputFilters;
        this.outputFilters = outputFilters;
    }

    public int getSlots() {
        return this.inventoryHandler.getSlots();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return this.inventoryHandler.getStackInSlot(slot);
    }

    @Nonnull
    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (this.inputFilters.isEmpty()) {
            return this.inventoryHandler.insertItem(slot, stack, simulate);
        }
        if (this.matchesFilters(stack, this.inputFilters)) {
            return this.inventoryHandler.insertItem(slot, stack, simulate);
        }
        return stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.outputFilters.isEmpty()) {
            return this.inventoryHandler.extractItem(slot, amount, simulate);
        }
        if (this.matchesFilters(this.getStackInSlot(slot), this.outputFilters)) {
            return this.inventoryHandler.extractItem(slot, amount, simulate);
        }
        return ItemStack.EMPTY;
    }

    protected boolean matchesFilters(ItemStack stack, List<FilterLogic> filters) {
        boolean matchAll = this.shouldMatchAllFilters(filters);
        for (FilterLogic filter : filters) {
            if (matchAll && !filter.matchesFilter(stack)) {
                return false;
            }
            if (matchAll || !filter.matchesFilter(stack)) continue;
            return true;
        }
        return matchAll;
    }

    private boolean shouldMatchAllFilters(List<FilterLogic> filters) {
        if (filters.size() < 2) {
            return false;
        }
        for (FilterLogic filter : filters) {
            if (filter.isAllowList()) continue;
            return true;
        }
        return false;
    }

    public int getSlotLimit(int slot) {
        return this.inventoryHandler.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        if (this.matchesFilters(stack, this.inputFilters)) {
            return this.inventoryHandler.isItemValid(slot, stack);
        }
        return false;
    }

    public static class Modifiable
    extends FilteredItemHandler<ITrackedContentsItemHandler>
    implements ITrackedContentsItemHandler {
        public Modifiable(ITrackedContentsItemHandler inventoryHandler, List<FilterLogic> inputFilters, List<FilterLogic> outputFilters) {
            super(inventoryHandler, inputFilters, outputFilters);
        }

        public void setStackInSlot(int slot, ItemStack stack) {
            ((ITrackedContentsItemHandler)this.inventoryHandler).setStackInSlot(slot, stack);
        }

        @Override
        public ItemStack insertItem(ItemStack stack, boolean simulate) {
            if (this.inputFilters.isEmpty()) {
                return ((ITrackedContentsItemHandler)this.inventoryHandler).insertItem(stack, simulate);
            }
            if (this.matchesFilters(stack, this.inputFilters)) {
                return ((ITrackedContentsItemHandler)this.inventoryHandler).insertItem(stack, simulate);
            }
            return stack;
        }

        @Override
        public Set<ItemStackKey> getTrackedStacks() {
            HashSet<ItemStackKey> ret = new HashSet<ItemStackKey>();
            ((ITrackedContentsItemHandler)this.inventoryHandler).getTrackedStacks().forEach(ts -> {
                if (this.matchesFilters(ts.stack(), this.inputFilters)) {
                    ret.add((ItemStackKey)ts);
                }
            });
            return ret;
        }

        @Override
        public void registerTrackingListeners(Consumer<ItemStackKey> onAddStackKey, Consumer<ItemStackKey> onRemoveStackKey, Runnable onAddFirstEmptySlot, Runnable onRemoveLastEmptySlot) {
            ((ITrackedContentsItemHandler)this.inventoryHandler).registerTrackingListeners(isk -> {
                if (this.matchesFilters(isk.stack(), this.inputFilters)) {
                    onAddStackKey.accept((ItemStackKey)isk);
                }
            }, isk -> {
                if (this.matchesFilters(isk.stack(), this.inputFilters)) {
                    onRemoveStackKey.accept((ItemStackKey)isk);
                }
            }, onAddFirstEmptySlot, onRemoveLastEmptySlot);
        }

        @Override
        public void unregisterStackKeyListeners() {
            ((ITrackedContentsItemHandler)this.inventoryHandler).unregisterStackKeyListeners();
        }

        @Override
        public boolean hasEmptySlots() {
            return ((ITrackedContentsItemHandler)this.inventoryHandler).hasEmptySlots();
        }

        @Override
        public boolean isInsertBlocked() {
            return ((ITrackedContentsItemHandler)this.inventoryHandler).isInsertBlocked();
        }
    }
}

