/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.client.screen;

import jagm.classicpipes.client.screen.RequestAmountScreen;
import jagm.classicpipes.client.screen.widget.PageButton;
import jagm.classicpipes.inventory.menu.RequestMenu;
import jagm.classicpipes.network.ServerBoundRequestPayload;
import jagm.classicpipes.services.Services;
import jagm.classicpipes.util.MiscUtil;
import jagm.classicpipes.util.SortingMode;
import java.util.Iterator;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class RequestScreen
extends AbstractContainerScreen<RequestMenu> {
    private static final ResourceLocation BACKGROUND = MiscUtil.resourceLocation("textures/gui/container/request.png");
    private static final WidgetSprites X_BUTTON = new WidgetSprites(MiscUtil.resourceLocation("widget/x"), MiscUtil.resourceLocation("widget/x_hovered"));
    private EditBox searchBar;
    private PageButton prev_page;
    private PageButton next_page;
    private Button sort_type;
    private Button sort_direction;
    private boolean refocus;

    public RequestScreen(RequestMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageHeight = 222;
        this.refocus = false;
    }

    protected void init() {
        super.init();
        this.searchBar = new EditBox(this.font, this.leftPos + 21, this.topPos + 22, 146, 12, (Component)Component.translatable((String)"container.classicpipes.search"));
        this.searchBar.setCanLoseFocus(true);
        this.searchBar.setMaxLength(32);
        this.searchBar.setValue(((RequestMenu)this.menu).getSearch());
        this.searchBar.setTextColor(-1);
        this.searchBar.setTextColorUneditable(-1);
        this.searchBar.setBordered(false);
        this.searchBar.setResponder(((RequestMenu)this.menu)::setSearch);
        this.searchBar.setEditable(true);
        this.prev_page = new PageButton(this.width / 2 - 48 - 8, this.topPos + 180, true, false, button -> this.changePage(-1));
        this.next_page = new PageButton(this.width / 2 + 48, this.topPos + 180, false, ((RequestMenu)this.menu).getMaxPage() > 0, button -> this.changePage(1));
        this.sort_type = Button.builder((Component)((RequestMenu)this.menu).getSortingMode().getType(), this::changeSortType).bounds(this.width / 2 - 25, this.topPos + 198, 50, 16).build();
        this.sort_direction = Button.builder((Component)((RequestMenu)this.menu).getSortingMode().getDirection(), this::changeSortDirection).bounds(this.width / 2 + 27, this.topPos + 198, 50, 16).build();
        this.addRenderableWidget((GuiEventListener)this.sort_type);
        this.addRenderableWidget((GuiEventListener)this.sort_direction);
        this.addRenderableWidget((GuiEventListener)this.searchBar);
        this.addRenderableWidget((GuiEventListener)this.prev_page);
        this.addRenderableWidget((GuiEventListener)this.next_page);
        this.addRenderableWidget((GuiEventListener)new ImageButton(this.leftPos + this.imageWidth - 12, this.topPos + 5, 7, 7, X_BUTTON, button -> this.onClose()));
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.updatePageButtons();
        super.render(graphics, mouseX, mouseY, partialTicks);
        graphics.pose().pushPose();
        graphics.pose().translate((float)this.leftPos, (float)this.topPos, 0.0f);
        this.hoveredSlot = this.getHoveredSlot(mouseX, mouseY);
        this.renderSlots(graphics);
        if (this.hoveredSlot != null && this.hoveredSlot.isHighlightable()) {
            RequestScreen.renderSlotHighlight((GuiGraphics)graphics, (int)this.hoveredSlot.x, (int)this.hoveredSlot.y, (int)0);
        }
        graphics.pose().popPose();
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    private Slot getHoveredSlot(double mouseX, double mouseY) {
        Slot slot;
        Iterator iterator = ((RequestMenu)this.menu).displaySlots.iterator();
        do {
            if (iterator.hasNext()) continue;
            return null;
        } while (!(slot = (Slot)iterator.next()).isActive() || !this.isHovering(slot.x, slot.y, 16, 16, mouseX, mouseY));
        return slot;
    }

    protected void renderSlots(GuiGraphics graphics) {
        for (Slot slot : ((RequestMenu)this.menu).displaySlots) {
            if (!slot.isActive()) continue;
            this.renderSlot(graphics, slot);
        }
    }

    protected void renderBg(GuiGraphics graphics, float f, int x, int y) {
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        graphics.blit(BACKGROUND, i, j, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, -12566464, false);
        MutableComponent pageIndicator = Component.translatable((String)"widget.classicpipes.page", (Object[])new Object[]{((RequestMenu)this.menu).getPage() + 1, ((RequestMenu)this.menu).getMaxPage() + 1});
        graphics.drawString(this.font, (Component)pageIndicator, (this.imageWidth - this.font.width((FormattedText)pageIndicator)) / 2, 182, -12566464, false);
        MutableComponent sortBy = Component.translatable((String)"widget.classicpipes.sort_by");
        graphics.drawString(this.font, (Component)sortBy, this.imageWidth / 2 - 29 - this.font.width((FormattedText)sortBy), 202, -12566464, false);
    }

    protected void renderSlot(GuiGraphics graphics, Slot slot) {
        ItemStack stack = slot.getItem();
        int seed = slot.x + slot.y * this.imageWidth;
        graphics.renderItem(stack, slot.x, slot.y, seed);
        if (!stack.isEmpty()) {
            this.renderItemBar(graphics, stack, slot.x, slot.y);
            this.renderItemCount(graphics, this.font, stack, slot.x, slot.y, ((RequestMenu)this.menu).itemCraftable(stack));
        }
    }

    private void renderItemBar(GuiGraphics graphics, ItemStack stack, int x, int y) {
        if (stack.isBarVisible()) {
            int i = x + 2;
            int j = y + 13;
            graphics.fill(RenderType.guiOverlay(), i, j, i + 13, j + 2, -16777216);
            graphics.fill(RenderType.guiOverlay(), i, j, i + stack.getBarWidth(), j + 1, stack.getBarColor() | 0xFF000000);
        }
    }

    private void renderItemCount(GuiGraphics graphics, Font font, ItemStack stack, int x, int y, boolean craftable) {
        int count = stack.getCount() - (craftable ? 1 : 0);
        String s = RequestScreen.stringForCount(count);
        int colour = RequestScreen.colourForCount(count);
        float countScale = 1.0f;
        if (this.minecraft != null) {
            int guiScale;
            int numerator = guiScale = (int)this.minecraft.getWindow().getGuiScale();
            while ((float)font.width(s) * countScale > 16.0f && numerator > 1) {
                countScale = (float)(--numerator) / (float)guiScale;
            }
        }
        int slotOffset = countScale == 1.0f ? 17 : 16;
        graphics.pose().pushPose();
        graphics.pose().translate((float)(x + slotOffset), (float)(y + slotOffset), 200.0f);
        graphics.pose().scale(countScale, countScale, 1.0f);
        graphics.drawString(font, s, -font.width(s), -8, colour, true);
        graphics.pose().popPose();
    }

    private static int colourForCount(int count) {
        return count == 0 ? -256 : -1;
    }

    private static String stringForCount(int count) {
        if (count == 0) {
            return "+";
        }
        if (count < 1000) {
            return String.valueOf(count);
        }
        if (count < 10000) {
            return String.format("%.1f", Float.valueOf((float)count / 1000.0f - 0.049f)) + "K";
        }
        if (count < 1000000) {
            return count / 1000 + "K";
        }
        if (count < 10000000) {
            return String.format("%.1f", Float.valueOf((float)count / 1000000.0f - 0.049f)) + "M";
        }
        if (count < 1000000000) {
            return count / 1000000 + "M";
        }
        if (count < Integer.MAX_VALUE) {
            return String.format("%.1f", Float.valueOf((float)count / 1.0E9f - 0.049f)) + "B";
        }
        return "MAX";
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        ItemStack toRequest;
        this.setFocused(null);
        Slot slot = this.getHoveredSlot(mouseX, mouseY);
        if (slot != null && !(toRequest = slot.getItem()).isEmpty()) {
            boolean craftable = ((RequestMenu)this.menu).itemCraftable(toRequest);
            if (RequestScreen.hasShiftDown() || button == 1) {
                int amount;
                int n = RequestScreen.hasShiftDown() ? Math.min(toRequest.getCount() - (craftable ? 1 : 0), toRequest.getMaxStackSize()) : (amount = 1);
                if (amount > 0) {
                    Services.LOADER_SERVICE.sendToServer(new ServerBoundRequestPayload(toRequest.copyWithCount(amount), ((RequestMenu)this.menu).getRequestPos()));
                    toRequest.shrink(amount);
                    ((RequestMenu)this.menu).update();
                }
            } else if (this.minecraft != null) {
                this.minecraft.setScreen((Screen)new RequestAmountScreen(toRequest, this, craftable));
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    protected void setInitialFocus() {
        this.setInitialFocus((GuiEventListener)this.searchBar);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256 && this.minecraft != null && this.minecraft.player != null) {
            this.minecraft.player.closeContainer();
        }
        return this.searchBar.keyPressed(keyCode, scanCode, modifiers) || this.searchBar.canConsumeInput() || super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        ((RequestMenu)this.menu).changePage((int)(-scrollY));
        return true;
    }

    private void changePage(int increment) {
        ((RequestMenu)this.menu).changePage(increment);
        this.refocus = true;
    }

    private void updatePageButtons() {
        this.prev_page.active = ((RequestMenu)this.menu).getPage() > 0;
        boolean bl = this.next_page.active = ((RequestMenu)this.menu).getPage() < ((RequestMenu)this.menu).getMaxPage();
        if (this.refocus) {
            this.setFocused((GuiEventListener)this.searchBar);
            this.refocus = false;
        }
    }

    private void changeSortType(Button button) {
        SortingMode nextMode = RequestScreen.hasShiftDown() ? ((RequestMenu)this.menu).getSortingMode().prevType() : ((RequestMenu)this.menu).getSortingMode().nextType();
        this.sort_type.setMessage(nextMode.getType());
        this.sort_direction.setMessage(nextMode.getDirection());
        ((RequestMenu)this.menu).setSortingMode(nextMode);
        this.refocus = true;
    }

    private void changeSortDirection(Button button) {
        SortingMode nextMode = ((RequestMenu)this.menu).getSortingMode().otherDirection();
        this.sort_type.setMessage(nextMode.getType());
        this.sort_direction.setMessage(nextMode.getDirection());
        ((RequestMenu)this.menu).setSortingMode(nextMode);
        this.refocus = true;
    }
}

