/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.network.impl.node.relay;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.network.storage.StorageNetworkComponent;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.filter.Filter;
import com.refinedmods.refinedstorage.api.resource.filter.FilterMode;
import com.refinedmods.refinedstorage.api.resource.list.MutableResourceList;
import com.refinedmods.refinedstorage.api.storage.AccessMode;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.Storage;
import com.refinedmods.refinedstorage.api.storage.composite.CompositeAwareChild;
import com.refinedmods.refinedstorage.api.storage.composite.ParentComposite;
import com.refinedmods.refinedstorage.api.storage.composite.PriorityProvider;
import com.refinedmods.refinedstorage.api.storage.root.RootStorageListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;

class RelayOutputStorage
implements CompositeAwareChild,
RootStorageListener,
PriorityProvider {
    private final Set<ParentComposite> parentComposites = new HashSet<ParentComposite>();
    private final Filter filter = new Filter();
    @Nullable
    private StorageNetworkComponent delegate;
    private AccessMode accessMode = AccessMode.INSERT_EXTRACT;
    private int insertPriority;
    private int extractPriority;

    RelayOutputStorage() {
    }

    boolean hasDelegate() {
        return this.delegate != null;
    }

    void setAccessMode(AccessMode accessMode) {
        this.accessMode = accessMode;
    }

    void setInsertPriority(int insertPriority) {
        this.insertPriority = insertPriority;
    }

    void setExtractPriority(int extractPriority) {
        this.extractPriority = extractPriority;
    }

    void setFilters(Set<ResourceKey> filters) {
        this.reset(() -> this.filter.setFilters(filters));
    }

    void setFilterMode(FilterMode filterMode) {
        this.reset(() -> this.filter.setMode(filterMode));
    }

    void setFilterNormalizer(UnaryOperator<ResourceKey> normalizer) {
        this.reset(() -> this.filter.setNormalizer(normalizer));
    }

    private void reset(Runnable action) {
        StorageNetworkComponent oldDelegate = this.delegate;
        this.setDelegate(null);
        action.run();
        this.setDelegate(oldDelegate);
    }

    void setDelegate(@Nullable StorageNetworkComponent delegate) {
        if (this.delegate != null) {
            this.parentComposites.forEach(parent -> this.getAll().forEach(resourceAmount -> parent.removeFromCache(resourceAmount.resource(), resourceAmount.amount())));
            this.delegate.removeListener(this);
        }
        this.delegate = delegate;
        if (delegate != null) {
            this.parentComposites.forEach(parent -> this.getAll().forEach(resourceAmount -> parent.addToCache(resourceAmount.resource(), resourceAmount.amount())));
            delegate.addListener(this);
        }
    }

    @Override
    public void onAddedIntoComposite(ParentComposite parentComposite) {
        this.parentComposites.add(parentComposite);
    }

    @Override
    public void onRemovedFromComposite(ParentComposite parentComposite) {
        this.parentComposites.remove(parentComposite);
    }

    @Override
    public boolean contains(Storage storage) {
        return storage == this.delegate || this.delegate != null && this.delegate.contains(storage);
    }

    @Override
    public CompositeAwareChild.Amount compositeInsert(ResourceKey resource, long amount, Action action, Actor actor) {
        if (this.delegate == null || this.accessMode == AccessMode.EXTRACT || this.delegate.contains(this.delegate) || !this.filter.isAllowed(resource)) {
            return CompositeAwareChild.Amount.ZERO;
        }
        long inserted = this.delegate.insert(resource, amount, action, actor);
        return new CompositeAwareChild.Amount(inserted, 0L);
    }

    @Override
    public CompositeAwareChild.Amount compositeExtract(ResourceKey resource, long amount, Action action, Actor actor) {
        if (this.delegate == null || this.accessMode == AccessMode.INSERT || this.delegate.contains(this.delegate) || !this.filter.isAllowed(resource)) {
            return CompositeAwareChild.Amount.ZERO;
        }
        long extracted = this.delegate.extract(resource, amount, action, actor);
        return new CompositeAwareChild.Amount(extracted, 0L);
    }

    @Override
    public long extract(ResourceKey resource, long amount, Action action, Actor actor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long insert(ResourceKey resource, long amount, Action action, Actor actor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<ResourceAmount> getAll() {
        if (this.delegate == null || this.delegate.contains(this.delegate)) {
            return Collections.emptyList();
        }
        return this.delegate.getAll().stream().filter(resourceAmount -> this.filter.isAllowed(resourceAmount.resource())).toList();
    }

    @Override
    public long getStored() {
        if (this.delegate == null || this.delegate.contains(this.delegate)) {
            return 0L;
        }
        return this.delegate.getAll().stream().filter(resourceAmount -> this.filter.isAllowed(resourceAmount.resource())).mapToLong(ResourceAmount::amount).sum();
    }

    @Override
    public void changed(MutableResourceList.OperationResult change) {
        if (this.delegate != null && this.delegate.contains(this.delegate)) {
            return;
        }
        ResourceKey resource = change.resource();
        if (!this.filter.isAllowed(resource)) {
            return;
        }
        if (change.change() > 0L) {
            this.parentComposites.forEach(parent -> parent.addToCache(resource, change.change()));
        } else {
            this.parentComposites.forEach(parent -> parent.removeFromCache(resource, -change.change()));
        }
    }

    @Override
    public int getInsertPriority() {
        return this.insertPriority;
    }

    @Override
    public int getExtractPriority() {
        return this.extractPriority;
    }
}

