/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.storage.portablegrid;

import com.refinedmods.refinedstorage.api.network.energy.EnergyStorage;
import com.refinedmods.refinedstorage.common.api.grid.Grid;
import com.refinedmods.refinedstorage.common.api.support.slotreference.SlotReference;
import com.refinedmods.refinedstorage.common.grid.GridData;
import com.refinedmods.refinedstorage.common.grid.PortableGridData;
import com.refinedmods.refinedstorage.common.storage.DiskInventory;
import com.refinedmods.refinedstorage.common.storage.portablegrid.PortableGridItemContainerMenu;
import com.refinedmods.refinedstorage.common.support.containermenu.ExtendedMenuProvider;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

class PortableGridItemExtendedMenuProvider
implements ExtendedMenuProvider<PortableGridData> {
    private final Component name;
    private final Grid grid;
    private final EnergyStorage energyStorage;
    private final DiskInventory diskInventory;
    private final SlotReference slotReference;

    PortableGridItemExtendedMenuProvider(Component name, Grid grid, EnergyStorage energyStorage, DiskInventory diskInventory, SlotReference slotReference) {
        this.name = name;
        this.grid = grid;
        this.energyStorage = energyStorage;
        this.diskInventory = diskInventory;
        this.slotReference = slotReference;
    }

    @Override
    public PortableGridData getMenuData() {
        return new PortableGridData(GridData.of(this.grid), this.energyStorage.getStored(), this.energyStorage.getCapacity(), Optional.of(this.slotReference));
    }

    @Override
    public StreamEncoder<RegistryFriendlyByteBuf, PortableGridData> getMenuCodec() {
        return PortableGridData.STREAM_CODEC;
    }

    public Component getDisplayName() {
        return this.name;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory inventory, Player player) {
        return new PortableGridItemContainerMenu(syncId, inventory, this.diskInventory, this.grid, this.energyStorage, this.slotReference);
    }
}

