/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support;

import com.refinedmods.refinedstorage.common.support.AbstractBaseBlock;
import com.refinedmods.refinedstorage.common.support.direction.DirectionType;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class AbstractDirectionalBlock<T extends Enum<T>>
extends AbstractBaseBlock {
    protected AbstractDirectionalBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected abstract DirectionType<T> getDirectionType();

    @Override
    protected BlockState getDefaultState() {
        return (BlockState)super.getDefaultState().setValue(this.getDirectionType().getProperty(), this.getDirectionType().getDefault());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{this.getDirectionType().getProperty()});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockState state = this.defaultBlockState();
        return (BlockState)state.setValue(this.getDirectionType().getProperty(), this.getDirectionType().getDirection(ctx.getClickedFace(), ctx.getHorizontalDirection(), ctx.getPlayer() != null ? ctx.getPlayer().getXRot() : 0.0f));
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        EnumProperty<T> directionProperty = this.getDirectionType().getProperty();
        Enum currentDirection = (Enum)((Object)state.getValue(directionProperty));
        return (BlockState)state.setValue(directionProperty, (Comparable)((Object)this.getDirectionType().rotate(currentDirection)));
    }

    @Nullable
    public T getDirection(@Nullable BlockState state) {
        EnumProperty<T> directionProperty = this.getDirectionType().getProperty();
        return (T)(state != null && state.hasProperty(directionProperty) ? (Enum)((Object)state.getValue(directionProperty)) : null);
    }

    @Nullable
    public Direction extractDirection(@Nullable BlockState state) {
        T direction = this.getDirection(state);
        if (direction == null) {
            return null;
        }
        return this.getDirectionType().extractDirection(direction);
    }

    public BlockState rotated(T direction) {
        return (BlockState)this.defaultBlockState().setValue(this.getDirectionType().getProperty(), direction);
    }

    public static boolean didDirectionChange(BlockState oldBlockState, BlockState newBlockState) {
        Block block = newBlockState.getBlock();
        if (!(block instanceof AbstractDirectionalBlock)) {
            return true;
        }
        AbstractDirectionalBlock newDirectionalBlock = (AbstractDirectionalBlock)block;
        Block block2 = oldBlockState.getBlock();
        if (!(block2 instanceof AbstractDirectionalBlock)) {
            return true;
        }
        AbstractDirectionalBlock oldDirectionalBlock = (AbstractDirectionalBlock)block2;
        return !Objects.equals(oldDirectionalBlock.getDirection(oldBlockState), newDirectionalBlock.getDirection(newBlockState));
    }

    @Nullable
    public static Direction tryExtractDirection(BlockState blockState) {
        Block block = blockState.getBlock();
        if (!(block instanceof AbstractDirectionalBlock)) {
            return null;
        }
        AbstractDirectionalBlock directionalBlock = (AbstractDirectionalBlock)block;
        return directionalBlock.extractDirection(blockState);
    }
}

