/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support;

import com.refinedmods.refinedstorage.common.support.PlayerInventoryListener;
import javax.annotation.Nullable;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

class PlayerInventorySlot
extends Slot {
    @Nullable
    private final PlayerInventoryListener listener;

    PlayerInventorySlot(Container container, int slot, int x, int y, @Nullable PlayerInventoryListener listener) {
        super(container, slot, x, y);
        this.listener = listener;
    }

    public void set(ItemStack stack) {
        if (this.listener != null) {
            this.listener.changed(this.getItem(), stack);
        }
        super.set(stack);
    }

    public ItemStack remove(int amount) {
        if (this.listener != null) {
            ItemStack before = this.getItem().copy();
            ItemStack result = super.remove(amount);
            this.listener.changed(before, this.getItem());
            return result;
        }
        return super.remove(amount);
    }
}

