/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.upgrade;

import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.upgrade.AbstractUpgradeItem;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeRegistry;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.function.LongSupplier;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public final class SimpleUpgradeItem
extends AbstractUpgradeItem {
    private final LongSupplier energyUsageResolver;
    private final boolean foil;

    private SimpleUpgradeItem(UpgradeRegistry registry, LongSupplier energyUsageResolver, boolean foil, Component helpText) {
        super(new Item.Properties(), registry, helpText);
        this.energyUsageResolver = energyUsageResolver;
        this.foil = foil;
    }

    @Override
    public long getEnergyUsage() {
        return this.energyUsageResolver.getAsLong();
    }

    public boolean isFoil(ItemStack stack) {
        return this.foil;
    }

    public static SimpleUpgradeItem speedUpgrade() {
        return new SimpleUpgradeItem(RefinedStorageApi.INSTANCE.getUpgradeRegistry(), Platform.INSTANCE.getConfig().getUpgrade()::getSpeedUpgradeEnergyUsage, false, (Component)IdentifierUtil.createTranslation("item", "speed_upgrade.help"));
    }

    public static SimpleUpgradeItem stackUpgrade() {
        return new SimpleUpgradeItem(RefinedStorageApi.INSTANCE.getUpgradeRegistry(), Platform.INSTANCE.getConfig().getUpgrade()::getStackUpgradeEnergyUsage, false, (Component)IdentifierUtil.createTranslation("item", "stack_upgrade.help"));
    }

    public static SimpleUpgradeItem silkTouchUpgrade() {
        return new SimpleUpgradeItem(RefinedStorageApi.INSTANCE.getUpgradeRegistry(), Platform.INSTANCE.getConfig().getUpgrade()::getSilkTouchUpgradeEnergyUsage, true, (Component)IdentifierUtil.createTranslation("item", "silk_touch_upgrade.help"));
    }

    public static SimpleUpgradeItem autocraftingUpgrade() {
        return new SimpleUpgradeItem(RefinedStorageApi.INSTANCE.getUpgradeRegistry(), Platform.INSTANCE.getConfig().getUpgrade()::getAutocraftingUpgradeEnergyUsage, false, (Component)IdentifierUtil.createTranslation("item", "autocrafting_upgrade.help"));
    }
}

