/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.neoforge.autocrafting;

import com.refinedmods.refinedstorage.api.autocrafting.task.ExternalPatternSink;
import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.autocrafting.PlatformPatternProviderExternalPatternSink;
import com.refinedmods.refinedstorage.common.support.resource.FluidResource;
import com.refinedmods.refinedstorage.neoforge.storage.CapabilityCache;
import com.refinedmods.refinedstorage.neoforge.support.resource.VariantUtil;
import java.util.Collection;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FluidHandlerExternalPatternProviderSink
implements PlatformPatternProviderExternalPatternSink {
    private static final Logger LOGGER = LoggerFactory.getLogger(FluidHandlerExternalPatternProviderSink.class);
    private final CapabilityCache capabilityCache;

    FluidHandlerExternalPatternProviderSink(CapabilityCache capabilityCache) {
        this.capabilityCache = capabilityCache;
    }

    @Override
    public ExternalPatternSink.Result accept(Collection<ResourceAmount> resources, Action action) {
        return this.capabilityCache.getFluidHandler().map(handler -> this.accept(resources, action, (IFluidHandler)handler)).orElse(ExternalPatternSink.Result.SKIPPED);
    }

    private ExternalPatternSink.Result accept(Collection<ResourceAmount> resources, Action action, IFluidHandler handler) {
        for (ResourceAmount resource : resources) {
            ResourceKey resourceKey = resource.resource();
            if (!(resourceKey instanceof FluidResource)) continue;
            FluidResource fluidResource = (FluidResource)resourceKey;
            if (this.accept(action, handler, resource.amount(), fluidResource)) continue;
            return ExternalPatternSink.Result.REJECTED;
        }
        return ExternalPatternSink.Result.ACCEPTED;
    }

    private boolean accept(Action action, IFluidHandler handler, long amount, FluidResource fluidResource) {
        FluidStack fluidStack = VariantUtil.toFluidStack(fluidResource, amount);
        int filled = handler.fill(fluidStack, action == Action.SIMULATE ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE);
        if (filled != fluidStack.getAmount()) {
            if (action == Action.EXECUTE) {
                LOGGER.warn("{} unexpectedly didn't accept all of {}, the remainder has been voided", (Object)handler, (Object)fluidStack);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.capabilityCache.getFluidHandler().map(handler -> {
            for (int i = 0; i < handler.getTanks(); ++i) {
                if (handler.getFluidInTank(i).isEmpty()) continue;
                return false;
            }
            return true;
        }).orElse(true);
    }

    @Override
    public boolean applies(ResourceKey resource) {
        return resource instanceof FluidResource;
    }
}

