/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.query.lexer;

import com.refinedmods.refinedstorage.query.lexer.LexerPosition;
import com.refinedmods.refinedstorage.query.lexer.LexerTokenMapping;
import com.refinedmods.refinedstorage.query.lexer.Source;
import com.refinedmods.refinedstorage.query.lexer.TokenType;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nullable;

public class LexerTokenMappings {
    public static final LexerTokenMappings DEFAULT_MAPPINGS = new LexerTokenMappings().addMapping(new LexerTokenMapping("!", TokenType.UNARY_OP)).addMapping(new LexerTokenMapping("@", TokenType.UNARY_OP)).addMapping(new LexerTokenMapping("$", TokenType.UNARY_OP)).addMapping(new LexerTokenMapping("#", TokenType.UNARY_OP)).addMapping(new LexerTokenMapping(">", TokenType.UNARY_OP)).addMapping(new LexerTokenMapping(">=", TokenType.UNARY_OP)).addMapping(new LexerTokenMapping("<", TokenType.UNARY_OP)).addMapping(new LexerTokenMapping("<=", TokenType.UNARY_OP)).addMapping(new LexerTokenMapping("=", TokenType.UNARY_OP)).addMapping(new LexerTokenMapping("&&", TokenType.BIN_OP)).addMapping(new LexerTokenMapping("||", TokenType.BIN_OP)).addMapping(new LexerTokenMapping("(", TokenType.PAREN_OPEN)).addMapping(new LexerTokenMapping(")", TokenType.PAREN_CLOSE));
    private final Set<LexerTokenMapping> mappings = new TreeSet<LexerTokenMapping>((a, b) -> {
        int cmp = Integer.compare(b.value().length(), a.value().length());
        if (cmp == 0) {
            return b.value().compareTo(a.value());
        }
        return cmp;
    });

    public LexerTokenMappings addMapping(LexerTokenMapping mapping) {
        this.mappings.add(mapping);
        return this;
    }

    public boolean hasMapping(LexerPosition position, Source source) {
        return this.findMapping(position, source) != null;
    }

    @Nullable
    public LexerTokenMapping findMapping(LexerPosition position, Source source) {
        for (LexerTokenMapping mapping : this.mappings) {
            String sourceContent;
            boolean sourceContainsMapping;
            String content = mapping.value();
            int contentLength = mapping.value().length();
            boolean mappingIsInBounds = position.getEndIndex() + contentLength <= source.content().length();
            if (!mappingIsInBounds || !(sourceContainsMapping = content.equals(sourceContent = source.content().substring(position.getEndIndex(), position.getEndIndex() + contentLength)))) continue;
            return mapping;
        }
        return null;
    }
}

