/*
 * Decompiled with CFR 0.152.
 */
package io.github.irishgreencitrus.occultengineering.content.block.pentacle_altar;

import com.simibubi.create.foundation.gui.menu.MenuBase;
import io.github.irishgreencitrus.occultengineering.content.block.pentacle_altar.PentacleAltarBlockEntity;
import io.github.irishgreencitrus.occultengineering.registry.OccultEngineeringItems;
import io.github.irishgreencitrus.occultengineering.registry.OccultEngineeringMenuTypes;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class PentacleAltarMenu
extends MenuBase<PentacleAltarBlockEntity> {
    private Slot inputSlot;
    private Slot outputSlot;

    public PentacleAltarMenu(MenuType<?> type, int id, Inventory inv, RegistryFriendlyByteBuf extraData) {
        super(type, id, inv, extraData);
    }

    public PentacleAltarMenu(MenuType<?> type, int id, Inventory inv, PentacleAltarBlockEntity contentHolder) {
        super(type, id, inv, (Object)contentHolder);
    }

    public static PentacleAltarMenu create(int id, Inventory inv, PentacleAltarBlockEntity be) {
        return new PentacleAltarMenu((MenuType)OccultEngineeringMenuTypes.PENTACLE_ALTAR.get(), id, inv, be);
    }

    public boolean canWrite() {
        return this.inputSlot.hasItem() && !this.outputSlot.hasItem();
    }

    protected PentacleAltarBlockEntity createOnClient(RegistryFriendlyByteBuf extraData) {
        ClientLevel world = Minecraft.getInstance().level;
        BlockEntity blockEntity = world.getBlockEntity(extraData.readBlockPos());
        if (blockEntity instanceof PentacleAltarBlockEntity) {
            PentacleAltarBlockEntity be = (PentacleAltarBlockEntity)blockEntity;
            be.readClient(extraData.readNbt(), (HolderLookup.Provider)extraData.registryAccess());
            return be;
        }
        return null;
    }

    protected void initAndReadInventory(PentacleAltarBlockEntity pentacleAltarBlockEntity) {
    }

    protected void addSlots() {
        this.inputSlot = new SlotItemHandler(this, (IItemHandler)((PentacleAltarBlockEntity)((Object)this.contentHolder)).inventory, 0, 21, 59){

            public boolean mayPlace(@NotNull ItemStack stack) {
                return OccultEngineeringItems.EMPTY_PENTACLE_SCHEMATIC.isIn(stack) || OccultEngineeringItems.PENTACLE_SCHEMATIC.isIn(stack);
            }
        };
        this.outputSlot = new SlotItemHandler(this, (IItemHandler)((PentacleAltarBlockEntity)((Object)this.contentHolder)).inventory, 1, 166, 59){

            public boolean mayPlace(@NotNull ItemStack stack) {
                return false;
            }
        };
        this.addSlot(this.inputSlot);
        this.addSlot(this.outputSlot);
        this.addPlayerSlots(38, 107);
    }

    protected void saveData(PentacleAltarBlockEntity pentacleAltarBlockEntity) {
    }

    public ItemStack quickMoveStack(Player player, int index) {
        Slot clickedSlot = this.getSlot(index);
        if (!clickedSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = clickedSlot.getItem();
        if (index < 2) {
            this.moveItemStackTo(stack, 2, this.slots.size(), false);
        } else {
            this.moveItemStackTo(stack, 0, 1, false);
        }
        return ItemStack.EMPTY;
    }
}

