/*
 * Decompiled with CFR 0.152.
 */
package io.github.irishgreencitrus.occultengineering.content.pentacleschematics.packet;

import io.github.irishgreencitrus.occultengineering.content.block.pentacle_altar.PentacleAltarBlockEntity;
import io.github.irishgreencitrus.occultengineering.content.block.pentacle_altar.PentacleAltarMenu;
import io.github.irishgreencitrus.occultengineering.content.item.PentacleSchematicItem;
import io.github.irishgreencitrus.occultengineering.registry.OccultEngineeringPackets;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import net.createmod.catnip.net.base.BasePacketPayload;
import net.createmod.catnip.net.base.ServerboundPacketPayload;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public record PentacleAltarConfirmPacket(String pentacleLocation) implements ServerboundPacketPayload
{
    public static final StreamCodec<ByteBuf, PentacleAltarConfirmPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, PentacleAltarConfirmPacket::pentacleLocation, PentacleAltarConfirmPacket::new);

    public void handle(ServerPlayer player) {
        player.server.execute(() -> {
            BlockPos altarPos;
            Level level = player.getCommandSenderWorld();
            BlockEntity be = level.getBlockEntity(altarPos = ((PentacleAltarBlockEntity)((Object)((Object)((PentacleAltarMenu)player.containerMenu).contentHolder))).getBlockPos());
            if (be == null) {
                return;
            }
            if (be instanceof PentacleAltarBlockEntity) {
                PentacleAltarBlockEntity altar = (PentacleAltarBlockEntity)be;
                altar.inventory.setStackInSlot(0, ItemStack.EMPTY);
                altar.inventory.setStackInSlot(1, PentacleSchematicItem.create(Objects.requireNonNull(ResourceLocation.tryParse((String)this.pentacleLocation))));
            }
        });
    }

    public BasePacketPayload.PacketTypeProvider getTypeProvider() {
        return OccultEngineeringPackets.PENTACLE_ALTAR_CONFIRM;
    }
}

