/*
 * Decompiled with CFR 0.152.
 */
package com.leobeliik.extremesoundmuffler.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.leobeliik.extremesoundmuffler.CommonConfig;
import com.leobeliik.extremesoundmuffler.Constants;
import com.leobeliik.extremesoundmuffler.gui.MufflerScreen;
import com.leobeliik.extremesoundmuffler.interfaces.ISoundLists;
import com.leobeliik.extremesoundmuffler.utils.Anchor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.FileUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class DataManager
implements ISoundLists {
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public static void loadData() {
        MufflerScreen.setMuffling(true);
        Optional.ofNullable(DataManager.loadMuffledMap()).ifPresent(mm -> mm.forEach((R, D) -> muffledSounds.put(ResourceLocation.parse((String)R), D)));
        if (!CommonConfig.get().disableAnchors().get().booleanValue()) {
            anchorList.clear();
            anchorList.addAll((Collection)Optional.ofNullable(DataManager.loadAnchors()).orElse(Constants.emptyAnchorList));
        }
        DataManager.saveData();
    }

    public static void saveData() {
        DataManager.saveMuffledMap();
        if (!CommonConfig.get().disableAnchors().get().booleanValue()) {
            DataManager.saveAnchors();
        }
    }

    private static String getWorldName() {
        IntegratedServer server = Minecraft.getInstance().getSingleplayerServer();
        String name = server != null ? server.getWorldData().getLevelName().strip() : "ServerWorld";
        try {
            return FileUtil.findAvailableName((Path)Path.of("", new String[0]), (String)name, (String)"");
        }
        catch (IOException e) {
            Constants.LOG.error("ESM: error trying to create a folder with the name of the world " + name, (Throwable)e);
            return "ServerWorld";
        }
    }

    private static void saveMuffledMap() {
        new File("ESM/").mkdir();
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream("ESM/soundsMuffled.dat"), StandardCharsets.UTF_8);){
            writer.write(gson.toJson((Object)muffledSounds));
        }
        catch (IOException e) {
            Constants.LOG.error(Component.translatable((String)"log.error.saveMuffledList", (Object[])new Object[]{e}).getString());
        }
    }

    private static Map<String, Double> loadMuffledMap() {
        Map map;
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream("ESM/soundsMuffled.dat"), StandardCharsets.UTF_8);
        try {
            map = (Map)gson.fromJson(new JsonReader((Reader)reader), new TypeToken<Map<String, Double>>(){}.getType());
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                if (e instanceof FileNotFoundException) {
                    Constants.LOG.warn(Component.translatable((String)"log.warn.loadMuffledList").getString());
                } else {
                    Constants.LOG.error(Component.translatable((String)"log.error.loadMuffledList", (Object[])new Object[]{e}).getString());
                }
                return new HashMap<String, Double>();
            }
        }
        reader.close();
        return map;
    }

    private static void saveAnchors() {
        new File("ESM/", DataManager.getWorldName()).mkdirs();
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream("ESM/" + DataManager.getWorldName() + "/anchors.dat"), StandardCharsets.UTF_8);){
            writer.write(gson.toJson((Object)anchorList));
        }
        catch (IOException e) {
            Constants.LOG.error(Component.translatable((String)"log.error.saveAnchorList", (Object[])new Object[]{e}).getString());
        }
    }

    private static List<Anchor> loadAnchors() {
        List list;
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream("ESM/" + DataManager.getWorldName() + "/anchors.dat"), StandardCharsets.UTF_8);
        try {
            list = (List)gson.fromJson(new JsonReader((Reader)reader), new TypeToken<List<Anchor>>(){}.getType());
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                if (e instanceof FileNotFoundException) {
                    Constants.LOG.warn(Component.translatable((String)"log.warn.loadAnchorList").getString());
                } else {
                    Constants.LOG.error(Component.translatable((String)"log.error.loadAnchorList", (Object[])new Object[]{e}).getString());
                }
                return Constants.emptyAnchorList;
            }
        }
        reader.close();
        return list;
    }
}

