/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.gui.analysis.config;

import dev.kostromdan.mods.crash_assistant.app.gui.analysis.config.ConfigChecker;
import dev.kostromdan.mods.crash_assistant.app.gui.analysis.config.GsonJsonChecker;
import dev.kostromdan.mods.crash_assistant.app.gui.analysis.config.NightConfigJsonChecker;
import dev.kostromdan.mods.crash_assistant.app.gui.analysis.config.TomlNightConfigChecker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ConfigCheckerRegistry {
    private static final List<ConfigChecker> CHECKERS = Arrays.asList(new TomlNightConfigChecker(), new NightConfigJsonChecker(), new GsonJsonChecker());
    private static final Map<String, List<ConfigChecker>> CHECKERS_BY_EXTENSION;
    private static final Set<String> SUPPORTED_EXTENSIONS;

    private ConfigCheckerRegistry() {
    }

    public static List<ConfigChecker> getCheckers(String extension) {
        List<ConfigChecker> checkers = CHECKERS_BY_EXTENSION.get(extension);
        return checkers == null ? Collections.emptyList() : checkers;
    }

    public static Set<String> getSupportedExtensions() {
        return SUPPORTED_EXTENSIONS;
    }

    static {
        LinkedHashMap<String, List> byExtension = new LinkedHashMap<String, List>();
        for (ConfigChecker checker : CHECKERS) {
            for (String extension : checker.supportedExtensions()) {
                byExtension.computeIfAbsent(extension, key -> new ArrayList()).add(checker);
            }
        }
        byExtension.replaceAll((ext, list) -> Collections.unmodifiableList(list));
        CHECKERS_BY_EXTENSION = Collections.unmodifiableMap(byExtension);
        SUPPORTED_EXTENSIONS = Collections.unmodifiableSet(new LinkedHashSet<String>(CHECKERS_BY_EXTENSION.keySet()));
    }
}

