/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.datagen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import mcjty.lib.setup.Registration;
import mcjty.lib.varia.Tools;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemEnchantmentsPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicates;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.AlternativesEntry;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.ApplyExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.CopyBlockState;
import net.minecraft.world.level.storage.loot.functions.CopyComponentsFunction;
import net.minecraft.world.level.storage.loot.functions.CopyNameFunction;
import net.minecraft.world.level.storage.loot.functions.EnchantedCountIncreaseFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BaseLootTableProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    protected final Map<EntityType<?>, LootTable.Builder> entityLootTables = new HashMap();
    protected final Map<ResourceLocation, LootTable.Builder> chestLootTables = new HashMap<ResourceLocation, LootTable.Builder>();
    protected final Map<Block, LootTable.Builder> lootTables = new HashMap<Block, LootTable.Builder>();

    public void addLootTable(Block block, LootTable.Builder builder) {
        this.lootTables.put(block, builder);
    }

    public void addItemDropTable(EntityType<?> entityType, ItemLike item) {
        this.entityLootTables.put(entityType, this.createItemDropTable(Tools.getId(entityType).getPath(), item));
    }

    public void addChestLootTable(ResourceLocation id, LootTable.Builder builder) {
        this.chestLootTables.put(id, builder);
    }

    public void addItemDropTable(HolderLookup.Provider provider, EntityType<?> entityType, ItemLike item, float min, float max, float lmin, float lmax) {
        this.entityLootTables.put(entityType, this.createItemDropTable(provider, Tools.getId(entityType).getPath(), item, min, max, lmin, lmax));
    }

    public LootTable.Builder createItemDropTable(String name, ItemLike item) {
        LootPool.Builder builder = LootPool.lootPool().name(name).setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)item));
        return LootTable.lootTable().withPool(builder);
    }

    public LootTable.Builder createItemDropTable(HolderLookup.Provider provider, String name, ItemLike item, float min, float max, float lmin, float lmax) {
        LootPool.Builder builder = LootPool.lootPool().name(name).setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)item).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)min, (float)max))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)provider, (NumberProvider)UniformGenerator.between((float)lmin, (float)lmax))));
        return LootTable.lootTable().withPool(builder);
    }

    public LootTable.Builder createSilkTouchTable(HolderLookup.Provider provider, String name, Block block, Item lootItem, float min, float max) {
        Optional silkTouch = ((HolderLookup.RegistryLookup)provider.lookup(Registries.ENCHANTMENT).get()).get(Enchantments.SILK_TOUCH);
        Optional fortune = ((HolderLookup.RegistryLookup)provider.lookup(Registries.ENCHANTMENT).get()).get(Enchantments.FORTUNE);
        EnchantmentPredicate silkTouchPredicate = new EnchantmentPredicate((Holder)silkTouch.get(), MinMaxBounds.Ints.atLeast((int)1));
        LootPool.Builder builder = LootPool.lootPool().name(name).setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)AlternativesEntry.alternatives((LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[]{LootItem.lootTableItem((ItemLike)block).when(MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().withSubPredicate(ItemSubPredicates.ENCHANTMENTS, (ItemSubPredicate)ItemEnchantmentsPredicate.enchantments(List.of(silkTouchPredicate))))), LootItem.lootTableItem((ItemLike)lootItem).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)min, (float)max))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)((Holder)fortune.get()), (int)1)).apply((LootItemFunction.Builder)ApplyExplosionDecay.explosionDecay())}));
        return LootTable.lootTable().withPool(builder);
    }

    protected void addBlockStateTable(Block block, Property<?> property) {
        this.lootTables.put(block, this.createBlockStateTable(Tools.getId(block).getPath(), block, property));
    }

    protected LootTable.Builder createBlockStateTable(String name, Block block, Property<?> property) {
        LootPool.Builder builder = LootPool.lootPool().name(Tools.getId(block).getPath()).setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)block).apply((LootItemFunction.Builder)CopyBlockState.copyState((Block)block).copy(property)));
        return LootTable.lootTable().withPool(builder);
    }

    protected void addStandardTable(Block block, DataComponentType<?> ... types) {
        this.lootTables.put(block, this.createStandardTable(Tools.getId(block).getPath(), block, types));
    }

    protected LootTable.Builder createStandardTable(String name, Block block, DataComponentType<?> ... types) {
        CopyComponentsFunction.Builder copyBuilder = CopyComponentsFunction.copyComponents((CopyComponentsFunction.Source)CopyComponentsFunction.Source.BLOCK_ENTITY).include((DataComponentType)Registration.ITEM_ENERGY.get()).include((DataComponentType)Registration.ITEM_INVENTORY.get());
        for (DataComponentType<?> type : types) {
            copyBuilder.include(type);
        }
        LootPool.Builder builder = LootPool.lootPool().name(name).setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)block).apply((LootItemFunction.Builder)CopyNameFunction.copyName((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)).apply((LootItemFunction.Builder)copyBuilder));
        return LootTable.lootTable().withPool(builder);
    }

    protected void addSimpleTable(Block block) {
        this.lootTables.put(block, this.createSimpleTable(Tools.getId(block).getPath(), block));
    }

    protected LootTable.Builder createSimpleTable(String name, Block block) {
        LootPool.Builder builder = LootPool.lootPool().name(name).setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)block));
        return LootTable.lootTable().withPool(builder);
    }

    protected LootTable.Builder createSimpleTable(String name, Item item) {
        LootPool.Builder builder = LootPool.lootPool().name(name).setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)item));
        return LootTable.lootTable().withPool(builder);
    }

    public void generate(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> builder, LootContextParamSet paramSet) {
        if (paramSet == LootContextParamSets.BLOCK) {
            for (Map.Entry<Block, LootTable.Builder> entry : this.lootTables.entrySet()) {
                builder.accept((ResourceKey<LootTable>)entry.getKey().getLootTable(), entry.getValue().setParamSet(LootContextParamSets.BLOCK));
            }
        }
        if (paramSet == LootContextParamSets.ENTITY) {
            for (Map.Entry<Block, LootTable.Builder> entry : this.entityLootTables.entrySet()) {
                builder.accept((ResourceKey<LootTable>)((EntityType)entry.getKey()).getDefaultLootTable(), entry.getValue().setParamSet(LootContextParamSets.ENTITY));
            }
        }
        if (paramSet == LootContextParamSets.CHEST) {
            for (Map.Entry<Block, LootTable.Builder> entry : this.chestLootTables.entrySet()) {
                ResourceLocation id = (ResourceLocation)entry.getKey();
                ResourceKey key = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)id.withPrefix("chests/"));
                builder.accept((ResourceKey<LootTable>)key, entry.getValue().setParamSet(LootContextParamSets.CHEST));
            }
        }
    }
}

