/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.baguettelib.mixin;

import com.leclowndu93150.baguettelib.event.entity.CreativeFlightEvent;
import net.minecraft.network.protocol.game.ServerboundPlayerAbilitiesPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerGamePacketListenerImpl.class})
public class PlayerAbilitiesPacketMixin {
    @Shadow
    public ServerPlayer player;

    @Inject(method={"handlePlayerAbilities"}, at={@At(value="HEAD")}, cancellable=true)
    private void onHandlePlayerAbilities(ServerboundPlayerAbilitiesPacket packet, CallbackInfo ci) {
        if (this.player.getAbilities().mayfly && this.player.getAbilities().flying != packet.isFlying()) {
            CreativeFlightEvent.Toggle toggleEvent = new CreativeFlightEvent.Toggle((Player)this.player, packet.isFlying());
            NeoForge.EVENT_BUS.post((Event)toggleEvent);
            if (toggleEvent.isCanceled()) {
                this.player.onUpdateAbilities();
                ci.cancel();
                return;
            }
            this.player.getAbilities().flying = toggleEvent.getFlightState();
            CreativeFlightEvent.Changed changedEvent = new CreativeFlightEvent.Changed((Player)this.player, !toggleEvent.getFlightState(), toggleEvent.getFlightState());
            NeoForge.EVENT_BUS.post((Event)changedEvent);
            ci.cancel();
        }
    }
}

