/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.packcompanion.config;

import dev.ftb.mods.ftblibrary.config.manager.ConfigManager;
import dev.ftb.mods.ftblibrary.snbt.config.BaseValue;
import dev.ftb.mods.ftblibrary.snbt.config.BooleanValue;
import dev.ftb.mods.ftblibrary.snbt.config.DoubleValue;
import dev.ftb.mods.ftblibrary.snbt.config.IntValue;
import dev.ftb.mods.ftblibrary.snbt.config.SNBTConfig;
import dev.ftb.mods.ftblibrary.snbt.config.StringListValue;
import dev.ftb.mods.ftblibrary.snbt.config.StringMapValue;
import java.util.ArrayList;
import java.util.HashMap;

public interface PCServerConfig {
    public static final SNBTConfig CONFIG = SNBTConfig.create((String)"ftbpc-server");
    public static final SNBTConfig SPAWNERS = CONFIG.addGroup("spawners");
    public static final BooleanValue SPAWNERS_ALLOW_RESPAWN = (BooleanValue)SPAWNERS.addBoolean("allow_respawn", false).comment(new String[]{"When enabled, broken spawner blocks will be remembered and will respawn at a given interval."});
    public static final IntValue SPAWNERS_RESPAWN_INTERVAL = (IntValue)SPAWNERS.addInt("respawn_interval", 60, 0, 1440).comment(new String[]{"The interval in minutes at which spawners will respawn."});
    public static final StringListValue SPAWNERS_USE_RANDOM_ENTITY = (StringListValue)SPAWNERS.addStringList("random_entity", new ArrayList()).comment(new String[]{"A list of entity types that will be used to replace broken spawners. Set to an empty list to disable."});
    public static final BooleanValue PUNISH_BREAKING_SPAWNER = SPAWNERS.addBoolean("punish_for_breaking_spawners", false);
    public static final DoubleValue MODIFY_MOB_BASE_HEALTH = (DoubleValue)CONFIG.addDouble("modify_mob_base_health", 0.0, 0.0, 1000.0).comment(new String[]{"If non-zero, set the base health of all mobs to be multiplied by this value. Set to 0 to disable."});
    public static final SNBTConfig PERFORMANCE = CONFIG.addGroup("performance");
    public static final BooleanValue RELOAD_PERFORMANCE = (BooleanValue)PERFORMANCE.addBoolean("skip_block_cache_rebuild", true).comment(new String[]{"Improve reloading performance by disabling block cache rebuild on client tag data reload"});
    public static final SNBTConfig WORLDGEN = CONFIG.addGroup("worldgen");
    public static final StringMapValue STRUCTURE_ROTATION_OVERRIDE = (StringMapValue)((StringMapValue)WORLDGEN.add((BaseValue)new StringMapValue(WORLDGEN, "structure_rotation_override", new HashMap()))).comment(new String[]{"Applies to structures of type 'minecraft:jigsaw' only", "Maps template pool ID's to a forced rotation for that pool: one of 'none', 'clockwise_90', '180', 'counterclockwise_90'"});
    public static final SNBTConfig VILLAGERS = CONFIG.addGroup("villagers");
    public static final BooleanValue NO_WANDERING_TRADER_INVIS_POTIONS = (BooleanValue)VILLAGERS.addBoolean("no_wandering_trader_invis_potions", false).comment(new String[]{"If true, Wandering Traders will no longer drink invisibility potions at night", "(or milk buckets to remove their invisibility when it's day)"});

    public static void init() {
        ConfigManager.getInstance().registerServerConfig(CONFIG, "ftbpc.server", false);
    }
}

