/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.item;

import com.hollingsworth.arsnouveau.common.block.tile.SummoningTile;
import com.hollingsworth.arsnouveau.common.items.ModItem;
import com.hollingsworth.arsnouveau.common.items.data.PersistentFamiliarData;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractSummonCharm
extends ModItem {
    public AbstractSummonCharm(Item.Properties properties) {
        super(properties);
    }

    public AbstractSummonCharm() {
        this(ItemsRegistry.defaultItemProperties().component(DataComponentRegistry.PERSISTENT_FAMILIAR_DATA, (Object)new PersistentFamiliarData()));
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        InteractionResult result;
        Level world = context.getLevel();
        if (world.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockPos pos = context.getClickedPos();
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof SummoningTile) {
            SummoningTile tile = (SummoningTile)blockEntity;
            result = this.useOnSummonTile(context, world, tile, pos);
        } else {
            result = this.useOnBlock(context, world, pos);
        }
        Player player = context.getPlayer();
        if (!(result != InteractionResult.SUCCESS || player != null && player.hasInfiniteMaterials())) {
            context.getItemInHand().shrink(1);
        }
        return result;
    }

    public abstract InteractionResult useOnBlock(UseOnContext var1, Level var2, BlockPos var3);

    public abstract InteractionResult useOnSummonTile(UseOnContext var1, Level var2, SummoningTile var3, BlockPos var4);
}

