/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.patchouli;

import com.hollingsworth.arsnouveau.common.crafting.recipes.EnchantingApparatusRecipe;
import com.hollingsworth.arsnouveau.common.crafting.recipes.ITextOutput;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class NoOutputApparatusProcessor
implements IComponentProcessor {
    RecipeHolder<EnchantingApparatusRecipe> holder;

    public void setup(Level level, IVariableProvider variables) {
        RecipeManager manager = Minecraft.getInstance().level.getRecipeManager();
        String recipeID = variables.get("recipe", (HolderLookup.Provider)level.registryAccess()).asString();
        this.holder = manager.byKey(ResourceLocation.tryParse((String)recipeID)).orElse(null);
    }

    public IVariable process(Level level, String key) {
        if (this.holder == null) {
            return null;
        }
        EnchantingApparatusRecipe recipe = (EnchantingApparatusRecipe)this.holder.value();
        if (key.equals("reagent")) {
            return IVariable.wrapList((Iterable)Arrays.stream(recipe.reagent().getItems()).map(i -> IVariable.from((Object)i, (HolderLookup.Provider)level.registryAccess())).collect(Collectors.toList()), (HolderLookup.Provider)level.registryAccess());
        }
        if (key.equals("recipe")) {
            return IVariable.wrap((String)this.holder.id().toString(), (HolderLookup.Provider)level.registryAccess());
        }
        if (recipe instanceof ITextOutput) {
            ITextOutput textOutput = (ITextOutput)((Object)recipe);
            if (key.equals("output")) {
                return IVariable.wrap((String)textOutput.getOutputComponent().getString(), (HolderLookup.Provider)level.registryAccess());
            }
        }
        if (key.equals("footer")) {
            return IVariable.wrap((String)recipe.result().getItem().getDescriptionId(), (HolderLookup.Provider)level.registryAccess());
        }
        return null;
    }
}

