/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.datagen;

import com.hollingsworth.arsnouveau.common.crafting.recipes.ImbuementRecipe;
import com.hollingsworth.arsnouveau.common.datagen.ModDatagen;
import com.hollingsworth.arsnouveau.common.datagen.RecipeDatagen;
import com.hollingsworth.arsnouveau.common.datagen.SimpleDataProvider;
import com.hollingsworth.arsnouveau.common.items.ModItem;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import com.mojang.serialization.Codec;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;

public class ImbuementRecipeProvider
extends SimpleDataProvider {
    public List<ImbuementRecipe> recipes = new ArrayList<ImbuementRecipe>();

    public ImbuementRecipeProvider(DataGenerator generatorIn) {
        super(generatorIn);
    }

    @Override
    @NotNull
    public CompletableFuture<?> run(@NotNull CachedOutput pOutput) {
        this.collectJsons(pOutput);
        ArrayList futures = new ArrayList();
        return ModDatagen.registries.thenCompose(registry -> {
            for (ImbuementRecipe g : this.recipes) {
                Path path = ImbuementRecipeProvider.getRecipePath(this.output, g.id.getPath());
                futures.add(DataProvider.saveStable((CachedOutput)pOutput, (HolderLookup.Provider)registry, (Codec)ImbuementRecipe.CODEC, (Object)g, (Path)path));
            }
            return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        });
    }

    @Override
    public void collectJsons(CachedOutput pOutput) {
        this.recipes.add(new ImbuementRecipe("lapis", Ingredient.of((TagKey)Tags.Items.GEMS_LAPIS), ((ModItem)((Object)ItemsRegistry.SOURCE_GEM.get())).getDefaultInstance(), 500));
        this.recipes.add(new ImbuementRecipe("amethyst", Ingredient.of((ItemLike[])new ItemLike[]{Items.AMETHYST_SHARD}), ((ModItem)((Object)ItemsRegistry.SOURCE_GEM.get())).getDefaultInstance(), 500));
        this.recipes.add(new ImbuementRecipe("amethyst_block", Ingredient.of((ItemLike[])new ItemLike[]{Items.AMETHYST_BLOCK}), new ItemStack(BlockRegistry.SOURCE_GEM_BLOCK), 2000));
        this.recipes.add(new ImbuementRecipe("fire_essence", RecipeDatagen.SOURCE_GEM, new ItemStack((ItemLike)ItemsRegistry.FIRE_ESSENCE.get()), 2000).withPedestalItem((ItemLike)Items.FLINT_AND_STEEL).withPedestalItem((ItemLike)Items.TORCH).withPedestalItem((ItemLike)Items.GUNPOWDER));
        this.recipes.add(new ImbuementRecipe("air_essence", RecipeDatagen.SOURCE_GEM, new ItemStack((ItemLike)ItemsRegistry.AIR_ESSENCE.get()), 2000).withPedestalItem((ItemLike)Items.FEATHER).withPedestalItem(ItemsRegistry.WILDEN_WING).withPedestalItem(Ingredient.of((TagKey)ItemTags.ARROWS)));
        this.recipes.add(new ImbuementRecipe("earth_essence", RecipeDatagen.SOURCE_GEM, new ItemStack((ItemLike)ItemsRegistry.EARTH_ESSENCE.get()), 2000).withPedestalItem(Ingredient.of((TagKey)Tags.Items.INGOTS_IRON)).withPedestalItem(Ingredient.of((TagKey)Tags.Items.SEEDS)).withPedestalItem(Ingredient.of((TagKey)ItemTags.DIRT)));
        this.recipes.add(new ImbuementRecipe("water_essence", RecipeDatagen.SOURCE_GEM, new ItemStack((ItemLike)ItemsRegistry.WATER_ESSENCE.get()), 2000).withPedestalItem((ItemLike)Items.WATER_BUCKET).withPedestalItem((ItemLike)Items.SNOW_BLOCK).withPedestalItem((ItemLike)Items.KELP));
        this.recipes.add(new ImbuementRecipe("conjuration_essence", RecipeDatagen.SOURCE_GEM, new ItemStack((ItemLike)ItemsRegistry.CONJURATION_ESSENCE.get()), 2000).withPedestalItem(ItemsRegistry.WILDEN_HORN).withPedestalItem(ItemsRegistry.STARBUNCLE_SHARD).withPedestalItem((ItemLike)Items.BOOK));
        this.recipes.add(new ImbuementRecipe("abjuration_essence", RecipeDatagen.SOURCE_GEM, new ItemStack((ItemLike)ItemsRegistry.ABJURATION_ESSENCE.get()), 2000).withPedestalItem((ItemLike)Items.FERMENTED_SPIDER_EYE).withPedestalItem((ItemLike)Items.SUGAR).withPedestalItem((ItemLike)Items.MILK_BUCKET));
        this.recipes.add(new ImbuementRecipe("manipulation_essence", RecipeDatagen.SOURCE_GEM, new ItemStack((ItemLike)ItemsRegistry.MANIPULATION_ESSENCE.get()), 2000).withPedestalItem((ItemLike)Items.STONE_BUTTON).withPedestalItem((ItemLike)Items.REDSTONE).withPedestalItem((ItemLike)Items.CLOCK));
        this.recipes.add(new ImbuementRecipe("pierce_arrow", Ingredient.of((TagKey)ItemTags.ARROWS), new ItemStack((ItemLike)ItemsRegistry.PIERCE_ARROW.get()), 100).withPedestalItem((ItemLike)ItemsRegistry.SOURCE_GEM.get()).withPedestalItem((ItemLike)ItemsRegistry.AIR_ESSENCE.get()).withPedestalItem((ItemLike)ItemsRegistry.WILDEN_SPIKE.get()));
        this.recipes.add(new ImbuementRecipe("amplify_arrow", Ingredient.of((TagKey)ItemTags.ARROWS), new ItemStack((ItemLike)ItemsRegistry.AMPLIFY_ARROW.get()), 100).withPedestalItem((ItemLike)ItemsRegistry.SOURCE_GEM.get()).withPedestalItem((ItemLike)ItemsRegistry.AIR_ESSENCE.get()).withPedestalItem(Ingredient.of((TagKey)Tags.Items.GEMS_DIAMOND)));
        this.recipes.add(new ImbuementRecipe("split_arrow", Ingredient.of((TagKey)ItemTags.ARROWS), new ItemStack((ItemLike)ItemsRegistry.SPLIT_ARROW.get()), 100).withPedestalItem((ItemLike)ItemsRegistry.SOURCE_GEM.get()).withPedestalItem((ItemLike)ItemsRegistry.AIR_ESSENCE.get()).withPedestalItem((ItemLike)ItemsRegistry.WILDEN_HORN.get()));
    }

    private static Path getRecipePath(Path pathIn, String str) {
        return pathIn.resolve("data/ars_nouveau/recipe/imbuement_" + str + ".json");
    }

    @NotNull
    public String getName() {
        return "Imbuement";
    }
}

