/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.datagen;

import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.api.registry.FamiliarRegistry;
import com.hollingsworth.arsnouveau.api.registry.GlyphRegistry;
import com.hollingsworth.arsnouveau.api.registry.PerkRegistry;
import com.hollingsworth.arsnouveau.api.registry.RitualRegistry;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.client.jei.AliasProvider;
import com.hollingsworth.arsnouveau.common.items.FamiliarScript;
import com.hollingsworth.arsnouveau.common.items.Glyph;
import com.hollingsworth.arsnouveau.common.items.PerkItem;
import com.hollingsworth.arsnouveau.common.items.RitualTablet;
import com.hollingsworth.arsnouveau.common.lib.LibBlockNames;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Supplier;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;

public class LangDatagen
extends LanguageProvider {
    private final Map<String, String> data = new TreeMap<String, String>();

    public LangDatagen(PackOutput output, String modid, String locale) {
        super(output, modid, locale);
    }

    protected void addTranslations() {
        Object key;
        for (DeferredHolder entry : ItemsRegistry.ITEMS.getEntries()) {
            Iterator<AliasProvider.Alias> iterator = entry.get();
            if (!(iterator instanceof AliasProvider)) continue;
            AliasProvider aliasProvider = (AliasProvider)((Object)iterator);
            for (AliasProvider.Alias alias : aliasProvider.getAliases()) {
                key = alias.toTranslationKey();
                if (this.data.containsKey(key)) continue;
                this.add((String)key, alias.name());
            }
        }
        ArsNouveauAPI arsNouveauAPI = ArsNouveauAPI.getInstance();
        for (Supplier<Glyph> supplier : GlyphRegistry.getGlyphItemMap().values()) {
            Glyph glyph = supplier.get();
            AbstractSpellPart abstractSpellPart = glyph.spellPart;
            ResourceLocation registryName = glyph.spellPart.getRegistryName();
            if (!registryName.getNamespace().equals("ars_nouveau")) continue;
            this.add("ars_nouveau.glyph_desc." + registryName.getPath(), abstractSpellPart.getBookDescription());
            this.add("ars_nouveau.glyph_name." + registryName.getPath(), abstractSpellPart.getName());
            HashMap<AbstractAugment, String> augmentDescriptions = new HashMap<AbstractAugment, String>();
            abstractSpellPart.addAugmentDescriptions(augmentDescriptions);
            for (AbstractAugment augment : augmentDescriptions.keySet()) {
                this.add("ars_nouveau.augment_desc." + registryName.getPath() + "_" + augment.getRegistryName().getPath(), (String)augmentDescriptions.get(augment));
            }
        }
        for (FamiliarScript familiarScript : FamiliarRegistry.getFamiliarScriptMap().values()) {
            if (!familiarScript.familiar.getRegistryName().getNamespace().equals("ars_nouveau")) continue;
            this.add("ars_nouveau.familiar_desc." + familiarScript.familiar.getRegistryName().getPath(), familiarScript.familiar.getBookDescription());
            this.add("ars_nouveau.familiar_name." + familiarScript.familiar.getRegistryName().getPath(), familiarScript.familiar.getBookName());
            this.add("item.ars_nouveau." + familiarScript.familiar.getRegistryName().getPath(), familiarScript.familiar.getBookName());
        }
        for (RitualTablet ritualTablet : RitualRegistry.getRitualItemMap().values()) {
            if (!ritualTablet.ritual.getRegistryName().getNamespace().equals("ars_nouveau")) continue;
            this.add("ars_nouveau.ritual_desc." + ritualTablet.ritual.getRegistryName().getPath(), ritualTablet.ritual.getLangDescription());
            this.add("item.ars_nouveau." + ritualTablet.ritual.getRegistryName().getPath(), ritualTablet.ritual.getLangName());
        }
        for (PerkItem perkItem : PerkRegistry.getPerkItemMap().values()) {
            if (!perkItem.perk.getRegistryName().getNamespace().equals("ars_nouveau") || perkItem.perk.getRegistryName().getPath().equals("blank_thread")) continue;
            this.add("ars_nouveau.perk_desc." + perkItem.perk.getRegistryName().getPath(), perkItem.perk.getLangDescription());
            this.add("item.ars_nouveau." + perkItem.perk.getRegistryName().getPath(), perkItem.perk.getLangName());
        }
        this.add("key.category.ars_nouveau.general", "Ars Nouveau");
        this.add("key.ars_nouveau.previous_slot", "(Spell Book) Previous Slot");
        this.add("key.ars_nouveau.next_slot", "(Spell Book) Next Slot");
        this.add("key.ars_nouveau.open_book", "(Spell Book) Open Book");
        this.add("key.ars_nouveau.selection_hud", "Toggle Selection HUD");
        this.add("itemGroup.ars_nouveau", "Ars Nouveau");
        this.add("itemGroup.ars_glyphs", "Ars Nouveau Glyphs");
        this.add("item.ars_nouveau.novice_spell_book", "Novice Spell Book");
        this.add("item.ars_nouveau.apprentice_spell_book", "Mage's Spell Book");
        this.add("item.ars_nouveau.archmage_spell_book", "Archmage Spell Book");
        this.add("enchantment.ars_nouveau.mana_regen.desc", "Increases the mana regeneration of the player.");
        this.add("enchantment.ars_nouveau.mana_boost.desc", "Increases the maximum mana of the player.");
        this.add("enchantment.ars_nouveau.reactive.desc", "Has a chance to cast the inscribed spell on tool use or player hurt.");
        this.add("attribute.name.ars_nouveau.mana_regen", "Mana Regeneration");
        this.add("attribute.name.ars_nouveau.max_mana", "Max Mana");
        this.add("entity.ars_nouveau.bookwyrm", "Bookwyrm");
        this.add("entity.ars_nouveau.starbuncle", "Starbuncle");
        this.add("item.ars_nouveau.battlemage_robes", "Battlemage's Gambeson");
        this.add("item.ars_nouveau.battlemage_leggings", "Battlemage's Legguards");
        this.add("item.ars_nouveau.battlemage_boots", "Battlemage's Boots");
        this.add("item.ars_nouveau.battlemage_hood", "Battlemage's Hood");
        this.add("item.ars_nouveau.sorcerer_boots", "Sorceror's Footpads");
        this.add("item.ars_nouveau.sorcerer_leggings", "Sorceror's Leggings");
        this.add("item.ars_nouveau.sorcerer_robes", "Sorceror's Wrap");
        this.add("item.ars_nouveau.sorcerer_hood", "Sorceror's Collar");
        this.add("item.ars_nouveau.arcanist_robes", "Arcanist's Robes");
        this.add("item.ars_nouveau.arcanist_leggings", "Arcanist's Pants");
        this.add("item.ars_nouveau.arcanist_boots", "Arcanist's Treads");
        this.add("item.ars_nouveau.arcanist_hood", "Arcanist's Hat");
        this.add("item.ars_nouveau.ring_of_amplify", "Ring of Amplify");
        this.add("item.ars_nouveau.lesser_discount_ring", "Ring of Lesser Discount");
        this.add("item.ars_nouveau.greater_discount_ring", "Ring of Greater Discount");
        this.add("item.ars_nouveau.belt_of_levitation", "Belt of Levitation");
        this.add("item.ars_nouveau.belt_of_unstable_gifts", "Belt of Unstable Gifts");
        this.add("item.ars_nouveau.mundane_belt", "Mundane Belt");
        this.add("item.ars_nouveau.ring_of_potential", "Ring of Potential");
        this.add("item.ars_nouveau.jar_of_light", "Jar of Light");
        this.add("item.ars_nouveau.bookwyrm_charm", "Bookwyrm Charm");
        this.add("item.ars_nouveau.starbuncle_charm", "Starbuncle Charm");
        this.add("item.ars_nouveau.starbuncle_shards", "Starbuncle Token");
        this.add("item.ars_nouveau.creative_spell_book", "Creative Spell Book");
        this.add("item.ars_nouveau.dull_trinket", "Dull Trinket");
        this.add("item.ars_nouveau.amulet_of_mana_boost", "Amulet of Mana Boost");
        this.add("item.ars_nouveau.amulet_of_mana_regen", "Amulet of Mana Regen");
        this.add("item.ars_nouveau.dominion_wand", "Dominion Wand");
        this.add("item.ars_nouveau.dominion_wand.strict", "Dominion Wand (Strict Mode)");
        this.add("item.ars_nouveau.ars_stencil", "Banner Pattern");
        this.add("item.ars_nouveau.ars_stencil.desc", "Nouveau");
        this.add("item.ars_nouveau.archwood_sign", "Archwood Sign");
        this.add("item.ars_nouveau.archwood_hanging_sign", "Archwood Hanging Sign");
        this.add("block.ars_nouveau.archwood_sign", "Archwood Sign");
        this.add("block.ars_nouveau.archwood_hanging_sign", "Archwood Hanging Sign");
        this.add("block.ars_nouveau.archwood_wall_sign", "Archwood Sign");
        this.add("block.ars_nouveau.archwood_hanging_wall_sign", "Archwood Hanging Sign");
        this.add("block.ars_nouveau.scribes_table", "Scribe's Table");
        this.add("block.ars_nouveau.light_block", "Magelight");
        this.add("block.ars_nouveau.temporary_light_block", "Temporary Magelight");
        this.add("block.ars_nouveau.mage_block", "Mage Block");
        this.add("block.ars_nouveau.agronomic_sourcelink", "Agronomic Sourcelink");
        this.add("block.ars_nouveau.source_jar", "Source Jar");
        this.add("block.ars_nouveau.rune", "Rune");
        this.add("block.ars_nouveau.warding_stone", "Warding Stone");
        this.add("block.ars_nouveau.arcane_pedestal", "Arcane Pedestal");
        this.add("block.ars_nouveau.enchanting_apparatus", "Enchanting Apparatus");
        this.add("block.ars_nouveau.portal", "Warp Portal");
        this.add("block.ars_nouveau.arcane_core", "Arcane Core");
        this.add("block.ars_nouveau.imbuement_chamber", "Imbuement Chamber");
        this.add("ars_nouveau.page.jar_of_light", "Summons a light that will follow the user as they move. Can be summoned and dismissed at any time.");
        this.add("ars_nouveau.page.amulet_of_mana_boost", "Increases max mana by a moderate amount.");
        this.add("ars_nouveau.page.amulet_of_mana_regen", "Increases mana regeneration by a moderate amount.");
        this.add("ars_nouveau.page.magebloom_crop", "A magically infused flower, Mageblooms provide additional source to nearby Agronomic Sourcelinks as they grow and provide a source of Magebloom Fiber. Mageblooms can also be used in crafting Potions of Spell Damage, increasing the damage of your spells.");
        this.add("ars_nouveau.page.belt_of_levitation", "A belt that allows the user levitate a moderate distance above the ground. Useful for climbing mountains! Simply sneak in the air while falling (or jumping) to rise. Reduces a small amount of fall damage while worn.");
        this.add("ars_nouveau.page.ring_of_lesser_discount", "In addition to providing a small bonus to maximum mana and mana regen, Rings of Discount reduce the total cost to cast a spell.");
        this.add("ars_nouveau.page.ring_of_greater_discount", "Provides a slightly larger discount over the Lesser Ring of Discount.");
        this.add("ars_nouveau.page.belt_of_unstable_gifts", "Occasionally grants a random positive potion effect for a short duration. These effects can vary in strength.");
        this.add("ars_nouveau.page.reactive", "Reactive is an enchantment that can be applied to ANY item and can be applied and upgraded by the Enchanting Apparatus. Tools and armor with the Reactive enchantment have a chance to automatically cast a spell on use or when the player is hurt. The spell that the enchantment will cast is dependent on the spell inscribed in the first crafting phase, and the user must have enough mana to cast the spell.");
        this.add("ars_nouveau.page.reactive2", "To enchant an item with Reactive, place any item or armor in the apparatus. The spell parchment placed on the pedestal must be inscribed with a valid spell. See the Scribes Table for additional information. Reactive Enchantment also requires jars of source near the Enchanting Apparatus. The first level enchantment requires approximately one third of a jar.");
        this.add("ars_nouveau.page.reactive3", "To upgrade the enchantment, replace the reagent with any item that has an existing Reactive enchantment. The Tier 2 reactive enchantment requires an item with Reactive I, and the Tier 3 Reactive enchantment requires an item with Reactive II. Higher levels will require a significantly higher amount of source nearby.");
        this.add("ars_nouveau.page.reactive4", "The spell that Reactive gear casts can be changed by placing an enchanted piece of gear into the apparatus with a new inscribed spell parchment. ");
        this.add("enchantment.ars_nouveau.mana_boost", "Mana Boost");
        this.add("enchantment.ars_nouveau.reactive", "Reactive");
        this.add("enchantment.ars_nouveau.mana_regen", "Mana Regen");
        this.add("item.ars_nouveau.magic_clay", "Magic Clay");
        this.add("item.ars_nouveau.marvelous_clay", "Marvelous Clay");
        this.add("item.ars_nouveau.mythical_clay", "Mythical Clay");
        this.add("item.ars_nouveau.runic_chalk", "Runic Chalk");
        this.add("item.ars_nouveau.magebloom", "Magebloom");
        this.add("item.ars_nouveau.magebloom_fiber", "Magebloom Fiber");
        this.add("item.ars_nouveau.blaze_fiber", "Blaze Fiber");
        this.add("item.ars_nouveau.end_fiber", "End Fiber");
        this.add("block.ars_nouveau.magebloom_crop", "Magebloom Seed");
        this.add("item.ars_nouveau.source_gem", "Source Gem");
        this.add("item.ars_nouveau.blank_glyph", "Blank Glyph");
        this.add("item.ars_nouveau.worn_notebook", "Tattered Tome");
        this.add("item.ars_nouveau.warp_scroll", "Warp Scroll");
        this.add("item.ars_nouveau.spell_parchment", "Spell Parchment");
        this.add("item.ars_nouveau.ring_of_greater_discount", "Ring of Greater Discount");
        this.add("item.ars_nouveau.ring_of_lesser_discount", "Ring of Lesser Discount");
        this.add("alert.core", "An Arcane Core must be placed next to the base of the Enchanting Apparatus.");
        this.add("alert.core.wrong_axis", "The Arcane Core must be aligned with the base of the Enchanting Apparatus.");
        this.add("whirlisprig.unhappy", "The Whirlisprig seems very unhappy in her home. Try sprucing it up!");
        this.add("whirlisprig.content", "The Whirlisprig seems content, but could be better.");
        this.add("whirlisprig.happy", "The Whirlisprig appears happy enough.");
        this.add("whirlisprig.very_happy", "The Whirlisprig is very happy!");
        this.add("whirlisprig.extremely_happy", "The Whirlisprig is extremely happy! It doesn't seem like it wants anything else.");
        this.add("whirlisprig.okay_diversity", "There does not appear to be much diversity.");
        this.add("whirlisprig.diverse_enough", "There is some diversity, but could be better.");
        this.add("whirlisprig.very_diverse", "The Whirlisprig thinks her home is very diverse.");
        this.add("whirlisprig.extremely_diverse", "The home is extremely diverse, but Whirlisprig will never turn down a new addition to their home!");
        this.add("whirlisprig.notinterested", "The Whirlisprig does not seem interested in this item.");
        this.add("whirlisprig.likes", "The Whirlisprig likes this block!");
        this.add("whirlisprig.excited", "The Whirlisprig would be excited to have this in their home!");
        this.add("whirlisprig.toomuch", "The Whirlisprig likes this item, but has enough of it already.");
        this.add("item.ars_nouveau.whirlisprig_charm", "Whirlisprig Charm");
        this.add("item.ars_nouveau.whirlisprig_shards", "Whirlisprig Token");
        this.add("entity.ars_nouveau.whirlisprig", "Whirlisprig");
        this.add("ars_nouveau.page.crystallizer1", "The crystallizer provides a renewable source of Source Gems by condensing source over time. The Crystallizer can work passively at a very slow rate, or it may be given source from adjacent jars and create Source Gems as a much faster rate. The Crystallizer may also be accessed by Hoppers and Starbuncles.");
        this.add("tooltip.source_gem", "Obtained by placing lapis or amethyst in an Imbuement Chamber.");
        this.add("tooltip.magebloom", "Crafted using the Enchanting Apparatus");
        this.add("ars_nouveau.alert.turret_type", "Selected form cannot be used by a turret.");
        this.add("ars_nouveau.alert.spell_set", "Spell set.");
        this.add("ars_nouveau.alert.duplicate_method", "No duplicate cast forms are allowed.");
        this.add("ars_nouveau.relay.current_power", "Current Power: %d");
        this.add("ars_nouveau.relay.no_to", "No send location set.");
        this.add("ars_nouveau.relay.one_to", "Sending to %d location(s).");
        this.add("ars_nouveau.relay.no_from", "No take location set.");
        this.add("ars_nouveau.relay.one_from", "Taking from %d location(s).");
        this.add("ars_nouveau.rune.touch", "Runes must have Touch as their first glyph.");
        this.add("ars_nouveau.bookwyrm.strict_mode", "Strict mode set to %s");
        this.add("item.ars_nouveau.allow_scroll", "Item Scroll: Allow");
        this.add("item.ars_nouveau.deny_scroll", "Item Scroll: Deny");
        this.add("item.ars_nouveau.wixie_shards", "Wixie Token");
        this.add("item.ars_nouveau.wixie_charm", "Wixie Charm");
        this.add("block.ars_nouveau.wixie_cauldron", "Wixie Cauldron");
        this.add("ars_nouveau.rune.error", "Rune threw an error. Please report this! Bye rune!");
        this.add("item.ars_nouveau.blank_parchment", "Blank Parchment");
        this.add("ars_nouveau.scribe.item_added", "Item added.");
        this.add("ars_nouveau.scribe.item_removed", "Item removed.");
        this.add("ars_nouveau.allow_set", "Starbuncle will only take these items.");
        this.add("ars_nouveau.ignore_set", "Starbuncle will ignore these items.");
        this.add("block.ars_nouveau.volcanic_sourcelink", "Volcanic Sourcelink");
        this.add("ars_nouveau.spell.disabled", "This spell has been disabled in the config.");
        this.add("block.ars_nouveau.sourceberry_bush", "Sourceberry");
        this.add("ars_nouveau.connections.cleared", "Connections cleared.");
        this.add("ars_nouveau.connections.take", "Relay set to take from %s");
        this.add("ars_nouveau.connections.send", "Relay set to send to %s");
        this.add("item.minecraft.splash_potion.effect.mana_regen_potion_strong", "Splash Potion of Mana Regeneration");
        this.add("item.minecraft.splash_potion.effect.mana_regen_potion", "Splash Potion of Mana Regeneration");
        this.add("item.minecraft.splash_potion.effect.mana_regen_potion_long", "Splash Potion of Mana Regeneration");
        this.add("item.minecraft.potion.effect.mana_regen_potion_strong", "Potion of Mana Regeneration");
        this.add("item.minecraft.potion.effect.mana_regen_potion", "Potion of Mana Regeneration");
        this.add("item.minecraft.potion.effect.mana_regen_potion_long", "Potion of Mana Regeneration");
        this.add("item.minecraft.lingering_potion.effect.mana_regen_potion_strong", "Lingering Potion of Mana Regeneration");
        this.add("item.minecraft.lingering_potion.effect.mana_regen_potion", "Lingering Potion of Mana Regeneration");
        this.add("item.minecraft.lingering_potion.effect.mana_regen_potion_long", "Lingering Potion of Mana Regeneration");
        this.add("item.minecraft.tipped_arrow.effect.mana_regen_potion_strong", "Arrow of Mana Regeneration");
        this.add("item.minecraft.tipped_arrow.effect.mana_regen_potion", "Arrow of Mana Regeneration");
        this.add("item.minecraft.tipped_arrow.effect.mana_regen_potion_long", "Arrow of Mana Regeneration");
        this.add("effect.ars_nouveau.mana_regen", "Mana Regeneration");
        this.add("effect.ars_nouveau.mana_regen.desc", "Improves mana regeneration");
        this.add("effect.ars_nouveau.looting", "Drygmy's Blessing");
        this.add("effect.ars_nouveau.looting.desc", "Increases the amount of loot dropped by mobs");
        this.add("ars_nouveau.on", "Active: Yes");
        this.add("ars_nouveau.off", "Active: No");
        this.add("item.ars_nouveau.void_jar", "Jar of Voiding");
        this.add("ars_nouveau.rune.setperm", "This rune is now permanent.");
        this.add("ars_nouveau.page.void_jar", "A jar that can destroy items on pickup and grants a small amount of mana in return. To turn the jar on and off, use the jar while sneaking. To add or remove an item to be destroyed by the jar, use the jar with an item in the off hand, or use an item on the Scribes Table with the jar placed on it. The jar must be in your hotbar to function.");
        this.add("ars_nouveau.page.runic_chalk", "Runic chalk can be used to place permanent Runes on the ground that will cast spells on entities that walk over them. To give a rune a spell, inscribe spell parchment using the scribes table. Once the rune has cast the spell, it will become uncharged. An uncharged rune will charge itself from nearby source jars. Using Runic Chalk on a temporary rune will convert it to a permanent one. Using an essence on the rune will change its pattern.");
        this.add("ars_nouveau.wand.invalid", "Invalid spell. Wands accept Effects and Augments only.");
        this.add("ars_nouveau.gauntlet.invalid", "Invalid spell. Gauntlets accept Effects and Augments only.");
        this.add("item.ars_nouveau.wand", "Enchanter's Wand");
        this.add("ars_nouveau.wixie.has_wixie", "This cauldron already has a wixie.");
        this.add("ars_nouveau.wixie.no_recipe", "No recipes found.");
        this.add("ars_nouveau.wixie.recipe_set", "Place pedestals nearby for recipes to craft.");
        this.add("tooltip.wixie_shard", "Obtained by using Dispel on a witch while it is less than half health.");
        this.add("tooltip.starbuncle_shard", "Obtained by giving a wild Starbuncle a Gold Nugget.");
        this.add("tooltip.whirlisprig_shard", "Obtained by growing a tree near a wild Whirlisprig.");
        this.add("entity.ars_nouveau.wixie", "Wixie");
        this.add("block.ars_nouveau.creative_source_jar", "Creative Source Jar");
        this.add("block.ars_nouveau.purple_archwood_log", "Vexing Archwood Log");
        this.add("block.ars_nouveau.blue_archwood_log", "Cascading Archwood Log");
        this.add("block.ars_nouveau.green_archwood_log", "Flourishing Archwood Log");
        this.add("block.ars_nouveau.red_archwood_log", "Blazing Archwood Log");
        this.add("block.ars_nouveau.purple_archwood_sapling", "Vexing Archwood Sapling");
        this.add("block.ars_nouveau.blue_archwood_sapling", "Cascading Archwood Sapling");
        this.add("block.ars_nouveau.green_archwood_sapling", "Flourishing Archwood Sapling");
        this.add("block.ars_nouveau.red_archwood_sapling", "Blazing Archwood Sapling");
        this.add("block.ars_nouveau.purple_archwood_leaves", "Vexing Archwood Leaves");
        this.add("block.ars_nouveau.blue_archwood_leaves", "Cascading Archwood Leaves");
        this.add("block.ars_nouveau.green_archwood_leaves", "Flourishing Archwood Leaves");
        this.add("block.ars_nouveau.red_archwood_leaves", "Blazing Archwood Leaves");
        this.add("block.ars_nouveau.archwood_planks", "Archwood Planks");
        this.add("ars_nouveau.page.wand", "Wands accept only a single spell, and are inscribed using the Scribes Table. A Wand always starts with Projectile -> Accelerate, and MUST be inscribed with a spell that does not have another form. This allows you to cast spells beyond the 10 spell cap. If you want a wand that casts Break, inscribe the wand with JUST break, and your result will be a wand with Projectile -> Acclerate -> Break.");
        this.add("ars_nouveau.starbuncle.cleared", "Tasks cleared.");
        this.add("block.ars_nouveau.red_archwood_wood", "Blazing Archwood Wood");
        this.add("block.ars_nouveau.green_archwood_wood", "Flourishing Archwood Wood");
        this.add("block.ars_nouveau.purple_archwood_wood", "Vexing Archwood Wood");
        this.add("block.ars_nouveau.blue_archwood_wood", "Cascading Archwood Wood");
        this.add("ars_nouveau.connections.fail", "Too far away.");
        this.add("block.ars_nouveau.archwood_slab", "Archwood Slab");
        this.add("block.ars_nouveau.archwood_fence", "Archwood Fence");
        this.add("block.ars_nouveau.archwood_fence_gate", "Archwood Fence Gate");
        this.add("block.ars_nouveau.archwood_trapdoor", "Archwood Trapdoor");
        this.add("block.ars_nouveau.archwood_pressure_plate", "Archwood Pressure Plate");
        this.add("block.ars_nouveau.archwood_door", "Archwood Door");
        this.add("block.ars_nouveau.stripped_blue_archwood_log", "Stripped Cascading Archwood Log");
        this.add("block.ars_nouveau.stripped_blue_archwood_wood", "Stripped Cascading Archwood Wood");
        this.add("block.ars_nouveau.stripped_red_archwood_log", "Stripped Blazing Archwood Log");
        this.add("block.ars_nouveau.stripped_red_archwood_wood", "Stripped Blazing Archwood Wood");
        this.add("block.ars_nouveau.stripped_green_archwood_log", "Stripped Flourishing Archwood Log");
        this.add("block.ars_nouveau.stripped_green_archwood_wood", "Stripped Flourishing Archwood Wood");
        this.add("block.ars_nouveau.stripped_purple_archwood_log", "Stripped Vexing Archwood Log");
        this.add("block.ars_nouveau.stripped_purple_archwood_wood", "Stripped Vexing Archwood Wood");
        this.add("block.ars_nouveau.archwood_stairs", "Archwood Stairs");
        this.add("block.ars_nouveau.archwood_button", "Archwood Button");
        this.add("block.ars_nouveau.source_gem_block", "Source Gem Block");
        this.add("item.ars_nouveau.spell_bow", "Enchanter's Bow");
        this.add("item.ars_nouveau.split_arrow", "Augment Arrow: Split");
        this.add("item.ars_nouveau.amplify_arrow", "Augment Arrow: Amplify");
        this.add("item.ars_nouveau.pierce_arrow", "Augment Arrow: Pierce");
        this.add("ars_nouveau.page1.spell_bow", "A bow that can be inscribed with a spell using the Scribes Table. If the player has enough mana, arrows will become Spell Arrows and will apply the spell on their target. If no arrows are in the inventory, a spell arrow that deals 0 damage will be cast. If there is not enough mana, regular arrows will be fired. Enchanter's Bows may use special Augment Arrows for empowering the inscribed spell.");
        this.add("ars_nouveau.page.amplify_arrow", "Adds two amplifies to the end of the inscribed spell when used. Each recipe makes 32.");
        this.add("ars_nouveau.page.pierce_arrow", "Adds two pierce to the beginning of the chain. Each recipe makes 32.");
        this.add("ars_nouveau.page.split_arrow", "Adds two split to the beginning of the chain. If a spell arrow will deal damage, each split arrow will as well. Each recipe makes 32.");
        this.add("ars_nouveau.bow.invalid", "This tool may only accept spells that do not contain a form.");
        this.add("ars_nouveau.norecipe", "No recipe found.");
        this.add("ars_nouveau.apparatus.nomana", "Not enough source nearby.");
        this.add("ars_nouveau.reset.cleared", "Progress cleared.");
        this.add("effect.ars_nouveau.summoning_sickness", "Summoning Sickness");
        this.add("effect.ars_nouveau.summoning_sickness.desc", "Prevents summoning for a short duration.");
        this.add("entity.ars_nouveau.wilden_guardian", "Wilden Defender");
        this.add("entity.ars_nouveau.wilden_stalker", "Wilden Stalker");
        this.add("entity.ars_nouveau.wilden_hunter", "Wilden Hunter");
        this.add("item.ars_nouveau.wilden_spike", "Wilden Spike");
        this.add("item.ars_nouveau.wilden_horn", "Wilden Horn");
        this.add("item.ars_nouveau.wilden_wing", "Wilden Wing");
        this.add("tooltip.wilden_spike", "Drops from Wilden Defenders, found in Wilden Dens in cold biomes, or by using a Tablet of Summon Wilden.");
        this.add("tooltip.wilden_wing", "Drops from Wilden Stalkers found in Wilden Dens, or by using a Tablet of Summon Wilden.");
        this.add("tooltip.wilden_horn", "Drops from Wilden Pack Hunters found in Wilden Dens, or by using a Tablet of Summon Wilden.");
        this.add("entity.ars_nouveau.summon_wolf", "Summoned Wolf");
        this.add("tooltip.worn_notebook", "Documentation for Ars Nouveau");
        this.add("effect.ars_nouveau.shocked", "Shocked");
        this.add("effect.ars_nouveau.shocked.desc", "Increases the damage taken from lightning damage.");
        this.add("ars_nouveau.flask.charges", "Charges: %d");
        this.add("item.ars_nouveau.potion_flask", "Potion Flask");
        this.add("ars_nouveau.glyph_of", "Glyph of %s");
        this.add("ars_nouveau.thread_of", "Thread of %s");
        this.add("ars_nouveau.book.name", "Worn Notebook");
        this.add("ars_nouveau.book.landing_text", "Ars Nouveau provides spell crafting, magical devices, powerful trinkets, and magical entity automation. To help  development or report issues, join the community: https://discord.gg/y7TMXZu Thank you for playing.");
        this.add("ars_nouveau.spell_tier", "Tier: %s");
        this.add("ars_nouveau.spell_tier.1", "ONE");
        this.add("ars_nouveau.spell_tier.2", "TWO");
        this.add("ars_nouveau.spell_tier.3", "THREE");
        this.add("ars_nouveau.mana_cost.none", "None");
        this.add("ars_nouveau.mana_cost.low", "Low");
        this.add("ars_nouveau.mana_cost.medium", "Medium");
        this.add("ars_nouveau.mana_cost.high", "High");
        this.add("ars_nouveau.spell_book.copied", "Copied %d new glyphs to the book.");
        this.add("ars_nouveau.spell_book.create_mode", "Create Mode");
        this.add("ars_nouveau.spell_book.select", "Press %s to quick select");
        this.add("ars_nouveau.spell_book.craft", "Press %s to quick craft");
        this.add("ars_nouveau.spell_book_gui.spell_name", "Spell Name");
        this.add("ars_nouveau.spell_book_gui.search", "Search");
        this.add("ars_nouveau.spell_book_gui.form", "Form");
        this.add("ars_nouveau.spell_book_gui.effect", "Effect");
        this.add("ars_nouveau.spell_book_gui.augment", "Augment");
        this.add("ars_nouveau.spell_book_gui.create", "Create");
        this.add("ars_nouveau.spell_book_gui.clear", "Clear");
        this.add("ars_nouveau.color_gui.red_slider", "Red: %s");
        this.add("ars_nouveau.color_gui.green_slider", "Green: %s");
        this.add("ars_nouveau.color_gui.blue_slider", "Blue: %s");
        this.add("ars_nouveau.color_gui.title", "Spell Color");
        this.add("ars_nouveau.color_gui.presets", "Presets");
        this.add("ars_nouveau.color_gui.default", "Default");
        this.add("ars_nouveau.color_gui.purple", "Purple");
        this.add("ars_nouveau.color_gui.blue", "Blue");
        this.add("ars_nouveau.color_gui.light_blue", "Light Blue");
        this.add("ars_nouveau.color_gui.red", "Red");
        this.add("ars_nouveau.color_gui.green", "Green");
        this.add("ars_nouveau.color_gui.yellow", "Yellow");
        this.add("ars_nouveau.color_gui.white", "White");
        this.add("ars_nouveau.color_gui.orange", "Orange");
        this.add("ars_nouveau.color_gui.cyan", "Cyan");
        this.add("ars_nouveau.color_gui.pink", "Pink");
        this.add("ars_nouveau.color_gui.lime", "Lime");
        this.add("ars_nouveau.color_gui.gray", "Gray");
        this.add("ars_nouveau.color_gui.light_gray", "Light Gray");
        this.add("ars_nouveau.color_gui.magenta", "Magenta");
        this.add("ars_nouveau.color_gui.brown", "Brown");
        this.add("ars_nouveau.color_gui.black", "Black");
        this.add("ars_nouveau.color_gui.save", "Save");
        this.add("ars_nouveau.color_gui.save_all", "Save All");
        this.add("ars_nouveau.dominion_wand.clear", "Clear");
        this.add("ars_nouveau.dominion_wand.normal", "Normal Mode");
        this.add("ars_nouveau.dominion_wand.strict", "Strict Mode");
        this.add("ars_nouveau.dominion_wand.stored_entity", "Stored entity");
        this.add("ars_nouveau.dominion_wand.position_set", "Position set.");
        this.add("ars_nouveau.dominion_wand.no_entity", "No entity set");
        this.add("ars_nouveau.dominion_wand.entity_stored", "Entity stored.");
        this.add("ars_nouveau.dominion_wand.no_location", "No location set.");
        this.add("ars_nouveau.dominion_wand.position_stored", "Stored: %s");
        this.add("ars_nouveau.position", "X: %1$d Y: %2$d Z: %3$d");
        this.add("ars_nouveau.global_position", "X: %1$d Y: %2$d Z: %3$d in %4$s");
        this.add("ars_nouveau.spell_arrow.desc", "Augments spells when used with an Enchanter's Bow.");
        this.add("ars_nouveau.spell_parchment.no_spell", "Set your spell book to a spell.");
        this.add("ars_nouveau.spell_parchment.inscribed", "Spell inscribed.");
        this.add("ars_nouveau.warp_scroll.wrong_dim", "Using this scroll from a different dimension would be a bad idea.");
        this.add("ars_nouveau.warp_scroll.inv_full", "There is no room in your inventory.");
        this.add("ars_nouveau.warp_scroll.recorded", "You record your location to your Warp Scroll.");
        this.add("ars_nouveau.warp_scroll.no_location", "Use while sneaking to set a location.");
        this.add("ars_nouveau.wand.spell_invalid", "Invalid Spell.");
        this.add("ars_nouveau.drygmy.blacklist", "Drygmy Blacklisted");
        this.add("ars_nouveau.drygmy.only_use_jars", "Only Using Containment Jars");
        this.add("ars_nouveau.starbuncle.store", "Starbuncle will store items here.");
        this.add("ars_nouveau.starbuncle.take", "Starbuncle take from this inventory.");
        this.add("ars_nouveau.starbuncle.whitelist", "Whitelisted: ");
        this.add("ars_nouveau.starbuncle.blacklist", "Ignoring: ");
        this.add("ars_nouveau.starbuncle.storing", "Storing items at %d locations");
        this.add("ars_nouveau.starbuncle.taking", "Taking items from %d locations");
        this.add("ars_nouveau.whirlisprig.ignore", "Whirlisprig will ignore these items");
        this.add("ars_nouveau.whirlisprig.ignore_list", "Ignoring: ");
        this.add("ars_nouveau.whirlisprig.tooltip_extremely_happy", "Extremely happy");
        this.add("ars_nouveau.whirlisprig.tooltip_very_happy", "Very happy");
        this.add("ars_nouveau.whirlisprig.tooltip_happy", "Happy");
        this.add("ars_nouveau.whirlisprig.tooltip_content", "Content");
        this.add("ars_nouveau.whirlisprig.tooltip_unhappy", "Very unhappy");
        this.add("ars_nouveau.whirlisprig.tooltip_mood", "Mood: ");
        this.add("ars_nouveau.source_jar.fullness", "%d%% full");
        this.add("ars_nouveau.spell_turret.casting", "Casting: ");
        this.add("ars_nouveau.wixie.crafting", "Crafting: ");
        this.add("ars_nouveau.wixie.need_mana", "Source needed.");
        this.add("ars_nouveau.wixie.needs", "Needs: ");
        this.add("ars_nouveau.wixie.needs_storage", "Needs: Storage for potion.");
        this.add("ars_nouveau.true", "true");
        this.add("ars_nouveau.false", "false");
        this.add("ars_nouveau.spell_hud.crafting_mode", "Crafting Mode");
        this.add("ars_nouveau.spell.validation.crafting.invalid", "There are problems with this spell.");
        this.add("ars_nouveau.spell.validation.crafting.invalid_glyphs", "One or more glyphs in this spell are invalid.");
        this.add("ars_nouveau.spell.validation.exists.non_empty_spell", "The spell may not be empty.");
        this.add("ars_nouveau.spell.validation.exists.max_one_cast_method", "The spell has an extra form glyph: %s");
        this.add("ars_nouveau.spell.validation.exists.starting_cast_method", "The spell does not start with a form glyph.");
        this.add("ars_nouveau.spell.validation.exists.action_augmentation_policy", "%s was augmented by %s too many times.");
        this.add("ars_nouveau.spell.validation.exists.action_augmentation_policy.zero", "%s may not be augmented by %s.");
        this.add("ars_nouveau.spell.validation.exists.glyph_occurrences_policy", "%s appears too many times.");
        this.add("ars_nouveau.spell.validation.exists.glyph_occurrences_reset_policy", "%s appears too many times. Use Reset before another %s.");
        this.add("ars_nouveau.spell.validation.exists.augment_compatibility", "%s cannot be augmented by %s");
        this.add("ars_nouveau.spell.validation.exists.glyph_tier", "%s is too powerful for your current spell book.");
        this.add("ars_nouveau.spell.validation.exists.invalid_combination_policy", "%s cannot be used with %s");
        this.add("ars_nouveau.spell.validation.exists.invalid_combination_reset_policy", "Reset must be used to combine %s with %s");
        this.add("ars_nouveau.spell.validation.adding.non_empty_spell", "The spell may not be empty.");
        this.add("ars_nouveau.spell.validation.adding.max_one_cast_method", "The spell already has a form glyph.");
        this.add("ars_nouveau.spell.validation.adding.starting_cast_method", "The spell must start with a form glyph.");
        this.add("ars_nouveau.spell.validation.adding.action_augmentation_policy", "%s is already augmented to the limit by %s.");
        this.add("ars_nouveau.spell.validation.adding.action_augmentation_policy.zero", "%s may not be augmented by %s.");
        this.add("ars_nouveau.spell.validation.adding.glyph_occurrences_policy", "%s has appeared its maximum number of times.");
        this.add("ars_nouveau.spell.validation.adding.glyph_occurrences_reset_policy", "Reset must be used to add another. %s has appeared its maximum number of times.");
        this.add("ars_nouveau.spell.validation.adding.augment_compatibility", "%s cannot be augmented by %s");
        this.add("ars_nouveau.spell.validation.adding.invalid_combination_policy", "%s cannot be used with %s");
        this.add("ars_nouveau.spell.validation.adding.invalid_combination_reset_policy", "Reset must be used to combine %s with %s");
        this.add("ars_nouveau.spell.validation.adding.glyph_tier", "%s is too powerful for your current spell book.");
        this.add("ars_nouveau.spell.no_mana", "Not enough Mana.");
        this.add("block.ars_nouveau.potion_jar", "Potion Jar");
        this.add("block.ars_nouveau.potion_melder", "Potion Melder");
        this.add("item.ars_nouveau.potion_flask_extend_time", "Potion Flask: Extend Time");
        this.add("item.ars_nouveau.potion_flask_amplify", "Potion Flask: Amplify");
        this.add("tooltip.potion_flask_extend_time", "Increases the duration of potions by 50%.");
        this.add("tooltip.potion_flask_amplify", "Increases the level of potions, but reduces their duration.");
        this.add("tooltip.potion_flask", "Holds 8 charges of potion.");
        this.add("tooltip.discount_item", "Reduce the cost of all spells by %d.");
        this.add("ars_nouveau.locked", "Locked");
        this.add("ars_nouveau.unlocked", "Unlocked");
        this.add("ars_nouveau.page5.wixie_charm", "Wixies will autocraft potions using nearby Potion Jars and items. Potions that require Water will be supplied by the Wixie. Potions that require another potion as a base will be taken from nearby Potion Jars. A Wixie will output 3 doses of a Potion into a nearby Potion Jar when complete. To begin, place down an empty Potion Jar, right click the cauldron with an Awkward Potion, and supply Nether Wart from a nearby chest.");
        this.add("ars_nouveau.page6.wixie_charm", "When using multiple Wixies, you may wish to lock a jar to a specific potion. Wixies will only output potion to jars that contain the same potion, or an unlocked empty potion. Each craft costs Source. See the section on the Potion Jar for more information.");
        this.add("entity.ars_nouveau.summon_horse", "Summoned Horse");
        this.add("block.ars_nouveau.sconce", "Gold Sconce");
        this.add("block.ars_nouveau.archwood_sconce", "Archwood Sconce");
        this.add("block.ars_nouveau.sourcestone_sconce", "Sourcestone Sconce");
        this.add("block.ars_nouveau.polished_sconce", "Polished Sourcestone Sconce");
        this.add("block.ars_nouveau.ritual_brazier", "Ritual Brazier");
        this.add("ars_nouveau.tooltip.consumed", "Items Consumed:");
        this.add("ars_nouveau.tooltip.waiting", "Awaiting Activation");
        this.add("ars_nouveau.tooltip.running", "Running");
        this.add("ars_nouveau.tooltip.conditions_unmet", "Conditions Unmet");
        this.add("ars_nouveau.tooltip.exp_gem", "Grants experience on use. Sneak to consume the entire stack.");
        this.add("ars_nouveau.tooltip.too_many_animals", "Too many animals nearby.");
        this.add("item.ars_nouveau.experience_gem", "Experience Gem");
        this.add("item.ars_nouveau.greater_experience_gem", "Greater Experience Gem");
        this.add("effect.ars_nouveau.hex", "Hex");
        this.add("effect.ars_nouveau.hex.desc", "Increases the damage taken potion and non-player damage.");
        this.add("ars_nouveau.set_spell", "Set spell.");
        this.add("ars_nouveau.invalid_spell", "Invalid Spell");
        this.add("effect.ars_nouveau.scrying", "Scrying");
        this.add("effect.ars_nouveau.scrying.desc", "Reveals certain blocks around you.");
        this.add("ars_nouveau.tooltip.magebloom", "Grown from seeds crafted using the Enchanting Apparatus.");
        this.add("ars_nouveau.tooltip.dull", "A dull trinket, cannot be worn. Used for crafting.");
        this.add("ars_nouveau.sword.invalid", "Invalid spell. Swords accept Effects and Augments only, such as Freeze -> Extend Time.");
        this.add("item.ars_nouveau.enchanters_sword", "Enchanter's Sword");
        this.add("item.ars_nouveau.enchanters_shield", "Enchanter's Shield");
        this.add("ars_nouveau.page.enchanters_sword", "Applies a Touch spell before damaging an entity. Additionally, all spells gain Spell Damage. Apply a spell at the Scribes Table that does NOT contain a form, such as Ignite -> Extend Time.");
        this.add("ars_nouveau.page.enchanters_shield", "Upon blocking damage, the user will gain a short duration of Mana Regeneration and Spell Damage. Additionally, this shield will repair over time using the wearers mana.");
        this.add("ars_nouveau.tooltip.can_inscribe", "Can be inscribed with a spell at the Scribes Table.");
        this.add("biome.ars_nouveau.archwood_forest", "Archwood Forest");
        this.add("ars_nouveau.tooltip.turned_off", "Turned off");
        this.add("effect.ars_nouveau.glide", "Glide");
        this.add("effect.ars_nouveau.glide.desc", "Allows the player to glide as if wearing an Elytra.");
        this.add("effect.ars_nouveau.snared", "Snared");
        this.add("effect.ars_nouveau.snared.desc", "Prevents the entity from moving.");
        this.add("item.ars_nouveau.starbuncle_se", "Starbuncle Spawn Egg");
        this.add("item.ars_nouveau.drygmy_se", "Drygmy Spawn Egg");
        this.add("item.ars_nouveau.whirlisprig_se", "Whirlisprig Spawn Egg");
        this.add("item.ars_nouveau.wilden_hunter_se", "Wilden Hunter Spawn Egg");
        this.add("item.ars_nouveau.wilden_guardian_se", "Wilden Guardian Spawn Egg");
        this.add("item.ars_nouveau.wilden_stalker_se", "Wilden Stalker Spawn Egg");
        this.add("item.ars_nouveau.alakarkinos_se", "Alakarkinos Spawn Egg");
        this.add("tooltip.ars_nouveau.caster_tome", "Casts a spell at half the cost or the users entire mana bar, whichever is smaller.");
        this.add("item.ars_nouveau.caster_tome", "Caster Tome");
        this.add("tooltip.ars_nouveau.glyph_disabled", "Disabled. Cannot be used.");
        this.add("tooltip.ars_nouveau.glyph_level", "A tier %s glyph.");
        this.add("tooltip.ars_nouveau.caster_level", "Can cast tier %s glyphs or lower.");
        this.add("tooltip.ars_nouveau.hold_shift", "Hold %s for more info.");
        this.add("item.ars_nouveau.drygmy_shard", "Drygmy Token");
        this.add("item.ars_nouveau.drygmy_charm", "Drygmy Charm");
        this.add("block.ars_nouveau.drygmy_stone", "Drygmy Henge");
        this.add("tooltip.ars_nouveau.drygmy_shard", "Obtained by giving a Drygmy a Wilden Horn.");
        this.add("entity.ars_nouveau.drygmy", "Drygmy");
        this.add("effect.ars_nouveau.flight", "Flight");
        this.add("effect.ars_nouveau.flight.desc", "Allows the player to fly.");
        this.add("effect.ars_nouveau.gravity", "Gravity");
        this.add("effect.ars_nouveau.gravity.desc", "Causes the entity to rapidly fall.");
        this.add("tooltip.ars_nouveau.tablet", "A tablet used for rituals. Consumed on use.");
        this.add("ars_nouveau.enchanting.bad_level", "This item must have the previous level of enchantment.");
        this.add("ars_nouveau.enchanting.incompatible", "This enchantment is incompatible with this item.");
        this.add("entity.ars_nouveau.wilden_boss", "Wilden Chimera");
        this.add("ars_nouveau.chimera.rage", "The chimera begins raging.");
        this.add("entity.ars_nouveau.spike", "Chimera Spike");
        this.add("tooltip.ars_nouveau.wilden_tribute", "Obtained by defeating the Wilden Chimera. See Ritual of Summon Wilden.");
        this.add("item.ars_nouveau.wilden_tribute", "Wilden Tribute");
        this.add("item.ars_nouveau.mimic_scroll", "Mimic Scroll");
        this.add("tooltip.ars_nouveau.spell_damage", "Spell Damage: %s");
        this.add("tooltip.ars_nouveau.duration_modifier", "Duration Modifier: %s");
        this.add("tooltip.ars_nouveau.amp_modifier", "Amplification Modifier: %s");
        this.add("item.ars_nouveau.summon_focus", "Focus of Summoning");
        this.add("tooltip.ars_nouveau.summon_focus", "Increases the duration and power of your summons.");
        this.add("curios.identifier.an_focus", "Spell Focus");
        this.add("ars_nouveau.school.manipulation", "Manipulation");
        this.add("ars_nouveau.school.abjuration", "Abjuration");
        this.add("ars_nouveau.school.conjuration", "Conjuration");
        this.add("ars_nouveau.school.air", "Elemental Air");
        this.add("ars_nouveau.school.earth", "Elemental Earth");
        this.add("ars_nouveau.school.fire", "Elemental Fire");
        this.add("ars_nouveau.school.water", "Elemental Water");
        this.add("ars_nouveau.spell_set", "Spell set.");
        this.add("block.ars_nouveau.vitalic_sourcelink", "Vitalic Sourcelink");
        this.add("block.ars_nouveau.alchemical_sourcelink", "Alchemical Sourcelink");
        this.add("ars_nouveau.page1.armor", "Magical robes will increase the wearers mana regen and can be upgraded with special abilities using Threads. The Sorceror's set provides the lowest defence, but provides the most powerful set of slots for Threads. The Arcanist's and Battlemage's sets provide increasingly more defence, but fewer and less powerful Thread Slots. For more information on Threads, see the section on Armor and Perks.");
        this.add("ars_nouveau.page.potion_jar", "A jar that stores up to 100 potions. Potion can be removed by using an Empty Bottle, Potion Flask, or Arrows on the jar. Wixies will use these jars during Potion Autocrafting. The jar may be locked by using a Dominion Wand while sneaking. Locked Jars will only receive the potion it is locked to from Wixies. Can be used with a Comparator.");
        this.add("ars_nouveau.glyph_crafting", "Glyph Crafting");
        this.add("ars_nouveau.page1.scribes_table", "To craft new glyphs, use a spell book on the table to open the codex. Each glyph requires a set of items and experience points to unlock. Select a glyph by clicking on it in the menu, and hit select. Throw the items onto the table as rendered above, and the table will scribe a new glyph. The table will also pull items from nearby inventories. Using the dominion wand on the table will disable auto-pull.");
        this.add("ars_nouveau.page2.scribes_table", "You may also inscribe a spell onto Spell Parchment or Enchanters Items. To do this, place a Blank Parchment on the table. Then, with your spell book in hand, change your spell book to your desired spell as if you were going to cast it. Then, use the book on the table while sneaking. Your item will now contain that spell. Using Manipulation Essence will permanently hide the scribed spell.");
        this.add("ars_nouveau.page1.wilden", "Wilden are hostile creatures that can be commonly found at night around Wilden Dens. While Wilden Defenders may only be found in cold biomes, Stalker and Hunter Dens can be found in any forest biome.");
        this.add("ars_nouveau.page3.wilden", "An aggressive and fast hunter that can summon allied wolves.");
        this.add("ars_nouveau.page4.wilden", "Generally spawning in small groups, Stalkers have ground and aerial attacks.");
        this.add("ars_nouveau.page5.wilden", "Found in cold biomes, a Defender is a slow moving heavy hitter with a ranged attack.");
        this.add("ars_nouveau.page6.wilden", "Summoned with a Ritual of Wilden Tribute, the chimera is a powerful and destructive mid-level boss.");
        this.add("ars_nouveau.page7.wilden", "The Chimera is a worthy fight for a caster with Tier 2 spells and equipment. The Chimera resists cold damage, and a variety of spells including buffs, dispel, and mobility are suggested.");
        this.add("ars_nouveau.page1.allow_scroll", "Provides a list of items to automation related entities. To inscribe an item, place on the Scribes Table and use blocks and items on the table while sneaking. When given to a Starbuncle, the Starbuncle will only pickup and take items on the scroll.");
        this.add("ars_nouveau.page1.deny_scroll", "Provides a list of items to automation related entities. To inscribe an item, place on the Scribes Table and use blocks and items on the table while sneaking. When given to a Starbuncle, the Starbuncle will pickup and take any item that is NOT on this scroll.");
        this.add("ars_nouveau.page1.mimic_scroll", "Provides a list of items to automation related entities. When this scroll is attached to an inventory, entities will only insert items that already exist in the inventory. To attach the scroll, place an item frame on the inventory, and place a Mimic Scroll in it.");
        this.add("block.ars_nouveau.mycelial_sourcelink", "Mycelial Sourcelink");
        this.add("item.ars_nouveau.source_berry_pie", "Source Berry Pie");
        this.add("item.ars_nouveau.source_berry_roll", "Source Berry Roll");
        this.add("tooltip.ars_nouveau.source_food", "Grants mana regeneration when consumed.");
        this.add("block.ars_nouveau.relay_warp", "Source Relay: Warper");
        this.add("block.ars_nouveau.relay_deposit", "Source Relay: Depositor");
        this.add("ars_nouveau.page.relay_deposit", "Operates similar to the Source Relay, but will deposit to jars it is not linked to within 5 blocks. See the instructions on the Source Relay for use.");
        this.add("ars_nouveau.page.relay_warp", "Operates similar to the Source Relay: Splitter but can teleport source an endless distance between other Warp relays. For distances beyond 30 blocks, there is a chance that some source will be lost during warp.");
        this.add("item.minecraft.splash_potion.effect.spell_damage_potion_strong", "Splash Potion of Spell Damage");
        this.add("item.minecraft.splash_potion.effect.spell_damage_potion", "Splash Potion of Spell Damage");
        this.add("item.minecraft.splash_potion.effect.spell_damage_potion_long", "Splash Potion of Spell Damage");
        this.add("item.minecraft.potion.effect.spell_damage_potion_strong", "Potion of Spell Damage");
        this.add("item.minecraft.potion.effect.spell_damage_potion", "Potion of Spell Damage");
        this.add("item.minecraft.potion.effect.spell_damage_potion_long", "Potion of Spell Damage");
        this.add("item.minecraft.lingering_potion.effect.spell_damage_potion_strong", "Lingering Potion of Spell Damage");
        this.add("item.minecraft.lingering_potion.effect.spell_damage_potion", "Lingering Potion of Spell Damage");
        this.add("item.minecraft.lingering_potion.effect.spell_damage_potion_long", "Lingering Potion of Spell Damage");
        this.add("item.minecraft.tipped_arrow.effect.spell_damage_potion_strong", "Arrow of Spell Damage");
        this.add("item.minecraft.tipped_arrow.effect.spell_damage_potion", "Arrow of Spell Damage");
        this.add("item.minecraft.tipped_arrow.effect.spell_damage_potion_long", "Arrow of Spell Damage");
        this.add("effect.ars_nouveau.spell_damage", "Spell Damage");
        this.add("effect.ars_nouveau.spell_damage.desc", "Increases the damage dealt by spells.");
        this.add("ars_nouveau.spell_book_gui.familiar", "Familiars");
        this.add("ars_nouveau.spell_book_gui.close", "Close");
        this.add("ars_nouveau.gui.notebook", "Documentation");
        this.add("ars_nouveau.gui.color", "Color Picker");
        this.add("ars_nouveau.gui.familiar", "Familiars");
        this.add("ars_nouveau.category.familiars", "Familiars can provide passive buffs and assistance in combat. For more information, see the section on Summoning a Familiar.");
        this.add("ars_nouveau.familiar.owned", "You already own this familiar.");
        this.add("ars_nouveau.familiar.unlocked", "Familiar unlocked.");
        this.add("ars_nouveau.familiar.script", "Used for obtaining familiars. Obtained from the Ritual of Binding.");
        this.add("ars_nouveau.schools", "Schools: ");
        this.add("entity.ars_nouveau.familiar_bookwyrm", "Bookwyrm Familiar");
        this.add("entity.ars_nouveau.familiar_starbuncle", "Starbuncle Familiar");
        this.add("entity.ars_nouveau.familiar_whirlisprig", "Whirlisprig Familiar");
        this.add("entity.ars_nouveau.familiar_wixie", "Wixie Familiar");
        this.add("entity.ars_nouveau.familiar_drygmy", "Drygmy Familiar");
        this.add("entity.ars_nouveau.familiar_amethyst_golem", "Amethyst Golem Familiar");
        this.add("ars_nouveau.mirror.invalid", "Invalid spell. Mirrors accept Effects and Augments only.");
        this.add("item.ars_nouveau.enchanters_mirror", "Enchanter's Mirror");
        this.add("ars_nouveau.page.enchanters_mirror", "Applies a self spell to the user. Spells cast with this mirror are discounted and gain additional bonus duration to all glyphs. Apply a spell at the Scribe's table that DOES NOT contain a form such as Heal -> Amplify.");
        this.add("block.ars_nouveau.bookwyrm_lectern", "Bookwyrm Lectern");
        this.add("ars_nouveau.seconds", "%s seconds");
        this.add("block.ars_nouveau.basic_spell_turret", "Basic Spell Turret");
        this.add("block.ars_nouveau.spell_turret", "Enchanted Spell Turret");
        this.add("block.ars_nouveau.timer_spell_turret", "Timer Spell Turret");
        this.add("block.ars_nouveau.rotating_spell_turret", "Adjustable Spell Turret");
        this.add("effect.ars_nouveau.bounce", "Bounce");
        this.add("effect.ars_nouveau.bounce.desc", "Causes the entity to bounce off of surfaces.");
        this.add("ars_nouveau.starbuncle.path", "Starbuncle will prefer to path on this block if it is on their way.");
        this.add("ars_nouveau.starbuncle.pathing", "Preferring to path on %s");
        this.add("ars_nouveau.summoning", "Summoning");
        this.add("ars_nouveau.item_transport", "Item Transport");
        this.add("ars_nouveau.filtering", "Filtering");
        this.add("ars_nouveau.filtering_with", "Filtering with: %s");
        this.add("ars_nouveau.filter_set", "Filter set.");
        this.add("ars_nouveau.pathing", "Pathing");
        this.add("block.ars_nouveau.archwood_chest", "Archwood Chest");
        this.add("block.ars_nouveau.spell_prism", "Spell Prism");
        this.add("ars_nouveau.page.spell_prism", "When a projectile spell hits this block, it is redirected the direction the block is facing. Spell Prisms will send a signal to nearby Observers if a spell is redirected.");
        this.add("ars_nouveau.weald_walker.home", "Guarding: %s");
        this.add("ars_nouveau.nothing", "Nothing");
        this.add("ars_nouveau.weald_walker", "Weald Walker");
        this.add("entity.ars_nouveau.cascading_weald_walker", "Cascading Weald Walker");
        this.add("entity.ars_nouveau.flourishing_weald_walker", "Flourishing Weald Walker");
        this.add("entity.ars_nouveau.blazing_weald_walker", "Blazing Weald Walker");
        this.add("entity.ars_nouveau.vexing_weald_walker", "Vexing Weald Walker");
        this.add("ars_nouveau.page1.weald_walker", "Weald Walkers are living Archwood Trees that guard their homes against hostile monsters. A Weald Walker can be created from the Ritual of Awakening. When summoned, the Weald Walker will roam randomly unless given a home position. To give the Weald Walker a home, use the dominion wand on the Weald Walker, and then the block you wish it to guard.");
        this.add("ars_nouveau.page2.weald_walker", "Casts Flare at nearby enemies, careful not to ignite any blocks in the process.");
        this.add("ars_nouveau.page3.weald_walker", "Casts Freeze and Cold Snap at nearby enemies.");
        this.add("ars_nouveau.page4.weald_walker", "Casts an amplified Harm with a Snare effect at nearby enemies.");
        this.add("ars_nouveau.page5.weald_walker", "Casts Hex and an amplified Wither at nearby enemies.");
        this.add("ars_nouveau.page1.weald_waddler", "If a Weald Walker dies, it will be turned into a Weald Waddler. Weald Waddlers will slowly grow back into Weald Walkers, and can be sped up by giving them bonemeal. A Weald Waddler cannot fight or protect itself until it has grown back to a Walker.");
        this.add("ars_nouveau.source", "Source: %s");
        this.add("ars_nouveau.crush_recipe", "Crush Glyph");
        this.add("ars_nouveau.budding_conversion_recipe", "Amethyst Golem Conversion");
        this.add("ars_nouveau.scry_ritual_recipe", "Scry Ritual");
        this.add("ars_nouveau.alakarkinos_recipe", "Alakarkinos Conversion");
        this.add("ars_nouveau.alakarkinos_recipe.chance", "Chance: %s");
        this.add("ars_nouveau.enchanting_apparatus", "Enchanting Apparatus");
        this.add("ars_nouveau.armor_upgrade", "Magic Armor Upgrade");
        this.add("ars_nouveau.page.archwood", "Archwood Trees");
        this.add("ars_nouveau.page1.archwood", "Archwood Trees have a small chance to spawn in any biome, and come in four types. Rarely, you may stumble upon an Archwood Forest, a biome full of magical creatures, naturally spawning lights, and Archwood trees. Can be used as decoration, rituals, or for crafting wands. Archwood Trees also have a chance to spawn magical fruits that can be consumed or brewed into potions.");
        this.add("ars_nouveau.page.spell_casting", "1 - Spells");
        this.add("ars_nouveau.page1.spell_casting", "Ars Nouveau grants aspiring wizards the ability to craft powerful spells. Through creative spellcrafting, you can vanquish foes, reshape the world, automate tasks, create spectacles, and so much more!\nTo begin spellcasting, you will need to craft a Novice\u2019s Spell Book which will allow you to create, store, and cast spells using Mana.\nUpgrading your Spell Book, learning new Glyphs, and crafting magical equipment will further enhance your ability to cast new and more powerful spells.");
        this.add("ars_nouveau.page.introduction_to_glyphs", "2 - Glyphs");
        this.add("ars_nouveau.page1.introduction_to_glyphs", "Glyphs are the building blocks that make up spells. A spell\u2019s outcome is determined by which Glyphs are used and in what order they appear. They fall under three major categories: Forms, Effects, and Augments.\nForm Glyphs are the vessels that deliver the contents of a spell to the target. Every spell must begin with a Form, and only one Form may be present. Effect Glyphs determine what a spell will do once it reaches its target. Spells can contain multiple Effects and will resolve in the order they are placed during spellcrafting.\nAugment Glyphs change the properties of the Form or Effect Glyph to their left as long as they are compatible. Multiple Augments may be chained together to modify the same Glyph. Augments have no effect on other Augments. Glyphs fall into tiers of I, II, or III. The Novice\u2019s Spell Book can only cast tier I Glyphs, but higher tiers will be available each time you upgrade your Spell Book.");
        this.add("ars_nouveau.page.introduction_to_spellcrafting", "3 - Spellcrafting");
        this.add("ars_nouveau.page1.introduction_to_spellcrafting", "Spellcrafting is accessed by pressing [C] while your Spell Book is selected on the inventory bar. Clicking Glyphs from the list will add them to the bottom of the page to represent they are part of the spell. Clicking Glyphs inside your spell will remove them.\nOnce satisfied, you may name the spell and click \u201cCreate\u201d to save it. Spell Books may hold up to ten spells at once as shown by the bookmarks on the right side of the book. Clicking one will swap the spell you are working on.");
        this.add("ars_nouveau.page.spellcasting", "4 - Spellcasting");
        this.add("ars_nouveau.page1.spellcasting", "To use a spell, select your Spell Book on the inventory bar and right-click to cast it.\nYour active spell is shown above your Mana bar. Press [X] to swap to your next spell and [Z] to swap your previous spell. Press [V] to open a radial menu that allows you to quickly swap between spells on your book. Each spell may also be hotkeyed individually via the Key Bind menu.\nIf the spell fails to cast, check to make sure that:\nYou have enough Mana to cast the spell.\nThe spell begins with a Form Glyph and has at least one Effect Glyph.\n");
        this.add("ars_nouveau.page.spell_mana", "5 - Mana");
        this.add("ars_nouveau.page1.spell_mana", "Casting a spell consumes your Mana based on the total cost of all the Glyphs that make up the spell. Your current Mana stores can be seen on the bar in the bottom left corner of your screen.\n\nExpended Mana will regenerate over time. Mana may also be consumed or reserved by other things such as magical items or familiars.\nEach new Glyph you learn will give a small permanent boost to your Mana\u2019s regeneration and maximum capacity. These boosts can also be gained by upgrading your spell book, equipping some pieces of magical gear, or drinking a Mana potion.");
        this.add("ars_nouveau.page.learning_glyphs", "6 - Learning Glyphs");
        this.add("ars_nouveau.page1.learning_glyphs", "New Glyphs may be created through the Scribe\u2019s Table from certain items and paying EXP. Once crafted, the Glyph can be consumed to learn it, making it available during spellcrafting.\nPlayers can share their current Glyph knowledge with each other by crafting an Annotated Codex.");
        this.add("ars_nouveau.page.important_resources", "7 - Important Resources");
        this.add("ars_nouveau.page1.important_resources", "It's recommended to keep stock of certain resources as they will be used in many crafting recipes.\nWhile exploring, look for Iron Ore, Gold Ore, Amethyst Shards (or Lapis Lazuli), Diamond, Sourceberries, and Archwood Logs.\nDowsing Rods can help with locating Budding Amethyst Blocks and magical creatures.");
        this.add("ars_nouveau.page.source", "8 - Source");
        this.add("ars_nouveau.page1.source", "Source is a magical resource used for many purposes such as speeding up the Imbuement Chamber, fueling devices, powering magical helpers, creating portals, or fueling powerful Enchanting Apparatus recipes.\nSourcelinks are specialized artifacts that can collect and concentrate Source from the world into Source Jars. Source Relays can be used to transfer Source over large distances between jars.\nThe Agronomic and Mycelial Sourcelinks are good early options for building up your Source supply.");
        this.add("ars_nouveau.page.magical_crafting", "9 - Magical Crafting");
        this.add("ars_nouveau.page1.magical_crafting", "The Imbuement Chamber allows the conversion of Amethyst Shards or Lapis Lazuli into Source Gems. By placing three Arcane Pedestals bearing certain items adjacent to the chamber, Source Gems can be imbued further into Essences which are used in many Glyph recipes.\nPlacing an Enchanting Apparatus on top of an Arcane Core allows the crafting of essentials such as Magebloom Seeds, magical equipment, and charms to summon magical helpers. It can also directly enchant your gear with enchantments of your choice.\nThe Alteration Table allows for slotting in various Threads into magical armor that grant special properties while worn.");
        this.add("ars_nouveau.page.magical_automation", "10 - Magical Automation");
        this.add("ars_nouveau.page1.magical_automation", "Ars Nouveau supports a wide variety of automation methods via Spell Turrets, magical helpers, and Rituals.\nUsing one or a combination of these options can achieve almost anything you want such as farming crops and trees, quarrying the earth, crafting and transporting items, smelting, and brewing potions.");
        this.add("ars_nouveau.page1.decorative", "Purely decorative blocks. To see the full list, place Arcane Stone in a Stonecutter.");
        this.add("ars_nouveau.wilden", "Wilden");
        this.add("ars_nouveau.page.decorative", "Decorative Blocks");
        this.add("ars_nouveau.page1.magelight_torch", "Decorative lights. To ignite, cast Light on the sconce. The color of the flame corresponds with your spell color. The Magelight Torch on a wall can change the direction of its flames by interacting. Use Touch or Projectile Sensitive to target the sconce.");
        this.add("ars_nouveau.page1.sourceberry_bush", "A Sourceberry Bush can be found in Taiga and Archwood Forest biomes, and produces Sourceberries. A Sourceberry can be used to craft a Potion of Mana Regeneration or consumed as food. Starbuncles will automatically harvest fully grown Source Berry Bushes, making them useful for early automation of the Agronomic Sourcelink. Sourceberry foods will also grant Mana Regeneration.");
        this.add("ars_nouveau.page.wilden", "Wilden");
        this.add("ars_nouveau.page.weald_walker", "Weald Walkers");
        this.add("ars_nouveau.spell_schools", "Spell Schools");
        this.add("ars_nouveau.casting_cost", "Casting Cost");
        this.add("ars_nouveau.tier", "Tier %s");
        this.add("ars_nouveau.page.agronomic_sourcelink", "The Agronomic Sourcelink generates source from crop and tree growth within 15 blocks. Bonus source is generated for magical plants such as Mageblooms, Source Berry Bushes, and Archwood Saplings. Source will be output from the Sourcelink to nearby jars within 5 blocks. Note: Bonemealing crops will not grant Source.");
        this.add("ars_nouveau.page.source_jar", "Source Jars store source gathered from nearby Sourcelinks. Source is used in rituals and automation by powering devices like the Imbuement Chamber and Enchanting Apparatus. Source may be moved using a Source Relay or by breaking and moving it. Devices will use source from nearby jars. Source Jars will provide a signal to comparators based on their level.");
        this.add("ars_nouveau.page1.volcanic_sourcelink", "The Volcanic Sourcelink generates Source by consuming burnable items. Archwood logs will generate bonus Source, with Blazing Archwood generating the most. As the Volcanic Sourcelink produces Source, it also produces heat, converting stone into magma blocks and then lava. The Volcanic Sourcelink automatically outputs to nearby jars, starting with the one closest to it.");
        this.add("ars_nouveau.page2.volcanic_sourcelink", "Nearby Blazing Archwood items will be burned up in exchange for a chunk of Source and a moderate amount of heat. The Volcanic Sourcelink will also take items from surrounding pedestals.");
        this.add("ars_nouveau.active_generation", "Active Generation");
        this.add("ars_nouveau.heat", "Heat");
        this.add("ars_nouveau.page.alchemical_sourcelink", "Generates source by consuming potions from adjacent potion jars. The amount of source varies per potion and is dependent on the complexity of the potion. Bonus source is given for the length and level of the potion with multipliers for each effect a potion contains. Utilizing Wixies and Potion Melders is recommended for creating highly complex potions.");
        this.add("ars_nouveau.page.vitalic_sourcelink", "Generates a moderate amount of source from nearby mob death and animal breeding. Additionally, the Vitalic Sourcelink will generate passive Source from nearby baby animals and will accelerate their growth.");
        this.add("ars_nouveau.page.mycelial_sourcelink", "Generates a moderate amount of source from nearby food, generating more for more nourishing food. Source Berry food is worth far more than other mundane foods. Additionally, the Mycelial Sourcelink will convert Grass or Dirt in the 3x3 below it into Mycelium and will grow mushrooms around it given that the space is empty. The Sourcelink will also pull items from nearby pedestals.");
        this.add("block.ars_nouveau.relay", "Source Relay");
        this.add("block.ars_nouveau.relay_splitter", "Source Relay: Splitter");
        this.add("block.ars_nouveau.whirlisprig_flower", "Whirlisprig Blossom");
        this.add("ars_nouveau.page.relay", "Enables the transport of source between Source Jars and other Source Relays. To pull source from jars, use the Dominion Wand on the jar, and then on the relay. To send between relays or from a relay to a jar, use the wand on the relay and then the target you wish to send source to. Relays may only reach up to 30 blocks away. To clear connections, sneak while using the Dominion Wand on the relay.");
        this.add("ars_nouveau.page.relay_splitter", "Operates similar to the Source Relay, but will support taking from and transferring to multiple jars at once. The splitter has a much larger through-put than the Source Relay, and will split this throughput amongst all of its jars. See the instructions on the Source Relay for use.");
        this.add("ars_nouveau.page1.enchanting_apparatus", "The Enchanting Apparatus utilizes pedestals and Source for crafting. To use the Enchanting Apparatus, place any number of Arcane Pedestals within 3 blocks with their items. Once you have filled the pedestals, use the middle item on the Enchanting Apparatus block. The Enchanting Apparatus requires an Arcane Core next to its base in order to work.");
        this.add("ars_nouveau.page1.imbuement_chamber", "Imbues items with Source to create new items. The primary way to obtain Source Gems, amethyst and lapis may be used to create Source Gems. The Imbuement Chamber will passively accumulate source for recipes, or will draw from Source Jars 2 block away. Some recipes require additional items placed in pedestals within 1 block of the Imbuement Chamber, such as Essences. Items in pedestals will not be consumed.");
        this.add("ars_nouveau.page.potion_melder", "Converts three doses of a potion from two Potion Jars and outputs a potion with the combined effects. Use the Dominion Wand from a Potion Jar to Melder to link a jar for consumption. Link two input potion jars to the melder. Then, use the wand on the Melder and then to a third jar to set the output. The Potion Melder requires source per mix.");
        this.add("ars_nouveau.page.warp_portal", "Warp Portals");
        this.add("ars_nouveau.page1.warp_portal", "Warp portals, like warp scrolls, provide a one-way teleport to any location, provided it is in the same dimension. To construct a Warp Portal, build a frame from Sourcestone or its variants in the shape of a rectangle and provide a full Source Jar nearby. Then, throw a warp scroll with a written location into the frame. Given there is enough source nearby, the portal will be created.");
        this.add("ars_nouveau.page2.warp_portal", "Portals can be built horizontal or vertical, from 1x1 to 21x21 in size. Warping does not cost any source after creation. Using a Dominion Wand on the portal will change the texture of the portal.");
        this.add("ars_nouveau.page3.warp_portal", "Warp Portal");
        this.add("ars_nouveau.page4.warp_portal", "A magical portal that can send players, mobs, spells, and items to any location in the same dimension.");
        this.add("ars_nouveau.page.ritual_brazier", "A brazier that may be used as decoration or for performing rituals. To light the brazier for decoration, cast a Light spell on the brazier. The color of the brazier corresponds with the color of the spell. Applying a redstone signal will disable a running ritual. For information on performing rituals, see the dedicated section on rituals.");
        this.add("ars_nouveau.page1.basic_spell_turret", "Turrets can be used to cast spells when given a redstone signal, functioning like a dispenser. Turrets will accept spells that use Touch and Projectile. Spells may be set using an inscribed piece of Spell Parchment. In order to cast spells, turrets will draw source from nearby Source Jars. Turrets may use Item Pickup and Place Block as long as an inventory is placed adjacent to this block.");
        this.add("ars_nouveau.page2.basic_spell_turret", "Enchanted Spell Turrets cast spells at half the source cost compared to basic spell turrets.");
        this.add("ars_nouveau.page3.basic_spell_turret", "Timer Spell Turrets will automatically fire on a timer. Defaulted to 1 second, the time may be increased by right-clicking the block. Punching will decrease the time. Sneaking will allow you to configure it in 10 second intervals. To prevent further changes, lock and unlock the turret using the dominion wand. Setting the turret to 0 seconds or providing a redstone signal will disable it. Casts Projectile, Touch, Sensitive and Redstone glyphs for free.");
        this.add("ars_nouveau.page4.basic_spell_turret", "Turrets can provide compact and efficient automation. Examples include: configurable redstone clocks, one block tree or crop farms, rapid smelting with fortune, or mob farms with looting.");
        this.add("ars_nouveau.page1.bookwyrm_charm", "Bookwyrm Charms can be used on a Storage Lectern to increase the number of accessible inventories. Augment a Ritual of Awakening with Book and Quills in order to obtain charms. Bookwyrms can be dyed using white, black, blue, green, red, or purple dye.");
        this.add("ars_nouveau.page2.bookwyrm_charm", "In the event that they die or are dispelled, they will drop their charm.");
        this.add("ars_nouveau.page.dominion_wand", "A tool for configuring Source Relays and automation entities. To set a transfer path, use the wand on the object that you would like to take source from, and then use it on the block you would like to send source to. For example: Source Jar to Source Relay, Source Relay to Source Relay, or Source Relay to Source Jar. To clear connections, sneak and use this wand on a relay. You can switch into Strict mode using the radial menu, allowing to specify the side of the blocks to use.");
        this.add("ars_nouveau.page1.drygmy_charm", "Drygmys are often found following and tending to animals around it. They can be found anywhere, though somewhat rarely. Drygmys can be given a home in the world, and will produce items from nearby monsters and animals as if they were slain, without harming them. A wild drygmy may be befriended by throwing a Wilden Horn near it! You may dye a Drygmy Cyan, Orange, or Brown.");
        this.add("ars_nouveau.page2.drygmy_charm", "A Drygmy can also produce experience gems!");
        this.add("ars_nouveau.page3.drygmy_charm", "To summon a Drygmy, use a Drymy Charm on a block of Mossy Cobblestone. After a short time, the cobblestone will transform into a Drygmy Henge and summon your Drygmy! To summon additional drygmys, use more charms on the henge. Casting dispel or killing the Drygmy will return your charm.");
        this.add("ars_nouveau.page4.drygmy_charm", "A Drygmy considers its home to be 10 blocks in every direction from its home. The drygmy will use this area to produce items from any entities nearby. Your drygmy's efficiency is dependent on its happiness. This may be increased for each entity nearby, with a bonus for each unique type in its home. Nearby Containment Jars will also count as an entity.");
        this.add("ars_nouveau.page5.drygmy_charm", "Each Drygmy working around a henge contributes progress. Once maximum progress has been reached, the henge will generate items and experience gems and deposit them into adjacent chests. Each time this occurs, the henge will require Source to recharge. The number of drops and experience gems is equal to the Drygmy happiness and experience value of the entities. To get started, place a chest and jar of Source next to the Henge.");
        this.add("ars_nouveau.happiness", "Happiness");
        this.add("ars_nouveau.production", "Production");
        this.add("ars_nouveau.important", "Important");
        this.add("ars_nouveau.page1.starbuncle_charm", "Starbuncles naturally appear in wooded areas in search of golden nuggets. While Starbuncles are normally afraid of humans, they will allow someone to approach if they are holding a gold nugget. When a Starbuncle has picked up a golden nugget, it will vanish from this world and leave behind a Starbuncle Token.");
        this.add("ars_nouveau.page2.starbuncle_charm", "While wild Starbuncles cannot be tamed, their tokens may be used to summon a Starbuncle.");
        this.add("ars_nouveau.page3.starbuncle_charm", "To summon a Starbuncle, use a Starbuncle charm on the ground. Summoned Starbuncles will pickup nearby items and can move items between inventories such as chests. Starbuncles will harvest fully grown Source Berry bushes around it. A Starbuncle will drop its charm when Dispelled or when killed. You may dye them any color.");
        this.add("ars_nouveau.page4.starbuncle_charm", "To bind a Starbuncle to place items into a chest, use the dominion wand on the Starbuncle and then the inventory. To take items from an inventory, use the wand on the inventory and then the Starbuncle. Starbuncles will move items between as many inventories as you desire. Looking at a Starbuncle will tell you how many chests are being taken from, and input to. Using the Dominion Wand on a Starbuncle while sneaking will reset them.");
        this.add("ars_nouveau.page5.starbuncle_charm", "You may dictate where items go and may be picked up by using Item Scrolls or Item Frames. A Starbuncle may be given an Item Scroll: Allow or Deny, and will only pickup and move items respecting that filter. Alternatively, you may place an Item Frame on the inventory a Starbuncle is interacting with. You may either place an Item Scroll or a single item directly on the frame. Starbuncle interacting with that inventory will respect item framed filters.");
        this.add("ars_nouveau.page6.starbuncle_charm", "Using a block on a Starbuncle will set them to prefer that block for pathing between areas, as long as it is on the way. They will also naturally prefer grass paths.");
        this.add("ars_nouveau.page7.starbuncle_charm", "Starbuncles may be bound to a Magebloom Bed using the Dominion Wand and will rest on the bed when there are no other tasks to be done. Useful for keeping them out of the way, or returning them to a spot where items drop. Providing a redstone signal to the bed will disable starbuncles and go back to their beds.");
        this.add("ars_nouveau.page8.starbuncle_charm", "Using a charm on an existing Starbuncle will stack them. Stacked starbuncles will transport multiple stacks at a time, depositing them in the order that they are taken. Wanding a stackbuncle will wand the main starbuncle and will always display the main starbuncles tooltip. Note: multiple itemstacks are not simulated at a time, which can result in several items being taken, but only able to deposit one while holding the rest.");
        this.add("ars_nouveau.starbuncle_bed", "Resting");
        this.add("ars_nouveau.starbuncle_stacking", "Starby Stacking");
        this.add("ars_nouveau.page1.whirlisprig_charm", "Whirlisprigs are curious nature sprites that are exclusively found in forested areas. Summoned Whirlisprigs can be given a home in the world, and will begin producing natural materials including wood, crops, seeds, and flowers that exist around them. Wild Whirlisprigs can be befriended and will drop Whirlisprig Tokens if a tree is grown near them.");
        this.add("ars_nouveau.page2.whirlisprig_charm", "Whirlisprigs will follow animals, players, and monsters! They will also grow grass around them every once and a while.");
        this.add("ars_nouveau.page3.whirlisprig_charm", "To summon a Whirlisprig, use a Whirlisprig charm on any flower. Whirlisprigs consider their home to be 10 blocks in any direction from the flower. Whirlisprigs require source nearby to operate, and will only generate items if there is a chest placed next to the flower. You can get your charm back by using Dispel on a Whirlisprig. They may be given orange, yellow, white, or green dye.");
        this.add("ars_nouveau.page4.whirlisprig_charm", "Summoned Whirlisprigs must be happy in order to produce materials, and their mood is determined by the number and diversity of natural materials in their home. You may use blocks on the Whirlisprig to gain additional info if a Whirlisprig would enjoy that block in their home. Interacting with the Whirlisprig with an empty hand will give you additional info on the Whirlisprig's happiness.");
        this.add("ars_nouveau.page5.whirlisprig_charm", "Note: It can take several minutes for a Whirlisprig to update its mood after placing a block. Whirlisprigs value diversity, and too much of one block will no longer count.");
        this.add("ars_nouveau.page6.whirlisprig_charm", "Drop rates are determined by happiness, diversity, and the proportions of blocks in a Whirlisprig home. For example, to generate a lot of logs, grow more trees. To gain more seeds and crop harvests, plant more crops.");
        this.add("ars_nouveau.page1.wixie_charm", "A Wixie can automatically craft items for you at the expense of source. To obtain a Wixie Token, cast Dispel on a Witch while it is half health or less. Once you have obtained a Wixie Charm, use it on a Cauldron to summon your Wixie. A Wixie can be dyed Red, White, Black, Blue, or Green.");
        this.add("ars_nouveau.page2.wixie_charm", "To select an item for crafting, use your item or block on the Wixie Cauldron.");
        this.add("ars_nouveau.page3.wixie_charm", "The Wixie will select the recipe for crafting based on the inventories nearby, you need not specify the exact materials for the recipe. For example, if you want to craft Sticks, the Wixie will mix and match planks from nearby chests in order to fulfill the recipe. Each craft requires a small amount of source and will be drained from nearby Source Jars. A redstone signal on the cauldron will stop crafting.");
        this.add("ars_nouveau.page4.wixie_charm", "Wixies can craft multiple items at once by placing pedestals adjacent to the cauldron. Wixie's will attempt to craft items in the pedestal, rotating round robin. Powering the pedestal will disable the wixie from crafting its item.");
        this.add("ars_nouveau.item_crafting_setting", "Multi-Item Crafting");
        this.add("ars_nouveau.item_crafting", "Item Crafting");
        this.add("ars_nouveau.potion_crafting", "Potion Crafting");
        this.add("ars_nouveau.page.summon_focus", "A special casting focus. Grants summons from spells additional duration, strength, speed, and deals damage to enemies that kill them. Additionally, casting spells that target you like Self and Orbit will cast a copy of the spell on your nearby summons.");
        this.add("ars_nouveau.page1.potion_flask", "A flask that stores 8 charges of a potion. To fill the flask, use the flask on a Potion Jar, or craft the flask in a Crafting Table with another potion. You may empty the flask by using the flask on a Potion Jar while sneaking.");
        this.add("ars_nouveau.page2.potion_flask", "An enchanted flask that extends the time of effects by 50%%");
        this.add("ars_nouveau.page3.potion_flask", "An enchanted flask that increases the power of effects by 1, but reduces their time in half.");
        this.add("ars_nouveau.page.warp_scroll", "A scroll that may be used a single time to teleport to a recorded location. However, teleporting across dimensions is not possible. Can be used to warp other entities if an inscribed scroll is held in the offhand and the holder casts Blink on an entity.");
        this.add("ars_nouveau.page.armor", "Magical Armor");
        this.add("ars_nouveau.page.reactive_enchantment", "Reactive");
        this.add("ars_nouveau.page.spell_books", "Spell Books");
        this.add("ars_nouveau.page1.spell_books", "Accessing higher tier spells will require a better spell book. While a novice spell book only has access to Tier 1 spells, the Apprentice and Archmage spell books will unlock tiers two and three. Upgrading your spell book will transfer all of the spells that you have learned into your new book. Books may be dyed by crafting them with a piece of dye.");
        this.add("ars_nouveau.page.summoning_familiars", "Summoning Familiars");
        this.add("ars_nouveau.page1.summoning_familiars", "To begin summoning familiars, you will need to obtain a Bound Script of the entity you wish to befriend. These can be obtained by performing the Ritual of Binding near a relevant entity. See the full list of eligible entities in the Familiars section. Once you have obtained a Bound Script, use it to learn the familiar.");
        this.add("ars_nouveau.page2.summoning_familiars", "Once you have obtained a bound script, you may access your list of familiars from your Spellbook crafting menu in the Familiars section. Selecting a Familiar will summon it in the world and give you Familiar Sickness, preventing you from summoning another one for a short time. To obtain your first familiar, perform the Ritual of Binding near a Starbuncle. Familiars are bound to the player and cannot be transferred between books.");
        this.add("ars_nouveau.page3.summoning_familiars", "Typically only one familiar may be out at a time, and summoning another familiar will remove others bound to you. You may dismiss your own familiar by casting Dispel on it. In exchange for empowering the owner, familiars will reserve a portion of max mana from their owner for as long as they persist in the world.");
        this.add("ars_nouveau.page.performing_rituals", "Performing Rituals");
        this.add("ars_nouveau.page1.performing_rituals", "Performing a ritual requires a Ritual Brazier, and a tablet. Once you have obtained a tablet and brazier, place your brazier in the world and use a tablet on it. The brazier will ignite, and is awaiting activation. In this state, you may throw in any additional items as a way to augment the ritual. If you wish to augment a ritual, simply toss the item on top of the brazier.");
        this.add("ars_nouveau.page2.performing_rituals", "To activate your ritual, interact with the brazier with an empty hand. Once activated, your ritual can no longer be augmented and has been consumed permanently. If a ritual requires source to operate, the brazier will pull from source jars within 6 blocks. Information related to rituals and their requirements can be found in their respective entries.");
        this.add("ars_nouveau.automation", "Automation");
        this.add("ars_nouveau.automation_desc", "Magical Automation");
        this.add("ars_nouveau.enchanting", "Enchanting");
        this.add("ars_nouveau.enchanting_desc", "Once you have acquired a jar of Source and an Enchanting Apparatus, you may begin enchanting items. For more information, see the section on the Enchanting Apparatus.");
        this.add("ars_nouveau.equipment", "Magical Equipment");
        this.add("ars_nouveau.equipment_desc", "Magical Equipment");
        this.add("ars_nouveau.familiars", "Familiars");
        this.add("ars_nouveau.familiars_desc", "Familiars may be summoned to provide passive buffs for spell casting, passive buffs, and more.");
        this.add("ars_nouveau.getting_started", "Getting Started");
        this.add("ars_nouveau.getting_started_desc", "An introduction to Ars Nouveau. It is recommended to follow each section in order.");
        this.add("ars_nouveau.tier_1_spells", "Tier 1 Glyphs");
        this.add("ars_nouveau.tier_1_spells_desc", "Glyphs that may be cast using a Novice Spellbook.");
        this.add("ars_nouveau.tier_2_spells", "Tier 2 Glyphs");
        this.add("ars_nouveau.tier_2_spells_desc", "Glyphs that may be cast using a Mage's Spellbook.");
        this.add("ars_nouveau.tier_3_spells", "Tier 3 Glyphs");
        this.add("ars_nouveau.tier_3_spells_desc", "Glyphs that may be cast using a Archmage's Spellbook.");
        this.add("ars_nouveau.machines", "Machines");
        this.add("ars_nouveau.machines_desc", "Magical Machines");
        this.add("ars_nouveau.resources", "Resources and Decoration");
        this.add("ars_nouveau.resources_desc", "Resources found in the world.");
        this.add("ars_nouveau.rituals", "Rituals");
        this.add("ars_nouveau.rituals_desc", "Rituals are more powerful versions of spells, and come in semi-permanent or single use forms. To get started with Rituals, you will need a Ritual Brazier and a tablet of the ritual you would like to perform.");
        this.add("ars_nouveau.category.source", "Source");
        this.add("ars_nouveau.source_desc", "Source can be used to power rituals, summons, and machines.");
        this.add("ars_nouveau.page.how_to_enchant", "How to Enchant");
        this.add("ars_nouveau.page1.how_to_enchant", "The Enchanting Apparatus may add new enchantments or upgrade existing ones by using Source and items. To begin, select a level 1 enchantment and add its items to the pedestals. Place a jar of Source nearby, and use the item you want to enchant on the apparatus. The apparatus may only apply enchantments that are valid to the item you have given it.");
        this.add("ars_nouveau.page2.how_to_enchant", "To apply a level 2 or higher enchantment, the item must already have the previous level. For example, to apply Smite 3, the item must already have Smite 2.");
        this.add("ars_nouveau.mod_news", "Mod News");
        this.add("ars_nouveau.mod_news_desc", "The latest releases and news");
        this.add("ars_nouveau.page.mod_news", "Join the Community!");
        this.add("ars_nouveau.store", "Support Ars Nouveau through our Redbubble store! Get the latest summon-themed merchandise including stickers, mugs, and more!");
        this.add("ars_nouveau.community", "Join the Ars Nouveau community! Get ideas for spells, help with the mod, report bugs and issues, or request new features!");
        this.add("ars_nouveau.page1.reactive_enchantment", "Items with Reactive have a chance to cast spells when swung. The spell on the Spell Parchment determines the spell that will be inscribed on the item.");
        this.add("ars_nouveau.page2.reactive_enchantment", "Like other enchantments, Reactive levels can only be applied to an item with the previous level of enchantment. Reactive 2 requires Reactive 1, etc.");
        this.add("ars_nouveau.page3.reactive_enchantment", "The spell inscribed for Reactive can be changed by placing the item in the apparatus with a new inscribed spell parchment.");
        this.add("ars_nouveau.discord_text", "Join Discord!");
        this.add("ars_nouveau.store_text", "Shop Redbubble!");
        this.add("ars_nouveau.page.obtaining_gems", "Obtaining Source Gems");
        this.add("ars_nouveau.page1.obtaining_gems", "To obtain Source Gems, you must first build an Imbuement Chamber. An Imbuement Chamber imbues items inside it with Source, and will convert them to a new item. To obtain a source gem, place an Amethyst or Lapis inside your Imbuement Chamber and wait. Imbuement Chambers will consume source from nearby Source Jars to speed up any crafting. A Dowsing Rod can be used for finding Budding Amethyst early.");
        this.add("ars_nouveau.reagent", "Reagent:");
        this.add("ars_nouveau.level", "Level");
        this.add("ars_nouveau.any_item", "ANY ITEM");
        this.add("item.ars_nouveau.abjuration_essence", "Abjuration Essence");
        this.add("item.ars_nouveau.conjuration_essence", "Conjuration Essence");
        this.add("item.ars_nouveau.air_essence", "Air Essence");
        this.add("item.ars_nouveau.earth_essence", "Earth Essence");
        this.add("item.ars_nouveau.manipulation_essence", "Manipulation Essence");
        this.add("item.ars_nouveau.water_essence", "Water Essence");
        this.add("item.ars_nouveau.fire_essence", "Fire Essence");
        this.add("item.ars_nouveau.dowsing_rod", "Dowsing Rod");
        this.add("effect.ars_nouveau.magic_find", "Magic Find");
        this.add("effect.ars_nouveau.magic_find.desc", "Causes nearby magical entities to glow.");
        this.add("tooltip.ars_nouveau.essences", "Magical Essences created in an Imbuement Chamber.");
        this.add("ars_nouveau.page.dowsing_rod", "A Dowsing Rod provides the user a short duration of Scrying for Budding Amethyst and Magic Find, which will cause magical creatures to glow within 75 blocks of you. The Dowsing Rod has a limited number of uses.");
        this.add("ars_nouveau.apparatus.norecipe", "No recipe found. Pedestals must be within 3 blocks.");
        this.add("ars_nouveau.apparatus.use_imbuement", "Did you mean to use an Imbuement Chamber for this recipe?");
        this.add("ars_nouveau.imbuement.norecipe", "No recipe found. If pedestals are required, they must be placed within the 1 block cube around the chamber.");
        this.add("ars_nouveau.imbuement.use_apparatus", "Did you mean to use an Enchanting Apparatus for this recipe?");
        this.add("ars_nouveau.spell_book_gui.select", "Select");
        this.add("ars_nouveau.levels_required", "Levels required: %s");
        this.add("ars_nouveau.crafting", "Crafting: %s");
        this.add("ars_nouveau.all_glyphs", "All Glyphs");
        this.add("ars_nouveau.not_enough_exp", "Not enough EXP for this glyph.");
        this.add("ars_nouveau.exp", "EXP levels required: %s");
        this.add("ars_nouveau.scribing", "Scribing Spells");
        this.add("ars_nouveau.home_set", "Home set.");
        this.add("ars_nouveau.gathering_at", "Gathering at: %s");
        this.add("entity.ars_nouveau.amethyst_golem", "Amethyst Golem");
        this.add("tooltip.ars_nouveau.amethyst_charm", "Obtained by performing the Ritual of Awakening near Budding Amethyst");
        this.add("item.ars_nouveau.amethyst_golem_charm", "Amethyst Golem Charm");
        this.add("ars_nouveau.page1.amethyst_golem_charm", "Amethyst Golems will harvest, grow, and collect Amethyst near its home. To obtain an Amethyst Golem, perform the Ritual of Awakening near Budding Amethyst to obtain the Amethyst Golem Charm.");
        this.add("ars_nouveau.page2.amethyst_golem_charm", "");
        this.add("ars_nouveau.page3.amethyst_golem_charm", "Summon the Amethyst Golem by using a charm on a block. Before an Amethyst Golem will perform tasks, they must first have a home. Set their home by using the Dominion Wand on the golem, and then on a block. The golem's home is considered to be 10 blocks in any direction from the set position.");
        this.add("ars_nouveau.amethyst_farming", "Farming Amethyst");
        this.add("ars_nouveau.page4.amethyst_golem_charm", "Once a home has been set, the golem will begin performing tasks over time. They will convert Amethyst Blocks into Budding Amethyst, harvest Amethyst Clusters, speed up Budding Amethyst growth, and pick up and store Amethyst Shards.");
        this.add("ars_nouveau.amethyst_storage", "Storing Amethyst");
        this.add("ars_nouveau.page5.amethyst_golem_charm", "If a golem's home has been set to an inventory, golems will pick up and store Amethyst Shards in their bounded inventory block. If their home is not an inventory, they will simply ignore items on the ground.");
        this.add("ars_nouveau.recorded_codex", "You record your known glyphs to the codex.");
        this.add("ars_nouveau.updated_codex", "You have updated the codex with %s glyphs");
        this.add("ars_nouveau.consumed_codex", "You consume to codex to learn %s glyphs.");
        this.add("ars_nouveau.codex_no_use", "This codex would not teach you anything new.");
        this.add("ars_nouveau.codex_up_to_date", "This codex is already up to date.");
        this.add("ars_nouveau.codex_not_enough_exp", "Not enough levels to record glyphs. %s levels needed.");
        this.add("ars_nouveau.recorded_by", "Created by %s");
        this.add("ars_nouveau.contains_glyphs", "Contains %s glyphs.");
        this.add("ars_nouveau.codex_tooltip", "Use to record your glyphs.");
        this.add("item.ars_nouveau.annotated_codex", "Annotated Codex");
        this.add("ars_nouveau.page.annotated_codex", "The Annoted Codex allows players to share their knowledge of glyphs with other players. To record your known glyphs, simply use the codex. Recording glyphs requires EXP for each glyph known, and the EXP will be consumed upon using the item. Using the item again will update the list of known glyphs. Other players may use the book to learn the glyphs, consuming the codex in the process.");
        this.add("ars_nouveau.ritual.no_start", "Start the current ritual or break the block to remove it.");
        this.add("ars_nouveau.lights_on", "You have turned dynamic lights on. This can cause lag for users with weaker CPUs, low RAM allocation, and unexpected results with 'performance' mods like Optifine. Run this command or change the ars_nouveau-client config to disable this.");
        this.add("ars_nouveau.lights_off", "You have turned dynamic lights off.");
        this.add("ars_nouveau.page.relay_collector", "Operates similar to the Source Relay, but will automatically take from jars it is not linked to within 5 blocks. See the instructions on the Source Relay for use.");
        this.add("block.ars_nouveau.relay_collector", "Source Relay: Collector");
        this.add("ars_nouveau.page2.relay", "A redstone signal will disable the relay.");
        this.add("ars_nouveau.sounds.pitch", "Pitch: %s");
        this.add("ars_nouveau.sounds.volume", "Volume: %s");
        this.add("ars_nouveau.gui.sounds", "Sounds");
        this.add("ars_nouveau.sounds.title", "Spell Sound");
        this.add("ars_nouveau.sound.empty", "No Sound");
        this.add("ars_nouveau.earth_essence.tooltip", "Can be used on Dirt to turn it into Grass.");
        this.add("ars_nouveau.fire_essence.tooltip", "Can be used as a fuel source.");
        this.add("tooltip.ars_nouveau.glyph_known", "You have unlocked this glyph.");
        this.add("tooltip.ars_nouveau.glyph_unknown", "You have not unlocked this glyph.");
        this.add("ars_nouveau.sounds.test", "Test");
        this.add("ars_nouveau.gui.settings", "Settings and Rewards");
        this.add("ars_nouveau.settings.title", "Settings");
        this.add("ars_nouveau.dynamic_lights.button_on", "Dynamic lights are turned on.  This can cause lag for users with weaker CPUs, low RAM allocation, and unexpected results with 'performance' mods like Optifine.");
        this.add("ars_nouveau.dynamic_lights.button_off", "Dynamic lights are turned off.");
        this.add("block.ars_nouveau.orange_sbed", "Orange Magebloom Bed");
        this.add("block.ars_nouveau.blue_sbed", "Blue Magebloom Bed");
        this.add("block.ars_nouveau.green_sbed", "Green Magebloom Bed");
        this.add("block.ars_nouveau.purple_sbed", "Purple Magebloom Bed");
        this.add("block.ars_nouveau.red_sbed", "Red Magebloom Bed");
        this.add("block.ars_nouveau.yellow_sbed", "Yellow Magebloom Bed");
        this.add("ars_nouveau.starbuncle.set_bed", "Set bed.");
        this.add("ars_nouveau.summon_bed", "Magebloom Bed");
        this.add("ars_nouveau.page1.summon_bed", "A decorative bed. Starbuncles can be bound to a bed using the Dominion Wand, and they will rest on the bed when there are no other tasks.");
        this.add("block.ars_nouveau.scryers_oculus", "Scryer's Oculus");
        this.add("block.ars_nouveau.scryers_crystal", "Scry Crystal");
        this.add("item.ars_nouveau.scryer_scroll", "Scryer's Scroll");
        this.add("ars_nouveau.scryers_oculus.no_pos", "No position set on scroll.");
        this.add("ars_nouveau.scryers_oculus.no_scrolls", "No scrolls found nearby. Place a linked Scryer's Scroll on a nearby pedestal.");
        this.add("ars_nouveau.scryer_scroll.bound", "Bound to %s.");
        this.add("tooltip.ars_nouveau.scryer_scroll", "Use on a Scryer's Crystal to bind the location to this scroll.");
        this.add("tooltip.ars_nouveau.dowsing_rod", "Grants Magic Find and Scrying on use, causing magical creatures to glow and Amethyst to be revealed through blocks. Can be used on Imbuement Chamber and Enchanting Apparatus to highlight linked pedestals.");
        this.add("ars_nouveau.camera.move", "%1$s%2$s%3$s%4$s - Move");
        this.add("ars_nouveau.camera.exit", "%s - Exit");
        this.add("ars_nouveau.tooltip.scryers_oculus", "If you stare into the eye, the Starbuncle stares back at you.");
        this.add("ars_nouveau.page.scryers_crystal", "Can be used to look through as if you were standing there. Right click to enter the camera, or bind the camera to a Scryer's Scroll by using Blank Parchment on the block. A Scryer's Scroll will let you remotely access the block via a Scryer's Oculus. ");
        this.add("ars_nouveau.page.scryer_scroll", "Stores the location of a Scryer's Crystal. To create one, use a Blank Parchment on a Scry Crystal. You can remotely access the stored position by placing this item on a pedestal near a Scryer's Oculus. Naming this item will allow you to easily recognize it in the Scryer's Oculus interface.");
        this.add("ars_nouveau.page.scryers_oculus", "Allows you to remotely access Scry Crystals. To use, place Scryer's Scrolls on nearby pedestals and interact with the Oculus to select which Scry Crystal you would like to access. Scry Crystals must be chunk loaded.");
        this.add("ars_nouveau.scryer_scroll.craft", "Created by using a Blank Parchment on a Scry Crystal.");
        this.add("item.ars_nouveau.starbuncle_shades", "Starbuncle Shades");
        this.add("tooltip.starbuncle_shades", "Using these on a Starbuncle will increase their coolness, but disable their ability to pickup items off the ground or pick Sourceberries.");
        this.add("ars_nouveau.page.starbuncle_shades", "Using these on a Starbuncle will disable their ability to pick up items off the ground or pick Sourceberries. Wanding the starbuncle will drop the glasses.");
        this.add("entity.ars_nouveau.ally_vex", "Summoned Vex");
        this.add("ars_nouveau.scryers_eye.no_scrolls", "Place a Scryer's Scroll on a nearby pedestal.");
        this.add("ars_nouveau.camera.not_loaded", "The block has been removed or is not chunk loaded.");
        this.add("ars_nouveau.page.support_mod", "Support Ars Nouveau!");
        this.add("ars_nouveau.patreon", "Join the Ars Nouveau patreon and get a special Discord role, contribute a custom Tome, receive merchandise, summon a Lily and Nook dog, and more!");
        this.add("ars_nouveau.patreon_text", "Patreon");
        this.add("entity.ars_nouveau.summon_skeleton", "Summoned Skeleton");
        this.add("item.ars_nouveau.shapers_focus", "Focus of Block Shaping");
        this.add("ars_nouveau.shapers_focus.tooltip", "Can be used to create a block.");
        this.add("ars_nouveau.page1.shapers_focus", "A focus that modifies effects that move, create, or modify blocks. Blocks that you move with effects like Launch, Gravity, Pull, Knockback, etc. will now deal damage to entities they hit. Damage is increased by Spell Damage, block hardness, and the speed of the block. Additionally, effects that target or create blocks will duplicate the rest of the spell targeting the new block or moving block.");
        this.add("ars_nouveau.shapers_focus.blocks", "Block Targeting");
        this.add("ars_nouveau.page2.shapers_focus", "Modifying or creating a block will duplicate the rest of your spell onto that new block. For example, Freeze -> Break will freeze the block, and cast break onto that block. Without the focus, break would only be applied to the block that was hit originally. Effects that will duplicate this target include glyphs such as Conjure Mageblock, Freeze, Break, Exchange, Place Block, and more. Using AOE on these effects will duplicate the spell onto every block.");
        this.add("ars_nouveau.page3.shapers_focus", "Effects that move blocks will duplicate the rest of the spell onto those moving blocks. To see this in action, try using Conjure Mageblock -> Launch -> Delay -> Knockback to send a block flying in the direction you are looking. This targeting system applies to all moved blocks. Using AOE on block moving effects will let you manipulate many blocks at once.");
        this.add("ars_nouveau.shapers_focus.entities", "Entity Targeting");
        this.add("ars_nouveau.shapers_focus.examples", "Spell Examples");
        this.add("ars_nouveau.page4.shapers_focus", "Throw Ice: Conjure Water -> Freeze -> Launch -> Delay -> Knockback. Damage and ignite hit targets: Conjure Mageblock -> Launch -> Ignite -> Delay -> Knockback. Ignite TNT: Place Block (TNT) -> Ignite. Throw Exploding Terrain: Launch -> Delay -> Knockback -> Delay -> Explosion. Throw many blocks: Launch -> AOE x2 -> Delay -> Knockback. Pull blocks: Pull -> AOE x2 -> Delay -> Duration Down -> Launch -> Delay -> Knockback. Harvest Sand: Crush (on stone) -> Aoe -> Break");
        this.add("tooltip.ars_nouveau.shapers_focus", "Duplicates spells that modify or move blocks. Can be used to create damaging moving blocks.");
        this.add("ars_nouveau.tablet_of", "Tablet of %s");
        this.add("ars_nouveau.bound_script", "Bound Script: %s");
        this.add("block.ars_nouveau.sourcestone", "Sourcestone");
        this.add("block.ars_nouveau.sourcestone_mosaic", "Sourcestone: Mosaic");
        this.add("block.ars_nouveau.sourcestone_basketweave", "Sourcestone: Basketweave");
        this.add("block.ars_nouveau.sourcestone_alternating", "Sourcestone: Alternating");
        this.add("block.ars_nouveau.sourcestone_large_bricks", "Sourcestone: Large Bricks");
        this.add("block.ars_nouveau.sourcestone_small_bricks", "Sourcestone: Small Bricks");
        this.add("block.ars_nouveau.smooth_sourcestone", "Smooth Sourcestone");
        this.add("block.ars_nouveau.smooth_sourcestone_mosaic", "Smooth Sourcestone: Mosaic");
        this.add("block.ars_nouveau.smooth_sourcestone_basketweave", "Smooth Sourcestone: Basketweave");
        this.add("block.ars_nouveau.smooth_sourcestone_alternating", "Smooth Sourcestone: Alternating");
        this.add("block.ars_nouveau.smooth_sourcestone_large_bricks", "Smooth Sourcestone: Large Bricks");
        this.add("block.ars_nouveau.smooth_sourcestone_small_bricks", "Smooth Sourcestone: Small Bricks");
        this.add("block.ars_nouveau.gilded_sourcestone_mosaic", "Gilded Sourcestone: Mosaic");
        this.add("block.ars_nouveau.gilded_sourcestone_basketweave", "Gilded Sourcestone: Basketweave");
        this.add("block.ars_nouveau.gilded_sourcestone_alternating", "Gilded Sourcestone: Alternating");
        this.add("block.ars_nouveau.gilded_sourcestone_large_bricks", "Gilded Sourcestone: Large Bricks");
        this.add("block.ars_nouveau.gilded_sourcestone_small_bricks", "Gilded Sourcestone: Small Bricks");
        this.add("block.ars_nouveau.smooth_gilded_sourcestone_mosaic", "Smooth Gilded Sourcestone: Mosaic");
        this.add("block.ars_nouveau.smooth_gilded_sourcestone_basketweave", "Smooth Gilded Sourcestone: Basketweave");
        this.add("block.ars_nouveau.smooth_gilded_sourcestone_alternating", "Smooth Gilded Sourcestone: Alternating");
        this.add("block.ars_nouveau.smooth_gilded_sourcestone_large_bricks", "Smooth Gilded Sourcestone: Large Bricks");
        this.add("block.ars_nouveau.smooth_gilded_sourcestone_small_bricks", "Smooth Gilded Sourcestone: Small Bricks");
        this.add("tooltip.item_scroll", "Use with an item in the offhand to add to the scroll, or scribe on the Scribes table.");
        this.add("item.ars_nouveau.mendosteen_pod", "Mendosteen");
        this.add("item.ars_nouveau.frostaya_pod", "Frostaya");
        this.add("item.ars_nouveau.bombegranate_pod", "Bombegranate");
        this.add("item.ars_nouveau.bastion_pod", "Bastion Fruit");
        this.add("item.ars_nouveau.alchemists_crown", "Alchemist's Crown");
        this.add("block.ars_nouveau.potion_diffuser", "Potion Diffuser");
        this.add("block.ars_nouveau.bastion_pod", "Bastion Fruit");
        this.add("block.ars_nouveau.bombegranate_pod", "Bombegranate");
        this.add("block.ars_nouveau.frostaya_pod", "Frostaya");
        this.add("block.ars_nouveau.intangible_air", "Intangible Air");
        this.add("block.ars_nouveau.mendosteen_pod", "Mendosteen");
        this.add("block.ars_nouveau.redstone_air", "Redstone Air");
        this.add("entity.ars_nouveau.dummy", "Dummy");
        this.add("entity.ars_nouveau.enchanted_falling_block", "Enchanted Falling Block");
        this.add("entity.ars_nouveau.enchanted_mage_block", "Enchanted Falling Block");
        this.add("entity.ars_nouveau.enchanted_head_block", "Enchanted Falling Block");
        this.add("entity.ars_nouveau.familiar_jabberwog", "Familiar Jabberwog");
        this.add("entity.ars_nouveau.fangs", "Fangs");
        this.add("entity.ars_nouveau.ritual", "Ritual");
        this.add("ars_nouveau.melder.from_capped", "Melders can only meld two jars. Clear the melder by using the Dominion Wand while sneaking to remove all jars.");
        this.add("ars_nouveau.melder.to_set", "Melder will send combined potions to this jar.");
        this.add("ars_nouveau.melder.from_set", "%s of 2 melding jars set.");
        this.add("ars_nouveau.melder.no_to_pos", "Wand the Melder to your desired Potion Jar.");
        this.add("ars_nouveau.melder.needs_potion", "Linked jars need potion");
        this.add("ars_nouveau.melder.destination_invalid", "Destination cannot accept the mixed potion.");
        this.add("arsnouveau.debug.log_created", "Log file created: %s");
        this.add("ars_nouveau.melder.too_far", "Jars must be within 3 blocks.");
        this.add("ars_nouveau.starbuncle.storing_potions", "Storing potions at %s locations");
        this.add("ars_nouveau.starbuncle.taking_potions", "Taking potions from %s locations");
        this.add("ars_nouveau.starbuncle.potion_to", "Starbuncle will send potions to this jar.");
        this.add("ars_nouveau.starbuncle.potion_from", "Starbuncle will take potions from this jar.");
        this.add("ars_nouveau.dominion_wand.cleared", "Dominion wand cleared.");
        this.add("ars_nouveau.starbuncle.potion_behavior_set", "Starbuncle will now transport potions!");
        this.add("key.ars_nouveau.qc1", "Quick Cast Slot 01");
        this.add("key.ars_nouveau.qc2", "Quick Cast Slot 02");
        this.add("key.ars_nouveau.qc3", "Quick Cast Slot 03");
        this.add("key.ars_nouveau.qc4", "Quick Cast Slot 04");
        this.add("key.ars_nouveau.qc5", "Quick Cast Slot 05");
        this.add("key.ars_nouveau.qc6", "Quick Cast Slot 06");
        this.add("key.ars_nouveau.qc7", "Quick Cast Slot 07");
        this.add("key.ars_nouveau.qc8", "Quick Cast Slot 08");
        this.add("key.ars_nouveau.qc9", "Quick Cast Slot 09");
        this.add("key.ars_nouveau.qc10", "Quick Cast Slot 10");
        this.add("item.minecraft.splash_potion.effect.recovery_potion_strong", "Splash Potion of Recovery");
        this.add("item.minecraft.splash_potion.effect.recovery_potion", "Splash Potion of Recovery");
        this.add("item.minecraft.splash_potion.effect.recovery_potion_long", "Splash Potion of Recovery");
        this.add("item.minecraft.potion.effect.recovery_potion_strong", "Potion of Recovery");
        this.add("item.minecraft.potion.effect.recovery_potion", "Potion of Recovery");
        this.add("item.minecraft.potion.effect.recovery_potion_long", "Potion of Recovery");
        this.add("item.minecraft.lingering_potion.effect.recovery_potion_strong", "Lingering Potion of Recovery");
        this.add("item.minecraft.lingering_potion.effect.recovery_potion", "Lingering Potion of Recovery");
        this.add("item.minecraft.lingering_potion.effect.recovery_potion_long", "Lingering Potion of Recovery");
        this.add("item.minecraft.tipped_arrow.effect.recovery_potion_strong", "Arrow of Recovery");
        this.add("item.minecraft.tipped_arrow.effect.recovery_potion", "Arrow of Recovery");
        this.add("item.minecraft.tipped_arrow.effect.recovery_potion_long", "Arrow of Recovery");
        this.add("item.minecraft.splash_potion.effect.blasting_potion_strong", "Splash Potion of Blasting");
        this.add("item.minecraft.splash_potion.effect.blasting_potion", "Splash Potion of Blasting");
        this.add("item.minecraft.splash_potion.effect.blasting_potion_long", "Splash Potion of Blasting");
        this.add("item.minecraft.potion.effect.blasting_potion_strong", "Potion of Blasting");
        this.add("item.minecraft.potion.effect.blasting_potion", "Potion of Blasting");
        this.add("item.minecraft.potion.effect.blasting_potion_long", "Potion of Blasting");
        this.add("item.minecraft.lingering_potion.effect.blasting_potion_strong", "Lingering Potion of Blasting");
        this.add("item.minecraft.lingering_potion.effect.blasting_potion", "Lingering Potion of Blasting");
        this.add("item.minecraft.lingering_potion.effect.blasting_potion_long", "Lingering Potion of Blasting");
        this.add("item.minecraft.tipped_arrow.effect.blasting_potion_strong", "Arrow of Blasting");
        this.add("item.minecraft.tipped_arrow.effect.blasting_potion", "Arrow of Blasting");
        this.add("item.minecraft.tipped_arrow.effect.blasting_potion_long", "Arrow of Blasting");
        this.add("item.minecraft.splash_potion.effect.freezing_potion_strong", "Splash Potion of Freezing");
        this.add("item.minecraft.splash_potion.effect.freezing_potion", "Splash Potion of Freezing");
        this.add("item.minecraft.splash_potion.effect.freezing_potion_long", "Splash Potion of Freezing");
        this.add("item.minecraft.potion.effect.freezing_potion_strong", "Potion of Freezing");
        this.add("item.minecraft.potion.effect.freezing_potion", "Potion of Freezing");
        this.add("item.minecraft.potion.effect.freezing_potion_long", "Potion of Freezing");
        this.add("item.minecraft.lingering_potion.effect.freezing_potion_strong", "Lingering Potion of Freezing");
        this.add("item.minecraft.lingering_potion.effect.freezing_potion", "Lingering Potion of Freezing");
        this.add("item.minecraft.lingering_potion.effect.freezing_potion_long", "Lingering Potion of Freezing");
        this.add("item.minecraft.tipped_arrow.effect.freezing_potion_strong", "Arrow of Freezing");
        this.add("item.minecraft.tipped_arrow.effect.freezing_potion", "Arrow of Freezing");
        this.add("item.minecraft.tipped_arrow.effect.freezing_potion_long", "Arrow of Freezing");
        this.add("item.minecraft.splash_potion.effect.shielding_potion_strong", "Splash Potion of Shielding");
        this.add("item.minecraft.splash_potion.effect.shielding_potion", "Splash Potion of Shielding");
        this.add("item.minecraft.splash_potion.effect.shielding_potion_long", "Splash Potion of Shielding");
        this.add("item.minecraft.potion.effect.shielding_potion_strong", "Potion of Shielding");
        this.add("item.minecraft.potion.effect.shielding_potion", "Potion of Shielding");
        this.add("item.minecraft.potion.effect.shielding_potion_long", "Potion of Shielding");
        this.add("item.minecraft.lingering_potion.effect.shielding_potion_strong", "Lingering Potion of Shielding");
        this.add("item.minecraft.lingering_potion.effect.shielding_potion", "Lingering Potion of Shielding");
        this.add("item.minecraft.lingering_potion.effect.shielding_potion_long", "Lingering Potion of Shielding");
        this.add("item.minecraft.tipped_arrow.effect.shielding_potion_strong", "Arrow of Shielding");
        this.add("item.minecraft.tipped_arrow.effect.shielding_potion", "Arrow of Shielding");
        this.add("item.minecraft.tipped_arrow.effect.shielding_potion_long", "Arrow of Shielding");
        this.add("effect.ars_nouveau.recovery", "Recovery");
        this.add("effect.ars_nouveau.recovery.desc", "Increases healing received from all sources.");
        this.add("effect.ars_nouveau.blasting", "Blasting");
        this.add("effect.ars_nouveau.blasting.desc", "Causes the target to explode when the duration ends.");
        this.add("effect.ars_nouveau.freezing", "Freezing");
        this.add("effect.ars_nouveau.freezing.desc", "Freezes the target over time.");
        this.add("effect.ars_nouveau.shielding", "Shielding");
        this.add("effect.ars_nouveau.shielding.desc", "Reduces the amount of damage taken.");
        this.add("item.ars_nouveau.wixie_hat", "Wixie Hat");
        this.add("tooltip.ars_nouveau.wixie_hat", "Give to a Starbuncle to make them transport potions.");
        this.add("ars_nouveau.starbuncle.default_behavior", "Starbuncle will now transport items!");
        this.add("ars_nouveau.potion_diffuser.set_pos", "Diffuser will spread this potion to nearby entities.");
        this.add("ars_nouveau.potion_diffuser.bind_to_jar", "You must bind the diffuser to a Potion Jar to use it.");
        this.add("ars_nouveau.potion_diffuser.no_pos", "Bind a Potion Jar to the diffuser using the Dominion Wand.");
        this.add("ars_nouveau.potion_diffuser.off", "Diffuser is off.");
        this.add("key.ars_nouveau.head_curio_hotkey", "Head Curio Menu");
        this.add("ars_nouveau.alchemists_crown.no_flasks", "No flasks or potions equipped.");
        this.add("ars_nouveau.page.alchemists_crown", "Allows the wearer to consume potions and flasks instantly from their inventory.");
        this.add("ars_nouveau.tooltip.alchemists_crown", "Press %s to open the potion radial menu.");
        this.add("ars_nouveau.page.wixie_hat", "Allows starbuncles to transport potions. Once wearing a Wixie Hat, use the Dominion Wand to connect them between Potion Jars.");
        this.add("ars_nouveau.page.potion_diffuser", "Consumes a potion and applies it to nearby entities, greatly extending the use of the potion. To use, bind a Potion Jar to the diffuser using the Dominion Wand. Every 10 minutes the diffuser will consume a single potion and apply it every few seconds.");
        this.add("ars_nouveau.page.bombegrante", "A fruit that packs an explosive punch. Can be brewed into a Potion of Blasting, causing the target to explode when the duration ends.");
        this.add("ars_nouveau.page.mendosteen", "A fruit that can be brewed into a Potion of Recovery, increases the amount of healing received from all sources.");
        this.add("ars_nouveau.page.frostaya", "A fruit that can be brewed into a Potion of Freezing, freezing the target over time.");
        this.add("ars_nouveau.page.bastion_fruit", "A fruit that can be brewed into a Potion of Defence, reducing the amount of damage taken.");
        this.add("ars_nouveau.wixie_familiar.applied", "Wixie applies %s");
        this.add("ars_nouveau.flask_cannon.no_potion", "No potions in inventory.");
        this.add("item.ars_nouveau.lingering_flask_cannon", "Lingering Flask Cannon");
        this.add("item.ars_nouveau.splash_flask_cannon", "Splash Flask Cannon");
        this.add("ars_nouveau.page.flask_cannons", "Flask Cannons");
        this.add("ars_nouveau.page1.flask_cannons", "Flask Cannons can consume potions from bottles and flasks from the players inventory and convert the potion into a Splash or Lingering potion. To select the potion to be thrown, use the Radial Menu to select your flask or potion and use the launcher.");
        this.add("ars_nouveau.imbuement.crafting_started", "Crafting %s. Add source nearby to increase craft speed.");
        this.add("ars_nouveau.crafting_progress", "Crafting Progress: %s");
        this.add("ars_nouveau.scribes_table.throw_items", "Toss remaining items onto the table.");
        this.add("ars_nouveau.scribes_table.started_crafting", "Toss items as they appear above to complete crafting.");
        this.add("ars_nouveau.gui.discord", "Join the Discord for spells, updates, and support!");
        this.add("entity.ars_nouveau.an_lightning", "Lightning");
        this.add("entity.ars_nouveau.flying_item", "Flying Item");
        this.add("entity.ars_nouveau.follow_proj", "Projectile");
        this.add("entity.ars_nouveau.linger", "Linger");
        this.add("entity.ars_nouveau.orbit", "Orbit");
        this.add("entity.ars_nouveau.scryer_camera", "Scryer Camera");
        this.add("entity.ars_nouveau.spell_arrow", "Spell Arrow");
        this.add("entity.ars_nouveau.spell_proj", "Spell Projectile");
        this.add("entity.ars_nouveau.arcing_spell_proj", "Arc Spell Projectile");
        this.add("entity.ars_nouveau.homing_spell_proj", "Homing Spell Projectile");
        this.add("ars_nouveau.armor", "Armor and Perks");
        this.add("ars_nouveau.page.armor_upgrading", "Armor Upgrading");
        this.add("ars_nouveau.armor_tiers", "Armor Tiers");
        this.add("ars_nouveau.armor_desc", "Threads can be slotted into magical armor to provide additional effects. Armor can be upgraded to new tiers, unlocking additional and more powerful thread slots.");
        this.add("ars_nouveau.page1.armor_upgrading", "Magical armor can be upgraded with Threads to provide additional effects. Each type of armor has a different number of slots, and those slots vary in size. Larger slots will increase the power of threads, and some threads require a slot of a certain size or larger. To apply threads, see the section on the Alteration Table.");
        this.add("ars_nouveau.page2.armor_upgrading", "Armor also has three tiers, and these tiers may be increased using the Enchanting Apparatus and the upgrade recipes found in this section. Each tier will increase the amount of mana regen the armor grants, and increases the number and size of the slots of the armor.");
        this.add("block.ars_nouveau.alteration_table", "Alteration Table");
        this.add("ars_nouveau.page.alteration_table", "Alteration Table");
        this.add("ars_nouveau.page1.alteration_table", "Used to inscribe Threads onto magical armors. To use the table, place armor onto the stand of the table. The tablet will display the available Thread Slots on the armor. To add or remove a Thread, use the thread on the tablet of the table. Removing the armor will apply the threads to the armor. To remove a thread, place the armor on the table and interact with the display with an empty hand.");
        this.add("item.ars_nouveau.blank_thread", "Blank Thread");
        this.add("tooltip.ars_nouveau.blank_thread", "Used to craft threads that may be used to empower your magical armor.");
        this.add("ars_nouveau.perk.invalid_for_slot", "This perk requires a level %s or higher slot.");
        this.add("ars_nouveau.perk.warding", "Warding");
        this.add("ars_nouveau.perk.warding.desc", "Reduces the amount of magic damage taken.");
        this.add("ars_nouveau.perk.mana_regen", "Mana Regen");
        this.add("ars_nouveau.perk.mana_regen.desc", "Increases the rate at which mana regenerates.");
        this.add("ars_nouveau.perk.percent_max_mana", "Max Mana");
        this.add("ars_nouveau.perk.max_mana", "Max Mana");
        this.add("ars_nouveau.perk.max_mana.desc", "Increases the maximum amount of mana.");
        this.add("ars_nouveau.perk.spell_damage", "Spell Power");
        this.add("ars_nouveau.perk.spell_damage.desc", "Increases the damage of your ars spells");
        this.add("ars_nouveau.perk.saturation", "Bonus Saturation");
        this.add("ars_nouveau.perk.saturation.desc", "Increases the saturation of the food");
        this.add("ars_nouveau.perk.wixie", "Potion Duration");
        this.add("ars_nouveau.perk.wixie.desc", "Increases the duration of potion effects.");
        this.add("ars_nouveau.perk.drygmy", "Extra Looting");
        this.add("ars_nouveau.perk.drygmy.desc", "Increases the amount of loot dropped by mobs.");
        this.add("ars_nouveau.perk.jump_height", "Jump Power");
        this.add("ars_nouveau.perk.jump_height.desc", "Increases the height of your jumps.");
        this.add("ars_nouveau.perk.feather", "Fall Damage Reduction");
        this.add("ars_nouveau.perk.feather.desc", "Reduces the amount of fall damage taken.");
        this.add("ars_nouveau.perk.weight", "Weight");
        this.add("ars_nouveau.perk.weight.desc", "Affects how much gravity is applied.");
        this.add("ars_nouveau.page.threads", "Each type of armor has its own unique set of Thread Slots. Upgrading the armor to a new tier will unlock and add additional slots to the armor. The Sorcerors set provides the least amount of defence while providing the most powerful slots, while the Battlemage's set provides defence but much weaker slots. For recipes on upgrading your armor to the next tier, see the section in the Armor and Perks category.");
        this.add("ars_nouveau.threads", "Thread Slots");
        this.add("ars_nouveau.thread_layout", "Thread Tiers");
        this.add("ars_nouveau.page.applying_perks", "Applying Threads");
        this.add("ars_nouveau.page1.applying_perks", "Threads may be applied to armor using the Alteration Apparatus. Each piece of armor has a unique set of Thread Slots with their own variety of levels. Some Threads may require a Thread Slot of a minimum level, but many threads simply increase in power based on the slot they are given.");
        this.add("ars_nouveau.page2.applying_perks", "Threads only apply a single time on an entire armor set, and they do not stack. For more information on applying threads, see the Alteration Table.");
        this.add("ars_nouveau.perk.not_perk", "Use a thread to apply it onto the selected armor.");
        this.add("ars_nouveau.perk.set_armor", "Place armor onto the table.");
        this.add("ars_nouveau.perk.max_perks", "This armor has reached its maximum number of perks.");
        this.add("ars_nouveau.page.layout_desc", "Each set of armor has its own unique set of Thread Slots.");
        this.add("ars_nouveau.armor_upgrade.book_desc", "Accepts Tier %s Armor");
        this.add("ars_nouveau.spell_write.book_desc", "Accepts Reactive Items");
        this.add("ars_nouveau.perks.duplicated", "You have equipped armor that contains a perk you already have. You will only receive the effect of the perk once.");
        this.add("ars_nouveau.totem_perk.trigger", "Thread of Undying will reactive the next time you sleep.");
        this.add("ars_nouveau.totem_perk.active", "Thread of Undying is now active.");
        this.add("ars_nouveau.sound.fire_family", "Fire");
        this.add("ars_nouveau.sound.default_family", "Default");
        this.add("ars_nouveau.sound.tempestry_family", "Tempestry");
        this.add("ars_nouveau.sound.gaia_family", "Gaia");
        this.add("block.ars_nouveau.mob_jar", "Containment Jar");
        this.add("ars_nouveau.page.mob_jar", "Containment Jar");
        this.add("ars_nouveau.page1.mob_jar", "Allows you to capture and store mobs for transportation or decoration. To capture a mob, you must perform a Ritual of Containment. See the Ritual of Containment for more info. To release a mob, cast Dispel on the jar and the mob will be released above the jar. Note Blocks placed above a jar will play an ambient sound of the mob inside.");
        this.add("ars_nouveau.page2.mob_jar", "Many entities can be interacted with inside the jar and will continue to simulate while inside the jar. Some examples include: chickens will lay eggs, sheep can be sheared, cows can be milked, and some mobs like the Blaze will turn the jar into a light source. Experiment with a variety of mobs to create aesthetic and functional farms. Drygmys will also treat the jar as if it were a normal entity in the area.");
        this.add("ars_nouveau.title.mob_jar", "Functionality");
        this.add("ars_nouveau.advancement.title.root", "Ars Nouveau");
        this.add("ars_nouveau.advancement.desc.root", "Acquire a Tattered Tome");
        this.add("ars_nouveau.adv.title.ritual_brazier", "Brazen");
        this.add("ars_nouveau.adv.desc.ritual_brazier", "Acquire a Ritual Brazier");
        this.add("ars_nouveau.adv.title.familiar", "This Seems Familiar...");
        this.add("ars_nouveau.adv.desc.familiar", "Bind a magical creature into a Familiar");
        this.add("ars_nouveau.adv.title.amethyst_golem_charm", "Purple Amethyst Eater");
        this.add("ars_nouveau.adv.desc.amethyst_golem_charm", "Acquire an Amethyst Golem Charm");
        this.add("ars_nouveau.adv.title.novice_spell_book", "Unbreaking X");
        this.add("ars_nouveau.adv.desc.novice_spell_book", "Acquire a Novice Spell Book");
        this.add("ars_nouveau.adv.title.apprentice_spell_book", "Mage's Spell Book");
        this.add("ars_nouveau.adv.desc.apprentice_spell_book", "Acquire a Mage's Spell Book");
        this.add("ars_nouveau.adv.title.archmage_spell_book", "Archmage Spell Book");
        this.add("ars_nouveau.adv.desc.archmage_spell_book", "Acquire an Archmage Spell Book");
        this.add("ars_nouveau.adv.title.shapers_focus", "Throw Another Rock!");
        this.add("ars_nouveau.adv.desc.shapers_focus", "Acquire a Shaper's Focus");
        this.add("ars_nouveau.adv.title.imbuement_chamber", "Imbued");
        this.add("ars_nouveau.adv.desc.imbuement_chamber", "Acquire an Imbuement Chamber");
        this.add("ars_nouveau.adv.title.eat_bombegranate", "To Die For");
        this.add("ars_nouveau.adv.desc.eat_bombegranate", "Eat a Bombegranate");
        this.add("ars_nouveau.adv.title.poof_mob", "Where did it go?");
        this.add("ars_nouveau.adv.desc.poof_mob", "Make a \"Trade\" with a Magical Creature");
        this.add("ars_nouveau.adv.title.enchanting_apparatus", "Magic Mod Mechanic");
        this.add("ars_nouveau.adv.desc.enchanting_apparatus", "Acquire an Enchanting Apparatus");
        this.add("ars_nouveau.adv.title.starby_charm", "The Cutest Hopper");
        this.add("ars_nouveau.adv.desc.starby_charm", "Acquire a Starbuncle Charm");
        this.add("ars_nouveau.adv.title.wixie_charm", "Free the Inner Child");
        this.add("ars_nouveau.adv.desc.wixie_charm", "Acquire a Wixie Charm");
        this.add("ars_nouveau.adv.title.whirlisprig_charm", "Whirli");
        this.add("ars_nouveau.adv.desc.whirlisprig_charm", "Acquire a Whirlisprig Charm");
        this.add("ars_nouveau.adv.title.magebloom_crop", "Magebloom");
        this.add("ars_nouveau.adv.desc.magebloom_crop", "Acquire a Magebloom Seed");
        this.add("ars_nouveau.adv.title.basic_spell_turret", "It's a Magic Mod, I Swear!");
        this.add("ars_nouveau.adv.desc.basic_spell_turret", "Acquire a Basic Spell Turret");
        this.add("ars_nouveau.adv.title.spell_prism", "Prismatic Redirection");
        this.add("ars_nouveau.adv.desc.spell_prism", "Acquire a Spell Prism");
        this.add("ars_nouveau.adv.title.scryers_oculus", "Eye Spy");
        this.add("ars_nouveau.adv.desc.scryers_oculus", "Acquire a Scryer's Oculus");
        this.add("ars_nouveau.adv.title.potion_jar", "Potion Storage");
        this.add("ars_nouveau.adv.desc.potion_jar", "Acquire a Potion Jar");
        this.add("ars_nouveau.adv.title.alteration_table", "Armor Alteration");
        this.add("ars_nouveau.adv.desc.alteration_table", "Acquire an Alteration Table");
        this.add("ars_nouveau.adv.desc.blank_thread", "Acquire a Blank Thread");
        this.add("ars_nouveau.adv.title.blank_thread", "Empty Canvas");
        this.add("ars_nouveau.adv.title.potion_melder", "Meld'em, Mash'em, Stick'em in a Cauldron");
        this.add("ars_nouveau.adv.desc.potion_melder", "Acquire a Potion Melder");
        this.add("ars_nouveau.adv.title.potion_diffuser", "Do you smell that?");
        this.add("ars_nouveau.adv.desc.potion_diffuser", "Acquire a Potion Diffuser");
        this.add("ars_nouveau.adv.title.potion_flask", "Stackable Potions");
        this.add("ars_nouveau.adv.desc.potion_flask", "Acquire a Potion Flask");
        this.add("ars_nouveau.adv.title.wilden_tribute", "Wilden Tribute");
        this.add("ars_nouveau.adv.desc.wilden_tribute", "Acquire a Wilden Tribute");
        this.add("ars_nouveau.adv.title.summon_focus", "Summoning Focus");
        this.add("ars_nouveau.adv.desc.summon_focus", "Acquire a Summoning Focus");
        this.add("ars_nouveau.adv.title.wixie_hat", "Potion Transport");
        this.add("ars_nouveau.adv.desc.wixie_hat", "Acquire a Wixie Hat");
        this.add("ars_nouveau.adv.title.starbuncle_shades", "One Cool Starbuncle");
        this.add("ars_nouveau.adv.desc.starbuncle_shades", "Acquire Starbuncle Shades");
        this.add("ars_nouveau.adv.title.wilden_explosion", "Wait, it can fly?");
        this.add("ars_nouveau.adv.desc.wilden_explosion", "Witness an explosive divebomb");
        this.add("ars_nouveau.adv.title.prismatic", "Thinking with Prisms");
        this.add("ars_nouveau.adv.desc.prismatic", "Redirect a Spell using a Prism four or more times");
        this.add("ars_nouveau.adv.title.create_portal", "Thinking with...wrong game");
        this.add("ars_nouveau.adv.desc.create_portal", "Create a Warp Portal");
        this.add("ars_nouveau.adv.title.warp_scroll", "Warped");
        this.add("ars_nouveau.adv.desc.warp_scroll", "Acquire a Warp Scroll");
        this.add("ars_nouveau.adv.title.drygmy_charm", "Moose Dance");
        this.add("ars_nouveau.adv.desc.drygmy_charm", "Acquire a Drygmy Charm");
        this.add("ars_nouveau.adv.title.source_jar", "Not a Fluid!");
        this.add("ars_nouveau.adv.desc.source_jar", "Acquire a Source Jar");
        this.add("ars_nouveau.adv.title.mob_jar", "Tiny Home");
        this.add("ars_nouveau.adv.desc.mob_jar", "Acquire a Containment Jar");
        this.add("ars_nouveau.adv.title.shrunk_starbuncle", "Honey I Shrunk the Starbuncle");
        this.add("ars_nouveau.adv.desc.shrunk_starbuncle", "Put a Starbuncle in a Containment Jar");
        this.add("ars_nouveau.adv.title.ritual_gravity", "You're Grounded");
        this.add("ars_nouveau.adv.desc.ritual_gravity", "Be affected by a Ritual of Gravity");
        this.add("block.ars_nouveau.void_prism", "Void Prism");
        this.add("ars_nouveau.page.void_prism", "Destroys any spell projectiles that pass through it.");
        this.add("item.ars_nouveau.music_disc_aria_biblio", "Music Disc");
        this.add("jukebox_song.ars_nouveau.aria_biblio", "Firel - Aria Biblio");
        this.add("item.ars_nouveau.starby_gift", "Starbuncle Gift");
        this.add("ars_nouveau.present.give", "Give this to a friend and they will get bonus items, or open it for yourself!");
        this.add("ars_nouveau.present.from", "A gift from %s");
        this.add("entity.ars_nouveau.gift_starby", "Starbuncle");
        this.add("block.ars_nouveau.falseweave", "Falseweave");
        this.add("block.ars_nouveau.ghostweave", "Ghostweave");
        this.add("block.ars_nouveau.mirrorweave", "Mirrorweave");
        this.add("block.ars_nouveau.magebloom_block", "Magebloom Block");
        this.add("ars_nouveau.page.illusion_blocks", "Illusion Blocks");
        this.add("ars_nouveau.page1.illusion_blocks", "Mirrorweave can replicate the appearance of any block that is used on it. These blocks will take on the same collisions and light as their replicated block. Sense Magic will reveal the illusion. All illusion blocks can also be used as frames for portals. Casting light on an illusion block will allow it to emit light.");
        this.add("ars_nouveau.page2.illusion_blocks", "Falseweave has the same properties as Mirrorweave, but can be passed through as if it were air. Sense Magic will cause the block to become invisible, revealing any hidden paths.");
        this.add("ars_nouveau.page3.illusion_blocks", "Ghostweave has the same properties as Mirrorweave, but can be turned into an invisible wall by casting Invisbility on it. Casting Dispel will reveal the block again. Sense Magic will cause the block to appear solid again.");
        this.add("item.ars_nouveau.spell_crossbow", "Enchanter's Crossbow");
        this.add("ars_nouveau.page1.spell_crossbow", "A crossbow that can be inscribed with a spell. The mana cost of the spell will be deducted when the bow is loaded if mana is present. Enchanter's Crossbows may use special augment arrows to empower their spells.");
        this.add("ars_nouveau.tooltip.from_blank", "Created by scribing a Blank Parchment in the scribes table.");
        this.add("ars_nouveau.manipulation_essence.tooltip", "Can be scribed onto a Spell Parchment or caster tool to permanently hide the spell.");
        this.add("ars_nouveau.spell_hidden", "Spell is now hidden.");
        this.add("entity.minecraft.villager.ars_nouveau.shady_wizard", "Shady Wizard");
        this.add("entity.minecraft.villager.shady_wizard", "Shady Wizard");
        this.add("death.attack.an_enchantedBlock", "%1$s was crushed by %2$s magic blocks");
        this.add("death.attack.freeze.item", "%1$s was frozen to death by %2$s using %3$");
        this.add("death.attack.sourceberry_bush", "%1$s was poked to death by a sourceberry bush");
        this.add("death.attack.sourceberry_bush.player", "%1$s was poked to death by a sourceberry bush while trying to escape %2$s");
        this.add("block.ars_nouveau.magelight_torch", "Magelight Torch");
        this.add("block.ars_nouveau.arcane_platform", "Arcane Platform");
        this.add("ars_nouveau.arcane_platform.tooltip", "Can be placed in any direction and can be used in place of a pedestal.");
        this.add("ars_nouveau.brazier_relay.connected", "Brazier connected.");
        this.add("block.ars_nouveau.brazier_relay", "Ritual Brazier Relay");
        this.add("ars_nouveau.page.brazier_relay", "Allows the users to bind a Ritual Brazier ritual to a new location. Multiple rituals can be connected to the same brazier relay. To connect, use the Dominion Wand on your Ritual Brazier, then the relay. Source is consumed at the original braziers location. Can be bound within 15 blocks.");
        this.add("item.ars_nouveau.stable_warp_scroll", "Stabilized Warp Scroll");
        this.add("overworld.minecraft.name", "Overworld");
        this.add("the_nether.minecraft.name", "The Nether");
        this.add("the_end.minecraft.name", "The End");
        this.add("ars_nouveau.page.stable_warp_scroll", "Creates a temporary Warp Portal when used on a block. This scroll is not consumed on use and can teleport between dimensions. Using a Stabilized Warp Scroll to create a Warp Portal will create a cross dimension warp portal, but consume the scroll. This scroll may only be bound to a location a single time.");
        this.add("ars_nouveau.adv.title.catch_lightning", "Lightning in a Bottle");
        this.add("ars_nouveau.adv.desc.catch_lightning", "Catch a lightning bolt in a containment jar.");
        this.add("ars_nouveau.adv.title.time_in_a_bottle", "Time in a Bottle");
        this.add("ars_nouveau.adv.desc.time_in_a_bottle", "Put a clock in a containment jar");
        this.add("ars_nouveau.light_message", "Ars Nouveau adds built in dynamic lights. Enable with `/ars-light on`. This won't appear again!");
        this.add("ars_nouveau.warp_scroll.already_recorded", "This scroll is already bound to a location.");
        this.add("ars_nouveau.page4.illusion_blocks", "Skyweave will display the skybox of the dimension it is placed in. To toggle the skybox and show the facade, cast Dispel on it. The facade may be set to another block like Mirrorweave.");
        this.add("block.ars_nouveau.sky_block", "Skyweave");
        this.add("ars_nouveau.scry_caster.not_crystal", "The bound crystal is no longer present.");
        this.add("ars_nouveau.scry_caster.no_pos", "No position set. Use this on a Scry Crystal or hold a Scryer's Scroll in the offhand.");
        this.add("ars_nouveau.scry_caster.invalid_behavior", "Invalid spell bound. Rebind a new valid spell.");
        this.add("entity.ars_nouveau.animated_block", "Animated Block");
        this.add("entity.ars_nouveau.animated_head", "Animated Head");
        this.add("item.ars_nouveau.enchanters_eye", "Enchanter's Eye");
        this.add("ars_nouveau.page.enchanters_eye", "A caster tool that can cast inscribed spells remotely through a Scry Crystal. Use the eye on a Scry Crystal to bind the location, or hold a bound Scry Parchment in the offhand. Spells will be cast through the eye similar to a Spell Turret, but you are considered the caster for all effects. Useful for remote teleportation or item movement.");
        this.add("ars_nouveau.warp_scroll.disabled_warp_portal", "Permanent warp portals are currently disabled");
        this.add("ars_nouveau.lectern_out_of_range", "The lectern is out of range.");
        this.add("tooltip.ars_nouveau.items_missing", "Items Missing");
        this.add("narrator.ars_nouveau.search", "Search");
        this.add("tooltip.ars_nouveau.amount", "Total: %s");
        this.add("tooltip.ars_nouveau.sorting_1", "Sorting Alphabetically");
        this.add("tooltip.ars_nouveau.sorting_0", "Sorting by Amount");
        this.add("ars_nouveau.storage.from_set", "Inventory added.");
        this.add("ars_nouveau.storage.too_many", "Maximum number of inventories reached. Add more Bookwyrms to increase the limit.");
        this.add("ars_nouveau.storage.num_connected", "%s connected inventories");
        this.add("ars_nouveau.storage_lectern", "Storage Lectern");
        this.add("tooltip.ars_nouveau.search_0", "Non-synced Search");
        this.add("tooltip.ars_nouveau.search_1", "Synced Search");
        this.add("ars_nouveau.invalid_lectern", "Invalid lectern connected.");
        this.add("ars_nouveau.storage.lectern_chained", "Linked to x: %s y: %s z: %s");
        this.add("ars_nouveau.storage.num_bookwyrms", "%s Bookwyrms");
        this.add("ars_nouveau.storage.removed", "Inventory removed.");
        this.add("ars_nouveau.storage.not_lectern", "Connect to another Lectern to connect the views.");
        this.add("ars_nouveau.storage.lectern_too_far", "Lectern must be within %s blocks.");
        this.add("ars_nouveau.storage.inv_too_far", "Inventory must be within %s blocks.");
        this.add("ars_nouveau.storage.no_tile", "Not a valid inventory.");
        this.add("block.ars_nouveau.storage_lectern", "Storage Lectern");
        this.add("ars_nouveau.page1.storage_lectern", "The Storage Lectern can used to view, manage, and craft from multiple connected inventories. The number of inventories that may be connected is determined by the number of Bookwyrms bound to the lectern. You can add more Bookwyrms to the lectern by using a Bookwyrm Charm. Use the Dominion Wand from an inventory to the lectern in order to bind or remove access. Inventories can be connected 30 blocks away.");
        this.add("ars_nouveau.storage", "Advanced Usage");
        this.add("ars_nouveau.page2.storage", "Items can be automatically inserted into the lectern by placing them into an unbound inventory that is adjacent to the lectern. Automatic import may be disabled by providing a redstone signal. You may also link a lectern to the 'main' lectern in order to extend the view and access of the original lectern, these lecterns can be chained together within 30 blocks indefinitely. Once a lectern is linked to another lectern, it will no longer be able to connect to inventories or accept bookwyrms.");
        this.add("ars_nouveau.tooltip.bookwyrm", "Obtained by augmenting a Ritual of Awakening with Book and Quills.");
        this.add("ars_nouveau.item_detector.count", "Emit at %s");
        this.add("block.ars_nouveau.item_detector", "Display Case");
        this.add("ars_nouveau.item_detector.item", "%s");
        this.add("ars_nouveau.item_detector.powered", "Powered: %s");
        this.add("ars_nouveau.item_detector.connected", "Detecting items at x: %s y: %s z: %s");
        this.add("ars_nouveau.page1.item_detector", "A Display Case can be configured to output a redstone signal when a certain level of inventory is reached. To set the item for tracking, use an item on the case. Interact with the block to increase the count, and punch to decrease. To link to an inventory, Dominion Wand an inventory to the display case. Wanding while sneaking will invert if the signal outputs below or greater than the set count.");
        this.add("ars_nouveau.item_detector.inverted", "Signal Inverted: %s");
        this.add("block.ars_nouveau.repository", "Repository");
        this.add("ars_nouveau.removed_familiars", "Dispelled Familiars");
        this.add("key.ars_nouveau.familiar_toggle", "Summon/Dispel Familiar");
        this.add("ars_nouveau.spell_book_gui.dispel", "Dispel");
        this.add("tooltip.ars_nouveau.master_tab", "All Items");
        this.add("ars_nouveau.page1.repository", "A repository can store a double chests worth of items. When named, it will display the name as a tooltip, and preserve it when dropped as an item. Useful for creating named inventory tabs with the Storage Lectern. A Repository Catalog can be used as a proxy for a chain of connected repositories, and respects filter scrolls on repositories when inserting items.");
        this.add("ars_nouveau.storage_tabs", "Storage Tabs");
        this.add("ars_nouveau.page3.storage", "Linked inventories that are named will create a tab in the Storage Lectern, allowing you to view and manipulate all inventories that share that name. Unlike normal chests, Repositories will preserve their name when dropped. The Name Effect can also name inventories placed in the world.");
        this.add("ars_nouveau.storage_performance", "Performance");
        this.add("ars_nouveau.page4.storage", "Repository Catalogs should be used when possible for large or frequent item automations involving the storage lectern. Repository catalogs are bound to a single location that exposes all connected repositories, and is optimized for server performance over other large slot inventories or chests.");
        this.add("ars_nouveau.page2.item_detector", "If a Filter Scroll is given to the Display Case, it will count all items that match the filter.");
        this.add("config.jade.plugin_ars_nouveau.mob_jar", "Mob Jar");
        this.add("mob_jar.villager", "Can be traded with in a jar, periodically resetting its trades.");
        this.add("mob_jar.piglin", "Can be traded with by throwing gold ingots at the jar.");
        this.add("mob_jar.ender_dragon", "Use a bottle to obtain Dragon's Breath.");
        this.add("mob_jar.sheep", "Can be sheared. Will eat Grass beneath the jar if available.");
        this.add("mob_jar.chicken", "Will occasionally lay eggs.");
        this.add("mob_jar.cow", "Can be milked.");
        this.add("mob_jar.mooshroom", "Can use a bowl to obtain mushroom stew. Can be sheared into a normal cow.");
        this.add("mob_jar.pufferfish", "Will inflate when mobs are nearby. While inflated, the jar produces a redstone signal.");
        this.add("mob_jar.frog", "Will eat nearby slimes.");
        this.add("mob_jar.panda", "Baby pandas will occasionally sneeze, creating Slimeballs. Sick Pandas will sneeze more often.");
        this.add("mob_jar.allay.title", "Allay Behavior");
        this.add("mob_jar.allay", "A jarred Allay can pickup and deposit items within 5 blocks of the jar. Giving an Allay an item will cause it to only pickup that item. Giving an Allay an Item Scroll will pickup any item that matches the scroll. Items will be deposited into inventories placed adjacent to the jar. Allays will also respect any filters placed on the adjacent inventories.");
        this.add("mob_jar.armadillo", "Will occasionally shed scutes.");
        this.add("mob_jar.breeze", "Shoots a wind charge when powered with redstone.");
        this.add("mob_jar.cat", "Will give gifts if its owner sleeps nearby. Produces a redstone signal if the owner is online.");
        this.add("mob_jar.sniffer", "Will occasionally dig up ancient seeds.");
        this.add("mob_jar.snow_golem", "Shoots a snowball when powered with redstone.");
        this.add("ars_nouveau.cauldron.num_bounded", "%s bounded inventories");
        this.add("ars_nouveau.wixie_cauldron.bound", "Inventory bound.");
        this.add("ars_nouveau.wixie_cauldron.removed", "Inventory removed.");
        this.add("ars_nouveau.wixie_cauldron.cleared", "Bound inventories cleared.");
        this.add("ars_nouveau.binding_inventories", "Binding Inventories");
        this.add("ars_nouveau.page7.wixie_charm", "You can select specific inventories for the wixie by using a dominion wand on an inventory, and then the cauldron. If any inventories are selected, only these inventories can be used and the Wixie will no longer pull from all nearby inventories by default.");
        this.add("tooltip.ars_nouveau.direction_0", "Sorting Descending");
        this.add("tooltip.ars_nouveau.direction_1", "Sorting Ascending");
        this.add("tooltip.ars_nouveau.clear_grid", "Clear");
        this.add("tooltip.ars_nouveau.open_recipe", "Recipe Book");
        this.add("ars_nouveau.color_gui.rainbow", "Rainbow");
        this.add("ars_nouveau.adopter", "Adopted by %s");
        this.add("entity.ars_nouveau.lily", "Lily");
        this.add("ars_nouveau.lily", "Patrons may summon Lily, a faithful tail wagging companion.");
        this.add("ars_nouveau.nook", "Patrons may summon Nook, a faithfulish tail wagging companion.");
        this.add("ars_nouveau.settings.summon_lily", "Summon Lily");
        this.add("ars_nouveau.settings.unsummon_lily", "Unsummon Lily");
        this.add("entity.ars_nouveau.nook", "Nook");
        this.add("ars_nouveau.settings.summon_nook", "Summon Nook");
        this.add("ars_nouveau.settings.unsummon_nook", "Unsummon Nook");
        this.add("ars_nouveau.rewards.enabled", "Ars Nouveau supporter rewards enabled, thank you! Rewards can be accessed in the Settings page of the spell book.");
        this.add("mob_jar.dummy", "A player dummy in a jar will attract nearby mobs.");
        this.add("ars_nouveau.turret.tooltip", "Can be rotated to face any direction. Use a dominion wand on the turret, and then on the target block.");
        this.add("ars_nouveau.scribes_table.auto_take_disabled", "Auto Take Disabled");
        this.add("item.ars_nouveau.debug", "Ars Nouveau Debugger");
        this.add("ars_nouveau.alert.turret_needs_form", "Spell must have a form.");
        this.add("item.ars_nouveau.music_disc_thistle_the_sound_of_glass", "Music Disc");
        this.add("jukebox_song.ars_nouveau.thistle_the_sound_of_glass", "Thistle - The Sound of Glass");
        this.add("item.ars_nouveau.music_disc_firel_the_wild_hunt", "Music Disc");
        this.add("jukebox_song.ars_nouveau.firel_the_wild_hunt", "Firel - The Wild Hunt");
        this.add("ars_nouveau.sensor.set_spell", "Sensor will now trigger on this spell only.");
        this.add("ars_nouveau.sensor.on_resolve", "Mode: On Resolve");
        this.add("ars_nouveau.sensor.on_cast", "Mode: On Cast");
        this.add("block.ars_nouveau.spell_sensor", "Spell Sensor");
        this.add("ars_nouveau.page.spell_sensor", "Outputs a redstone signal when a spell is cast nearby. Output strength is determined by the length of the spell cast. Using a Dominion Wand will cause it to trigger when a spell resolves nearby, instead of being cast. Using a Spell Parchment will set the sensor to only output when that exact spell is detected.");
        this.add("ars_nouveau.no_stack_crafting", "No valid craft nearby.");
        this.add("item.ars_nouveau.jump_ring", "Ring of Jumping");
        this.add("ars_nouveau.page.jump_ring", "Allows the user to continue jumping in the air. Each jump will expend mana.");
        this.add("ars_nouveau.connections.remove", "Connection removed.");
        this.add("ars_nouveau.powered_from", "Receiving signal from %d relays");
        this.add("block.ars_nouveau.redstone_relay", "Redstone Relay");
        this.add("ars_nouveau.page.redstone_relay", "Can be connected to other Redstone Relays to wirelessly send a redstone signal. Takes input from one side and outputs in all other directions. Can be connected within 30 blocks of another relay, and multiple relays can be connected.");
        this.add("block.ars_nouveau.magic_fire", "Mage Fire");
        this.add("effect.ars_nouveau.immolate", "Immolate");
        this.add("effect.ars_nouveau.immolate.desc", "Enhances fire spells.");
        this.add("effect.ars_nouveau.soaked", "Soaked");
        this.add("effect.ars_nouveau.soaked.desc", "Wets the target, protecting from fire and triggering effects as if under the rain.");
        this.add("block.ars_nouveau.sourceberry_sack", "Sourceberry Sack");
        this.add("ars_nouveau.empty", "Empty");
        this.add("ars_nouveau.melder.output_not_unique", "Output potion is not a unique mix.");
        this.add("ars_nouveau.melder.output_duplicate_effect", "Cannot mix potions with the same effect but different levels.");
        this.add("ars_nouveau.page1.archwood_grate", "Liquids placed on top of them will be transported below, waterlogging the below block if possible. Interacting with the grate will also act as if you are interacting with the block below it, allowing you to bucket liquids below. Additionally, items and projectiles will pass through it. Can be placed in any direction.");
        for (Iterator<Object> iterator : LibBlockNames.DECORATIVE_SOURCESTONE) {
            key = "block.ars_nouveau." + iterator;
            String val = this.data.get(key);
            this.add((String)key + "_slab", val + " Slab");
            this.add((String)key + "_stairs", val + " Stairs");
        }
        this.add("block.ars_nouveau.sourcestone_grate", "Sourcestone Grate");
        this.add("block.ars_nouveau.gold_grate", "Gold Grate");
        this.add("block.ars_nouveau.archwood_grate", "Archwood Grate");
        this.add("block.ars_nouveau.smooth_sourcestone_grate", "Smooth Sourcestone Grate");
        this.add("block.ars_nouveau.source_lamp", "Source Gem Lamp");
        this.add("ars_nouveau.page.source_lamp", "Behaves like a copper bulb, but the light and comparator values can be adjusted by casting Light with dampen.");
        this.add("ars_nouveau.patchouli.missing", "Patchouli missing: opening online wiki");
        this.add("ars_nouveau.dependency.install", "Open mod page");
        this.add("tooltip.starbuncle_shard2", "Made with love.");
        this.add("tooltip.whirlisprig_shard2", "A natural portrait.");
        this.add("tooltip.drygmy_shard2", "A tribute to what once was.");
        this.add("tooltip.wixie_shard2", "Knowledge for freedom.");
        this.add("block.ars_nouveau.alakarkinos_hat", "Alakarkinos Hat");
        this.add("entity.ars_nouveau.bubble", "Bubble");
        this.add("entity.ars_nouveau.alakarkinos", "Alakarkinos");
        this.add("item.ars_nouveau.alakarkinos_charm", "Alakarkinos Charm");
        this.add("item.ars_nouveau.alakarkinos_token", "Alakarkinos Token");
        this.add("ars_nouveau.page1.alakarkinos_charm", "Alakarkinos can sift sand and gravel to find items found in archaeology sites. They can be found on beaches and will give you a token if they receive a Pottery Sherd of any kind.");
        this.add("ars_nouveau.page2.alakarkinos_charm", "Loves to dance to nearby jukeboxes.");
        this.add("ars_nouveau.page3.alakarkinos_charm", "Alakarkinos can be summoned anywhere by using a charm on a block. To set its home, use the Dominion Wand to bind Alakarkinos to a chest or inventory.");
        this.add("ars_nouveau.page4.alakarkinos_charm", "Alakarkinos will seek out gravel or sand that is placed within 3 blocks horizontal and one block vertical around its bound inventory. In order to convert blocks into items, Source must be provided near its chest. After some time and a few magic tricks, Alakarkinos will destroy the sand or gravel and insert items into the inventory.");
        this.add("ars_nouveau.alakarkinos.set_home", "Home set. Place source and gravel or sand within 3 blocks.");
        this.add("ars_nouveau.sifting", "Sifting");
        this.add("tooltip.alakarkinos_shard1", "Found by giving an Alakarkinos a Sherd.");
        this.add("tooltip.alakarkinos_shard2", "What's that behind your ear?");
        this.addCategory("getting_started", "Getting Started");
        this.addCategory("crafting", "Crafting and Automation");
        this.addCategory("glyph_index", "Glyph Index");
        this.addCategory("ritual_index", "Ritual Index");
        this.addCategory("source", "Source");
        this.addCategory("creature_compendium", "Creature Compendium");
        this.addCategory("items_equipment", "Items and Equipment");
        this.addCategory("spell_casting", "Spell Casting");
        this.addCategory("items", "Items");
        this.addCategory("glyphs_tier_one", "Tier One Glyphs");
        this.addCategory("glyphs_tier_two", "Tier Two Glyphs");
        this.addCategory("glyphs_tier_three", "Tier Three Glyphs");
        this.addCategory("armor", "Armor");
        this.addCategory("familiars", "Familiars");
        this.addCategory("equipment", "Items");
        this.addCategory("field_guide", "Field Guide");
        this.addCategory("enchanting", "Apparatus Enchanting");
        this.add("ars_nouveau.augmenting", "Augmenting %s:");
        this.add("ars_nouveau.tier.one", "Tier One");
        this.add("ars_nouveau.tier.two", "Tier Two");
        this.add("ars_nouveau.tier.three", "Tier Three");
        this.add("ars_nouveau.shift_delete", "Shift-Click to remove");
        this.add("ars_nouveau.add_bookmark", "Add Bookmark");
        this.add("ars_nouveau.shift_back", "Shift-Click to go to home");
        this.add("ars_nouveau.doc.categories", "Categories");
        this.add("ars_nouveau.doc.related_entries", "Related Entries");
        this.add("ars_nouveau.doc.search_results", "Search Results");
        this.add("ars_nouveau.documentation.intro1", "Welcome to Ars Nouveau! If you are new, following Getting Started and completing the Advancements is recommended.");
        this.add("ars_nouveau.documentation.intro2", "Join the discord to share spells, ask questions, and see what's coming next!");
        this.add("ars_nouveau.connected_search_result", "%s (%s)");
        this.add("ars_nouveau.keyword.glyph", "Glyph");
        this.add("ars_nouveau.keyword.thread", "Thread");
        this.add("ars_nouveau.keyword.ritual", "Ritual");
        this.add("ars_nouveau.keyword.familiar", "Familiar");
        this.add("ars_nouveau.slots_armor", "Thread Slots and Tiers");
        this.add("ars_nouveau.thread_tier", "Tier %s thread slot");
        this.add("ars_nouveau.search_desc", "Search for any entry, item, or concepts such as Glyph, Familiar, Ritual, Spell School, etc.");
        this.add("emi.category.ars_nouveau.apparatus_enchanting", this.data.get("ars_nouveau.enchanting"));
        this.add("emi.category.ars_nouveau.scry_ritual", this.data.get("ars_nouveau.scry_ritual_recipe"));
        this.add("emi.category.ars_nouveau.crush", this.data.get("ars_nouveau.crush_recipe"));
        this.add("emi.category.ars_nouveau.glyph_recipe", this.data.get("block.ars_nouveau.scribes_table"));
        this.add("emi.category.ars_nouveau.budding_conversion", this.data.get("ars_nouveau.budding_conversion_recipe"));
        this.add("emi.category.ars_nouveau.enchanting_apparatus", this.data.get("ars_nouveau.enchanting_apparatus"));
        this.add("emi.category.ars_nouveau.armor_upgrade", this.data.get("ars_nouveau.armor_upgrade"));
        this.add("emi.category.ars_nouveau.imbuement", this.data.get("block.ars_nouveau.imbuement_chamber"));
        this.add("emi.category.ars_nouveau.alakarkinos", this.data.get("ars_nouveau.alakarkinos_recipe"));
        this.add("block.ars_nouveau.banner.fire", "Fire School");
        this.add("block.ars_nouveau.banner.water", "Water School");
        this.add("block.ars_nouveau.banner.air", "Air School");
        this.add("block.ars_nouveau.banner.earth", "Earth School");
        this.add("block.ars_nouveau.banner.manipulation", "Manipulation School");
        this.add("block.ars_nouveau.banner.abjuration", "Abjuration School");
        this.add("block.ars_nouveau.banner.conjuration", "Conjuration School");
        this.add("ars_nouveau.lectern_blacklist", "This block has been disabled from being connected to the Storage Lectern.");
        this.add("key.ars_nouveau.open_documentation", "Open Documentation");
        this.add("block.ars_nouveau.repository_controller", "Repository Catalog");
        this.add("ars_nouveau.page1.repository_controller", "Catalogs can insert and extract items from any adjacent and connected repository. Catalogs respect filters placed on repositories via item frames while inserting items, and will prioritize existing stacks of an item. Filter scrolls can be used on the Catalog, storing the filter and applying it to all connected repositories when interacted with directly.");
        this.add("ars_nouveau.page2.repository_controller", "Catalogs are highly performant when used with the Storage Lectern and should be used over other big inventories or systems with many slots. Filters are not applied when items are extracted from other systems like a Hopper, and insertions via hopper will not respect the catalogs own filter, but will respect inserting into a filtered repository.");
        this.add("item.ars_nouveau.enchanters_fishing_rod", "Enchanter's Fishing Rod");
        this.add("item.ars_nouveau.enchanters_gauntlet", "Enchanter's Gauntlet");
        this.add("ars_nouveau.fishing_rod.invalid", "Invalid Spell. Enchanter's Fishing Rod accept Effects and Augments only.");
        this.add("ars_nouveau.page1.enchanters_gauntlet", "Gauntlets are a spell casting multi-tool that can break blocks at diamond hardness. Gauntlets accept a single spell and are inscribed using the Scribes Table. Gauntlets always start with Touch and MUST be inscribed with a spell that does not contain a form. Spells cast with the gauntlet are cast with a discount.");
        this.add("ars_nouveau.page1.enchanters_fishing_rod", "Fishing Rods accept a single spell and are inscribed using the Scribes Table. Rods always start with Touch and MUST be inscribed with a spell that does not contain a form. Fishing Rods can be used like a normal fishing rod, but hooking an entity will allow the user to cast the spell on the hooked entity until the line is broken.");
        this.add("ars_nouveau.particle_config.trail", "Line");
        this.add("ars_nouveau.particle_config.burst", "Burst");
        this.add("ars_nouveau.particle_config.helix", "Helix");
        this.add("ars_nouveau.particle_config.spiral", "Spiral");
        this.add("ars_nouveau.particle.property.color", "Color");
        this.add("ars_nouveau.particle.property.particle_type", "Particle");
        this.add("ars_nouveau.spell_styles", "Spell Styles");
        this.add("ars_nouveau.timeline.trail", "Trail");
        this.add("ars_nouveau.timeline.impact", "On Resolve");
        this.add("ars_nouveau.particle_timelines", "Configurable Particles");
        this.add("ars_nouveau.particle.new_glow", "Glow");
        this.add("ars_nouveau.particle.snow", "Snow");
        this.add("ars_nouveau.particle.smoke", "Smoke");
        this.add("ars_nouveau.gui.spell_style", "Spell Style");
        this.add("ars_nouveau.density_slider", "Particles/Sec: %s");
        this.add("ars_nouveau.particle.property.density", "Particle Spawning");
        this.add("ars_nouveau.particle.leaf", "Leaf");
        this.add("ars_nouveau.spawn.point", "Point");
        this.add("ars_nouveau.spawn.sphere", "Sphere");
        this.add("ars_nouveau.spawn.box", "Box");
        this.add("ars_nouveau.radius_slider", "Radius: %s");
        this.add("ars_nouveau.particle_config.upward_wall", "Upward Wall");
        this.add("ars_nouveau.particle.dripping_water", "Water");
        this.add("ars_nouveau.particle.an_bubble", "Bubble");
        this.add("ars_nouveau.particle.dripping_lava", "Lava");
        this.add("ars_nouveau.particle_config.upward_field", "Field");
        this.add("ars_nouveau.particle.property.model", "Body");
        this.add("ars_nouveau.model.empty", "None");
        this.add("ars_nouveau.model.cube", "Cube");
        this.add("ars_nouveau.spawn_header", "Spawn Shape: %s");
        this.add("ars_nouveau.spawn.cube", "Cube");
        this.add("ars_nouveau.hue", "Hue");
        this.add("ars_nouveau.sat", "Saturation");
        this.add("ars_nouveau.lightness", "Lightness");
        this.add("ars_nouveau.particle.end_rod", "End Rod");
        this.add("ars_nouveau.particle.glow_squid", "Glow Squid");
        this.add("ars_nouveau.particle.glow_ink", "Glow Ink");
        this.add("ars_nouveau.particle.crit", "Crit");
        this.add("ars_nouveau.particle.enchant", "Enchant");
        this.add("ars_nouveau.particle.spit", "Spit");
        this.add("ars_nouveau.particle.dust_plume", "Dust Plume");
        this.add("ars_nouveau.particle.small_gust", "Small Gust");
        this.add("ars_nouveau.particle.big_gust", "Big Gust");
        this.add("ars_nouveau.particle.dragon_breath", "Dragon Breath");
        this.add("ars_nouveau.particle.enchanted_hit", "Enchanted Hit");
        this.add("ars_nouveau.particle.sonic_boom", "Sonic Boom");
        this.add("ars_nouveau.particle.firework", "Firework");
        this.add("ars_nouveau.particle.flame", "Flame");
        this.add("ars_nouveau.particle.infested", "Infested");
        this.add("ars_nouveau.particle.sculk_soul", "Sculk Soul");
        this.add("ars_nouveau.particle.soul_fire_flame", "Soul Fire Flame");
        this.add("ars_nouveau.color_rainbow", "Rainbow");
        this.add("ars_nouveau.color_none", "No Tinting");
        this.add("ars_nouveau.timeline.spawn", "On Spawn");
        this.add("ars_nouveau.timeline.flair", "Flair");
        this.add("ars_nouveau.particle_config.none", "None");
        this.add("ars_nouveau.particle_config.wave", "Wave");
        this.add("ars_nouveau.particle_config.zigzag", "Zigzag");
        this.add("ars_nouveau.timeline.tick", "On Tick");
        this.add("ars_nouveau.particle_config.light", "Light");
        this.add("ars_nouveau.particle.heart", "Heart");
        this.add("ars_nouveau.particle.instant_effect", "Instant Effect");
        this.add("ars_nouveau.particle.cobweb", "Cobweb");
        this.add("ars_nouveau.particle.large_smoke", "Large Smoke");
        this.add("ars_nouveau.particle.lava", "Lava");
        this.add("ars_nouveau.particle.mycelium", "Mycelium");
        this.add("ars_nouveau.particle.note", "Note");
        this.add("ars_nouveau.particle.poof", "Poof");
        this.add("ars_nouveau.particle.splash", "Splash");
        this.add("ars_nouveau.particle.minecraft_smoke", "Smoke (MC)");
        this.add("ars_nouveau.particle.white_smoke", "White Smoke");
        this.add("ars_nouveau.particle.sneeze", "Sneeze");
        this.add("ars_nouveau.particle.squid_ink", "Squid Ink");
        this.add("ars_nouveau.particle.sweep_attack", "Sweep Attack");
        this.add("ars_nouveau.particle.totem_of_undying", "Totem of Undying");
        this.add("ars_nouveau.particle.witch", "Witch");
        this.add("ars_nouveau.particle.bubble_pop", "Bubble Pop");
        this.add("ars_nouveau.particle.nautilus", "Nautilus");
        this.add("ars_nouveau.particle.campfire_cosy_smoke", "Campfire Cosy Smoke");
        this.add("ars_nouveau.particle.campfire_signal_smoke", "Campfire Signal Smoke");
        this.add("ars_nouveau.particle.ash", "Ash");
        this.add("ars_nouveau.particle.crimson_spore", "Crimson Spore");
        this.add("ars_nouveau.particle.warped_spore", "Warped Spore");
        this.add("ars_nouveau.particle.reverse_portal", "Reverse Portal");
        this.add("ars_nouveau.particle.white_ash", "White Ash");
        this.add("ars_nouveau.particle.small_flame", "Small Flame");
        this.add("ars_nouveau.particle.snowflake", "Snowflake");
        this.add("ars_nouveau.particle.electric_spark", "Electric Spark");
        this.add("ars_nouveau.particle.scrape", "Scrape");
        this.add("ars_nouveau.particle.wax", "Wax");
        this.add("ars_nouveau.particle.trial_spawner", "Trial Spawner");
        this.add("ars_nouveau.particle.ominous_spawning", "Ominous Spawning");
        this.add("ars_nouveau.particle.raid_omen", "Raid Omen");
        this.add("ars_nouveau.particle.composter", "Composter");
        this.add("ars_nouveau.particle.item_cobweb", "Item Cobweb");
        this.add("ars_nouveau.particle.soul", "Soul");
        this.add("ars_nouveau.particle.happy_villager", "Happy Villager");
        this.add("ars_nouveau.particle.property.motion", "Motion");
        this.add("ars_nouveau.particle.property.rune", "Texture");
        this.add("ars_nouveau.rune.rune", "Default");
        this.add("ars_nouveau.rune.rune_abjuration", "Abjuration");
        this.add("ars_nouveau.rune.rune_conjuration", "Conjuration");
        this.add("ars_nouveau.rune.rune_manipulation", "Manipulation");
        this.add("ars_nouveau.rune.rune_fire", "Fire");
        this.add("ars_nouveau.rune.rune_water", "Water");
        this.add("ars_nouveau.rune.rune_air", "Air");
        this.add("ars_nouveau.rune.rune_earth", "Earth");
        this.add("ars_nouveau.yspeed_slider", "Min Vertical Speed: %s");
        this.add("ars_nouveau.ymaxspeed_slider", "Max Vertical Speed: %s");
        this.add("ars_nouveau.xzspeed_slider", "Min XZ Speed: %s");
        this.add("ars_nouveau.xzmaxspeed_slider", "Horizontal Speed: %s");
        this.add("ars_nouveau.particle.property.speed", "Particle Speed");
        this.add("ars_nouveau.particle_config.brazier", "Brazier");
        this.add("ars_nouveau.particle_config.wisp", "Wisp");
        this.add("ars_nouveau.particle.property.sound", "Sound");
        this.add("ars_nouveau.sound.pyro", "Pyro");
        this.add("ars_nouveau.sound.allay_ambient_with_item", "Allay Ambient With Item");
        this.add("ars_nouveau.sound.allay_ambient_without_item", "Allay Ambient Without Item");
        this.add("ars_nouveau.sound.allay_death", "Allay Death");
        this.add("ars_nouveau.sound.allay_hurt", "Allay Hurt");
        this.add("ars_nouveau.sound.ambient_underwater_enter", "Ambient Underwater Enter");
        this.add("ars_nouveau.sound.amethyst_block_break", "Amethyst Block Break");
        this.add("ars_nouveau.sound.amethyst_block_chime", "Amethyst Block Chime");
        this.add("ars_nouveau.sound.anvil_land", "Anvil Land");
        this.add("ars_nouveau.sound.arrow_hit", "Arrow Hit");
        this.add("ars_nouveau.sound.arrow_shoot", "Arrow Shoot");
        this.add("ars_nouveau.sound.axe_strip", "Axe Strip");
        this.add("ars_nouveau.sound.axe_scrape", "Axe Scrape");
        this.add("ars_nouveau.sound.bamboo_fall", "Bamboo Fall");
        this.add("ars_nouveau.sound.bat_ambient", "Bat Ambient");
        this.add("ars_nouveau.sound.beacon_activate", "Beacon Activate");
        this.add("ars_nouveau.sound.beacon_deactivate", "Beacon Deactivate");
        this.add("ars_nouveau.sound.beacon_power_select", "Beacon Power Select");
        this.add("ars_nouveau.sound.bee_sting", "Bee Sting");
        this.add("ars_nouveau.sound.beehive_work", "Beehive Work");
        this.add("ars_nouveau.sound.bell_block", "Bell Block");
        this.add("ars_nouveau.sound.bell_resonate", "Bell Resonate");
        this.add("ars_nouveau.sound.blaze_burn", "Blaze Burn");
        this.add("ars_nouveau.sound.blaze_shoot", "Blaze Shoot");
        this.add("ars_nouveau.sound.bogged_ambient", "Bogged Ambient");
        this.add("ars_nouveau.sound.bogged_hurt", "Bogged Hurt");
        this.add("ars_nouveau.sound.bone_meal_use", "Bone Meal Use");
        this.add("ars_nouveau.sound.bottle_empty", "Bottle Empty");
        this.add("ars_nouveau.sound.bottle_fill", "Bottle Fill");
        this.add("ars_nouveau.sound.bottle_fill_dragonbreath", "Bottle Fill Dragonbreath");
        this.add("ars_nouveau.sound.breeze_charge", "Breeze Charge");
        this.add("ars_nouveau.sound.breeze_deflect", "Breeze Deflect");
        this.add("ars_nouveau.sound.breeze_shoot", "Breeze Shoot");
        this.add("ars_nouveau.sound.breeze_jump", "Breeze Jump");
        this.add("ars_nouveau.sound.breeze_wind_charge_burst", "Breeze Wind Charge Burst");
        this.add("ars_nouveau.sound.brewing_stand_brew", "Brewing Stand Brew");
        this.add("ars_nouveau.sound.bubble_column_upwards_inside", "Bubble Column Upwards Inside");
        this.add("ars_nouveau.sound.bucket_empty", "Bucket Empty");
        this.add("ars_nouveau.sound.bucket_fill", "Bucket Fill");
        this.add("ars_nouveau.sound.cat_ambient", "Cat Ambient");
        this.add("ars_nouveau.sound.cat_hiss", "Cat Hiss");
        this.add("ars_nouveau.sound.chain_break", "Chain Break");
        this.add("ars_nouveau.sound.chain_fall", "Chain Fall");
        this.add("ars_nouveau.sound.chicken_egg", "Chicken Egg");
        this.add("ars_nouveau.sound.chicken_ambient", "Chicken Ambient");
        this.add("ars_nouveau.sound.chorus_fruit_teleport", "Chorus Fruit Teleport");
        this.add("ars_nouveau.sound.comparator_click", "Comparator Click");
        this.add("ars_nouveau.sound.cow_ambient", "Cow Ambient");
        this.add("ars_nouveau.sound.creeper_primed", "Creeper Primed");
        this.add("ars_nouveau.sound.dolphin_ambient", "Dolphin Ambient");
        this.add("ars_nouveau.sound.dolphin_attack", "Dolphin Attack");
        this.add("ars_nouveau.sound.dolphin_play", "Dolphin Play");
        this.add("ars_nouveau.sound.donkey_ambient", "Donkey Ambient");
        this.add("ars_nouveau.sound.drowned_ambient", "Drowned Ambient");
        this.add("ars_nouveau.sound.elder_guardian_curse", "Elder Guardian Curse");
        this.add("ars_nouveau.sound.enchantment_table_use", "Enchantment Table Use");
        this.add("ars_nouveau.sound.dragon_fireball_explode", "Dragon Fireball Explode");
        this.add("ars_nouveau.sound.ender_dragon_flap", "Ender Dragon Flap");
        this.add("ars_nouveau.sound.ender_eye_death", "Ender Eye Death");
        this.add("ars_nouveau.sound.enderman_ambient", "Enderman Ambient");
        this.add("ars_nouveau.sound.enderman_teleport", "Enderman Teleport");
        this.add("ars_nouveau.sound.endermite_ambient", "Endermite Ambient");
        this.add("ars_nouveau.sound.end_gateway_spawn", "End Gateway Spawn");
        this.add("ars_nouveau.sound.end_portal_frame_fill", "End Portal Frame Fill");
        this.add("ars_nouveau.sound.evoker_ambient", "Evoker Ambient");
        this.add("ars_nouveau.sound.evoker_cast_spell", "Evoker Cast Spell");
        this.add("ars_nouveau.sound.evoker_fangs_attack", "Evoker Fangs Attack");
        this.add("ars_nouveau.sound.experience_orb_pickup", "Experience Orb Pickup");
        this.add("ars_nouveau.sound.firework_rocket_blast", "Firework Rocket Blast");
        this.add("ars_nouveau.sound.firework_rocket_large_blast", "Firework Rocket Large Blast");
        this.add("ars_nouveau.sound.firework_rocket_launch", "Firework Rocket Launch");
        this.add("ars_nouveau.sound.firework_rocket_twinkle", "Firework Rocket Twinkle");
        this.add("ars_nouveau.sound.fire_ambient", "Fire Ambient");
        this.add("ars_nouveau.sound.fire_extinguish", "Fire Extinguish");
        this.add("ars_nouveau.sound.fox_ambient", "Fox Ambient");
        this.add("ars_nouveau.sound.fox_screech", "Fox Screech");
        this.add("ars_nouveau.sound.frog_ambient", "Frog Ambient");
        this.add("ars_nouveau.sound.generic_drink", "Generic Drink");
        this.add("ars_nouveau.sound.generic_eat", "Generic Eat");
        this.add("ars_nouveau.sound.ghast_ambient", "Ghast Ambient");
        this.add("ars_nouveau.sound.ghast_scream", "Ghast Scream");
        this.add("ars_nouveau.sound.ghast_warn", "Ghast Warn");
        this.add("ars_nouveau.sound.glass_break", "Glass Break");
        this.add("ars_nouveau.sound.grindstone_use", "Grindstone Use");
        this.add("ars_nouveau.sound.growing_plant_crop", "Growing Plant Crop");
        this.add("ars_nouveau.sound.guardian_hurt", "Guardian Hurt");
        this.add("ars_nouveau.sound.trial_spawner_spawn_mob", "Trial Spawner Spawn Mob");
        this.add("ars_nouveau.sound.trial_spawner_detect_player", "Trial Spawner Detect Player");
        this.add("ars_nouveau.sound.honey_drink", "Honey Drink");
        this.add("ars_nouveau.sound.horse_gallop", "Horse Gallop");
        this.add("ars_nouveau.sound.horse_ambient", "Horse Ambient");
        this.add("ars_nouveau.sound.hostile_hurt", "Hostile Hurt");
        this.add("ars_nouveau.sound.illusioner_ambient", "Illusioner Ambient");
        this.add("ars_nouveau.sound.illusioner_cast_spell", "Illusioner Cast Spell");
        this.add("ars_nouveau.sound.illusioner_mirror_move", "Illusioner Mirror Move");
        this.add("ars_nouveau.sound.lava_extinguish", "Lava Extinguish");
        this.add("ars_nouveau.sound.lava_pop", "Lava Pop");
        this.add("ars_nouveau.sound.lightning_bolt_impact", "Lightning Bolt Impact");
        this.add("ars_nouveau.sound.mace_smash_air", "Mace Smash Air");
        this.add("ars_nouveau.sound.mace_smash_ground", "Mace Smash Ground");
        this.add("ars_nouveau.sound.mace_smash_ground_heavy", "Mace Smash Ground Heavy");
        this.add("ars_nouveau.sound.mooshroom_convert", "Mooshroom Convert");
        this.add("ars_nouveau.sound.phantom_bite", "Phantom Bite");
        this.add("ars_nouveau.sound.piglin_converted_to_zombified", "Piglin Converted To Zombified");
        this.add("ars_nouveau.sound.piston_contract", "Piston Contract");
        this.add("ars_nouveau.sound.piston_extend", "Piston Extend");
        this.add("ars_nouveau.sound.player_attack_crit", "Player Attack Crit");
        this.add("ars_nouveau.sound.player_levelup", "Player Levelup");
        this.add("ars_nouveau.sound.portal_trigger", "Portal Trigger");
        this.add("ars_nouveau.sound.puffer_fish_blow_out", "Puffer Fish Blow Out");
        this.add("ars_nouveau.sound.puffer_fish_blow_up", "Puffer Fish Blow Up");
        this.add("ars_nouveau.sound.puffer_fish_sting", "Puffer Fish Sting");
        this.add("ars_nouveau.sound.pumpkin_carve", "Pumpkin Carve");
        this.add("ars_nouveau.sound.ravager_stunned", "Ravager Stunned");
        this.add("ars_nouveau.sound.ravager_roar", "Ravager Roar");
        this.add("ars_nouveau.sound.sculk_clicking", "Sculk Clicking");
        this.add("ars_nouveau.sound.sculk_shrieker_shriek", "Sculk Shrieker Shriek");
        this.add("ars_nouveau.sound.shield_block", "Shield Block");
        this.add("ars_nouveau.sound.shield_break", "Shield Break");
        this.add("ars_nouveau.sound.shulker_bullet_hit", "Shulker Bullet Hit");
        this.add("ars_nouveau.sound.skeleton_converted_to_stray", "Skeleton Converted To Stray");
        this.add("ars_nouveau.sound.silverfish_ambient", "Silverfish Ambient");
        this.add("ars_nouveau.sound.skeleton_shoot", "Skeleton Shoot");
        this.add("ars_nouveau.sound.sniffer_sniffing", "Sniffer Sniffing");
        this.add("ars_nouveau.sound.sniffer_happy", "Sniffer Happy");
        this.add("ars_nouveau.sound.sniffer_egg_crack", "Sniffer Egg Crack");
        this.add("ars_nouveau.sound.sponge_absorb", "Sponge Absorb");
        this.add("ars_nouveau.sound.tnt_primed", "Tnt Primed");
        this.add("ars_nouveau.sound.thorns_hit", "Thorns Hit");
        this.add("ars_nouveau.sound.trident_return", "Trident Return");
        this.add("ars_nouveau.sound.trident_riptide_3", "Trident Riptide 3");
        this.add("ars_nouveau.sound.vault_activate", "Vault Activate");
        this.add("ars_nouveau.sound.vex_charge", "Vex Charge");
        this.add("ars_nouveau.sound.villager_ambient", "Villager Ambient");
        this.add("ars_nouveau.sound.warden_attack_impact", "Warden Attack Impact");
        this.add("ars_nouveau.sound.warden_heartbeat", "Warden Heartbeat");
        this.add("ars_nouveau.sound.warden_listening", "Warden Listening");
        this.add("ars_nouveau.sound.warden_sonic_boom", "Warden Sonic Boom");
        this.add("ars_nouveau.sound.warden_sonic_charge", "Warden Sonic Charge");
        this.add("ars_nouveau.sound.warden_tendril_clicks", "Warden Tendril Clicks");
        this.add("ars_nouveau.sound.weather_rain", "Weather Rain");
        this.add("ars_nouveau.sound.wind_charge_burst", "Wind Charge Burst");
        this.add("ars_nouveau.sound.witch_ambient", "Witch Ambient");
        this.add("ars_nouveau.sound.witch_celebrate", "Witch Celebrate");
        this.add("ars_nouveau.sound.witch_drink", "Witch Drink");
        this.add("ars_nouveau.sound.wolf_armor_break", "Wolf Armor Break");
        this.add("ars_nouveau.sound.wolf_armor_crack", "Wolf Armor Crack");
        this.add("ars_nouveau.sound.wolf_ambient", "Wolf Ambient");
        this.add("ars_nouveau.sound.wolf_howl", "Wolf Howl");
        this.add("ars_nouveau.sound.wolf_shake", "Wolf Shake");
        this.add("ars_nouveau.sound.zombie_infect", "Zombie Infect");
        this.add("ars_nouveau.sound.zombie_villager_converted", "Zombie Villager Converted");
        this.add("ars_nouveau.sound.zombie_villager_cure", "Zombie Villager Cure");
        this.add("ars_nouveau.sound.apply_effect_bad_omen", "Apply Effect Bad Omen");
        this.add("ars_nouveau.sound.apply_effect_trial_omen", "Apply Effect Trial Omen");
        this.add("ars_nouveau.sound.apply_effect_raid_omen", "Apply Effect Raid Omen");
        this.add("ars_nouveau.right_click_sound", "Right-Click to preview");
        this.add("ars_nouveau.sound.pointed_dripstone_drip_water", "Dripping Water");
        this.add("ars_nouveau.sound.pointed_dripstone_drip_lava", "Dripping Lava");
        this.add("ars_nouveau.model_tooltip", "Projectile Model");
        this.add("ars_nouveau.particle_type_tooltip", "Particle Texture");
        this.add("ars_nouveau.speed_tooltip", "Initial Particle Speed");
        this.add("ars_nouveau.density_tooltip", "Amount and shape of particles spawned over time");
        this.add("ars_nouveau.timeline.spawn.tooltip", "Sound and particles created when spawned or cast");
        this.add("ars_nouveau.timeline.trail.tooltip", "Creates particles that follow the projectile");
        this.add("ars_nouveau.timeline.impact.tooltip", "Creates particles and sound where the spell resolves");
        this.add("ars_nouveau.timeline.flair.tooltip", "Additional particles that play on the projectile's path");
        this.add("ars_nouveau.timeline.tick.tooltip", "Creates particles every tick");
        this.add("block.ars_nouveau.particle_block", "Prestidigitation Block");
        this.add("ars_nouveau.expand_button", "Toggle Expanded View");
        this.add("ars_nouveau.model.spike", "Spike");
        this.add("ars_nouveau.sound.horse_death", "Horse Death");
        this.add("ars_nouveau.sound.armadillo_hurt_reduced", "Armadillo Hurt Reduced");
        this.add("ars_nouveau.sound.wither_ambient", "Wither Ambient");
        this.add("ars_nouveau.sound.wither_death", "Wither Death");
        this.add("ars_nouveau.sound.wither_hurt", "Wither Hurt");
        this.add("ars_nouveau.sound.wither_shoot", "Wither Shoot");
        this.add("ars_nouveau.sound.wither_break_block", "Wither Break Block");
        this.add("ars_nouveau.sound.zoglin_ambient", "Zoglin Ambient");
        this.add("ars_nouveau.sound.zoglin_angry", "Zoglin Angry");
        this.add("ars_nouveau.sound.zoglin_attack", "Zoglin Attack");
        this.add("ars_nouveau.sound.water_ambient", "Water Ambient");
        this.add("ars_nouveau.sound.warden_agitated", "Warden Agitated");
        this.add("ars_nouveau.sound.warden_ambient", "Warden Ambient");
        this.add("ars_nouveau.sound.warden_death", "Warden Death");
        this.add("ars_nouveau.sound.warden_dig", "Warden Dig");
        this.add("ars_nouveau.sound.warden_emerge", "Warden Emerge");
        this.add("ars_nouveau.sound.warden_hurt", "Warden Hurt");
        this.add("ars_nouveau.sound.warden_sniff", "Warden Sniff");
        this.add("ars_nouveau.sound.trident_thunder", "Trident Thunder");
        this.add("ars_nouveau.sound.trident_throw", "Trident Throw");
        this.add("ars_nouveau.sound.totem_use", "Totem Use");
        this.add("ars_nouveau.sound.squid_squirt", "Squid Squirt");
        this.add("ars_nouveau.particle.sculk_charge", "Sculk Charge");
        this.add("ars_nouveau.particle.sculk_charge_pop", "Sculk Charge Pop");
        this.add("ars_nouveau.particle.explosion", "Explosion");
        this.add("ars_nouveau.particle.cloud", "Cloud");
        this.add("ars_nouveau.particle.breaking_circle", "Breaking Circle");
        this.add("ars_nouveau.prestidigitation.tooltip", "Prestidigitation");
        this.add("ars_nouveau.prestidigitation.prestidigitation_clear", "Prestidigitation Removed");
        this.add("ars_nouveau.abjuration_essence.tooltip", "Can be used on the Scribes Table to remove Prestidigitation from items.");
        this.add("ars_nouveau.page.prestidigitation", "Illusory Items");
        this.add("ars_nouveau.page1.prestidigitation", "Prestidigitation can be applied to Items, causing them to emit particles when held or worn. Particle settings are determined by the Prestidigitation glyph settings for the spell contained within the Spell Parchment when used in the apparatus. To remove Prestidigitation, use an Abjuration Essence on the Scribes Table with the enchanted item inside it.");
        this.add("ars_nouveau.connection.range", "Can only connect within %s blocks.");
        this.add("block.ars_nouveau.decor_blossom", "Decor Blossom");
        this.add("ars_nouveau.page.decor_blossom", "Decor Blossoms will create Prestidigitation particles at a wireless location. To set the particles, cast Prestidigitation on the block. Then use the Dominion Wand to set the desired location. Casting Dispel will remove the particles, while using the dominion wand while sneaking will remove the location and particles.");
        this.add("ars_nouveau.learn_glyph", "Unlocked %s");
        this.add("ars_nouveau.already_learned", "You have already learned this Glyph.");
        this.add("block.ars_nouveau.planarium", "Planarium");
        this.add("ars_nouveau.planarium.set_name", "Cast Name or set a name in an Anvil to create a dimension.");
        this.add("ars_nouveau.set_jar_spawn", "Jar spawn point set.");
        this.add("block.ars_nouveau.dim_boundary", "Dimension Boundary");
        this.add("biome.ars_nouveau.jar", "Jar");
        this.add("ars_nouveau.jar_spawn_out_of_bounds", "Cannot set jar spawn point out of bounds.");
        this.add("ars_nouveau.page1.planarium", "The Planarium allows for the creation of custom pocket dimensions. Blocks placed within the jar will be rendered inside the Planarium. To create a new dimension, name a Planarium with the Name glyph or an anvil. Interact with the planarium while sneaking to enter the jar.\nThe spawn point of the Planarium can be set by using the Dominion Wand on a boundary of the jar, and then using the wand again on your desired spawn point. To exit the jar, simply break any wall of the dimension.");
        this.add("ars_nouveau.form_icon_tooltip", "Forms: Appear at the start of the spell and determine how it is cast.");
        this.add("ars_nouveau.augment_icon_tooltip", "Augments: Appear after Forms and Effects and modifies how they behave.");
        this.add("ars_nouveau.effect_icon_tooltip", "Effects: Determines what the spell does after hitting a target.");
        this.add("ars_nouveau.filter_icon_tooltip", "Filters: Prevents the spell from resolving if the target does not match the filter.");
        this.add("ars_nouveau.spell_book_info_tooltip", "Tips and Tricks: \n\u2022 Middle-Click a glyph in the spell to add an empty space to the left of it.\n\u2022 Press 0-9 when hovering your mouse over a glyph to add it to that spell slot.\n\u2022 Ctrl + C to copy the spell and its particles.\n\u2022 Ctrl + V to paste a spell.");
    }

    public void addCategory(String key, String value) {
        this.add("ars_nouveau.section." + key, value);
    }

    public void add(@NotNull Item key, @NotNull String name) {
        super.add(key, name);
    }

    public void add(@NotNull String key, @NotNull String value) {
        super.add(key, value);
        this.data.put(key, value);
    }
}

