/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items;

import com.hollingsworth.arsnouveau.api.item.ICasterTool;
import com.hollingsworth.arsnouveau.api.spell.AbstractCaster;
import com.hollingsworth.arsnouveau.client.renderer.item.ScryCasterRenderer;
import com.hollingsworth.arsnouveau.common.block.ScryerCrystal;
import com.hollingsworth.arsnouveau.common.items.ModItem;
import com.hollingsworth.arsnouveau.common.items.data.ScryPosData;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ScryCaster
extends ModItem
implements ICasterTool,
GeoItem {
    AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public ScryCaster(Item.Properties properties) {
        super(properties);
    }

    public ScryCaster() {
    }

    @NotNull
    public InteractionResult useOn(UseOnContext pContext) {
        BlockPos pos = pContext.getClickedPos();
        ItemStack stack = pContext.getItemInHand();
        if (pContext.getLevel().getBlockState(pos).getBlock() instanceof ScryerCrystal) {
            if (!pContext.getLevel().isClientSide) {
                stack.set(DataComponentRegistry.SCRY_DATA, (Object)new ScryPosData(new GlobalPos(pContext.getLevel().dimension(), pos)));
                PortUtil.sendMessage((Entity)pContext.getPlayer(), (Component)Component.translatable((String)"ars_nouveau.dominion_wand.position_set"));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level pLevel, Player pPlayer, @NotNull InteractionHand pUsedHand) {
        ItemStack stack = pPlayer.getItemInHand(pUsedHand);
        if (!pLevel.isClientSide) {
            return InteractionResultHolder.pass((Object)stack);
        }
        AbstractCaster caster = this.getSpellCaster(stack);
        if (caster == null) {
            return InteractionResultHolder.pass((Object)stack);
        }
        caster.castOnServer(pUsedHand, (Component)Component.translatable((String)"ars_nouveau.invalid_spell"));
        return InteractionResultHolder.pass((Object)stack);
    }

    @Override
    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip2, @NotNull TooltipFlag flagIn) {
        this.getInformation(stack, context, tooltip2, flagIn);
        ScryPosData data = (ScryPosData)stack.get(DataComponentRegistry.SCRY_DATA);
        GlobalPos globalPos = data.pos().orElse(null);
        if (globalPos == null) {
            tooltip2.add((Component)Component.translatable((String)"ars_nouveau.scry_caster.no_pos"));
        } else {
            BlockPos pos = globalPos.pos();
            tooltip2.add((Component)Component.translatable((String)"ars_nouveau.scryer_scroll.bound", (Object[])new Object[]{pos.getX() + ", " + pos.getY() + ", " + pos.getZ()}));
        }
        super.appendHoverText(stack, context, tooltip2, flagIn);
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(this){
            private final BlockEntityWithoutLevelRenderer renderer = new ScryCasterRenderer();

            public BlockEntityWithoutLevelRenderer getGeoItemRenderer() {
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }
}

