/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.api.util.SpellUtil;
import com.hollingsworth.arsnouveau.common.items.curios.ShapersFocus;
import com.hollingsworth.arsnouveau.common.lib.GlyphLib;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentRandomize;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSensitive;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class EffectRotate
extends AbstractEffect {
    public static EffectRotate INSTANCE = new EffectRotate();

    public EffectRotate() {
        super(GlyphLib.EffectRotateID, "Rotate");
    }

    @Override
    public String getBookDescription() {
        return "Rotates a block or an entity clockwise. If augmented with sensitive it will change the axis of the block (if possible) or force the entity to turn their look. Dampen will rotate counter-clockwise.";
    }

    @Override
    public SpellTier defaultTier() {
        return SpellTier.ONE;
    }

    @Override
    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        Entity entity = rayTraceResult.getEntity();
        boolean sensitive = spellStats.isSensitive();
        boolean randomize = spellStats.isRandomized();
        int ampMod = (int)spellStats.getAmpMultiplier();
        boolean counterClockwise = ampMod < 0;
        for (int i = 0; i < 1 + Math.abs(ampMod); ++i) {
            float angle = randomize ? world.random.nextFloat() * 360.0f : entity.rotate(counterClockwise ? Rotation.COUNTERCLOCKWISE_90 : Rotation.CLOCKWISE_90);
            if (sensitive) {
                entity.lookAt(EntityAnchorArgument.Anchor.FEET, entity.position.add(entity.getLookAngle().yRot(angle)));
            } else {
                entity.setYRot(angle);
            }
            if (entity instanceof Projectile) {
                Projectile projectile = (Projectile)entity;
                Vec3 vec3d = projectile.getDeltaMovement();
                projectile.setDeltaMovement(this.rotateVec(vec3d, randomize ? angle : (counterClockwise ? -90.0f : 90.0f)));
            }
            entity.hurtMarked = true;
        }
    }

    public Vec3 rotateVec(Vec3 vec, float angle) {
        double x = vec.x * Math.cos(angle) - vec.z * Math.sin(angle);
        double z = vec.x * Math.sin(angle) + vec.z * Math.cos(angle);
        return new Vec3(x, vec.y, z);
    }

    @Override
    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        List<BlockPos> posList = SpellUtil.calcAOEBlocks(shooter, rayTraceResult.getBlockPos(), rayTraceResult, spellStats);
        boolean swapAxis = spellStats.isSensitive();
        boolean randomize = spellStats.isRandomized();
        for (BlockPos pos : posList) {
            BlockState state = world.getBlockState(pos);
            if (randomize) {
                if (state.hasProperty((Property)BlockStateProperties.AXIS)) {
                    state = (BlockState)state.setValue((Property)BlockStateProperties.AXIS, (Comparable)Direction.Axis.getRandom((RandomSource)world.random));
                } else if (state.hasProperty((Property)BlockStateProperties.FACING)) {
                    state = (BlockState)state.setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.getRandom((RandomSource)world.random));
                }
                state = state.rotate((LevelAccessor)world, pos, Rotation.getRandom((RandomSource)world.random));
            } else {
                int ampMod = (int)spellStats.getAmpMultiplier();
                boolean counterClockwise = ampMod < 0;
                for (int i = 0; i < (counterClockwise ? 0 : 1) + Math.abs(ampMod); ++i) {
                    if (swapAxis) {
                        if (state.hasProperty((Property)BlockStateProperties.AXIS)) {
                            state = (BlockState)state.setValue((Property)BlockStateProperties.AXIS, (Comparable)(switch ((Direction.Axis)state.getValue((Property)BlockStateProperties.AXIS)) {
                                default -> throw new MatchException(null, null);
                                case Direction.Axis.X -> {
                                    if (counterClockwise) {
                                        yield Direction.Axis.Z;
                                    }
                                    yield Direction.Axis.Y;
                                }
                                case Direction.Axis.Y -> {
                                    if (counterClockwise) {
                                        yield Direction.Axis.X;
                                    }
                                    yield Direction.Axis.Z;
                                }
                                case Direction.Axis.Z -> counterClockwise ? Direction.Axis.Y : Direction.Axis.X;
                            }));
                            continue;
                        }
                        if (!state.hasProperty((Property)BlockStateProperties.FACING)) continue;
                        Direction curr = (Direction)state.getValue((Property)BlockStateProperties.FACING);
                        state = (BlockState)state.setValue((Property)BlockStateProperties.FACING, (Comparable)(switch (curr) {
                            default -> throw new MatchException(null, null);
                            case Direction.DOWN -> {
                                if (counterClockwise) {
                                    yield Direction.SOUTH;
                                }
                                yield Direction.NORTH;
                            }
                            case Direction.UP -> {
                                if (counterClockwise) {
                                    yield Direction.NORTH;
                                }
                                yield Direction.SOUTH;
                            }
                            case Direction.NORTH, Direction.EAST -> {
                                if (counterClockwise) {
                                    yield Direction.DOWN;
                                }
                                yield Direction.UP;
                            }
                            case Direction.SOUTH, Direction.WEST -> counterClockwise ? Direction.UP : Direction.DOWN;
                        }));
                        continue;
                    }
                    state = state.rotate((LevelAccessor)world, pos, counterClockwise ? Rotation.COUNTERCLOCKWISE_90 : Rotation.CLOCKWISE_90);
                }
            }
            world.setBlockAndUpdate(pos, state);
            ShapersFocus.tryPropagateBlockSpell(rayTraceResult, world, (Entity)shooter, spellContext, resolver);
        }
    }

    @Override
    protected void addDefaultAugmentLimits(Map<ResourceLocation, Integer> defaults) {
        super.addDefaultAugmentLimits(defaults);
        defaults.put(AugmentSensitive.INSTANCE.getRegistryName(), 1);
        defaults.put(AugmentRandomize.INSTANCE.getRegistryName(), 1);
    }

    @Override
    public int getDefaultManaCost() {
        return 10;
    }

    @Override
    @NotNull
    protected Set<SpellSchool> getSchools() {
        return this.setOf(SpellSchools.MANIPULATION);
    }

    @Override
    @NotNull
    protected Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(AugmentAmplify.INSTANCE, AugmentSensitive.INSTANCE, AugmentAOE.INSTANCE, AugmentPierce.INSTANCE, AugmentDampen.INSTANCE, AugmentRandomize.INSTANCE);
    }

    @Override
    public void addAugmentDescriptions(Map<AbstractAugment, String> map) {
        super.addAugmentDescriptions(map);
        this.addBlockAoeAugmentDescriptions(map);
        map.put(AugmentSensitive.INSTANCE, "Rotates the block on a different axis or forces an entity to rotate their head.");
        map.put(AugmentDampen.INSTANCE, "Increases rotations counter-clockwise.");
        map.put(AugmentAmplify.INSTANCE, "Increases rotations clockwise.");
        map.put(AugmentRandomize.INSTANCE, "Applies a random rotation, ignoring axis.");
    }
}

