/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.setup.registry;

import com.hollingsworth.arsnouveau.api.registry.FamiliarRegistry;
import com.hollingsworth.arsnouveau.api.registry.GlyphRegistry;
import com.hollingsworth.arsnouveau.api.registry.PerkRegistry;
import com.hollingsworth.arsnouveau.api.registry.RitualRegistry;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.common.crafting.recipes.GlyphRecipe;
import com.hollingsworth.arsnouveau.common.items.FamiliarScript;
import com.hollingsworth.arsnouveau.common.items.Glyph;
import com.hollingsworth.arsnouveau.common.items.PerkItem;
import com.hollingsworth.arsnouveau.common.items.RitualTablet;
import com.hollingsworth.arsnouveau.common.items.SpellBook;
import com.hollingsworth.arsnouveau.common.spell.method.MethodProjectile;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import java.util.Comparator;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class CreativeTabRegistry {
    public static Comparator<RecipeHolder<GlyphRecipe>> COMPARE_GLYPH_BY_TYPE = Comparator.comparingInt(holder -> ((GlyphRecipe)holder.value()).getSpellPart().getTypeIndex());
    public static Comparator<RecipeHolder<GlyphRecipe>> COMPARE_TYPE_THEN_NAME = COMPARE_GLYPH_BY_TYPE.thenComparing(holder -> ((GlyphRecipe)holder.value()).getSpellPart().getLocaleName());
    public static Comparator<RecipeHolder<GlyphRecipe>> COMPARE_TIER_THEN_NAME = COMPARE_GLYPH_BY_TYPE.thenComparingInt(o -> ((GlyphRecipe)o.value()).getSpellPart().getConfigTier().value).thenComparing(holder -> ((GlyphRecipe)holder.value()).getSpellPart().getLocaleName());
    public static Comparator<AbstractSpellPart> COMPARE_SPELL_TYPE_NAME = Comparator.comparingInt(AbstractSpellPart::getTypeIndex).thenComparing(AbstractSpellPart::getLocaleName);
    public static final DeferredRegister<CreativeModeTab> TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"ars_nouveau");
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> BLOCKS = TABS.register("general", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.ars_nouveau")).icon(() -> ((SpellBook)ItemsRegistry.CREATIVE_SPELLBOOK.get()).getDefaultInstance()).displayItems((params, output) -> {
        for (DeferredHolder entry : ItemsRegistry.ITEMS.getEntries()) {
            if (entry.get() instanceof Glyph) continue;
            output.accept(((Item)entry.get()).getDefaultInstance());
        }
        for (PerkItem perk : PerkRegistry.getPerkItemMap().values()) {
            output.accept(perk.getDefaultInstance());
        }
        for (RitualTablet ritual : RitualRegistry.getRitualItemMap().values()) {
            output.accept(ritual.getDefaultInstance());
        }
        for (FamiliarScript familiar : FamiliarRegistry.getFamiliarScriptMap().values()) {
            output.accept(familiar.getDefaultInstance());
        }
    }).withTabsBefore(new ResourceKey[]{CreativeModeTabs.SPAWN_EGGS}).build());
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> GLYPHS = TABS.register("glyphs", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.ars_glyphs")).icon(() -> MethodProjectile.INSTANCE.glyphItem.getDefaultInstance()).displayItems((params, output) -> {
        for (AbstractSpellPart glyph : GlyphRegistry.getSpellpartMap().values().stream().sorted(COMPARE_SPELL_TYPE_NAME).toList()) {
            output.accept(glyph.getGlyph().getDefaultInstance());
        }
    }).withTabsBefore(new ResourceKey[]{BLOCKS.getKey()}).build());
}

