/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.index;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.lucene.ars_nouveau.index.DocValuesUpdate;
import org.apache.lucene.ars_nouveau.index.FieldUpdatesBuffer;
import org.apache.lucene.ars_nouveau.index.Term;
import org.apache.lucene.ars_nouveau.search.Query;
import org.apache.lucene.ars_nouveau.util.Accountable;
import org.apache.lucene.ars_nouveau.util.ArrayUtil;
import org.apache.lucene.ars_nouveau.util.ByteBlockPool;
import org.apache.lucene.ars_nouveau.util.BytesRef;
import org.apache.lucene.ars_nouveau.util.BytesRefHash;
import org.apache.lucene.ars_nouveau.util.Counter;
import org.apache.lucene.ars_nouveau.util.RamUsageEstimator;

class BufferedUpdates
implements Accountable {
    static final int BYTES_PER_DEL_QUERY = 5 * RamUsageEstimator.NUM_BYTES_OBJECT_REF + 2 * RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 8 + 24;
    final AtomicInteger numFieldUpdates = new AtomicInteger();
    final DeletedTerms deleteTerms = new DeletedTerms();
    final Map<Query, Integer> deleteQueries = new HashMap<Query, Integer>();
    final Map<String, FieldUpdatesBuffer> fieldUpdates = new HashMap<String, FieldUpdatesBuffer>();
    public static final Integer MAX_INT = Integer.MAX_VALUE;
    private final Counter bytesUsed = Counter.newCounter(true);
    final Counter fieldUpdatesBytesUsed = Counter.newCounter(true);
    private static final boolean VERBOSE_DELETES = false;
    long gen;
    final String segmentName;

    public BufferedUpdates(String segmentName) {
        this.segmentName = segmentName;
    }

    public String toString() {
        String s = "gen=" + this.gen;
        if (!this.deleteTerms.isEmpty()) {
            s = s + " " + this.deleteTerms.size() + " unique deleted terms ";
        }
        if (this.deleteQueries.size() != 0) {
            s = s + " " + this.deleteQueries.size() + " deleted queries";
        }
        if (this.numFieldUpdates.get() != 0) {
            s = s + " " + this.numFieldUpdates.get() + " field updates";
        }
        if (this.bytesUsed.get() != 0L) {
            s = s + " bytesUsed=" + this.bytesUsed.get();
        }
        return s;
    }

    public void addQuery(Query query, int docIDUpto) {
        Integer current = this.deleteQueries.put(query, docIDUpto);
        if (current == null) {
            this.bytesUsed.addAndGet(BYTES_PER_DEL_QUERY);
        }
    }

    public void addTerm(Term term, int docIDUpto) {
        int current = this.deleteTerms.get(term);
        if (current != -1 && docIDUpto < current) {
            return;
        }
        this.deleteTerms.put(term, docIDUpto);
    }

    void addNumericUpdate(DocValuesUpdate.NumericDocValuesUpdate update, int docIDUpto) {
        FieldUpdatesBuffer buffer = this.fieldUpdates.computeIfAbsent(update.field, k -> new FieldUpdatesBuffer(this.fieldUpdatesBytesUsed, update, docIDUpto));
        if (update.hasValue) {
            buffer.addUpdate(update.term, update.getValue(), docIDUpto);
        } else {
            buffer.addNoValue(update.term, docIDUpto);
        }
        this.numFieldUpdates.incrementAndGet();
    }

    void addBinaryUpdate(DocValuesUpdate.BinaryDocValuesUpdate update, int docIDUpto) {
        FieldUpdatesBuffer buffer = this.fieldUpdates.computeIfAbsent(update.field, k -> new FieldUpdatesBuffer(this.fieldUpdatesBytesUsed, update, docIDUpto));
        if (update.hasValue) {
            buffer.addUpdate(update.term, update.getValue(), docIDUpto);
        } else {
            buffer.addNoValue(update.term, docIDUpto);
        }
        this.numFieldUpdates.incrementAndGet();
    }

    void clearDeleteTerms() {
        this.deleteTerms.clear();
    }

    void clear() {
        this.deleteTerms.clear();
        this.deleteQueries.clear();
        this.numFieldUpdates.set(0);
        this.fieldUpdates.clear();
        this.bytesUsed.addAndGet(-this.bytesUsed.get());
        this.fieldUpdatesBytesUsed.addAndGet(-this.fieldUpdatesBytesUsed.get());
    }

    boolean any() {
        return this.deleteTerms.size() > 0 || this.deleteQueries.size() > 0 || this.numFieldUpdates.get() > 0;
    }

    @Override
    public long ramBytesUsed() {
        return this.bytesUsed.get() + this.fieldUpdatesBytesUsed.get() + this.deleteTerms.ramBytesUsed();
    }

    static class DeletedTerms
    implements Accountable {
        private final Counter bytesUsed = Counter.newCounter();
        private final ByteBlockPool pool = new ByteBlockPool(new ByteBlockPool.DirectTrackingAllocator(this.bytesUsed));
        private final Map<String, BytesRefIntMap> deleteTerms = new HashMap<String, BytesRefIntMap>();
        private int termsSize = 0;

        DeletedTerms() {
        }

        int get(Term term) {
            BytesRefIntMap hash = this.deleteTerms.get(term.field);
            if (hash == null) {
                return -1;
            }
            return hash.get(term.bytes);
        }

        void put(Term term, int value) {
            BytesRefIntMap hash = this.deleteTerms.computeIfAbsent(term.field, k -> {
                this.bytesUsed.addAndGet(RamUsageEstimator.sizeOf(term.field));
                return new BytesRefIntMap(this.pool, this.bytesUsed);
            });
            if (hash.put(term.bytes, value)) {
                ++this.termsSize;
            }
        }

        void clear() {
            this.pool.reset(false, false);
            this.bytesUsed.addAndGet(-this.bytesUsed.get());
            this.deleteTerms.clear();
            this.termsSize = 0;
        }

        int size() {
            return this.termsSize;
        }

        boolean isEmpty() {
            return this.termsSize == 0;
        }

        Set<Term> keySet() {
            return this.deleteTerms.entrySet().stream().flatMap(entry -> ((BytesRefIntMap)entry.getValue()).keySet().stream().map(b -> new Term((String)entry.getKey(), (BytesRef)b))).collect(Collectors.toSet());
        }

        <E extends Exception> void forEachOrdered(DeletedTermConsumer<E> consumer) throws E {
            ArrayList<Map.Entry<String, BytesRefIntMap>> deleteFields = new ArrayList<Map.Entry<String, BytesRefIntMap>>(this.deleteTerms.entrySet());
            deleteFields.sort(Map.Entry.comparingByKey());
            Term scratch = new Term("", new BytesRef());
            for (Map.Entry entry : deleteFields) {
                scratch.field = (String)entry.getKey();
                BytesRefIntMap terms = (BytesRefIntMap)entry.getValue();
                int[] indices = terms.bytesRefHash.sort();
                for (int i = 0; i < terms.bytesRefHash.size(); ++i) {
                    int index = indices[i];
                    terms.bytesRefHash.get(index, scratch.bytes);
                    consumer.accept(scratch, terms.values[index]);
                }
            }
        }

        ByteBlockPool getPool() {
            return this.pool;
        }

        @Override
        public long ramBytesUsed() {
            return this.bytesUsed.get();
        }

        public String toString() {
            return this.keySet().stream().map(t -> String.valueOf(t) + "=" + this.get((Term)t)).collect(Collectors.joining(", ", "{", "}"));
        }

        static interface DeletedTermConsumer<E extends Exception> {
            public void accept(Term var1, int var2) throws E;
        }
    }

    private static class BytesRefIntMap {
        private static final long INIT_RAM_BYTES = RamUsageEstimator.shallowSizeOf(BytesRefIntMap.class) + RamUsageEstimator.shallowSizeOf(BytesRefHash.class) + RamUsageEstimator.sizeOf(new int[16]);
        private final Counter counter;
        private final BytesRefHash bytesRefHash;
        private int[] values;

        private BytesRefIntMap(ByteBlockPool pool, Counter counter) {
            this.counter = counter;
            this.bytesRefHash = new BytesRefHash(pool, 16, new BytesRefHash.DirectBytesStartArray(16, counter));
            this.values = new int[16];
            counter.addAndGet(INIT_RAM_BYTES);
        }

        private Set<BytesRef> keySet() {
            BytesRef scratch = new BytesRef();
            HashSet<BytesRef> set = new HashSet<BytesRef>();
            for (int i = 0; i < this.bytesRefHash.size(); ++i) {
                this.bytesRefHash.get(i, scratch);
                set.add(BytesRef.deepCopyOf(scratch));
            }
            return set;
        }

        private boolean put(BytesRef key, int value) {
            assert (value >= 0);
            int e = this.bytesRefHash.add(key);
            if (e < 0) {
                this.values[-e - 1] = value;
                return false;
            }
            if (e >= this.values.length) {
                int originLength = this.values.length;
                this.values = ArrayUtil.grow(this.values, e + 1);
                this.counter.addAndGet((long)(this.values.length - originLength) * 4L);
            }
            this.values[e] = value;
            return true;
        }

        private int get(BytesRef key) {
            int e = this.bytesRefHash.find(key);
            if (e == -1) {
                return -1;
            }
            return this.values[e];
        }
    }
}

